/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.C45.Attribute;
import keel.Algorithms.Decision_Trees.C45.Itemset;
import keel.Dataset.Attributes;
import keel.Dataset.DatasetException;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.InstanceSet;

public class Dataset {
    protected String name = "";
    protected Vector attributes;
    protected Vector itemsets;
    protected int classIndex;
    protected InstanceSet IS;

    public Dataset(String name, boolean train) {
        try {
            this.IS = new InstanceSet();
            this.IS.readSet(name, train);
        }
        catch (DatasetException e) {
            System.out.println("Error loading dataset instances");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (HeaderFormatException e) {
            System.out.println("Error loading dataset instances");
            e.printStackTrace();
            System.exit(-1);
        }
        this.readHeader();
        this.itemsets = new Vector(this.IS.getNumInstances());
        this.getItemsetFull();
    }

    public Dataset(Dataset dataset) {
        this(dataset, dataset.numItemsets());
        dataset.copyItemsets(0, this, dataset.numItemsets());
    }

    public Dataset(Dataset dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.classIndex = dataset.classIndex;
        this.name = dataset.getName();
        this.attributes = dataset.attributes;
        this.itemsets = new Vector(capacity);
    }

    private void readHeader() {
        Vector<String> attributeValues;
        Attribute att;
        float max;
        float min;
        String attributeName;
        keel.Dataset.Attribute at;
        int j;
        this.name = Attributes.getRelationName();
        this.attributes = new Vector();
        for (j = 0; j < Attributes.getInputNumAttributes(); ++j) {
            at = Attributes.getInputAttribute(j);
            attributeName = at.getName();
            if (at.getType() == 2) {
                min = (float)at.getMinAttribute();
                max = (float)at.getMinAttribute();
                this.attributes.addElement(new Attribute(attributeName, j));
                att = (Attribute)this.attributes.elementAt(j);
                att.setRange(min, max);
                att.activate();
                continue;
            }
            if (at.getType() == 1) {
                int min2 = (int)at.getMinAttribute();
                int max2 = (int)at.getMinAttribute();
                this.attributes.addElement(new Attribute(attributeName, j));
                att = (Attribute)this.attributes.elementAt(j);
                att.setRange(min2, max2);
                att.activate();
                continue;
            }
            attributeValues = new Vector<String>();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new Attribute(attributeName, attributeValues, j));
            Attribute att2 = (Attribute)this.attributes.elementAt(j);
            att2.activate();
        }
        at = Attributes.getOutputAttribute(0);
        attributeName = at.getName();
        j = Attributes.getNumAttributes() - 1;
        if (at.getType() == 2) {
            min = (float)at.getMinAttribute();
            max = (float)at.getMinAttribute();
            this.attributes.addElement(new Attribute(attributeName, j));
            att = (Attribute)this.attributes.elementAt(j);
            att.setRange(min, max);
            att.activate();
        } else if (at.getType() == 1) {
            int min3 = (int)at.getMinAttribute();
            int max3 = (int)at.getMinAttribute();
            this.attributes.addElement(new Attribute(attributeName, j));
            att = (Attribute)this.attributes.elementAt(j);
            att.setRange(min3, max3);
            att.activate();
        } else {
            attributeValues = new Vector();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new Attribute(attributeName, attributeValues, j));
            Attribute att3 = (Attribute)this.attributes.elementAt(j);
            att3.activate();
        }
        this.classIndex = Attributes.getNumAttributes() - 1;
    }

    private boolean getItemsetFull() {
        for (int j = 0; j < this.IS.getNumInstances(); ++j) {
            int k;
            int i;
            double[] itemset = new double[Attributes.getNumAttributes()];
            for (i = 0; i < Attributes.getInputNumAttributes(); ++i) {
                if (this.IS.getInstance(j).getInputMissingValues(i)) {
                    itemset[i] = Itemset.getMissingValue();
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    for (k = 0; k < Attributes.getInputAttribute(i).getNumNominalValues(); ++k) {
                        if (!Attributes.getInputAttribute(i).getNominalValue(k).equals(this.IS.getInstance(j).getInputNominalValues(i))) continue;
                        itemset[i] = k;
                    }
                    continue;
                }
                itemset[i] = this.IS.getInstance(j).getInputRealValues(i);
            }
            i = Attributes.getInputNumAttributes();
            if (this.IS.getInstance(j).getOutputMissingValues(0)) {
                itemset[i] = Itemset.getMissingValue();
            } else if (Attributes.getOutputAttribute(0).getType() == 0) {
                for (k = 0; k < Attributes.getOutputAttribute(0).getNumNominalValues(); ++k) {
                    if (!Attributes.getOutputAttribute(0).getNominalValue(k).equals(this.IS.getInstance(j).getOutputNominalValues(0))) continue;
                    itemset[i] = k;
                }
            } else {
                itemset[i] = this.IS.getInstance(j).getOutputRealValues(0);
            }
            this.addItemset(new Itemset(1.0, itemset));
        }
        return true;
    }

    public final void addItemset(Itemset itemset) {
        Itemset newItemset = (Itemset)itemset.copy();
        newItemset.setDataset(this);
        this.itemsets.addElement(newItemset);
    }

    public String getName() {
        return this.name;
    }

    public final Attribute getAttribute(int index) {
        return (Attribute)this.attributes.elementAt(index);
    }

    public final Attribute getAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!((Attribute)this.attributes.elementAt(i)).name().equalsIgnoreCase(name)) continue;
            return (Attribute)this.attributes.elementAt(i);
        }
        return null;
    }

    public final Attribute getClassAttribute() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return null;
        }
        return this.getAttribute(this.classIndex);
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final int numAttributes() {
        return this.attributes.size();
    }

    public final int numClasses() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return -1;
        }
        return this.getClassAttribute().numValues();
    }

    public final int numItemsets() {
        return this.itemsets.size();
    }

    public final void delete(int index) {
        this.itemsets.removeElementAt(index);
    }

    public final void deleteWithMissing(int attIndex) {
        Vector<Itemset> newItemsets = new Vector<Itemset>(this.numItemsets());
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (this.itemset(i).isMissing(attIndex)) continue;
            newItemsets.addElement(this.itemset(i));
        }
        this.itemsets = newItemsets;
    }

    public Enumeration enumerateAttributes() {
        Vector help = new Vector(this.attributes.size() - 1);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i == this.classIndex) continue;
            help.addElement(this.attributes.elementAt(i));
        }
        return help.elements();
    }

    public final Enumeration enumerateItemsets() {
        return this.itemsets.elements();
    }

    public final Itemset itemset(int index) {
        return (Itemset)this.itemsets.elementAt(index);
    }

    public final Itemset lastItemset() {
        return (Itemset)this.itemsets.lastElement();
    }

    private void copyItemsets(int from, Dataset dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.addItemset(this.itemset(from + i));
        }
    }

    public final double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numItemsets(); ++i) {
            sum += this.itemset(i).getWeight();
        }
        return sum;
    }

    public final void sort(int attIndex) {
        int j = this.numItemsets() - 1;
        int i = 0;
        while (i <= j) {
            if (this.itemset(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.itemset(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    private void quickSort(int attIndex, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = this.itemset((lo0 + hi0) / 2).getValue(attIndex);
            double midPlus = mid + 1.0E-6;
            double midMinus = mid - 1.0E-6;
            while (lo <= hi) {
                while (this.itemset(lo).getValue(attIndex) < midMinus && lo < hi0) {
                    ++lo;
                }
                while (this.itemset(hi).getValue(attIndex) > midPlus && hi > lo0) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(attIndex, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(attIndex, lo, hi0);
            }
        }
    }

    private void swap(int i, int j) {
        Object help = this.itemsets.elementAt(i);
        this.itemsets.insertElementAt(this.itemsets.elementAt(j), i);
        this.itemsets.removeElementAt(i + 1);
        this.itemsets.insertElementAt(help, j);
        this.itemsets.removeElementAt(j + 1);
    }
}

