/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.resourcegroupstaggingapi.AWSResourceGroupsTaggingAPIAsync;
import com.amazonaws.services.resourcegroupstaggingapi.AWSResourceGroupsTaggingAPIAsyncClientBuilder;
import com.amazonaws.services.resourcegroupstaggingapi.AWSResourceGroupsTaggingAPIClient;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetResourcesResult;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetTagKeysRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetTagKeysResult;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetTagValuesRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetTagValuesResult;
import com.amazonaws.services.resourcegroupstaggingapi.model.TagResourcesRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.TagResourcesResult;
import com.amazonaws.services.resourcegroupstaggingapi.model.UntagResourcesRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.UntagResourcesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSResourceGroupsTaggingAPIAsyncClient
extends AWSResourceGroupsTaggingAPIClient
implements AWSResourceGroupsTaggingAPIAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSResourceGroupsTaggingAPIAsyncClientBuilder asyncBuilder() {
        return AWSResourceGroupsTaggingAPIAsyncClientBuilder.standard();
    }

    AWSResourceGroupsTaggingAPIAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetResourcesResult> getResourcesAsync(GetResourcesRequest request) {
        return this.getResourcesAsync(request, null);
    }

    @Override
    public Future<GetResourcesResult> getResourcesAsync(GetResourcesRequest request, final AsyncHandler<GetResourcesRequest, GetResourcesResult> asyncHandler) {
        final GetResourcesRequest finalRequest = (GetResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcesResult>(){

            @Override
            public GetResourcesResult call() throws Exception {
                GetResourcesResult result = null;
                try {
                    result = AWSResourceGroupsTaggingAPIAsyncClient.this.executeGetResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagKeysResult> getTagKeysAsync(GetTagKeysRequest request) {
        return this.getTagKeysAsync(request, null);
    }

    @Override
    public Future<GetTagKeysResult> getTagKeysAsync(GetTagKeysRequest request, final AsyncHandler<GetTagKeysRequest, GetTagKeysResult> asyncHandler) {
        final GetTagKeysRequest finalRequest = (GetTagKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagKeysResult>(){

            @Override
            public GetTagKeysResult call() throws Exception {
                GetTagKeysResult result = null;
                try {
                    result = AWSResourceGroupsTaggingAPIAsyncClient.this.executeGetTagKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagValuesResult> getTagValuesAsync(GetTagValuesRequest request) {
        return this.getTagValuesAsync(request, null);
    }

    @Override
    public Future<GetTagValuesResult> getTagValuesAsync(GetTagValuesRequest request, final AsyncHandler<GetTagValuesRequest, GetTagValuesResult> asyncHandler) {
        final GetTagValuesRequest finalRequest = (GetTagValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagValuesResult>(){

            @Override
            public GetTagValuesResult call() throws Exception {
                GetTagValuesResult result = null;
                try {
                    result = AWSResourceGroupsTaggingAPIAsyncClient.this.executeGetTagValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourcesResult> tagResourcesAsync(TagResourcesRequest request) {
        return this.tagResourcesAsync(request, null);
    }

    @Override
    public Future<TagResourcesResult> tagResourcesAsync(TagResourcesRequest request, final AsyncHandler<TagResourcesRequest, TagResourcesResult> asyncHandler) {
        final TagResourcesRequest finalRequest = (TagResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourcesResult>(){

            @Override
            public TagResourcesResult call() throws Exception {
                TagResourcesResult result = null;
                try {
                    result = AWSResourceGroupsTaggingAPIAsyncClient.this.executeTagResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourcesResult> untagResourcesAsync(UntagResourcesRequest request) {
        return this.untagResourcesAsync(request, null);
    }

    @Override
    public Future<UntagResourcesResult> untagResourcesAsync(UntagResourcesRequest request, final AsyncHandler<UntagResourcesRequest, UntagResourcesResult> asyncHandler) {
        final UntagResourcesRequest finalRequest = (UntagResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourcesResult>(){

            @Override
            public UntagResourcesResult call() throws Exception {
                UntagResourcesResult result = null;
                try {
                    result = AWSResourceGroupsTaggingAPIAsyncClient.this.executeUntagResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

