/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moa.AbstractMOAObject;
import moa.cluster.Clustering;
import moa.clusterers.kmeanspm.ClusteringFeature;
import moa.clusterers.kmeanspm.Metric;

public class ClusteringTreeNode
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    private double[] center;
    private final ClusteringFeature clusteringFeature;
    private List<ClusteringTreeNode> children;

    public ClusteringTreeNode(double[] center, ClusteringFeature cf) {
        assert (center == null || center.length == cf.getSumPoints().length);
        this.center = center;
        this.clusteringFeature = cf;
        this.children = new ArrayList<ClusteringTreeNode>();
    }

    @Deprecated
    public int count() {
        int count = this.clusteringFeature != null ? 1 : 0;
        for (ClusteringTreeNode child : this.children) {
            count += child.count();
        }
        return count;
    }

    public Clustering addToClustering(Clustering clustering) {
        if (this.center != null && this.getClusteringFeature() != null) {
            clustering.add(this.getClusteringFeature().toCluster());
        }
        for (ClusteringTreeNode child : this.children) {
            child.addToClustering(clustering);
        }
        return clustering;
    }

    public List<double[]> addToClusteringCenters(List<double[]> clustering) {
        if (this.center != null && this.getClusteringFeature() != null) {
            clustering.add(this.getClusteringFeature().toClusterCenter());
        }
        for (ClusteringTreeNode child : this.children) {
            child.addToClusteringCenters(clustering);
        }
        return clustering;
    }

    public void printClusteringCenters(Writer stream) throws IOException {
        if (this.center != null && this.getClusteringFeature() != null) {
            this.getClusteringFeature().printClusterCenter(stream);
        }
        for (ClusteringTreeNode child : this.children) {
            child.printClusteringCenters(stream);
        }
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        assert (this.center.length == center.length);
        this.center = center;
    }

    public ClusteringFeature getClusteringFeature() {
        return this.clusteringFeature;
    }

    public List<ClusteringTreeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("ClusteringFeature Tree Object");
    }

    public ClusteringTreeNode nearestChild(double[] pointA) {
        assert (this.center.length == pointA.length);
        double minDistance = Double.POSITIVE_INFINITY;
        ClusteringTreeNode min = null;
        for (ClusteringTreeNode node : this.getChildren()) {
            double d = Metric.distance(pointA, node.getCenter());
            if (!(d < minDistance)) continue;
            minDistance = d;
            min = node;
        }
        return min;
    }

    public boolean addChild(ClusteringTreeNode e) {
        assert (this.center.length == e.center.length);
        return this.children.add(e);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public boolean hasNoChildren() {
        return this.children.isEmpty();
    }

    public double getThreshold() {
        return this.clusteringFeature.getThreshold();
    }

    public void setThreshold(double threshold) {
        this.clusteringFeature.setThreshold(threshold);
    }
}

