/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LookupTableIconUtil {
    private static String[] LUTS = new String[]{"16_colors.lut", "3-3-2_rgb.lut", "5_ramps.lut", "6_shades.lut", "blue_orange_icb.lut", "brgbcmyw.lut", "cool.lut", "cyan_hot.lut", "edges.lut", "fire.lut", "gem.lut", "glasbey.lut", "glasbey_inverted.lut", "glow.lut", "grays.lut", "green_fire_blue.lut", "hilo.lut", "ica.lut", "ica2.lut", "ica3.lut", "ice.lut", "magenta_hot.lut", "orange_hot.lut", "phase.lut", "physics.lut", "pup_br.lut", "pup_nr.lut", "rainbow_rgb.lut", "red-green.lut", "red_hot.lut", "royal.lut", "sepia.lut", "smart.lut", "spectrum.lut", "thal.lut", "thallium.lut", "thermal.lut", "unionjack.lut", "yellow_hot.lut"};

    public static Icon getLUTIcon(String filename, Dimension dim) {
        Image img = LookupTableIconUtil.getLUTIconImage(filename);
        if (img != null) {
            img = img.getScaledInstance(dim.width, dim.height, 4);
            return new ImageIcon(img);
        }
        return LookupTableIconUtil.getDefaultIcon();
    }

    public static BufferedImage getLUTIconImage(String filename) {
        BufferedImage src = LookupTableIconUtil.getFullIconsImage();
        for (int i = 0; i < LUTS.length; ++i) {
            if (!LUTS[i].equals(filename)) continue;
            return src.getSubimage(0, i * 10, src.getWidth(), 10);
        }
        return LookupTableIconUtil.getDefaultImage();
    }

    private static BufferedImage getFullIconsImage() {
        ImageIcon i = IconManager.getInstance().getImageIcon(162);
        Image img = i.getImage();
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    private static BufferedImage getDefaultImage() {
        Dimension dim = new Dimension(96, 24);
        BufferedImage bimage = new BufferedImage(dim.width, dim.height, 1);
        Graphics2D bGr = bimage.createGraphics();
        bGr.setColor(UIUtilities.BACKGROUND);
        bGr.fillRect(0, 0, dim.width, dim.height);
        bGr.dispose();
        return bimage;
    }

    private static Icon getDefaultIcon() {
        return new ImageIcon(LookupTableIconUtil.getDefaultImage());
    }
}

