/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.roi.model.util.UnitPoint;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.BezierTextFigure;

public class MeasureBezierFigure
extends BezierTextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private boolean interactable;
    private List<Length> pointArrayX;
    private List<Length> pointArrayY;
    private List<Length> lengthArray;
    private Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;

    private int getLineSize() {
        int total = 0;
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Point2D.Double pt1 = this.getPoint(i);
            Point2D.Double pt2 = this.getPoint(i + 1);
            this.iterateLine((Line2D)new Line2D.Double(pt1, pt2), total);
        }
        return total;
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    private List<Point> getLinePoints() {
        ArrayList<Point> vector = new ArrayList<Point>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Point2D.Double pt1 = this.getPoint(i);
            Point2D.Double pt2 = this.getPoint(i + 1);
            this.iterateLine((Line2D)new Line2D.Double(pt1, pt2), vector);
        }
        return vector;
    }

    private void iterateLine(Line2D line, List<Point> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(pt.getX()), Math.floor(pt.getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, Boolean.TRUE);
        }
        for (Point2D pt : map.keySet()) {
            vector.add(new Point((int)pt.getX(), (int)pt.getY()));
        }
    }

    private void iterateLine(Line2D line, int total) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        HashMap<Point2D.Double, Boolean> map = new HashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D.Double pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(((Point2D)pt).getX()), Math.floor(((Point2D)pt).getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, Boolean.TRUE);
        }
        total += map.size();
    }

    public MeasureBezierFigure() {
        this(false, false, true, true, true, true);
    }

    public MeasureBezierFigure(boolean closed) {
        this(closed, false, true, true, true, true);
    }

    public MeasureBezierFigure(boolean closed, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", closed, readOnly, clientObject, editable, deletable, annotatable);
    }

    public MeasureBezierFigure(String text) {
        this(text, false);
    }

    public MeasureBezierFigure(String text, boolean closed) {
        this(text, closed, false, true, true, true, true);
    }

    public MeasureBezierFigure(String text, boolean closed, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        super(text, closed);
        this.setAttribute(MeasurementAttributes.FONT_FACE, DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.readOnly = readOnly;
        this.pointArrayX = new ArrayList<Length>();
        this.pointArrayY = new ArrayList<Length>();
        this.lengthArray = new ArrayList<Length>();
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue() || MeasurementAttributes.SHOWID.get(this).booleanValue()) {
            Double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            Font font = (Font)this.getAttribute(MeasurementAttributes.FONT_FACE);
            if (font != null) {
                g.setFont(font.deriveFont(sz.floatValue()));
            } else {
                g.setFont(new Font("sans-serif", 0, sz.intValue()));
            }
            if (this.isClosed()) {
                Length a = this.getArea();
                String polygonArea = UIUtilities.formatValue(a, true);
                this.bounds = g.getFontMetrics().getStringBounds(polygonArea, g);
                this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
                    g.setColor(MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get(this));
                    g.drawString(polygonArea, (int)this.bounds.getX(), (int)this.bounds.getY());
                }
                if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
                    g.setColor(this.getTextColor());
                    g.drawString(this.getROI().getID() + "", (int)this.bounds.getX(), (int)this.bounds.getY());
                }
            } else {
                Length l = this.getLength();
                String polygonLength = UIUtilities.formatValue(l);
                this.bounds = g.getFontMetrics().getStringBounds(polygonLength, g);
                if (super.getNodeCount() > 1) {
                    int midPoint = this.getNodeCount() / 2 - 1;
                    if (midPoint < 0) {
                        midPoint = 0;
                    }
                    Point2D.Double p0 = this.getPoint(midPoint);
                    Point2D.Double p1 = this.getPoint(midPoint + 1);
                    double x = Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()) + Math.abs(((Point2D)p0).getX() - ((Point2D)p1).getX());
                    double y = Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()) + Math.abs(((Point2D)p0).getY() - ((Point2D)p1).getY());
                    this.bounds = new Rectangle2D.Double(x - this.bounds.getWidth() / 2.0, y + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                    if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
                        g.setColor(MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get(this));
                        g.drawString(polygonLength + "", (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
                    }
                    if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
                        g.setColor(this.getTextColor());
                        g.drawString(this.getROI().getID() + "", (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
                    }
                }
            }
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        double diff;
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds == null) {
            return newBounds;
        }
        if (newBounds.getX() > this.bounds.getX()) {
            diff = newBounds.x - this.bounds.getX();
            newBounds.x = this.bounds.getX();
            newBounds.width += diff;
        }
        if (newBounds.getY() > this.bounds.getY()) {
            diff = newBounds.y - this.bounds.getY();
            newBounds.y = this.bounds.getY();
            newBounds.height += diff;
        }
        if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
            diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
            newBounds.width += diff;
        }
        if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
            diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
            newBounds.height += diff;
        }
        return newBounds;
    }

    public String addDegrees(String str) {
        if (str == null) {
            str = "0";
        }
        return str + "\u00b0";
    }

    private UnitPoint getPt(int i) {
        Point2D.Double pt = this.getNode(i).getControlPoint(0);
        return new UnitPoint(this.transformX(pt.getX()), this.transformY(pt.getY()));
    }

    public Length getLength() {
        double length = 0.0;
        for (int i = 0; i < this.path.size() - 1; ++i) {
            Point2D.Double p0 = ((BezierPath.Node)this.path.get(i)).getControlPoint(0);
            Point2D.Double p1 = ((BezierPath.Node)this.path.get(i + 1)).getControlPoint(0);
            length += p0.distance(p1);
        }
        return new LengthI(length, this.getUnit());
    }

    public int getPointCount() {
        return this.getPoints().size();
    }

    public UnitPoint getCentre() {
        Point2D.Double pt = this.path.getCenter();
        return new UnitPoint(this.transformX(pt.x), this.transformY(pt.y));
    }

    public Length getArea() {
        double area = 0.0;
        UnitPoint centre = this.getCentre();
        for (int i = 0; i < this.path.size(); ++i) {
            UnitPoint p0 = this.getPt(i);
            UnitPoint p1 = i == this.path.size() - 1 ? this.getPt(0) : this.getPt(i + 1);
            p0.setLocation(p0.x.getValue() - centre.x.getValue(), p0.y.getValue() - centre.y.getValue());
            p1.setLocation(p1.x.getValue() - centre.x.getValue(), p1.y.getValue() - centre.y.getValue());
            area += p0.x.getValue() * p1.y.getValue() - p1.x.getValue() * p0.y.getValue();
        }
        return new LengthI(Math.abs(area / 2.0), this.getUnit());
    }

    public void measureBasicRemoveNode(int index) {
        this.removeNode(index);
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        if (this.getNodeCount() < 2) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        for (int i = 0; i < this.path.size(); ++i) {
            this.pointArrayX.add(this.transformX(((BezierPath.Node)this.path.get(i)).getControlPoint(0).getX()));
            this.pointArrayY.add(this.transformY(((BezierPath.Node)this.path.get(i)).getControlPoint(0).getY()));
        }
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
        if (super.isClosed()) {
            AnnotationKeys.AREA.set(this.shape, this.getArea());
            AnnotationKeys.PERIMETER.set(this.shape, this.getLength());
            AnnotationKeys.CENTREX.set(this.shape, this.getCentre().x);
            AnnotationKeys.CENTREY.set(this.shape, this.getCentre().y);
        } else {
            this.lengthArray.clear();
            this.lengthArray.add(this.getLength());
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
            AnnotationKeys.CENTREX.set(this.shape, this.getCentre().x);
            AnnotationKeys.CENTREY.set(this.shape, this.getCentre().y);
            AnnotationKeys.STARTPOINTX.set(this.shape, this.getPt((int)0).x);
            AnnotationKeys.STARTPOINTX.set(this.shape, this.getPt((int)0).y);
            AnnotationKeys.ENDPOINTX.set(this.shape, this.getPt((int)(this.path.size() - 1)).x);
            AnnotationKeys.ENDPOINTY.set(this.shape, this.getPt((int)(this.path.size() - 1)).y);
        }
    }

    private List<Point> getAreaPoints() {
        Rectangle r = this.path.getBounds();
        double iX = Math.floor(r.getX());
        double iY = Math.floor(r.getY());
        ArrayList<Point> vector = new ArrayList<Point>();
        this.path.toPolygonArray();
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        int x = 0;
        while ((double)x < Math.ceil(r.getWidth())) {
            int y = 0;
            while ((double)y < Math.ceil(r.getHeight())) {
                ((Point2D)point).setLocation(iX + (double)x, iY + (double)y);
                if (this.path.contains(point)) {
                    vector.add(new Point((int)((Point2D)point).getX(), (int)((Point2D)point).getY()));
                }
                ++y;
            }
            ++x;
        }
        return vector;
    }

    private int getAreaSize() {
        Rectangle r = this.path.getBounds();
        double iX = Math.floor(r.getX());
        double iY = Math.floor(r.getY());
        int total = 0;
        this.path.toPolygonArray();
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        int x = 0;
        while ((double)x < Math.ceil(r.getWidth())) {
            int y = 0;
            while ((double)y < Math.ceil(r.getHeight())) {
                ((Point2D)point).setLocation(iX + (double)x, iY + (double)y);
                if (this.path.contains(point)) {
                    ++total;
                }
                ++y;
            }
            ++x;
        }
        return total;
    }

    @Override
    public String getType() {
        if (this.isClosed()) {
            return "Polygon";
        }
        return "Scribble";
    }

    @Override
    public List<Point> getPoints() {
        if (this.isClosed()) {
            return this.getAreaPoints();
        }
        return this.getLinePoints();
    }

    @Override
    public int getSize() {
        if (this.isClosed()) {
            return this.getAreaSize();
        }
        return this.getLineSize();
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureBezierFigure clone() {
        MeasureBezierFigure that = (MeasureBezierFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setClosed(boolean newValue) {
        super.setClosed(newValue);
        this.setObjectDirty(true);
    }

    @Override
    public void setBezierPath(BezierPath newValue) {
        super.setBezierPath(newValue);
        this.setObjectDirty(true);
    }

    @Override
    public void setEndPoint(Point2D.Double p) {
        super.setEndPoint(p);
        this.setObjectDirty(true);
    }

    @Override
    public void setNode(int index, BezierPath.Node p) {
        super.setNode(index, p);
        this.setObjectDirty(true);
    }

    @Override
    public void setPoint(int index, int coord, Point2D.Double p) {
        super.setPoint(index, coord, p);
        this.setObjectDirty(true);
    }

    @Override
    public void setStartPoint(Point2D.Double p) {
        super.setStartPoint(p);
        this.setObjectDirty(true);
    }

    @Override
    public int splitSegment(Point2D.Double split) {
        this.setObjectDirty(true);
        return super.splitSegment(split);
    }

    @Override
    public int splitSegment(Point2D.Double split, float tolerance) {
        this.setObjectDirty(true);
        return super.splitSegment(split, tolerance);
    }

    @Override
    public int joinSegments(Point2D.Double join, float tolerance) {
        this.setObjectDirty(true);
        return super.joinSegments(join, tolerance);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public BezierPath.Node removeNode(int node) {
        return super.removeNode(node);
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }

    private Length transformX(double x) {
        return this.transformX((int)x);
    }

    private Length transformY(double y) {
        return this.transformY((int)y);
    }

    private Length transformX(int x) {
        if (this.units.getPixelSizeX() != null) {
            return new LengthI((double)x * this.units.getPixelSizeX().getValue(), this.units.getPixelSizeX().getUnit());
        }
        return new LengthI((double)x, UnitsLength.PIXEL);
    }

    private Length transformY(int y) {
        if (this.units.getPixelSizeY() != null) {
            return new LengthI((double)y * this.units.getPixelSizeY().getValue(), this.units.getPixelSizeY().getUnit());
        }
        return new LengthI((double)y, UnitsLength.PIXEL);
    }

    private UnitsLength getUnit() {
        if (this.units.getPixelSizeX() != null) {
            return this.units.getPixelSizeX().getUnit();
        }
        return UnitsLength.PIXEL;
    }
}

