/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import omero.ValidationException;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ScriptUploader
extends UserNotifierLoader {
    private CallHandle handle;
    private ScriptObject script;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to upload the script", message, ex);
    }

    public ScriptUploader(UserNotifier viewer, Registry registry, SecurityContext ctx, ScriptObject script, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        this.script = script;
    }

    @Override
    public void load() {
        this.handle = this.ivView.uploadScript(this.ctx, this.script, this);
    }

    @Override
    public void cancel() {
        if (this.handle != null) {
            this.handle.cancel();
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (result instanceof Long) {
            Long value = (Long)result;
            if (value < 0L) {
                this.onException("No result returned.", null);
            } else {
                this.activity.endActivity(result);
            }
        }
    }

    @Override
    public void handleException(Throwable exc) {
        if (exc instanceof ValidationException) {
            ValidationException e = (ValidationException)exc;
            StringBuilder sb = new StringBuilder();
            sb.append("Script was rejected because its validation failed, details:\n\n");
            Boolean read = null;
            BufferedReader in = new BufferedReader(new StringReader(e.message));
            String line = null;
            try {
                while ((line = in.readLine()) != null) {
                    if (line.matches("\\-{10,}")) {
                        if (read == null) {
                            read = Boolean.TRUE;
                            continue;
                        }
                        break;
                    }
                    if (!Boolean.TRUE.equals(read)) continue;
                    sb.append(line + "\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.registry.getUserNotifier().notifyError("Script Validation failed", sb.toString());
        } else {
            super.handleException(exc);
        }
    }
}

