/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.FileLoadingComponent;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DownloadsDialog
extends JDialog
implements PropertyChangeListener {
    static final String CANCEL_LOADING_PROPERTY = "cancelLoading";
    static final int DOWNLOAD = 0;
    static final int UPLOAD = 1;
    static final int ACTIVITY = 2;
    private static final String TITLE_DOWNLOAD = "Downloads";
    private static final String TITLE_UPLOAD = "Uploads";
    private static final String TITLE_ACTIVITY = "Activities";
    private static final double[] COLUMNS = new double[]{-1.0};
    private IconManager icons;
    private JPanel entries;
    private JButton cleanupButton;
    private List<JComponent> components;
    private int dialogIndex;

    private void initComponents() {
        this.components = new ArrayList<JComponent>();
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        this.cleanupButton = new JButton("Clear List");
        this.getRootPane().setDefaultButton(this.cleanupButton);
        this.cleanupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadsDialog.this.cleanup();
            }
        });
    }

    private void cleanup() {
        ArrayList<JComponent> toRemove = new ArrayList<JComponent>();
        for (JComponent comp : this.components) {
            if (comp instanceof FileLoadingComponent) {
                if (((FileLoadingComponent)comp).isOngoingActivity()) continue;
                toRemove.add(comp);
                continue;
            }
            if (!(comp instanceof ActivityComponent) || ((ActivityComponent)comp).isOngoingActivity()) continue;
            toRemove.add(comp);
        }
        this.components.removeAll(toRemove);
        this.layoutEntries();
    }

    private JPanel buildStatusBar() {
        JPanel p = new JPanel();
        p.add(this.cleanupButton);
        JPanel bar = UIUtilities.buildComponentPanelRight(p);
        bar.setBorder(new LineBorder(Color.LIGHT_GRAY));
        return bar;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        JScrollPane pane = new JScrollPane(this.entries);
        pane.setOpaque(false);
        pane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        c.add((Component)pane, "Center");
        c.add((Component)this.buildStatusBar(), "South");
    }

    private void layoutEntries() {
        this.entries.removeAll();
        TableLayout layout = new TableLayout();
        layout.setColumn(COLUMNS);
        this.entries.setLayout(layout);
        int index = 0;
        ListIterator<JComponent> i = this.components.listIterator(this.components.size());
        while (i.hasPrevious()) {
            layout.insertRow(index, -2.0);
            JComponent c = i.previous();
            this.entries.add((Component)c, "0, " + index + ", FULL, CENTER");
            if (index % 2 == 0) {
                c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
            } else {
                c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
            }
            ++index;
        }
        this.entries.revalidate();
        this.repaint();
    }

    private void setDialogIndex(int value) {
        switch (value) {
            default: {
                this.dialogIndex = 0;
                this.setTitle(TITLE_DOWNLOAD);
                break;
            }
            case 1: {
                this.dialogIndex = value;
                this.setTitle(TITLE_UPLOAD);
                break;
            }
            case 2: {
                this.dialogIndex = 2;
                this.setTitle(TITLE_ACTIVITY);
            }
        }
    }

    DownloadsDialog(JFrame owner, IconManager icons, int index) {
        super(owner);
        this.setModal(false);
        if (icons == null) {
            throw new IllegalArgumentException("No icons manager specified.");
        }
        this.setDialogIndex(index);
        this.icons = icons;
        this.initComponents();
        this.buildGUI();
        this.setSize(350, 250);
    }

    DownloadsDialog(JFrame owner, IconManager icons) {
        this(owner, icons, 0);
    }

    void setLoadingStatus(int percent, String name, long fileID) {
        for (JComponent obj : this.components) {
            FileLoadingComponent c;
            if (!(obj instanceof FileLoadingComponent) || (c = (FileLoadingComponent)obj).getFileID() != fileID || !c.getAbsolutePath().equals(name)) continue;
            c.setStatus(percent);
        }
    }

    void addActivityEntry(String directory, String fileName, long fileID) {
        FileLoadingComponent c = new FileLoadingComponent(directory, fileName, fileID, this.icons);
        c.addPropertyChangeListener(this);
        this.components.add(c);
        this.layoutEntries();
    }

    void addActivityEntry(JComponent component) {
        if (component == null) {
            return;
        }
        component.addPropertyChangeListener(this);
        this.components.add(component);
        this.layoutEntries();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("cancel".equals(name)) {
            this.firePropertyChange(CANCEL_LOADING_PROPERTY, evt.getOldValue(), evt.getNewValue());
        } else if ("remove".equals(name)) {
            String path = (String)evt.getNewValue();
            Iterator<JComponent> i = this.components.iterator();
            FileLoadingComponent toRemove = null;
            while (i.hasNext()) {
                FileLoadingComponent c;
                JComponent obj = i.next();
                if (!(obj instanceof FileLoadingComponent) || !(c = (FileLoadingComponent)obj).getAbsolutePath().equals(path)) continue;
                toRemove = c;
                break;
            }
            if (toRemove != null) {
                this.components.remove(toRemove);
                this.layoutEntries();
            }
        } else if ("removeActivity".equals(name)) {
            this.components.remove(evt.getNewValue());
            this.layoutEntries();
        }
    }
}

