/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.api.RenderingEnginePrx;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.ChannelData;
import omero.gateway.rnd.DataSink;
import omero.log.Logger;
import omero.model.ChannelBinding;
import omero.model.CodomainMapContext;
import omero.model.Pixels;
import omero.model.QuantumDef;
import omero.model.RenderingDef;
import omero.model.ReverseIntensityContext;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingControlProxy;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class PixelsServicesFactory {
    private static final double RATIO = 0.1;
    private static final int FACTOR = 0x100000;
    private static PixelsServicesFactory singleton;
    private static Registry registry;
    private static int maxSize;
    private Map<Long, RenderingControl> rndSvcProxies = new HashMap<Long, RenderingControl>();
    private DataSink pixelsSource;
    private Map<Long, Integer> rndSvcProxiesCount = new HashMap<Long, Integer>();

    public static RndProxyDef convert(RenderingDef rndDef) {
        if (rndDef == null) {
            return null;
        }
        RndProxyDef proxy = new RndProxyDef(rndDef);
        try {
            long v = rndDef.getDetails().getUpdateEvent().getTime().getValue();
            proxy.setLastModified(new Timestamp(v));
        }
        catch (Exception v) {
            // empty catch block
        }
        if (rndDef.getName() != null) {
            proxy.setName(rndDef.getName().getValue());
        }
        proxy.setDefaultZ(rndDef.getDefaultZ().getValue());
        proxy.setDefaultT(rndDef.getDefaultT().getValue());
        proxy.setColorModel(rndDef.getModel().getValue().getValue());
        QuantumDef def = rndDef.getQuantization();
        proxy.setCodomain(def.getCdStart().getValue(), def.getCdEnd().getValue());
        proxy.setBitResolution(def.getBitResolution().getValue());
        List bindings = rndDef.copyWaveRendering();
        Iterator k = bindings.iterator();
        int i = 0;
        while (k.hasNext()) {
            ChannelBinding c = (ChannelBinding)k.next();
            ChannelBindingsProxy cb = proxy.getChannel(i);
            if (cb == null) {
                cb = new ChannelBindingsProxy();
                proxy.setChannel(i, cb);
            }
            if (c != null) {
                int[] rgba = new int[]{c.getRed().getValue(), c.getGreen().getValue(), c.getBlue().getValue(), c.getAlpha().getValue()};
                cb.setActive(c.getActive().getValue());
                cb.setInterval(c.getInputStart().getValue(), c.getInputEnd().getValue());
                cb.setRGBA(rgba);
                cb.setQuantization(c.getFamily().getValue().getValue(), c.getCoefficient().getValue(), c.getNoiseReduction().getValue());
                if (c.getLookupTable() != null) {
                    cb.setLookupTable(c.getLookupTable().getValue());
                }
                cb.setReverseIntensity(false);
                List cdctx = c.copySpatialDomainEnhancement();
                for (CodomainMapContext cd : cdctx) {
                    if (!(cd instanceof ReverseIntensityContext)) continue;
                    cb.setReverseIntensity(true);
                    break;
                }
            }
            ++i;
        }
        return proxy;
    }

    public static PixelsServicesFactory getInstance(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            registry = c.getRegistry();
            singleton = new PixelsServicesFactory();
            MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            String message = "Heap memory usage: max " + usage.getMax();
            registry.getLogger().info((Object)singleton, message);
            maxSize = (int)(0.1 * (double)usage.getMax()) / 0x100000;
        }
        return singleton;
    }

    public static RenderingControl createRenderingControl(Registry context, SecurityContext ctx, List<RenderingEnginePrx> reList, Pixels pixels, List<ChannelData> metadata, int compression, List<RndProxyDef> defs) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        return singleton.makeNew(ctx, reList, pixels, metadata, compression, defs);
    }

    public static RenderingControlProxy reloadRenderingControl(Registry context, long pixelsID, List<RenderingEnginePrx> reList) throws RenderingServiceException, DSOutOfServiceException {
        if (!registry.equals(context)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        if (reList == null || reList.size() == 0) {
            throw new IllegalArgumentException("No RE specified.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy != null) {
            proxy.shutDown();
            proxy.setRenderingEngine(reList.get(0));
            reList.remove(0);
            List<RenderingControl> slaves = proxy.getSlaves();
            if (slaves.size() == reList.size()) {
                Iterator<RenderingControl> i = slaves.iterator();
                int index = 0;
                while (i.hasNext()) {
                    proxy = (RenderingControlProxy)i.next();
                    proxy.shutDown();
                    proxy.setRenderingEngine(reList.get(index));
                }
                ++index;
            }
        }
        return proxy;
    }

    public static RenderingControlProxy resetRenderingControl(Registry context, long pixelsID, List<RenderingEnginePrx> reList, RenderingDef def) throws RenderingServiceException, DSOutOfServiceException {
        if (!registry.equals(context)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        if (reList == null || reList.size() == 0) {
            throw new IllegalArgumentException("No RE specified.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy != null) {
            RndProxyDef converted = PixelsServicesFactory.convert(def);
            proxy.resetRenderingEngine(reList.get(0), converted);
            reList.remove(0);
            List<RenderingControl> slaves = proxy.getSlaves();
            if (slaves.size() == reList.size()) {
                Iterator<RenderingControl> i = slaves.iterator();
                int index = 0;
                while (i.hasNext()) {
                    proxy = (RenderingControlProxy)i.next();
                    proxy.resetRenderingEngine(reList.get(index), converted);
                }
                ++index;
            }
        }
        return proxy;
    }

    public static boolean shutDownRenderingControl(Registry context, long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        Integer count = PixelsServicesFactory.singleton.rndSvcProxiesCount.get(pixelsID);
        if (proxy != null) {
            if (count == 1) {
                proxy.shutDown();
                PixelsServicesFactory.singleton.rndSvcProxies.remove(pixelsID);
                PixelsServicesFactory.singleton.rndSvcProxiesCount.remove(pixelsID);
                PixelsServicesFactory.getCacheSize();
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count - 1);
                PixelsServicesFactory.singleton.rndSvcProxiesCount.put(pixelsID, count);
            }
            return PixelsServicesFactory.singleton.rndSvcProxiesCount.containsKey(pixelsID);
        }
        return false;
    }

    public static void shutDownRenderingControls(Registry context) {
        PixelsServicesFactory.singleton.rndSvcProxies.clear();
        PixelsServicesFactory.singleton.rndSvcProxiesCount.clear();
    }

    public static void checkRenderingControls(Registry context) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        Iterator<Map.Entry<Long, RenderingControl>> i = PixelsServicesFactory.singleton.rndSvcProxies.entrySet().iterator();
        Long value = (Long)context.lookup("/services/RE/timeout");
        long timeout = 60000L;
        if (value != null && value > timeout) {
            timeout = value;
        }
        Logger logger = context.getLogger();
        while (i.hasNext()) {
            Map.Entry<Long, RenderingControl> e = i.next();
            RenderingControlProxy proxy = (RenderingControlProxy)e.getValue();
            if (proxy.isProxyActive(timeout) || proxy.shutDown(true)) continue;
            logger.info((Object)singleton, "Rendering Engine shut down: PixelsID " + e.getKey());
        }
    }

    public static RenderingControl getRenderingControl(Registry context, Long pixelsID, boolean init) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        if (init && PixelsServicesFactory.singleton.rndSvcProxiesCount.containsKey(pixelsID)) {
            Integer count;
            Integer n = count = PixelsServicesFactory.singleton.rndSvcProxiesCount.get(pixelsID);
            Integer n2 = count = Integer.valueOf(count + 1);
            PixelsServicesFactory.singleton.rndSvcProxiesCount.put(pixelsID, count);
        }
        return PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
    }

    public static boolean isRenderingControlShared(Registry context, Long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        if (!PixelsServicesFactory.singleton.rndSvcProxiesCount.containsKey(pixelsID)) {
            return false;
        }
        Integer count = PixelsServicesFactory.singleton.rndSvcProxiesCount.get(pixelsID);
        return count > 1;
    }

    public static Object render(Registry context, SecurityContext ctx, Long pixelsID, PlaneDef pDef, boolean largeImage, int compression) throws RenderingServiceException, DSOutOfServiceException {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        int level = proxy.getSelectedResolutionLevel();
        if (compression < 0) {
            compression = 0;
        }
        if (compression > 2) {
            compression = 2;
        }
        proxy.setCompression(compression);
        if (largeImage) {
            proxy.setSelectedResolutionLevel(0);
        }
        BufferedImage o = proxy.render(pDef);
        if (largeImage) {
            proxy.setSelectedResolutionLevel(level);
        }
        return o;
    }

    public static Object renderOverlays(Registry context, long pixelsID, PlaneDef pd, long tableID, Map<Long, Integer> overlays) throws RenderingServiceException, DSOutOfServiceException {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        proxy.setOverlays(tableID, overlays);
        return proxy.render(pd);
    }

    public static BufferedImage renderProjected(Registry context, Long pixelsID, int startZ, int endZ, int type, int stepping, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        return proxy.renderProjected(startZ, endZ, stepping, type, channels);
    }

    static final float getCompressionQuality(int compressionLevel) {
        switch (compressionLevel) {
            default: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
            case 2: 
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private PixelsServicesFactory() {
    }

    private RenderingControl makeNew(SecurityContext ctx, List<RenderingEnginePrx> reList, Pixels pixels, List<ChannelData> metadata, int compression, List<RndProxyDef> defs) {
        if (singleton == null) {
            throw new NullPointerException();
        }
        Long id = pixels.getId().getValue();
        RenderingControl rnd = PixelsServicesFactory.singleton.rndSvcProxies.get(id);
        if (rnd != null) {
            return rnd;
        }
        PixelsServicesFactory.singleton.rndSvcProxiesCount.put(id, 1);
        RenderingEnginePrx master = reList.get(0);
        int size = PixelsServicesFactory.getCacheSize();
        reList.remove(0);
        rnd = new RenderingControlProxy(registry, ctx, master, pixels, metadata, compression, defs, size);
        Iterator<RenderingEnginePrx> i = reList.iterator();
        if (reList.size() > 0) {
            ArrayList<RenderingControl> slaves = new ArrayList<RenderingControl>(reList.size());
            while (i.hasNext()) {
                slaves.add(new RenderingControlProxy(registry, ctx, i.next(), pixels, metadata, compression, defs, size));
            }
            ((RenderingControlProxy)rnd).setSlaves(slaves);
        }
        PixelsServicesFactory.singleton.rndSvcProxies.put(id, rnd);
        return rnd;
    }

    private static int getCacheSize() {
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        maxSize = (int)(0.1 * (double)(usage.getMax() - usage.getUsed())) / 0x100000;
        int m = PixelsServicesFactory.singleton.rndSvcProxies.size();
        int n = 0;
        int sizeCache = 0;
        if (PixelsServicesFactory.singleton.pixelsSource != null) {
            n = 1;
        }
        if (n == 0 && m == 0) {
            return maxSize * 0x100000;
        }
        if (n == 0 && m > 0) {
            sizeCache = maxSize / (m + 1) * 0x100000;
            for (Map.Entry<Long, RenderingControl> entry : PixelsServicesFactory.singleton.rndSvcProxies.entrySet()) {
                RenderingControlProxy proxy = (RenderingControlProxy)entry.getValue();
                proxy.setCacheSize(sizeCache);
            }
            return sizeCache;
        }
        if (m == 0 && n > 0) {
            sizeCache = maxSize / (n + 1) * 0x100000;
            return sizeCache;
        }
        sizeCache = maxSize / (m + n + 1) * 0x100000;
        for (Map.Entry<Long, RenderingControl> entry : PixelsServicesFactory.singleton.rndSvcProxies.entrySet()) {
            RenderingControlProxy proxy = (RenderingControlProxy)entry.getValue();
            proxy.setCacheSize(sizeCache);
        }
        return sizeCache;
    }
}

