/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class AdminLoader
extends BatchCallTree {
    public static final int SPACE = 0;
    public static final int GROUPS = 1;
    public static final int EXPERIMENTERS = 2;
    public static final int EXPERIMENTER_PHOTO = 3;
    public static final int EXPERIMENTER_UPDATE = 4;
    private Object result;
    private BatchCall loadCall;

    private BatchCall availableSpaceCall(final SecurityContext ctx, final Class type, final long id) {
        return new BatchCall("Loading disk space information"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.getQuota(ctx, type, id);
            }
        };
    }

    private BatchCall availableSpaceCall(final SecurityContext ctx, final Class type, final List<Long> ids) {
        return new BatchCall("Loading disk space information"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                ArrayList<DiskQuota> list = new ArrayList<DiskQuota>();
                Iterator i = ids.iterator();
                while (i.hasNext()) {
                    list.add(os.getQuota(ctx, type, (Long)i.next()));
                }
                AdminLoader.this.result = list;
            }
        };
    }

    private BatchCall changePassword(final SecurityContext ctx, final String oldPassword, final String newPassword) {
        return new BatchCall("Change password"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.changePassword(ctx, oldPassword, newPassword);
            }
        };
    }

    private BatchCall updateExperimenter(final SecurityContext ctx, final ExperimenterData exp) {
        return new BatchCall("Update experimenter"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateExperimenter(ctx, exp, null);
            }
        };
    }

    private BatchCall updateGroup(final SecurityContext ctx, final GroupData group) {
        return new BatchCall("Update group"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateGroup(ctx, group);
            }
        };
    }

    private BatchCall changeGroup(final SecurityContext ctx, final GroupData group, final ExperimenterData experimenter) {
        return new BatchCall("Change the default group"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.changeExperimenterGroup(ctx, experimenter, group.getId());
            }
        };
    }

    private BatchCall loadGroup(final SecurityContext ctx, final long id) {
        return new BatchCall("Load groups"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.loadGroups(ctx, id);
            }
        };
    }

    private BatchCall loadExperimenters(final SecurityContext ctx, final long id) {
        return new BatchCall("Load experimenters"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.loadExperimenters(ctx, id);
            }
        };
    }

    private BatchCall lookupExperimenter(final SecurityContext ctx, final long id) {
        return new BatchCall("lookupLdapAuthExperimenter"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.lookupLdapAuthExperimenter(ctx, id);
            }
        };
    }

    private BatchCall updateExperimenters(final SecurityContext ctx, final GroupData group, final Map<ExperimenterData, UserCredentials> experimenters) {
        return new BatchCall("Update experimenters"){

            @Override
            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateExperimenters(ctx, group, experimenters);
            }
        };
    }

    private BatchCall loadExperimenterPhoto(final SecurityContext ctx, final ExperimenterData experimenter) {
        return new BatchCall("Load photo"){

            @Override
            public void doCall() throws Exception {
                OmeroImageService os = AdminLoader.this.context.getImageService();
                ArrayList<DataObject> exps = new ArrayList<DataObject>();
                exps.add((DataObject)experimenter);
                Map<DataObject, BufferedImage> map = os.getExperimenterThumbnailSet(ctx, exps, 96);
                AdminLoader.this.result = map.get(experimenter);
            }
        };
    }

    private BatchCall uploadExperimenterPhoto(final SecurityContext ctx, final ExperimenterData experimenter, final File photo, final String format) {
        return new BatchCall("Update experimenters"){

            @Override
            public void doCall() throws Exception {
                AdminService svc = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = svc.uploadUserPhoto(ctx, photo, format, experimenter);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public AdminLoader(SecurityContext ctx, long id, int index) {
        switch (index) {
            case 0: {
                this.loadCall = this.availableSpaceCall(ctx, ExperimenterData.class, id);
                break;
            }
            case 1: {
                this.loadCall = this.loadGroup(ctx, id);
                break;
            }
            case 2: {
                this.loadCall = this.loadExperimenters(ctx, id);
            }
        }
    }

    public AdminLoader(SecurityContext ctx, Class type, long id) {
        this.loadCall = this.availableSpaceCall(ctx, type, id);
    }

    public AdminLoader(SecurityContext ctx, Class type, List<Long> ids) {
        this.loadCall = this.availableSpaceCall(ctx, type, ids);
    }

    public AdminLoader(SecurityContext ctx, String oldPassword, String newPassword) {
        if (CommonsLangUtils.isBlank(newPassword) || CommonsLangUtils.isBlank(oldPassword)) {
            throw new IllegalArgumentException("Password not valid.");
        }
        this.loadCall = this.changePassword(ctx, oldPassword, newPassword);
    }

    public AdminLoader(SecurityContext ctx, ExperimenterData exp, int index) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        switch (index) {
            case 4: {
                this.loadCall = this.updateExperimenter(ctx, exp);
                break;
            }
            case 3: {
                this.loadCall = this.loadExperimenterPhoto(ctx, exp);
            }
        }
    }

    public AdminLoader(SecurityContext ctx, ExperimenterData exp, File photo, String format) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        if (photo == null) {
            throw new IllegalArgumentException("Photo not valid.");
        }
        this.loadCall = this.uploadExperimenterPhoto(ctx, exp, photo, format);
    }

    public AdminLoader(SecurityContext ctx, GroupData group) {
        if (group == null) {
            throw new IllegalArgumentException("Group not valid.");
        }
        this.loadCall = this.updateGroup(ctx, group);
    }

    public AdminLoader(SecurityContext ctx, GroupData group, Map<ExperimenterData, UserCredentials> experimenters) {
        if (experimenters == null) {
            throw new IllegalArgumentException("No experimenters to update.");
        }
        this.loadCall = this.updateExperimenters(ctx, group, experimenters);
    }

    public AdminLoader(SecurityContext ctx, GroupData group, ExperimenterData experimenter) {
        if (group == null) {
            throw new IllegalArgumentException("No group indicated.");
        }
        this.loadCall = this.changeGroup(ctx, group, experimenter);
    }

    public AdminLoader(SecurityContext ctx, long userID) {
        this.loadCall = this.lookupExperimenter(ctx, userID);
    }
}

