/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import loci.common.RandomAccessInputStream;
import loci.formats.IFormatHandler;
import loci.formats.ImageReader;
import loci.formats.gui.GUITools;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportContainer;
import omero.ValidationException;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.util.PojoMapper;
import omero.log.LogMessage;
import omero.model.Annotation;
import omero.model.Channel;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.RenderingDef;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.TagAnnotation;
import omero.romio.PlaneDef;
import omero.rtypes;
import omero.sys.Parameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.ScriptCallback;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.Resolver;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.WriterImage;

class OmeroImageServiceImpl
implements OmeroImageService {
    private FileFilter[] filters;
    private Registry context;
    private OMEROGateway gateway;
    private static Collection<String> LOOKUP_TABLES;

    private int getNumberOfRenderingEngines(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        int number = 1;
        Integer workers = (Integer)this.context.lookup("/services/RE/worker");
        if (workers != null && (number = workers.intValue()) <= 0) {
            number = 1;
        }
        if (!this.gateway.isLargeImage(ctx, pixelsID).booleanValue()) {
            number = 1;
        }
        return number;
    }

    private Object importCandidates(SecurityContext ctx, Map<File, Status> files, Status status, ImportableObject object, IObject ioContainer, List<Annotation> list, long userID, boolean close, boolean hcs, String userName) throws DSAccessException, DSOutOfServiceException {
        if (status.isMarkedAsCancel()) {
            if (close) {
                this.gateway.closeImport(ctx, userName);
            }
            return false;
        }
        Iterator<Map.Entry<File, Status>> jj = files.entrySet().iterator();
        Status label = null;
        boolean toClose = false;
        int n = files.size() - 1;
        int index = 0;
        while (jj.hasNext()) {
            Map.Entry<File, Status> entry = jj.next();
            File file = entry.getKey();
            if (hcs && !file.getName().endsWith("dat") && ioContainer != null && !ioContainer.getClass().equals(Screen.class) && !ioContainer.getClass().equals(ScreenI.class)) {
                ioContainer = null;
            }
            label = entry.getValue();
            if (close) {
                toClose = index == n;
                ++index;
            }
            if (!label.isMarkedAsCancel()) {
                try {
                    ImportCandidates ic;
                    List icContainers;
                    if (ioContainer == null) {
                        label.setNoContainer();
                    }
                    if ((icContainers = (ic = this.gateway.getImportCandidates(ctx, object, file, status)).getContainers()).size() == 0) {
                        Object o = status.getImportResult();
                        if (o instanceof ImportException) {
                            label.setCallback(o);
                            continue;
                        }
                        label.setCallback(new ImportException("File Not Valid"));
                        continue;
                    }
                    if (label.isMarkedAsCancel()) {
                        label.setCallback(false);
                        continue;
                    }
                    ImportContainer importIc = (ImportContainer)icContainers.get(0);
                    importIc.setCustomAnnotationList(list);
                    label.setCallback(this.gateway.importImageFile(ctx, object, ioContainer, importIc, label, toClose, userName));
                }
                catch (Exception e) {
                    label.setCallback(e);
                }
                continue;
            }
            label.setCallback(false);
        }
        if (close) {
            this.gateway.closeImport(ctx, userName);
        }
        return null;
    }

    private boolean isBinaryAvailable() {
        Boolean b = (Boolean)this.context.lookup("/services/SERVER/BinaryAvailable");
        if (b == null) {
            return true;
        }
        return b;
    }

    private BufferedImage createImage(byte[] values) throws RenderingServiceException {
        try {
            return WriterImage.bytesToImage(values);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot create buffered image", (Throwable)e);
        }
    }

    private BufferedImage createImage(String path) throws FSAccessException {
        try {
            return ImageIO.read(new File(path));
        }
        catch (Exception e) {
            throw new FSAccessException("Cannot create buffered image", e);
        }
    }

    private IObject determineContainer(SecurityContext ctx, DatasetData dataset, DataObject container, ImportableObject object, String userName) throws DSOutOfServiceException, DSAccessException {
        IObject ioContainer = null;
        HashMap parameters = new HashMap();
        IObject project = null;
        if (dataset != null) {
            if (dataset.getId() <= 0L) {
                if (container != null) {
                    if (container.getId() <= 0L) {
                        DataObject createdData = object.hasObjectBeenCreated(container, ctx);
                        if (createdData == null) {
                            project = this.gateway.saveAndReturnObject(ctx, container.asIObject(), parameters, userName);
                            object.addNewDataObject(PojoMapper.asDataObject((IObject)project));
                            ioContainer = this.gateway.saveAndReturnObject(ctx, dataset.asIObject(), parameters, userName);
                            object.registerDataset(project.getId().getValue(), (DatasetData)PojoMapper.asDataObject((IObject)ioContainer));
                            ProjectDatasetLink link = (ProjectDatasetLink)ModelMapper.linkParentToChild((IObject)((Dataset)ioContainer), (IObject)((Project)project));
                            link = (ProjectDatasetLink)this.gateway.saveAndReturnObject(ctx, (IObject)link, parameters, userName);
                        } else {
                            DatasetData d = object.isDatasetCreated(createdData.getId(), dataset);
                            if (d == null) {
                                ioContainer = this.gateway.saveAndReturnObject(ctx, dataset.asIObject(), parameters, userName);
                                object.registerDataset(createdData.getId(), (DatasetData)PojoMapper.asDataObject((IObject)ioContainer));
                                ProjectDatasetLink link = (ProjectDatasetLink)ModelMapper.linkParentToChild((IObject)((Dataset)ioContainer), (IObject)createdData.asProject());
                                link = (ProjectDatasetLink)this.gateway.saveAndReturnObject(ctx, (IObject)link, parameters, userName);
                            } else {
                                ioContainer = d.asIObject();
                            }
                        }
                    } else {
                        DatasetData createdData = object.isDatasetCreated(container.getId(), dataset);
                        if (createdData == null) {
                            ioContainer = this.gateway.saveAndReturnObject(ctx, dataset.asIObject(), parameters, userName);
                            object.registerDataset(container.getId(), (DatasetData)PojoMapper.asDataObject((IObject)ioContainer));
                            IObject ho = this.gateway.findIObject(ctx, container.asIObject());
                            if (ho != null) {
                                ProjectDatasetLink link = (ProjectDatasetLink)ModelMapper.linkParentToChild((IObject)((Dataset)ioContainer), (IObject)container.asProject());
                                link = (ProjectDatasetLink)this.gateway.saveAndReturnObject(ctx, (IObject)link, parameters, userName);
                            }
                        } else {
                            ioContainer = createdData.asIObject();
                        }
                    }
                } else {
                    DataObject createdData = object.hasObjectBeenCreated((DataObject)dataset, ctx);
                    if (createdData == null) {
                        ioContainer = this.gateway.saveAndReturnObject(ctx, dataset.asIObject(), parameters, userName);
                        object.addNewDataObject(PojoMapper.asDataObject((IObject)ioContainer));
                    } else {
                        ioContainer = createdData.asIObject();
                    }
                }
            } else {
                ioContainer = dataset.asIObject();
            }
        } else if (container != null) {
            if (container.getId() <= 0L) {
                DataObject createdData = object.hasObjectBeenCreated(container, ctx);
                if (createdData == null) {
                    ioContainer = this.gateway.saveAndReturnObject(ctx, container.asIObject(), parameters, userName);
                    object.addNewDataObject(PojoMapper.asDataObject(project));
                } else {
                    ioContainer = createdData.asIObject();
                }
            } else {
                ioContainer = container.asIObject();
            }
        }
        return this.gateway.findIObject(ctx, ioContainer);
    }

    OmeroImageServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public RenderingControl loadRenderingControl(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, pixelsID, true);
        if (proxy == null) {
            int compressionLevel;
            UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
            switch (uc.getSpeedLevel()) {
                case 1: {
                    compressionLevel = 1;
                    break;
                }
                case 2: {
                    compressionLevel = 2;
                    break;
                }
                default: {
                    compressionLevel = 0;
                }
            }
            Pixels pixels = this.gateway.getPixels(ctx, pixelsID);
            if (pixels == null) {
                return null;
            }
            int number = this.getNumberOfRenderingEngines(ctx, pixelsID);
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            ArrayList<RenderingEnginePrx> reList = new ArrayList<RenderingEnginePrx>(number);
            for (int i = 0; i < number; ++i) {
                reList.add(this.gateway.createRenderingEngine(ctx, pixelsID));
            }
            List<RndProxyDef> defs = this.gateway.getRenderingSettingsFor(ctx, pixelsID, exp.getId());
            List l = pixels.copyChannels();
            Iterator i = l.iterator();
            ArrayList<ChannelData> m = new ArrayList<ChannelData>(l.size());
            int index = 0;
            while (i.hasNext()) {
                m.add(new ChannelData(index, (Channel)i.next()));
                ++index;
            }
            proxy = PixelsServicesFactory.createRenderingControl(this.context, ctx, reList, pixels, m, compressionLevel, defs);
            proxy.setAvailableLookupTables(this.getLookupTables(ctx));
        }
        return proxy;
    }

    private Collection<String> getLookupTables(SecurityContext ctx) {
        if (LOOKUP_TABLES != null) {
            return LOOKUP_TABLES;
        }
        try {
            LOOKUP_TABLES = ((BrowseFacility)this.gateway.getGateway().getFacility(BrowseFacility.class)).getLookupTables(ctx);
            return LOOKUP_TABLES;
        }
        catch (Exception e) {
            this.context.getLogger().warn((Object)this, e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public Object renderImage(SecurityContext ctx, long pixelsID, PlaneDef pDef, boolean largeImage, int compression) throws RenderingServiceException {
        try {
            return PixelsServicesFactory.render(this.context, ctx, pixelsID, pDef, largeImage, compression);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", (Throwable)e);
        }
    }

    @Override
    public boolean isAlive(SecurityContext ctx) throws DSOutOfServiceException {
        return this.gateway.getGateway().isAlive(ctx);
    }

    @Override
    public void shutDown(SecurityContext ctx, long pixelsID) {
        try {
            if (!PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID)) {
                this.gateway.removeREService(ctx, pixelsID);
            }
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, e.getMessage());
        }
    }

    @Override
    public BufferedImage getThumbnail(SecurityContext ctx, long pixID, int sizeX, int sizeY, long userID) throws RenderingServiceException {
        try {
            if (pixID < 0L) {
                return null;
            }
            if (!this.isBinaryAvailable()) {
                return null;
            }
            return this.createImage(this.gateway.getThumbnail(ctx, pixID, sizeX, sizeY, userID));
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return null;
            }
            throw new RenderingServiceException("Get Thumbnail", (Throwable)e);
        }
    }

    @Override
    public Map<Long, BufferedImage> getThumbnailSet(SecurityContext ctx, Collection<Long> pixelsID, int max) throws RenderingServiceException {
        HashMap<Long, BufferedImage> r = new HashMap<Long, BufferedImage>();
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            if (pixelsID == null || pixelsID.size() == 0) {
                return r;
            }
            Iterator<Long> j = pixelsID.iterator();
            if (!this.isBinaryAvailable()) {
                while (j.hasNext()) {
                    long id = j.next();
                    r.put(id, null);
                }
                return r;
            }
            ArrayList blocks = new ArrayList();
            int index = 0;
            ArrayList<Long> l = null;
            while (j.hasNext()) {
                if (index == 0) {
                    l = new ArrayList<Long>();
                }
                l.add(j.next());
                if (++index != 50) continue;
                blocks.add(l);
                index = 0;
            }
            if (l != null && l.size() > 0) {
                blocks.add(l);
            }
            ids.addAll(pixelsID);
            j = blocks.iterator();
            HashMap m = new HashMap();
            while (j.hasNext()) {
                Map map = this.gateway.getThumbnailSet(ctx, (List)((Object)j.next()), max, false);
                m.putAll(map);
            }
            if (m == null || m.size() == 0) {
                Iterator i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
                return r;
            }
            Iterator<Object> i = m.keySet().iterator();
            while (i.hasNext()) {
                long id = (Long)i.next();
                byte[] values = (byte[])m.get(id);
                ids.remove(id);
                if (values == null || values.length == 0) {
                    r.put(id, null);
                    continue;
                }
                try {
                    r.put(id, this.createImage(values));
                }
                catch (Exception e) {
                    r.put(id, null);
                }
            }
            if (ids.size() > 0) {
                i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
            }
            return r;
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, e.getMessage());
            if (ids.size() > 0) {
                Iterator i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
            }
            return r;
        }
    }

    @Override
    public RenderingControl reloadRenderingService(SecurityContext ctx, long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, pixelsID, false);
        if (proxy == null) {
            return null;
        }
        try {
            int number = this.getNumberOfRenderingEngines(ctx, pixelsID);
            ArrayList<RenderingEnginePrx> proxies = new ArrayList<RenderingEnginePrx>(number);
            for (int i = 0; i < number; ++i) {
                proxies.add(this.gateway.createRenderingEngine(ctx, pixelsID));
            }
            proxy = PixelsServicesFactory.reloadRenderingControl(this.context, pixelsID, proxies);
            proxy.setAvailableLookupTables(this.getLookupTables(ctx));
            return proxy;
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, (Throwable)e);
        }
    }

    @Override
    public RenderingControl resetRenderingService(SecurityContext ctx, long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, pixelsID, false);
        if (proxy == null) {
            return null;
        }
        try {
            int number = this.getNumberOfRenderingEngines(ctx, pixelsID);
            ArrayList<RenderingEnginePrx> proxies = new ArrayList<RenderingEnginePrx>(number);
            for (int i = 0; i < number; ++i) {
                proxies.add(this.gateway.createRenderingEngine(ctx, pixelsID));
            }
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            RenderingDef def = this.gateway.getRenderingDef(ctx, pixelsID, exp.getId());
            proxy = PixelsServicesFactory.resetRenderingControl(this.context, pixelsID, proxies, def);
            if (proxy != null) {
                proxy.setAvailableLookupTables(this.getLookupTables(ctx));
            }
            return proxy;
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, (Throwable)e);
        }
    }

    @Override
    public PixelsData loadPixels(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return (PixelsData)PojoMapper.asDataObject((IObject)this.gateway.getPixels(ctx, pixelsID));
    }

    @Override
    public byte[] getPlane(SecurityContext ctx, long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return this.gateway.getPlane(ctx, pixelsID, z, t, c);
    }

    public Map pasteRenderingSettings(SecurityContext ctx, long pixelsID, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.pasteRenderingSettings(ctx, pixelsID, rootNodeType, nodesID);
    }

    public Map resetRenderingSettings(SecurityContext ctx, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.resetRenderingSettings(ctx, rootNodeType, nodesID);
    }

    public Map setMinMaxSettings(SecurityContext ctx, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.setMinMaxSettings(ctx, rootNodeType, nodesID);
    }

    public Map setOwnerRenderingSettings(SecurityContext ctx, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.setOwnerRenderingSettings(ctx, rootNodeType, nodesID);
    }

    @Override
    public Map<DataObject, Collection<RndProxyDef>> getRenderingSettings(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getRenderingSettings(ctx, pixelsID, userID);
    }

    @Override
    public List<RndProxyDef> getRenderingSettingsFor(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getRenderingSettingsFor(ctx, pixelsID, userID);
    }

    @Override
    public BufferedImage renderProjected(SecurityContext ctx, long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        return PixelsServicesFactory.renderProjected(this.context, pixelsID, startZ, endZ, type, stepping, channels);
    }

    @Override
    public ImageData projectImage(SecurityContext ctx, ProjectionParam ref) throws DSOutOfServiceException, DSAccessException {
        if (ref == null) {
            return null;
        }
        ImageData image = this.gateway.projectImage(ctx, ref.getPixelsID(), ref.getStartT(), ref.getEndT(), ref.getStartZ(), ref.getEndZ(), ref.getStepping(), ref.getProjectionType(), ref.getChannels(), ref.getName(), ref.getPixelsType());
        if (image == null) {
            return null;
        }
        Image img = image.asImage();
        img.setDescription(rtypes.rstring((String)ref.getDescription()));
        image = (ImageData)PojoMapper.asDataObject((IObject)this.gateway.updateObject(ctx, (IObject)img, new Parameters()));
        image = this.gateway.getImage(ctx, image.getId(), new Parameters());
        List<DatasetData> datasets = ref.getDatasets();
        if (datasets != null && datasets.size() > 0) {
            Iterator<Object> i = datasets.iterator();
            ArrayList<DatasetData> existing = new ArrayList<DatasetData>();
            ArrayList<DatasetData> toCreate = new ArrayList<DatasetData>();
            while (i.hasNext()) {
                DatasetData dataset = i.next();
                if (dataset.getId() > 0L) {
                    existing.add(dataset);
                    continue;
                }
                toCreate.add(dataset);
            }
            if (toCreate.size() > 0) {
                i = toCreate.iterator();
                OmeroDataService svc = this.context.getDataService();
                while (i.hasNext()) {
                    existing.add((DatasetData)svc.createDataObject(ctx, (DataObject)i.next(), ref.getDatasetParent(), null));
                }
            }
            ArrayList<IObject> links = new ArrayList<IObject>(datasets.size());
            img = image.asImage();
            i = existing.iterator();
            while (i.hasNext()) {
                IObject l = ModelMapper.linkParentToChild((IObject)img, ((DatasetData)i.next()).asIObject());
                links.add(l);
            }
            this.gateway.createObjects(ctx, links);
        }
        return image;
    }

    @Override
    public Boolean createRenderingSettings(SecurityContext ctx, long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        if (rndToCopy == null) {
            RenderingDef def = this.gateway.createRenderingDef(ctx, pixelsID);
            return def != null;
        }
        RenderingControl rndControl = this.loadRenderingControl(ctx, pixelsID);
        try {
            rndControl.copyRenderingSettings(rndToCopy, indexes);
            rndControl.saveCurrentSettings();
            this.shutDown(ctx, pixelsID);
        }
        catch (Exception e) {
            throw new DSAccessException("Unable to copy the rendering settings.");
        }
        return Boolean.TRUE;
    }

    @Override
    public Collection loadPlaneInfo(SecurityContext ctx, long pixelsID, int z, int t, int channel) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadPlaneInfo(ctx, pixelsID, z, t, channel);
    }

    private boolean isHCS(List<ImportContainer> containers) {
        if (CollectionUtils.isEmpty(containers)) {
            return false;
        }
        int count = 0;
        for (ImportContainer ic : containers) {
            if (!ic.getIsSPW().booleanValue()) continue;
            ++count;
        }
        return count == containers.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object importFile(ImportableObject object, ImportableFile importable, boolean close) throws ImportException, DSAccessException, DSOutOfServiceException {
        LogMessage msg;
        List lic;
        boolean hcs;
        Object o;
        DataObject createdData;
        void var18_23;
        if (importable == null || importable.getFile() == null) {
            throw new IllegalArgumentException("No images to import.");
        }
        Status status = importable.getStatus();
        SecurityContext ctx = new SecurityContext(importable.getGroup().getId());
        ExperimenterData loggedIn = this.context.getAdminService().getUserDetails();
        long userID = loggedIn.getId();
        String userName = null;
        if (importable.getUser() != null) {
            ExperimenterData exp = importable.getUser();
            userID = exp.getId();
            if (exp.getId() != loggedIn.getId()) {
                userName = exp.getUserName();
            }
        }
        if (status.isMarkedAsCancel()) {
            if (close) {
                this.gateway.closeImport(ctx, userName);
            }
            return false;
        }
        Collection<TagAnnotationData> tags = object.getTags();
        ArrayList<Annotation> customAnnotationList = new ArrayList<Annotation>();
        HashMap parameters = new HashMap();
        if (!CollectionUtils.isEmpty(tags)) {
            ArrayList<TagAnnotationData> values = new ArrayList<TagAnnotationData>();
            Iterator<TagAnnotationData> i = tags.iterator();
            List<IObject> l = new ArrayList<IObject>();
            while (i.hasNext()) {
                TagAnnotationData tag = i.next();
                if (tag.getId() > 0L) {
                    values.add(tag);
                    customAnnotationList.add((Annotation)tag.asIObject());
                    continue;
                }
                l.add(tag.asIObject());
            }
            try {
                if (l.size() > 0) {
                    l = this.gateway.saveAndReturnObject(ctx, l, parameters, userName);
                }
                for (Annotation annotation : l) {
                    values.add(new TagAnnotationData((TagAnnotation)annotation));
                    customAnnotationList.add(annotation);
                }
                object.setTags(values);
            }
            catch (Exception e) {
                LogMessage logMessage = new LogMessage();
                logMessage.print("Cannot create the tags.");
                logMessage.print((Throwable)e);
                this.context.getLogger().error((Object)this, logMessage);
            }
        }
        ImportCandidates ic = null;
        File file = importable.getFile().getFileToImport();
        DatasetData datasetData = importable.getDataset();
        DataObject container = importable.getParent();
        IObject ioContainer = null;
        IObject project = null;
        DataObject folder = null;
        if (file.isFile()) {
            List candidates;
            ic = this.gateway.getImportCandidates(ctx, object, file, status);
            if (CollectionUtils.isEmpty((Collection)ic.getContainers())) {
                Object o2 = status.getImportResult();
                if (o2 instanceof ImportException) {
                    return o2;
                }
                ImportException e = new ImportException("File Not Valid");
                status.setCallback(e);
                return e;
            }
            boolean hcsFile = this.isHCS(ic.getContainers());
            if (hcsFile) {
                if (ic != null && (candidates = ic.getPaths()).size() == 1) {
                    String value = (String)candidates.get(0);
                    if (!file.getAbsolutePath().equals(value) && object.isFileinQueue(value)) {
                        if (close) {
                            this.gateway.closeImport(ctx, userName);
                        }
                        status.markedAsDuplicate();
                        return true;
                    }
                }
                Object var18_22 = null;
                if (!(container instanceof ScreenData)) {
                    container = null;
                }
            }
            if (!hcsFile && importable.isFolderAsContainer()) {
                folder = object.createFolderAsContainer(importable, hcsFile);
                DatasetData d = null;
                DataObject c = container;
                if (folder instanceof DatasetData) {
                    d = (DatasetData)folder;
                } else if (folder instanceof ScreenData) {
                    c = folder;
                }
                try {
                    ioContainer = this.determineContainer(ctx, d, c, object, userName);
                    status.setContainerFromFolder(PojoMapper.asDataObject((IObject)ioContainer));
                }
                catch (Exception e) {
                    LogMessage msg4 = new LogMessage();
                    msg4.print("Cannot create the container.");
                    msg4.print((Throwable)e);
                    this.context.getLogger().error((Object)this, msg4);
                }
            }
            if (folder == null && var18_23 != null) {
                try {
                    ioContainer = this.determineContainer(ctx, (DatasetData)var18_23, container, object, userName);
                }
                catch (Exception e) {
                    LogMessage msg3 = new LogMessage();
                    msg3.print("Cannot create the container hosting the images.");
                    msg3.print((Throwable)e);
                    this.context.getLogger().error((Object)this, msg3);
                }
            } else if (container instanceof ScreenData) {
                if (container.getId() <= 0L) {
                    createdData = object.hasObjectBeenCreated(container, ctx);
                    if (createdData == null) {
                        try {
                            ioContainer = this.gateway.saveAndReturnObject(ctx, container.asIObject(), parameters, userName);
                            object.addNewDataObject(PojoMapper.asDataObject((IObject)ioContainer));
                        }
                        catch (Exception e) {
                            LogMessage msg2 = new LogMessage();
                            msg2.print("Cannot create the Screen hosting the plate.");
                            msg2.print((Throwable)e);
                            this.context.getLogger().error((Object)this, msg2);
                        }
                    }
                } else {
                    ioContainer = this.gateway.findIObject(ctx, container.asIObject());
                }
            }
            if (ImportableObject.isArbitraryFile(file)) {
                int size;
                if (ic == null) {
                    ic = this.gateway.getImportCandidates(ctx, object, file, status);
                }
                if ((size = (candidates = ic.getPaths()).size()) == 0) {
                    o = status.getImportResult();
                    if (o instanceof ImportException) {
                        return o;
                    }
                    ImportException e = new ImportException("File Not Valid");
                    status.setCallback(e);
                    return e;
                }
                if (size == 1) {
                    String value = (String)candidates.get(0);
                    if (!file.getAbsolutePath().equals(value) && object.isFileinQueue(value)) {
                        if (close) {
                            this.gateway.closeImport(ctx, userName);
                        }
                        status.markedAsDuplicate();
                        return true;
                    }
                    File f = new File(value);
                    status.resetFile(f);
                    if (ioContainer == null) {
                        status.setNoContainer();
                    }
                    ImportContainer importIc = (ImportContainer)ic.getContainers().get(0);
                    importIc.setCustomAnnotationList(customAnnotationList);
                    status.setUsedFiles(importIc.getUsedFiles());
                    if (status.isMarkedAsCancel()) {
                        return false;
                    }
                    return this.gateway.importImageFile(ctx, object, ioContainer, importIc, status, close, userName);
                }
                List containers = ic.getContainers();
                hcs = this.isHCS(containers);
                HashMap<File, Status> files = new HashMap<File, Status>();
                Iterator i = candidates.iterator();
                int index = 0;
                while (i.hasNext()) {
                    File f = new File((String)i.next());
                    Status label = new Status(new FileObject(f));
                    label.setUsedFiles(((ImportContainer)containers.get(index)).getUsedFiles());
                    files.put(f, label);
                    ++index;
                }
                status.setFiles(files);
                Object v = this.importCandidates(ctx, files, status, object, ioContainer, customAnnotationList, userID, close, hcs, userName);
                if (v != null) {
                    return v;
                }
            } else {
                List icContainers;
                if (ioContainer == null) {
                    status.setNoContainer();
                }
                if ((icContainers = (ic = this.gateway.getImportCandidates(ctx, object, file, status)).getContainers()).size() == 0) {
                    Object o3 = status.getImportResult();
                    if (o3 instanceof ImportException) {
                        return o3;
                    }
                    return new ImportException("File Not Valid");
                }
                ImportContainer importIc = (ImportContainer)icContainers.get(0);
                importIc.setCustomAnnotationList(customAnnotationList);
                status.setUsedFiles(importIc.getUsedFiles());
                if (status.isMarkedAsCancel()) {
                    return false;
                }
                return this.gateway.importImageFile(ctx, object, ioContainer, importIc, status, close, userName);
            }
        }
        if ((lic = (ic = this.gateway.getImportCandidates(ctx, object, file, status)).getContainers()).size() == 0) {
            o = status.getImportResult();
            if (o instanceof ImportException) {
                return o;
            }
            return new ImportException("File Not Valid");
        }
        if (status.isMarkedAsCancel()) {
            return false;
        }
        HashMap<File, Status> hcsFiles = new HashMap<File, Status>();
        HashMap<File, Status> otherFiles = new HashMap<File, Status>();
        HashMap<File, Status> files = new HashMap<File, Status>();
        int n = lic.size();
        for (ImportContainer c : lic) {
            hcs = c.getIsSPW();
            File f = c.getFile();
            Status sl = new Status(new FileObject(f));
            sl.setUsedFiles(c.getUsedFiles());
            if (hcs) {
                if (n == 1 && file.list().length > 1) {
                    hcsFiles.put(f, sl);
                } else if (n > 1) {
                    if (f.getName().endsWith("dat")) {
                        otherFiles.put(f, sl);
                    } else {
                        hcsFiles.put(f, sl);
                    }
                } else {
                    hcsFiles.put(f, sl);
                }
            } else {
                otherFiles.put(f, sl);
            }
            files.put(f, sl);
        }
        status.setFiles(files);
        if (hcsFiles.size() > 0) {
            if (container != null && container instanceof ScreenData) {
                if (container.getId() <= 0L) {
                    createdData = object.hasObjectBeenCreated(container, ctx);
                    if (createdData == null) {
                        try {
                            ioContainer = this.gateway.saveAndReturnObject(ctx, container.asIObject(), parameters, userName);
                            object.addNewDataObject(PojoMapper.asDataObject((IObject)ioContainer));
                        }
                        catch (Exception e) {
                            msg = new LogMessage();
                            msg.print("Cannot create the Screen hosting the plates.");
                            msg.print((Throwable)e);
                            this.context.getLogger().error((Object)this, msg);
                        }
                    }
                } else {
                    ioContainer = this.gateway.findIObject(ctx, container.asIObject());
                }
            }
            this.importCandidates(ctx, hcsFiles, status, object, ioContainer, customAnnotationList, userID, close, true, userName);
        }
        if (otherFiles.size() > 0) {
            block85: {
                folder = object.createFolderAsContainer(importable);
                if (folder != null) {
                    try {
                        ioContainer = this.gateway.saveAndReturnObject(ctx, folder.asIObject(), parameters, userName);
                        status.setContainerFromFolder(PojoMapper.asDataObject((IObject)ioContainer));
                        if (!(folder instanceof DatasetData) || container == null) break block85;
                        try {
                            Project p;
                            if (container.getId() <= 0L) {
                                createdData = object.hasObjectBeenCreated(container, ctx);
                                if (createdData == null) {
                                    project = this.gateway.saveAndReturnObject(ctx, container.asIObject(), parameters, userName);
                                    object.addNewDataObject(PojoMapper.asDataObject((IObject)project));
                                    p = (Project)project;
                                } else {
                                    p = createdData.asProject();
                                }
                            } else {
                                p = container.asProject();
                            }
                            ProjectDatasetLink link = (ProjectDatasetLink)ModelMapper.linkParentToChild((IObject)((Dataset)ioContainer), (IObject)p);
                            link = (ProjectDatasetLink)this.gateway.saveAndReturnObject(ctx, (IObject)link, parameters, userName);
                        }
                        catch (Exception e) {
                            msg = new LogMessage();
                            msg.print("Cannot create the container hosting the data.");
                            msg.print((Throwable)e);
                            this.context.getLogger().error((Object)this, msg);
                        }
                    }
                    catch (Exception e) {}
                } else if (var18_23 != null) {
                    try {
                        ioContainer = this.determineContainer(ctx, (DatasetData)var18_23, container, object, userName);
                    }
                    catch (Exception e) {
                        msg = new LogMessage();
                        msg.print("Cannot create the container hosting the data.");
                        msg.print((Throwable)e);
                        this.context.getLogger().error((Object)this, msg);
                    }
                }
            }
            this.importCandidates(ctx, otherFiles, status, object, ioContainer, customAnnotationList, userID, close, false, userName);
        }
        return true;
    }

    @Override
    public FileFilter[] getSupportedFileFormats() {
        if (this.filters != null) {
            return this.filters;
        }
        try {
            ImageReader reader = new ImageReader();
            FileFilter[] array = GUITools.buildFileFilters((IFormatHandler)reader);
            if (array != null) {
                this.filters = new FileFilter[array.length];
                System.arraycopy(array, 0, this.filters, 0, array.length);
            } else {
                this.filters = new FileFilter[0];
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot retrieve the list of supported formats.");
            msg.print((Throwable)e);
            this.context.getLogger().error((Object)this, msg);
            this.filters = new FileFilter[0];
        }
        return this.filters;
    }

    @Override
    public ScriptCallback createMovie(SecurityContext ctx, long imageID, long pixelsID, List<Integer> channels, MovieExportParam param) throws ProcessException, DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("Image ID not valid.");
        }
        if (param == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        if (channels == null) {
            channels = new ArrayList<Integer>();
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        return this.gateway.createMovie(ctx, imageID, pixelsID, exp.getId(), channels, param);
    }

    @Override
    public List<ROIResult> loadROI(SecurityContext ctx, long imageID, List<Long> fileID, long userID) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.loadROI(ctx, imageID, fileID, userID);
    }

    @Override
    public Collection<ROIData> saveROI(SecurityContext ctx, long imageID, long userID, List<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.saveROI(ctx, imageID, userID, roiList);
    }

    private File applyTransforms(File inputXML, List<InputStream> transforms, String encoding) throws Exception {
        Iterator<InputStream> i = transforms.iterator();
        InputStream in = null;
        OutputStream out = null;
        Resolver resolver = null;
        while (i.hasNext()) {
            InputStream stream = i.next();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                resolver = new Resolver();
                factory.setURIResolver(resolver);
                File output = File.createTempFile(RandomStringUtils.random((int)60, (boolean)false, (boolean)true), ".ome.xml");
                output.deleteOnExit();
                StreamSource src = new StreamSource(stream);
                Templates template = factory.newTemplates(src);
                Transformer transformer = template.newTransformer();
                transformer.setParameter("encoding", encoding);
                out = new FileOutputStream(output);
                in = new FileInputStream(inputXML);
                transformer.transform(new StreamSource(in), new StreamResult(out));
                inputXML = output;
            }
            catch (Exception e) {
                throw new Exception("Cannot apply transform", e);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                if (stream != null) {
                    stream.close();
                }
                if (in != null) {
                    in.close();
                }
                if (out == null) continue;
                out.close();
            }
        }
        File f = File.createTempFile(RandomStringUtils.random((int)60, (boolean)false, (boolean)true), ".ome.xml");
        FileUtils.copyFile((File)inputXML, (File)f);
        return f;
    }

    @Override
    public Object exportImageAsOMEFormat(SecurityContext ctx, int index, long imageID, File file, Target target) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        if (file == null) {
            throw new IllegalArgumentException("No File specified.");
        }
        String path = file.getAbsolutePath();
        switch (index) {
            case 0: {
                if (path.endsWith("ome.tiff") || path.endsWith("ome.tif")) break;
                path = path + ".ome.tiff";
                file.delete();
                file = new File(path);
                break;
            }
            case 1: {
                if (path.endsWith("ome.xml")) break;
                path = path + ".ome.xml";
                file.delete();
                file = new File(path);
            }
        }
        this.gateway.exportImageAsOMEObject(ctx, index, file, imageID);
        if (target == null) {
            return file;
        }
        List<InputStream> transforms = target.getTransforms();
        if (CollectionUtils.isEmpty(transforms)) {
            return file;
        }
        File tmp = null;
        File result = null;
        File transformed = null;
        RandomAccessInputStream ra = null;
        String encoding = "UTF-8";
        try {
            Object c;
            if (index == 0) {
                tmp = File.createTempFile(RandomStringUtils.random((int)60, (boolean)false, (boolean)true), ".ome.xml");
                c = new TiffParser(file.getAbsolutePath()).getComment();
                FileUtils.writeStringToFile((File)tmp, (String)c, (String)encoding);
                transformed = this.applyTransforms(tmp, transforms, encoding);
            } else {
                transformed = this.applyTransforms(file, transforms, encoding);
            }
            if (index == 1) {
                file.delete();
                File r = new File(path);
                FileUtils.copyFile((File)transformed, (File)r);
                c = r;
                return c;
            }
            TiffSaver saver = new TiffSaver(file.getAbsolutePath());
            ra = new RandomAccessInputStream(file.getAbsolutePath());
            saver.overwriteComment(ra, (Object)FileUtils.readFileToString((File)transformed, (String)encoding));
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to apply the transforms", e);
        }
        finally {
            if (transformed != null) {
                transformed.delete();
            }
            if (tmp != null) {
                tmp.delete();
            }
            try {
                if (ra != null) {
                    ra.close();
                }
            }
            catch (Exception exception) {}
            if (result != null) {
                result.delete();
            }
        }
    }

    @Override
    public ScriptCallback createFigure(SecurityContext ctx, List<Long> ids, Class type, Object parameters) throws ProcessException, DSOutOfServiceException, DSAccessException {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        if (parameters instanceof FigureParam) {
            FigureParam p = (FigureParam)parameters;
            return this.gateway.createFigure(ctx, ids, type, p, exp.getId());
        }
        return null;
    }

    @Override
    public List<ROIResult> loadROIFromServer(SecurityContext ctx, long imageID, long userID) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.loadROI(ctx, imageID, null, userID);
    }

    @Override
    public Object renderOverLays(SecurityContext ctx, long pixelsID, PlaneDef pd, long tableID, Map<Long, Integer> overlays) throws RenderingServiceException {
        try {
            return PixelsServicesFactory.renderOverlays(this.context, pixelsID, pd, tableID, overlays);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", (Throwable)e);
        }
    }

    @Override
    public ScriptCallback runScript(SecurityContext ctx, ScriptObject script) throws ProcessException, DSOutOfServiceException, DSAccessException {
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        if (!script.allRequiredValuesPopulated()) {
            throw new ProcessException("No all required parameters have been filled.");
        }
        return this.gateway.runScript(ctx, script);
    }

    @Override
    public List<ScriptObject> loadAvailableScriptsWithUI(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadRunnableScriptsWithUI(ctx);
    }

    @Override
    public List<ScriptObject> loadAvailableScripts(SecurityContext ctx, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadRunnableScripts(ctx);
    }

    @Override
    public ScriptObject loadScript(SecurityContext ctx, long scriptID) throws ProcessException {
        return this.gateway.loadScript(ctx, scriptID);
    }

    @Override
    public Map<Long, String> getScriptsAsString(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getScriptsAsString(ctx);
    }

    @Override
    public Object uploadScript(SecurityContext ctx, ScriptObject script) throws DSOutOfServiceException, DSAccessException, ValidationException {
        if (script == null) {
            throw new IllegalArgumentException("No script to upload.");
        }
        Boolean b = (Boolean)this.context.lookup("/users/administrator");
        boolean value = false;
        if (b != null) {
            value = b;
        }
        return this.gateway.uploadScript(ctx, script, value);
    }

    @Override
    public Collection loadROIMeasurements(SecurityContext ctx, Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        if (ImageData.class.equals((Object)type)) {
            return this.gateway.loadROIMeasurements(ctx, id, userID);
        }
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(id);
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(FileAnnotationData.class);
        Map map = this.gateway.loadAnnotations(ctx, type, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return new ArrayList();
        }
        Collection l = (Collection)map.get(id);
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (l != null) {
            for (FileAnnotationData fa : l) {
                String ns = fa.getNameSpace();
                if (!"openmicroscopy.org/omero/measurement".equals(ns)) continue;
                list.add(fa);
            }
        }
        return list;
    }

    @Override
    public Map<DataObject, BufferedImage> getFSThumbnailSet(SecurityContext ctx, List<DataObject> files, int maxLength, long userID) throws DSAccessException, DSOutOfServiceException, FSAccessException {
        HashMap<DataObject, BufferedImage> m = new HashMap<DataObject, BufferedImage>();
        if (files == null || files.size() == 0) {
            return m;
        }
        Iterator<DataObject> i = files.iterator();
        if (!this.isBinaryAvailable()) {
            while (i.hasNext()) {
                DataObject file = i.next();
                m.put(file, null);
            }
            return m;
        }
        FSFileSystemView view = this.gateway.getFSRepositories(ctx, userID);
        while (i.hasNext()) {
            DataObject file = i.next();
            String path = view.getThumbnail(file);
            try {
                if (path != null) {
                    m.put(file, Factory.scaleBufferedImage(this.createImage(path), maxLength));
                    continue;
                }
                m.put(file, null);
            }
            catch (Exception e) {
                m.put(file, null);
            }
        }
        return m;
    }

    @Override
    public Map<DataObject, BufferedImage> getExperimenterThumbnailSet(SecurityContext ctx, List<DataObject> experimenters, int maxLength) throws DSAccessException, DSOutOfServiceException {
        Map annotations;
        DataObject exp;
        HashMap<DataObject, BufferedImage> m = new HashMap<DataObject, BufferedImage>();
        if (experimenters == null || experimenters.size() == 0) {
            return m;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator<DataObject> i = experimenters.iterator();
        if (!this.isBinaryAvailable()) {
            while (i.hasNext()) {
                m.put(i.next(), null);
            }
            return m;
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(FileAnnotationData.class);
        HashMap<Long, DataObject> exps = new HashMap<Long, DataObject>();
        while (i.hasNext()) {
            exp = i.next();
            ids.add(exp.getId());
            m.put(exp, null);
            exps.put(exp.getId(), exp);
        }
        try {
            annotations = this.gateway.loadAnnotations(ctx, ExperimenterData.class, ids, types, new ArrayList(), new Parameters());
        }
        catch (Exception e) {
            return m;
        }
        if (annotations == null || annotations.size() == 0) {
            return m;
        }
        for (Map.Entry entry : annotations.entrySet()) {
            Long id = (Long)entry.getKey();
            Collection values = (Collection)entry.getValue();
            Iterator k = values.iterator();
            FileAnnotationData ann = null;
            while (k.hasNext()) {
                FileAnnotationData fa;
                Object object = k.next();
                if (!(object instanceof FileAnnotationData) || !"openmicroscopy.org/omero/experimenter/photo".equals((fa = (FileAnnotationData)object).getNameSpace())) continue;
                if (ann == null) {
                    ann = fa;
                    continue;
                }
                if (fa.getId() <= ann.getId()) continue;
                ann = fa;
            }
            if (ann == null) continue;
            exp = (DataObject)exps.get(id);
            try {
                BufferedImage img = this.createImage(this.gateway.getUserPhoto(ctx, ann.getFileID(), ann.getFileSize()));
                m.put((DataObject)exps.get(id), Factory.scaleBufferedImage(img, maxLength));
            }
            catch (Exception exception) {}
        }
        return m;
    }

    @Override
    public ScriptCallback saveAs(SecurityContext ctx, SaveAsParam param) throws ProcessException, DSAccessException, DSOutOfServiceException {
        if (param == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        List<DataObject> objects = param.getObjects();
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No objects specified.");
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        return this.gateway.saveAs(ctx, exp.getId(), param);
    }

    @Override
    public Boolean isLargeImage(SecurityContext ctx, long pixelsId) throws DSAccessException, DSOutOfServiceException {
        return this.gateway.isLargeImage(ctx, pixelsId);
    }

    @Override
    public Collection<DataObject> getFileSet(SecurityContext ctx, long imageId) throws DSAccessException, DSOutOfServiceException {
        return this.gateway.getFileSet(ctx, Arrays.asList(imageId));
    }

    @Override
    public ThumbnailStorePrx createThumbnailStore(SecurityContext ctx) throws DSAccessException, DSOutOfServiceException {
        if (ctx != null) {
            return this.gateway.getGateway().createThumbnailStore(ctx);
        }
        return null;
    }

    @Override
    public Long getRenderingDef(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        RenderingDef def = this.gateway.getRenderingDef(ctx, pixelsID, userID);
        if (def == null) {
            return -1L;
        }
        return def.getId().getValue();
    }

    @Override
    public RndProxyDef getSettings(SecurityContext ctx, long rndID) throws DSOutOfServiceException, DSAccessException {
        if (rndID < 0L) {
            return null;
        }
        RenderingDef def = this.gateway.getRenderingDef(ctx, rndID);
        if (def == null) {
            return null;
        }
        return PixelsServicesFactory.convert(def);
    }

    @Override
    public RawPixelsStorePrx createPixelsStore(SecurityContext ctx) throws DSAccessException, DSOutOfServiceException {
        if (ctx != null) {
            return this.gateway.getGateway().createPixelsStore(ctx);
        }
        return null;
    }
}

