/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import Glacier2.CannotCreateSessionException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.ConnectionTimeoutException;
import Ice.DNSException;
import Ice.ObjectNotExistException;
import Ice.SocketException;
import Ice.TimeoutException;
import Ice.UnknownException;
import java.net.UnknownHostException;
import ome.conditions.SessionTimeoutException;
import omero.DatabaseBusyException;
import omero.gateway.exception.ConnectionStatus;
import omero.gateway.exception.DSOutOfServiceException;

public class ConnectionExceptionHandler {
    public static final int LOST_CONNECTION = 0;
    public static final int SERVER_OUT_OF_SERVICE = 1;
    public static final int DESTROYED_CONNECTION = 2;
    public static final int NETWORK = 3;
    private static final String REFUSED = "Ice::ConnectionRefusedException";
    private static final String LOST = "Ice::ConnectionLostException";

    private int handleIceUnknownException(Throwable e) {
        int index = -1;
        UnknownException ex = (UnknownException)e;
        if (ex.unknown.contains(REFUSED)) {
            index = 1;
        } else if (ex.unknown.contains(LOST)) {
            index = 0;
        }
        return index;
    }

    public int handleConnectionException(Throwable e) {
        int index = -1;
        Throwable cause = e.getCause();
        ConnectionStatus cs = null;
        if (e instanceof DSOutOfServiceException) {
            DSOutOfServiceException dso = (DSOutOfServiceException)e;
            cs = dso.getConnectionStatus();
        }
        if (cause instanceof ConnectionLostException || e instanceof ConnectionLostException || cause instanceof SessionTimeoutException || e instanceof SessionTimeoutException || cause instanceof TimeoutException || e instanceof TimeoutException || cause instanceof ObjectNotExistException || e instanceof ObjectNotExistException || cause instanceof DNSException || e instanceof DNSException || cs == ConnectionStatus.LOST_CONNECTION) {
            index = 0;
        } else if (cause instanceof CommunicatorDestroyedException || e instanceof CommunicatorDestroyedException) {
            index = 2;
        } else if (cause instanceof SocketException || e instanceof SocketException || e instanceof UnknownHostException || cs == ConnectionStatus.NETWORK) {
            index = 3;
        } else if (cause instanceof ConnectionRefusedException || e instanceof ConnectionRefusedException || cause instanceof ConnectionTimeoutException || e instanceof ConnectionTimeoutException || cause instanceof DatabaseBusyException || e instanceof DatabaseBusyException || e instanceof CannotCreateSessionException || cause instanceof CannotCreateSessionException) {
            index = 1;
        } else if (cause instanceof UnknownException) {
            index = this.handleIceUnknownException(cause);
        } else if (e instanceof UnknownException) {
            index = this.handleIceUnknownException(e);
        }
        return index;
    }
}

