/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.SelectionTable;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UserManagerDialog
extends JDialog
implements ActionListener {
    public static final String USER_SWITCH_PROPERTY = "userSwitch";
    public static final String NO_USER_SWITCH_PROPERTY = "noUserSwitch";
    static final Dimension DEFAULT_SIZE = new Dimension(400, 400);
    private static final String TITLE = "Users Selection";
    private static final String TEXT = "Select the users.";
    private static final String CANCEL_DESCRIPTION = "Close the window.";
    private static final String APPLY_DESCRIPTION = "Select the users.";
    private static final int CANCEL = 0;
    private static final int APPLY = 1;
    static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private JButton cancel;
    private JButton apply;
    private JTable members;
    private JTable owners;
    private ExperimenterData loggedUser;
    private ViewerSorter sorter;
    private GroupData group;
    private List<ExperimenterData> selectedUsers;

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void apply() {
        Boolean b;
        int i;
        HashMap r = new HashMap();
        ArrayList<ExperimenterData> users = new ArrayList<ExperimenterData>();
        for (i = 0; i < this.owners.getRowCount(); ++i) {
            b = (Boolean)this.owners.getValueAt(i, 1);
            if (!b.booleanValue()) continue;
            users.add((ExperimenterData)this.owners.getValueAt(i, 0));
        }
        for (i = 0; i < this.members.getRowCount(); ++i) {
            b = (Boolean)this.members.getValueAt(i, 1);
            if (!b.booleanValue()) continue;
            users.add((ExperimenterData)this.members.getValueAt(i, 0));
        }
        r.put(this.group.getId(), users);
        this.firePropertyChange(USER_SWITCH_PROPERTY, null, r);
        this.cancel();
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    private boolean isAlreadyDisplayed(ExperimenterData experimenter) {
        Iterator<ExperimenterData> i = this.selectedUsers.iterator();
        long id = experimenter.getId();
        while (i.hasNext()) {
            ExperimenterData exp = i.next();
            if (exp.getId() != id) continue;
            return true;
        }
        return false;
    }

    private void fillList(GroupData group) {
        ExperimenterData exp;
        if (group == null) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.owners.getModel();
        int index = 0;
        List l = this.sorter.sort(group.getLeaders());
        Iterator i = l.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            exp = (ExperimenterData)i.next();
            if (exp.getId() == this.loggedUser.getId()) continue;
            model.insertRow(index, new Object[]{exp, new Boolean(this.isAlreadyDisplayed(exp))});
            ids.add(exp.getId());
            ++index;
        }
        if (group.getLeaders().size() == group.getExperimenters().size()) {
            return;
        }
        model = (DefaultTableModel)this.members.getModel();
        l = this.sorter.sort(group.getExperimenters());
        i = l.iterator();
        index = 0;
        while (i.hasNext()) {
            exp = (ExperimenterData)i.next();
            if (exp.getId() == this.loggedUser.getId() || ids.contains(exp.getId())) continue;
            model.insertRow(index, new Object[]{exp, new Boolean(this.isAlreadyDisplayed(exp))});
            ++index;
        }
    }

    private void attachListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserManagerDialog.this.cancel();
            }
        });
        this.cancel.setActionCommand("0");
        this.cancel.addActionListener(this);
        this.apply.setActionCommand("1");
        this.apply.addActionListener(this);
    }

    private void initComponents(Icon userIcon) {
        this.sorter = new ViewerSorter();
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText(UIUtilities.formatToolTipText(CANCEL_DESCRIPTION));
        this.apply = new JButton("Apply");
        this.apply.setToolTipText(UIUtilities.formatToolTipText("Select the users."));
        this.getRootPane().setDefaultButton(this.apply);
        this.members = new SelectionTable(userIcon);
        this.owners = new SelectionTable(userIcon);
        this.fillList(this.group);
        this.attachListeners();
    }

    private JPanel buildContent(GroupData group) {
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, -1.0}};
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setLayout(new TableLayout(tl));
        if (group != null) {
            content.add((Component)UIUtilities.setTextFont("Select from: " + group.getName()), "0, 0, 1, 0");
        }
        int rows = this.owners.getRowCount();
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND);
        double[][] size = new double[][]{{-2.0, -1.0}, {-2.0, -2.0, 5.0, -2.0, -2.0}};
        p.setLayout(new TableLayout(size));
        if (rows > 0) {
            p.add((Component)UIUtilities.setTextFont("Group's owners"), "0, 0");
            p.add((Component)this.owners, "0, 1, 1, 1");
        }
        if ((rows = this.members.getRowCount()) > 0) {
            p.add((Component)UIUtilities.setTextFont("Members"), "0, 3");
            p.add((Component)this.members, "0, 4, 1, 4");
        }
        content.add((Component)new JScrollPane(p), "0, 2, 1, 2");
        return content;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.apply);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancel);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private void buildGUI(GroupData group, Icon icon) {
        TitlePanel titlePanel = new TitlePanel(TITLE, "Select the users.", icon);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)titlePanel), "North");
        c.add((Component)this.buildContent(group), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public UserManagerDialog(JFrame parent, ExperimenterData loggedUser, GroupData selected, List<ExperimenterData> selectedUsers, Icon userIcon, Icon icon) {
        super(parent);
        this.setProperties();
        this.loggedUser = loggedUser;
        this.group = selected;
        if (selectedUsers == null) {
            selectedUsers = new ArrayList<ExperimenterData>();
        }
        this.selectedUsers = selectedUsers;
        this.initComponents(userIcon);
        this.buildGUI(selected, icon);
    }

    List<ExperimenterData> getSelectedUsers() {
        return this.selectedUsers;
    }

    public void setDefaultSize() {
        this.setSize(DEFAULT_SIZE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int id = Integer.parseInt(e.getActionCommand());
        switch (id) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.apply();
            }
        }
    }
}

