/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PreviewControlBar
extends JPanel {
    static final int SPACE = 3;
    private RendererControl control;
    private RendererModel model;

    private void formatButton(AbstractButton b) {
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        b.setIconTextGap(0);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JToolBar buildToolBar() {
        JButton b;
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.setFloatable(false);
        if (this.model.isGeneralIndex()) {
            b = new JButton(this.control.getAction(RendererControl.SAVE));
            b.setText("Save");
            this.formatButton(b);
            bar.add(b);
            bar.add(Box.createHorizontalStrut(3));
            b = new JButton(this.control.getAction(RendererControl.APPLY_TO_ALL));
            this.formatButton(b);
            bar.add(b);
            bar.add(new JSeparator(1));
        }
        b = new JButton(this.control.getAction(RendererControl.RND_UNDO));
        this.formatButton(b);
        bar.add(b);
        bar.add(Box.createHorizontalStrut(3));
        b = new JButton(this.control.getAction(RendererControl.RND_REDO));
        this.formatButton(b);
        bar.add(b);
        if (this.model.isGeneralIndex()) {
            bar.add(new JSeparator(1));
            b = new JButton(this.control.getAction(RendererControl.COPY));
            this.formatButton(b);
            bar.add(b);
            bar.add(Box.createHorizontalStrut(3));
            b = new JButton(this.control.getAction(RendererControl.PASTE));
            this.formatButton(b);
            bar.add(b);
        }
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add(this.buildToolBar());
    }

    PreviewControlBar(RendererControl control, RendererModel model) {
        this.control = control;
        this.model = model;
        this.buildGUI();
    }
}

