/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;

class GraphicsPaneUI
extends JPanel {
    private static final Color LINECOLOUR = Color.BLACK;
    private static final Color GREYCOLOUR = new Color(196, 196, 196, 128);
    private static final Color FILLCOLOUR = new Color(255, 255, 255);
    private static final Color BORDERCOLOUR = new Color(224, 209, 207);
    private static final BasicStroke STROKE1_5 = new BasicStroke(1.5f);
    private static final BasicStroke STROKE2 = new BasicStroke(2.0f);
    private ImageIcon histogramImage;
    private RendererModel model;
    private GraphicsPane view;

    GraphicsPaneUI(GraphicsPane view, RendererModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        IconManager icons = IconManager.getInstance();
        this.histogramImage = icons.getImageIcon(61);
    }

    @Override
    public void paintComponent(Graphics og) {
        super.paintComponent(og);
        Graphics2D g = (Graphics2D)og;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double width = this.getWidth();
        double height = this.getHeight();
        g.setColor(FILLCOLOUR);
        g.fillRect(1, 1, (int)width - 1, (int)height - 1);
        g.setColor(BORDERCOLOUR);
        g.setStroke(STROKE2);
        g.drawRect(0, 0, (int)width - 1, (int)height - 1);
        if (this.histogramImage != null) {
            g.drawImage(this.histogramImage.getImage(), 0, 0, (int)width - 1, (int)height - 1, null);
        }
        double codomainMin = this.model.getCodomainStart();
        double codomainMax = this.model.getCodomainEnd();
        double domainGlobalMin = this.view.getPartialMinimum();
        double domainGlobalMax = this.view.getPartialMaximum();
        double domainMin = this.model.getWindowStart();
        double domainMax = this.model.getWindowEnd();
        if (domainMin < domainGlobalMin) {
            domainMin = domainGlobalMin;
        }
        if (domainMax > domainGlobalMax) {
            domainMax = domainGlobalMax;
        }
        double domainMinScreenX = (domainMin - domainGlobalMin) / (domainGlobalMax - domainGlobalMin) * width;
        double domainMaxScreenX = (domainMax - domainGlobalMin) / (domainGlobalMax - domainGlobalMin) * width;
        double codomainMinScreenY = (255.0 - codomainMin) / 255.0 * height;
        double codomainMaxScreenY = (255.0 - codomainMax) / 255.0 * height;
        double domainRangeScreen = domainMaxScreenX - domainMinScreenX;
        double codomainRangeScreen = codomainMinScreenY - codomainMaxScreenY;
        g.setColor(GREYCOLOUR);
        g.fillRect(0, 0, (int)domainMinScreenX + 1, (int)height);
        g.fillRect((int)domainMaxScreenX - 1, 0, (int)width, (int)height);
        g.fillRect(0, 0, (int)domainMinScreenX, (int)height);
        g.fillRect((int)domainMaxScreenX, 0, (int)width, (int)height);
        g.fillRect(0, 0, (int)width, (int)codomainMaxScreenY);
        g.fillRect(0, (int)codomainMinScreenY, (int)width, (int)height);
        String family = this.model.getFamily();
        double k = this.model.getCurveCoefficient();
        double a = 0.0;
        if (family.equals("linear")) {
            a = codomainRangeScreen / domainRangeScreen;
        } else if (family.equals("polynomial")) {
            a = codomainRangeScreen / Math.pow(domainRangeScreen, k);
        } else if (family.equals("exponential")) {
            a = codomainRangeScreen / Math.exp(Math.pow(domainRangeScreen, k));
        } else if (family.equals("logarithmic")) {
            if (domainRangeScreen <= 1.0) {
                domainRangeScreen = 1.0;
            }
            a = codomainRangeScreen / Math.log(domainRangeScreen);
        }
        double b = codomainMinScreenY;
        double currentX = domainMinScreenX - 1.0;
        double currentY = b;
        g.setColor(this.model.getChannelColor(this.model.getSelectedChannel()));
        g.setStroke(STROKE1_5);
        for (double x = 1.0; x < domainRangeScreen; x += 1.0) {
            double oldX = currentX;
            double oldY = currentY;
            currentX = x + domainMinScreenX - 1.0;
            if (family.equals("linear")) {
                currentY = b - a * x;
            } else if (family.equals("exponential")) {
                currentY = b - a * Math.exp(Math.pow(x, k));
            } else if (family.equals("polynomial")) {
                currentY = b - a * Math.pow(x, k);
            } else if (family.equals("logarithmic")) {
                currentY = b - a * Math.log(x);
            }
            g.drawLine((int)oldX, (int)oldY, (int)currentX, (int)currentY);
        }
        if (this.view.isPaintLine()) {
            double v;
            int vertical = this.view.getVerticalLine();
            g.setColor(LINECOLOUR);
            if (this.view.paintVertical()) {
                v = ((double)vertical - domainGlobalMin) / (domainGlobalMax - domainGlobalMin) * width;
                g.drawLine((int)v, 0, (int)v, (int)height);
            }
            int horizontal = this.view.getHorizontalLine();
            if (this.view.paintHorizontal()) {
                v = (double)((float)(255 - horizontal) / 255.0f) * height;
                g.drawLine(0, (int)v, (int)width, (int)v);
            }
        }
    }
}

