/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.InstrumentData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.FileAnnotationCheckResult;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.OriginalMetadataComponent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.AnalysisResultsItem;
import org.openmicroscopy.shoola.agents.metadata.util.FigureDialog;
import org.openmicroscopy.shoola.agents.metadata.util.FileAttachmentWarningDialog;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.ui.ScriptingDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AnnotationLinkData;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;
    private ScriptingDialog dialog;

    private Collection<DataObject> getImmutableAnnotation(Class type, Collection<DataObject> common) {
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        Map<DataObject, StructuredDataResults> data = this.model.getAllStructuredData();
        if (data == null || data.size() == 0) {
            return list;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = data.entrySet().iterator();
        if (this.model.isMultiSelection()) {
            ArrayList selected = new ArrayList();
            ArrayList<Long> ids = new ArrayList<Long>(common.size());
            Iterator<DataObject> k = common.iterator();
            while (k.hasNext()) {
                ids.add(k.next().getId());
            }
            while (i.hasNext()) {
                Map.Entry<DataObject, StructuredDataResults> e = i.next();
                StructuredDataResults result = e.getValue();
                Collection<AnnotationLinkData> links = result.getAnnotationLinks();
                if (links == null) continue;
                for (AnnotationLinkData link : links) {
                    AnnotationData child = (AnnotationData)link.getChild();
                    if (!child.getClass().equals(type) || this.model.isNameSpaceExcluded(child.getNameSpace()) || ids.contains(link.getChild().getId()) || selected.contains(link.getChild().getId())) continue;
                    list.add(link.getChild());
                }
            }
        } else {
            while (i.hasNext()) {
                Map.Entry<DataObject, StructuredDataResults> e = i.next();
                StructuredDataResults result = e.getValue();
                Collection<AnnotationLinkData> links = result.getAnnotationLinks();
                if (links == null) continue;
                for (AnnotationLinkData link : links) {
                    AnnotationData child = (AnnotationData)link.getChild();
                    if (this.model.isNameSpaceExcluded(child.getNameSpace()) || link.canDelete() || !link.getChild().equals(type)) continue;
                    list.add(link.getChild());
                }
            }
        }
        return list;
    }

    private void showSelectionWizard(Class type, Collection available, Collection selected, boolean addCreation) {
        IconManager icons = IconManager.getInstance();
        Registry reg = MetadataViewerAgent.getRegistry();
        String title = "";
        String text = "";
        Icon icon = null;
        if (TagAnnotationData.class.equals((Object)type)) {
            title = "Tags Selection";
            text = "Select from available tags";
            icon = icons.getIcon(24);
        } else if (FileAnnotationData.class.equals((Object)type)) {
            title = "Attachments Selection";
            text = "Select from available attachments";
            icon = icons.getIcon(42);
        }
        SelectionWizard wizard = new SelectionWizard(reg.getTaskBar().getFrame(), (Collection<Object>)available, selected, type, addCreation, this.model.getCurrentUser());
        wizard.setImmutableElements(this.getImmutableAnnotation(type, selected));
        if (this.model.isMultiSelection()) {
            wizard.setAcceptButtonText("Save");
        }
        wizard.setTitle(title, text, icon);
        wizard.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(wizard);
    }

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = new EditorUI();
        this.controller = new EditorControl();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.model, this.controller);
        this.model.getObservable().addPropertyChangeListener(this.controller);
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public void setStructuredDataResults() {
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.layoutUI();
        this.view.setStatus(false);
    }

    @Override
    public void setRootObject(Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Root object not valid.");
        }
        Object oldObject = this.model.getRefObject();
        this.model.setRootObject(refObject);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.setRootObject(oldObject);
    }

    @Override
    public void setParentRootObject(Object parentRefObject, Object grandParent) {
        this.model.setParentRootObject(parentRefObject, grandParent);
        this.view.setParentRootObject();
    }

    @Override
    public void setExistingTags(Collection tags) {
        this.model.setExistingTags(tags);
        ArrayList<TagAnnotationData> selected = new ArrayList<TagAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        Collection<TagAnnotationData> setTags = this.model.getCommonTags();
        if (setTags != null) {
            for (TagAnnotationData tag : setTags) {
                if (!this.model.isAnnotationUsedByUser(tag)) continue;
                ids.add(tag.getId());
                selected.add(tag);
            }
        }
        ArrayList<TagAnnotationData> available = new ArrayList<TagAnnotationData>();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            for (TagAnnotationData data : tags) {
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        if (this.controller.getFigureDialog() != null) {
            ArrayList<TagAnnotationData> all = new ArrayList<TagAnnotationData>();
            all.addAll(available);
            if (CollectionUtils.isNotEmpty(setTags)) {
                all.addAll(setTags);
            }
            this.controller.getFigureDialog().setTags(all);
            return;
        }
        this.showSelectionWizard(TagAnnotationData.class, available, selected, true);
    }

    @Override
    public void setChannelsData(Map channels, boolean updateView) {
        this.model.setChannelData(channels);
        if (updateView) {
            this.view.showChannelData();
        }
    }

    @Override
    public boolean hasDataToSave() {
        return this.view.hasDataToSave();
    }

    @Override
    public void setDiskSpace(DiskQuota quota) {
        if (quota == null) {
            return;
        }
        this.view.setDiskSpace(quota);
        this.view.layoutUI();
    }

    @Override
    public void passwordChanged(boolean changed) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (changed) {
            un.notifyInfo("Password change", "The password has been successfully modified.");
        } else {
            un.notifyInfo("Password change", "The password could not be modified. Please try again.");
        }
        this.view.passwordChanged();
    }

    @Override
    public void loadChannelData() {
        if (this.model.isNumerousChannel()) {
            return;
        }
        if (this.model.getRndIndex() == 0) {
            if (this.model.getChannelData() == null) {
                this.model.loadChannelData();
            }
        } else {
            this.view.showChannelData();
        }
    }

    @Override
    public Map getChannelData() {
        return this.model.getChannelData();
    }

    @Override
    public void setExistingAttachments(Collection attachments) {
        if (attachments == null) {
            return;
        }
        this.model.setExistingAttachments(attachments);
        Collection<FileAnnotationData> setAttachments = this.model.getCommonAttachments();
        ArrayList<FileAnnotationData> selected = new ArrayList<FileAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (setAttachments != null) {
            for (FileAnnotationData file : setAttachments) {
                if (!this.model.isAnnotationUsedByUser(file)) continue;
                selected.add(file);
                ids.add(file.getId());
            }
        }
        ArrayList<FileAnnotationData> available = new ArrayList<FileAnnotationData>();
        if (attachments != null) {
            for (FileAnnotationData data : attachments) {
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        this.showSelectionWizard(FileAnnotationData.class, available, selected, true);
    }

    @Override
    public void setSelectionMode(boolean single) {
        if (!single) {
            this.view.layoutUI();
        }
        this.view.repaint();
    }

    @Override
    public void loadParents() {
        this.model.loadParents();
    }

    @Override
    public void setStatus(boolean busy) {
        this.view.setStatus(busy);
    }

    @Override
    public void loadExistingTags() {
        this.model.loadExistingTags();
        this.setStatus(true);
    }

    @Override
    public void setImageAcquisitionData(ImageAcquisitionData map) {
        if (map == null) {
            return;
        }
        this.model.setImageAcquisitionData(map);
        this.view.setImageAcquisitionData();
        this.view.setStatus(false);
    }

    @Override
    public void removeFileAnnotations(List<FileAnnotationData> annotations) {
        this.model.fireFileAnnotationRemoveCheck(annotations);
    }

    @Override
    public void handleFileAnnotationRemoveCheck(final FileAnnotationCheckResult result) {
        if (!result.getDeleteCandidates().isEmpty()) {
            JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
            FileAttachmentWarningDialog dlg = new FileAttachmentWarningDialog(f, result);
            dlg.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (arg0.getPropertyName().equals("delete")) {
                        for (FileAnnotationData fd : result.getDeleteCandidates()) {
                            EditorComponent.this.view.deleteAnnotation((AnnotationData)fd);
                        }
                        for (FileAnnotationData fd : result.getAllAnnotations()) {
                            EditorComponent.this.view.unlinkAttachedFile(fd);
                        }
                    }
                }
            });
            UIUtilities.centerAndShow(dlg);
        } else {
            for (FileAnnotationData fd : result.getAllAnnotations()) {
                this.view.unlinkAttachedFile(fd);
            }
        }
    }

    @Override
    public void loadImageAcquisitionData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            ImageAcquisitionData data = this.model.getImageAcquisitionData();
            if (data != null) {
                return;
            }
            this.model.fireImagAcquisitionDataLoading();
            this.view.setStatus(true);
        }
    }

    @Override
    public void loadChannelAcquisitionData(ChannelData channel) {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            if (channel == null) {
                return;
            }
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(channel.getIndex());
            if (data != null) {
                return;
            }
            this.model.fireChannelAcquisitionDataLoading(channel);
            this.view.setStatus(true);
        }
    }

    @Override
    public void loadInstrumentData() {
        ImageData img;
        long id;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)refObject;
            refObject = wsd.getImage();
        }
        if (refObject instanceof ImageData && (id = (img = (ImageData)refObject).getInstrumentId()) > 0L) {
            this.model.fireInstrumentDataLoading(id);
            this.view.setStatus(true);
        }
    }

    @Override
    public void setChannelEnumerations(Map map) {
        this.model.setChannelEnumerations(map);
    }

    @Override
    public void setImageEnumerations(Map map) {
        this.model.setImageEnumerations(map);
    }

    @Override
    public void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        this.model.setChannelAcquisitionData(index, data);
        this.view.setChannelAcquisitionData(index);
        this.view.setStatus(false);
    }

    @Override
    public void loadExistingAttachments() {
        this.model.loadExistingAttachments();
        this.setStatus(true);
    }

    @Override
    public void download(File file, boolean override) {
        if (file == null) {
            return;
        }
        this.model.download(file, override);
    }

    @Override
    public void downloadOriginal(String path, boolean override) {
        if (CommonsLangUtils.isEmpty(path)) {
            return;
        }
        this.model.downloadOriginal(path, override);
    }

    @Override
    public void setPlaneInfo(Collection result, long pixelsID, int channel) {
        Object ref = this.model.getRefObject();
        if (ref instanceof WellSampleData) {
            WellSampleData ws = (WellSampleData)ref;
            ref = ws.getImage();
        }
        if (!(ref instanceof ImageData)) {
            return;
        }
        ImageData img = (ImageData)ref;
        if (pixelsID != img.getDefaultPixels().getId()) {
            return;
        }
        FigureDialog d = this.controller.getFigureDialog();
        if (channel >= 0) {
            this.model.setPlaneInfo(channel, result);
            this.view.setStatus(false);
        }
        if (d != null) {
            d.setPlaneInfo(this.model.getChannelPlaneInfo(0));
        } else {
            this.view.setPlaneInfo(channel);
        }
    }

    @Override
    public void setRenderingControl(RenderingControl rndControl) {
        boolean loaded = this.model.isRendererLoaded();
        this.setStatus(false);
        if (rndControl == null) {
            this.setSelectedTab(0);
            return;
        }
        FigureDialog d = this.controller.getFigureDialog();
        PixelsData data = this.model.getPixels();
        if (data == null) {
            this.setSelectedTab(0);
            return;
        }
        if (data.getId() != rndControl.getPixelsID()) {
            this.setSelectedTab(0);
            return;
        }
        this.model.setRenderingControl(rndControl);
        if (loaded) {
            this.view.onSettingsApplied(false);
        }
        if (d == null) {
            this.view.setRenderer();
        }
        if (this.model.getRndIndex() == 1) {
            this.loadChannelData();
        }
        this.model.getRenderer().addPropertyChangeListener(this.controller);
        this.model.onRndLoaded(false);
        if (d != null) {
            d.setRenderer(this.model.getRenderer());
            if (d.getDialogType() == 4) {
                this.model.firePlaneInfoLoading(0, 0);
            }
        }
        this.model.getRenderer().refresh();
        this.model.getRenderer().retrieveRelatedSettings();
        this.model.getRenderer().updatePasteAction();
    }

    @Override
    public void loadRenderingControl(int index) {
        int value;
        if (this.model.getRenderer() == null && index == 1) {
            return;
        }
        ImageData image = this.model.getImage();
        if (image == null || image.getId() < 0L) {
            return;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return;
        }
        switch (index) {
            case 0: 
            case 1: {
                value = index;
                break;
            }
            default: {
                value = index;
            }
        }
        this.setStatus(this.model.fireRenderingControlLoading(pixels.getId(), value));
    }

    @Override
    public void loadRenderingControl() {
        ImageData image = this.model.getImage();
        if (image == null || image.getId() < 0L) {
            return;
        }
        PixelsData pixels = image.getDefaultPixels();
        this.model.loadRenderingControl(pixels.getId());
    }

    @Override
    public void setLoadedFile(FileAnnotationData data, File file, Object uiView) {
        if (uiView instanceof DocComponent) {
            if (file == null) {
                return;
            }
            DocComponent doc = (DocComponent)uiView;
            if (doc.getData() == data) {
                doc.setThumbnail(file.getAbsolutePath());
                file.delete();
            }
        } else if (uiView instanceof OriginalMetadataComponent) {
            ((OriginalMetadataComponent)uiView).setOriginalFile(file);
        }
    }

    @Override
    public Renderer getRenderer() {
        return this.model.getRenderer();
    }

    @Override
    public void setInstrumentData(InstrumentData data) {
        if (data == null) {
            return;
        }
        this.model.setInstrumentData(data);
        this.view.setInstrumentData();
        this.view.setStatus(false);
    }

    @Override
    public void refresh() {
        this.model.refresh();
    }

    @Override
    public void exportImageAsOMETIFF(File folder, Target target) {
        Object refObject = this.model.getRefObject();
        ImageData image = null;
        if (refObject instanceof ImageData) {
            image = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            image = ((WellSampleData)refObject).getImage();
        }
        if (image == null) {
            return;
        }
        if (folder == null) {
            folder = UIUtilities.getDefaultFolder();
        }
        ExportActivityParam param = new ExportActivityParam(folder, image, 0, target);
        IconManager icons = IconManager.getInstance();
        param.setIcon(icons.getIcon(75));
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.model.getSecurityContext(), param);
    }

    @Override
    public void onChannelColorChanged(int index) {
        this.view.onChannelColorChanged(index);
    }

    @Override
    public void setSelectedTab(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.view.setSelectedTab(index);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void createFigure(int index) {
        if (this.controller.getFigureDialog() == null) {
            String name = this.model.getRefObjectName();
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            PixelsData pixels = this.model.getPixels();
            boolean b = this.view.isNumerousChannel();
            switch (index) {
                case 0: {
                    if (pixels == null) {
                        un.notifyInfo("Split View Figure", "Image not valid. Cannot create figure.");
                        return;
                    }
                    if (b) {
                        un.notifyInfo("Split View Figure", "The selected type of figure is not available for the image.");
                        return;
                    }
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 0);
                    if (!this.model.isRendererLoaded()) {
                        this.loadRenderingControl(0);
                    } else {
                        dialog.setRenderer(this.model.getRenderer());
                    }
                    dialog.centerDialog();
                    break;
                }
                case 1: {
                    if (b) {
                        un.notifyInfo("ROI Split Figure", "The selected type of figure is not available for the image.");
                        return;
                    }
                    this.model.fireROILoading(1);
                    break;
                }
                case 3: {
                    Object ref = this.model.getRefObject();
                    if (ref instanceof WellSampleData || ref instanceof PlateData) {
                        un.notifyInfo("Thumbnails Figure", "Script not available for Wells or Plate");
                        return;
                    }
                    Collection<TagAnnotationData> tags = this.model.isMultiSelection() ? this.model.getAllTags() : this.model.getTags();
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 3);
                    dialog.setParentRef(this.model.getParentRootObject());
                    if (tags != null) {
                        dialog.setTags(tags);
                    } else {
                        this.model.loadExistingTags();
                    }
                    dialog.centerDialog();
                    break;
                }
                case 2: {
                    if (pixels == null) {
                        un.notifyInfo("Movie Figure", "Image not valid. Cannot create figure.");
                        return;
                    }
                    Collection planes = this.model.getChannelPlaneInfo(0);
                    FigureDialog dialog = this.controller.createFigureDialog(name, pixels, 2);
                    if (planes != null) {
                        dialog.setPlaneInfo(planes);
                    } else {
                        this.model.firePlaneInfoLoading(0, 0);
                    }
                    dialog.centerDialog();
                    break;
                }
                case 4: {
                    this.model.fireROILoading(4);
                }
            }
        }
    }

    @Override
    public void setROI(Collection rois, long imageID, int index) {
        if (index != 1 && index != 4) {
            return;
        }
        ImageData img = this.model.getImage();
        if (img == null || img.getId() != imageID) {
            return;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (rois == null || rois.size() == 0) {
            un.notifyInfo("ROI Split Figure", "The primary select does not have Region of Interests.");
            return;
        }
        Iterator r = rois.iterator();
        int count = 0;
        try {
            while (r.hasNext()) {
                ROIResult result = (ROIResult)r.next();
                Collection list = result.getROIs();
                if (list.size() <= 0) continue;
                ++count;
            }
        }
        catch (Exception list) {
            // empty catch block
        }
        if (count == 0) {
            un.notifyInfo("ROI Split Figure", "The primary select does not have Region of Interests.");
            return;
        }
        if (this.controller.getFigureDialog() == null) {
            PixelsData pixels = this.model.getPixels();
            if (pixels == null) {
                un.notifyInfo("ROI Split Figure", "Image not valid. Cannot create figure.");
                return;
            }
            String name = this.model.getRefObjectName();
            FigureDialog dialog = this.controller.createFigureDialog(name, pixels, index);
            if (dialog == null) {
                return;
            }
            dialog.setROIs(rois);
            if (!this.model.isRendererLoaded()) {
                this.loadRenderingControl(0);
            } else {
                dialog.setRenderer(this.model.getRenderer());
                if (index == 4) {
                    this.model.firePlaneInfoLoading(0, 0);
                }
            }
            dialog.centerDialog();
        }
    }

    @Override
    public void setScripts(List scripts) {
        this.model.setScripts(scripts);
        this.view.setScripts();
    }

    @Override
    public long getUserID() {
        return this.model.getUserID();
    }

    @Override
    public void loadScript(long scriptID) {
        if (scriptID < 0L) {
            return;
        }
        this.model.loadScript(scriptID);
        this.setStatus(true);
    }

    @Override
    public void setScript(ScriptObject script) {
        if (script == null) {
            throw new IllegalArgumentException("No script.");
        }
        this.model.setScript(script);
        this.setStatus(false);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        if (this.dialog == null) {
            this.dialog = new ScriptingDialog(f, this.model.getScript(script.getScriptID()), this.model.getSelectedObjects(), MetadataViewerAgent.isBinaryAvailable());
            this.dialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(this.dialog);
        } else {
            this.dialog.reset(this.model.getScript(script.getScriptID()), this.model.getSelectedObjects());
            if (!this.dialog.isVisible()) {
                UIUtilities.centerAndShow(this.dialog);
            }
        }
    }

    @Override
    public void setUserPhoto(BufferedImage photo, long experimenterID) {
        ExperimenterData exp;
        if (photo == null) {
            return;
        }
        Object o = this.model.getRefObject();
        if (o instanceof ExperimenterData && (exp = (ExperimenterData)o).getId() == experimenterID) {
            this.model.setUserPhoto(photo, experimenterID);
            this.view.setUserPhoto(photo);
        }
    }

    @Override
    public boolean canLink() {
        return this.model.canLink();
    }

    @Override
    public boolean canEdit() {
        return this.model.canEdit();
    }

    @Override
    public boolean canAnnotate() {
        return this.model.canAnnotate();
    }

    @Override
    public void displayAnalysisResults(AnalysisResultsItem analysis) {
        if (analysis == null) {
            return;
        }
        List<FileAnnotationData> list = analysis.getAttachments();
        if (list == null || list.size() == 0) {
            return;
        }
        Map<FileAnnotationData, File> results = analysis.getResults();
        if (results != null) {
            this.analysisResultsLoaded(analysis);
        } else {
            this.model.loadAnalysisResults(analysis);
            analysis.notifyLoading(true);
        }
    }

    @Override
    public void analysisResultsLoaded(AnalysisResultsItem analysis) {
        if (analysis == null) {
            return;
        }
        analysis.notifyLoading(false);
        this.model.removeAnalysisResultsLoading(analysis);
    }

    @Override
    public void saveAs(File folder, int format, String fileName) {
        if (folder == null) {
            folder = UIUtilities.getDefaultFolder();
        }
        this.model.saveAs(folder, format, fileName);
    }

    @Override
    public void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.model.getSecurityContext();
    }

    @Override
    public void setLargeImage(Boolean value) {
        ImageData img = this.model.getImage();
        if (img == null) {
            return;
        }
        this.model.setLargeImage(value);
        this.view.onSizeLoaded();
        this.view.handleImageSelection();
        this.loadRnd();
    }

    @Override
    public void onUpdatedChannels(List<ChannelData> channels) {
        this.model.updateChannels(channels);
        this.view.showChannelData();
    }

    @Override
    public void setFileset(Collection<FilesetData> set) {
        this.model.setFileset(set);
        this.view.displayFileset();
    }

    @Override
    public void loadFileset() {
        this.model.fireFilesetLoading();
    }

    @Override
    public void loadRnd() {
        if (this.model.getRndIndex() == 1) {
            if (!this.model.isRendererLoaded()) {
                this.loadRenderingControl(0);
            }
        } else if (this.view.getSelectedTab() == 2) {
            this.loadRenderingControl(0);
        }
    }

    @Override
    public void setLDAPDetails(long userID, String result) {
        ExperimenterData exp;
        Object o = this.model.getRefObject();
        if (o instanceof ExperimenterData && (exp = (ExperimenterData)o).getId() == userID) {
            this.view.setLDAPDetails(result);
        }
    }

    @Override
    public ScriptObject getScriptFromName(String name) {
        return this.model.getScriptFromName(name);
    }

    @Override
    public Collection<FileAnnotationData> getSelectedFileAnnotations() {
        return this.view.getSelectedFileAnnotations();
    }

    @Override
    public void reloadROICount() {
        this.view.reloadROICount();
    }
}

