/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.PropertiesUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;

public class ROICountLoader
extends DSCallAdapter {
    private final Registry registry;
    private final ImageDataView imView;
    private final SecurityContext ctx;
    private PropertiesUI propUI;
    private long imageID;
    private CallHandle handle;

    public ROICountLoader(SecurityContext ctx, PropertiesUI propUI, long imageID) {
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.ctx = ctx;
        this.imageID = imageID;
        this.propUI = propUI;
        this.registry = MetadataViewerAgent.getRegistry();
        this.imView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
    }

    @Override
    public void handleNullResult() {
        LogMessage msg = new LogMessage();
        msg.print("No data returned.");
        this.registry.getLogger().error((Object)this, msg);
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
    }

    public void load() {
        this.handle = this.imView.getROICount(this.ctx, this.imageID, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Integer) {
            this.propUI.updateROICount((Integer)result);
        }
    }
}

