/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import org.apache.commons.collections.CollectionUtils;

public class FileAnnotationCheckResult {
    private HashMultimap<FileAnnotationData, DataObject> linkMap = HashMultimap.create();
    private List<DataObject> referenceObjects;

    public FileAnnotationCheckResult() {
    }

    public FileAnnotationCheckResult(List<DataObject> referenceObjects) {
        this.referenceObjects = referenceObjects;
    }

    public Set<DataObject> getLinks(FileAnnotationData fd) {
        return this.linkMap.get((Object)fd);
    }

    public void addLinks(FileAnnotationData fd, List<DataObject> links) {
        this.linkMap.putAll((Object)fd, links);
    }

    public List<FileAnnotationData> getDeleteCandidates() {
        ArrayList<FileAnnotationData> result = new ArrayList<FileAnnotationData>();
        for (FileAnnotationData fd : this.linkMap.keySet()) {
            Set parents = this.linkMap.get((Object)fd);
            if (CollectionUtils.isEmpty(this.referenceObjects) && parents.size() == 1) {
                result.add(fd);
                continue;
            }
            if (!this.containsAll(this.referenceObjects, parents)) continue;
            result.add(fd);
        }
        return result;
    }

    public Set<FileAnnotationData> getAllAnnotations() {
        return this.linkMap.keySet();
    }

    boolean containsAll(Collection<DataObject> collA, Collection<DataObject> collB) {
        for (DataObject b : collB) {
            boolean contains = false;
            for (DataObject a : collA) {
                if (!a.getClass().equals(b.getClass()) || a.getId() != b.getId()) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }
}

