/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import omero.gateway.model.FolderData;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIUtil;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;

public class ROINode
extends OMETreeNode {
    private static final int ROIID_COLUMN = 0;
    private static final int TIME_COLUMN = 2;
    private static final int Z_COLUMN = 1;
    private static final int SHAPE_COLUMN = 3;
    private static final int ANNOTATION_COLUMN = 4;
    private static final int SHOW_COLUMN = 5;
    private Map<ROIShape, ROINode> childMap;
    private TreeMap<Coord3D, ROINode> childCoordMap;
    private HashMap<FolderData, ROINode> folderMap;
    private boolean show = true;
    private boolean showEnabled = true;

    public ROINode(String str) {
        super(str);
        this.initMaps();
    }

    public ROINode(ROI nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public ROINode(ROIShape nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public ROINode(FolderData folder) {
        super(folder);
        this.initMaps();
    }

    public boolean isFolderNode() {
        return this.getUserObject() instanceof FolderData;
    }

    public boolean isROINode() {
        return this.getUserObject() instanceof ROI;
    }

    public boolean isShapeNode() {
        return this.getUserObject() instanceof ROIShape;
    }

    public boolean isAncestorOf(ROINode node) {
        for (int i = 0; i < node.getPath().getPathCount(); ++i) {
            if (node.getPath().getPathComponent(i) != this) continue;
            return true;
        }
        return false;
    }

    public int getInsertionPoint(Coord3D coord) {
        Iterator<Coord3D> i = this.childCoordMap.keySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Coord3D nodeCoord = i.next();
            if (nodeCoord.compare(nodeCoord, coord) != -1) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public int getInsertionPoint(FolderData f) {
        int index = 0;
        if (f == null) {
            return index;
        }
        for (MutableTreeTableNode n : this.children) {
            ROINode r = (ROINode)n;
            if (r.getUserObject() == null) continue;
            if (r.isFolderNode() && ((FolderData)r.getUserObject()).getName().compareToIgnoreCase(f.getName()) > 0) break;
            ++index;
        }
        return index;
    }

    private void initMaps() {
        this.childMap = new HashMap<ROIShape, ROINode>();
        this.childCoordMap = new TreeMap(new Coord3D());
        this.folderMap = new HashMap();
    }

    public ROINode findChild(ROIShape shape) {
        return this.childMap.get(shape);
    }

    public ROINode findChild(Coord3D shapeCoord) {
        return this.childCoordMap.get(shapeCoord);
    }

    public ROINode findChild(FolderData folder) {
        return this.folderMap.get(folder);
    }

    @Override
    public boolean isEditable(int column) {
        switch (column) {
            case 6: {
                return this.showEnabled;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void insert(ROINode child, int index) {
        super.insert((MutableTreeTableNode)child, index);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            child.setExpanded(true);
            this.childMap.put(shape, child);
            this.childCoordMap.put(shape.getCoord3D(), child);
        } else if (child.isFolderNode()) {
            this.folderMap.put((FolderData)userObject, child);
        }
    }

    public void remove(ROINode child) {
        super.remove((MutableTreeTableNode)child);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        } else if (child.isFolderNode()) {
            this.folderMap.remove((FolderData)userObject);
        }
    }

    public void remove(Coord3D childCoord) {
        ROINode childNode = this.childCoordMap.get(childCoord);
        super.remove((MutableTreeTableNode)childNode);
        Object userObject = childNode.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        }
    }

    public Object getValueAt(int column) {
        Object userObject = this.getUserObject();
        if (userObject instanceof ROI) {
            ROI roi = (ROI)userObject;
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    return roi.getID();
                }
                case 3: {
                    return roi.getTRange();
                }
                case 2: {
                    return roi.getZRange();
                }
                case 4: {
                    return roi.getShapeTypes();
                }
                case 5: {
                    return AnnotationKeys.TEXT.get(roi);
                }
                case 6: {
                    return this.isShown();
                }
            }
            return null;
        }
        if (userObject instanceof ROIShape) {
            ROIShape roiShape = (ROIShape)userObject;
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (roiShape.getROI().isClientSide()) {
                        return "--";
                    }
                    return roiShape.getROIShapeID();
                }
                case 3: {
                    int v = roiShape.getT();
                    if (v < 0) {
                        return "";
                    }
                    return Integer.valueOf(v + 1).toString();
                }
                case 2: {
                    int v = roiShape.getZ();
                    if (v < 0) {
                        return "";
                    }
                    return Integer.valueOf(v + 1).toString();
                }
                case 4: {
                    return roiShape.getFigure().getType();
                }
                case 5: {
                    return roiShape.getFigure().getAttribute(MeasurementAttributes.TEXT);
                }
                case 6: {
                    return this.isShown();
                }
            }
            return null;
        }
        if (userObject instanceof FolderData) {
            FolderData folder = (FolderData)userObject;
            switch (column) {
                case 1: {
                    return folder.getId();
                }
                case 5: {
                    return folder.getDescription();
                }
                case 6: {
                    return this.isShown();
                }
            }
            return "";
        }
        return null;
    }

    boolean isShown() {
        return this.show;
    }

    public void setValueAt(Object value, int column) {
        Object userObject = this.getUserObject();
        if (userObject instanceof ROI) {
            ROI roi = (ROI)userObject;
            switch (column) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    if (!(value instanceof String)) break;
                    roi.setAnnotation(AnnotationKeys.TEXT, (String)value);
                    break;
                }
                case 6: {
                    if (!(value instanceof Boolean)) break;
                    this.setShow((Boolean)value);
                    this.updateShapeVisibility();
                    break;
                }
            }
        } else if (userObject instanceof ROIShape) {
            ROIShape roiShape = (ROIShape)userObject;
            ROIFigure figure = roiShape.getFigure();
            switch (column) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (!(value instanceof String)) break;
                    AnnotationKeys.TEXT.set(roiShape, (String)value);
                    MeasurementAttributes.TEXT.set(figure, (String)value);
                    MeasurementAttributes.SHOWTEXT.set(figure, Boolean.valueOf(!((String)value).equals("")));
                    break;
                }
                case 6: {
                    if (!(value instanceof Boolean)) break;
                    this.setShow((Boolean)value);
                    this.updateShapeVisibility();
                    break;
                }
            }
        } else if (userObject instanceof FolderData) {
            switch (column) {
                case 6: {
                    if (!(value instanceof Boolean)) break;
                    this.setShow((Boolean)value);
                    this.updateShapeVisibility();
                    break;
                }
            }
        }
    }

    public boolean isShowEnabled() {
        return this.showEnabled;
    }

    public void setShowEnabled(boolean showEnabled) {
        this.showEnabled = showEnabled;
        for (MutableTreeTableNode n : this.getChildList()) {
            ((ROINode)n).setShowEnabled(showEnabled);
        }
    }

    void setShow(boolean show) {
        block3: {
            block4: {
                block2: {
                    this.show = show;
                    if (!this.isShapeNode()) break block2;
                    ROINode roinode = (ROINode)((Object)this.getPath().getParentPath().getLastPathComponent());
                    roinode.show = show;
                    break block3;
                }
                if (!this.isROINode()) break block4;
                for (MutableTreeTableNode n : this.getChildList()) {
                    ((ROINode)n).show = show;
                }
                break block3;
            }
            if (!this.isFolderNode()) break block3;
            for (MutableTreeTableNode n : this.getChildList()) {
                ((ROINode)n).setShowEnabled(show);
            }
        }
    }

    private void updateShapeVisibility() {
        long shapeId = -123L;
        if (this.isShapeNode()) {
            shapeId = ((ROIShape)this.getUserObject()).getID();
        }
        if (this.isROINode()) {
            shapeId = ((ROIShape)((ROINode)this.getChildList().iterator().next()).getUserObject()).getID();
        }
        Collection<ROINode> shapeNodes = ROIUtil.getShapeNodes(this.getRoot());
        ArrayListMultimap map = ArrayListMultimap.create();
        for (ROINode n : shapeNodes) {
            map.put((Object)((ROIShape)n.getUserObject()).getID(), (Object)n);
        }
        for (ROINode n : shapeNodes) {
            ROIShape s = (ROIShape)n.getUserObject();
            if (s.getID() == shapeId) {
                n.setShow(this.isShown());
                s.getFigure().setVisible(this.isShown());
                continue;
            }
            Collection sNodes = map.get((Object)s.getID());
            boolean shown = false;
            for (ROINode n2 : sNodes) {
                if (!this.checkPathShown(n2)) continue;
                shown = true;
                break;
            }
            s.getFigure().setVisible(shown);
        }
    }

    private boolean checkPathShown(ROINode n) {
        TreePath p = n.getPath();
        boolean shown = true;
        for (int i = 0; i < p.getPathCount(); ++i) {
            ROINode r;
            Object o = p.getPathComponent(i);
            if (!(o instanceof ROINode) || (r = (ROINode)((Object)o)).isShown()) continue;
            shown = false;
            break;
        }
        return shown;
    }

    public boolean canAnnotate() {
        if (this.isFolderNode()) {
            return ((FolderData)this.getUserObject()).canAnnotate();
        }
        if (this.isROINode()) {
            return ((ROI)this.getUserObject()).canAnnotate();
        }
        if (this.isShapeNode()) {
            return ((ROIShape)this.getUserObject()).getROI().canAnnotate();
        }
        return false;
    }

    public boolean canDelete() {
        if (this.isFolderNode()) {
            return ((FolderData)this.getUserObject()).canDelete();
        }
        if (this.isROINode()) {
            return ((ROI)this.getUserObject()).canDelete();
        }
        if (this.isShapeNode()) {
            return ((ROIShape)this.getUserObject()).getROI().canDelete();
        }
        return false;
    }

    public boolean canEdit() {
        if (this.isFolderNode()) {
            return ((FolderData)this.getUserObject()).canEdit();
        }
        if (this.isROINode()) {
            return ((ROI)this.getUserObject()).canEdit();
        }
        if (this.isShapeNode()) {
            return ((ROIShape)this.getUserObject()).getROI().canEdit();
        }
        return false;
    }

    private ROINode getRoot() {
        return (ROINode)((Object)this.getPath().getPathComponent(0));
    }
}

