/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ObjectiveData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.TableResult;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.PlaneInfo;
import omero.model.enums.UnitsLength;
import omero.romio.PlaneDef;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.imviewer.AcquisitionDataLoader;
import org.openmicroscopy.shoola.agents.imviewer.BirdEyeLoader;
import org.openmicroscopy.shoola.agents.imviewer.ContainerLoader;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.ImageDataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImageLoader;
import org.openmicroscopy.shoola.agents.imviewer.MeasurementsLoader;
import org.openmicroscopy.shoola.agents.imviewer.OverlaysRenderer;
import org.openmicroscopy.shoola.agents.imviewer.PlaneInfoLoader;
import org.openmicroscopy.shoola.agents.imviewer.ProjectionSaver;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsCreator;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsLoader;
import org.openmicroscopy.shoola.agents.imviewer.TileLoader;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.util.player.ChannelPlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.Region;
import org.openmicroscopy.shoola.env.rnd.data.ResolutionLevel;
import org.openmicroscopy.shoola.env.rnd.data.Tile;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImViewerModel {
    static long DEFAULT_MAX_EXPORT_SIZE = 144000000L;
    private static final int BIRD_EYE_SIZE_LOWER = 128;
    private static final int BIRD_EYE_SIZE_MEDIUM = 196;
    private static final int BIRD_EYE_SIZE_HEIGH = 256;
    private static final int MAX_HISTORY = 10;
    private static final int THUMB_MAX_WIDTH = 24;
    private static final int THUMB_MAX_HEIGHT = 24;
    private static final int SETTINGS = 0;
    private static final int IMAGE = 1;
    private static final int BIRD_EYE_VIEW = 2;
    private DataObject image;
    private int state;
    private ImViewer component;
    private Map<Integer, DataLoader> loaders;
    private Browser browser;
    private ChannelPlayer player;
    private int sizeX;
    private int sizeY;
    private double factor;
    private BufferedImage imageIcon;
    private Rectangle requesterBounds;
    private int tabbedIndex;
    private boolean textVisible;
    private boolean playingMovie;
    private boolean playingChannelMovie;
    private List<HistoryItem> historyItems;
    private int movieIndex;
    private Map renderingSettings;
    private MetadataViewer metadataViewer;
    private boolean metadataLoaded;
    private long currentPixelsID;
    private RndProxyDef alternativeSettings;
    private long selectedUserID;
    private boolean initMagnificationFactor;
    private DataObject parent;
    private DataObject grandParent;
    private Map<Integer, PlaneInfo> planeInfos;
    private long imageID;
    private RndProxyDef originalDef;
    private RndProxyDef lastMainDef;
    private RndProxyDef lastProjDef;
    private ProjectionParam lastProjRef;
    private int lastProjTime;
    private Collection containers;
    private Collection measurements;
    private boolean separateWindow;
    private long overlayTableID;
    private double originalRatio;
    private Map<Integer, Tile> tiles;
    private int numberOfRows;
    private int numberOfColumns;
    private List<ResolutionLevel> resolutions;
    private int tiledImageSizeX;
    private int tiledImageSizeY;
    private boolean firstTime;
    private SecurityContext ctx;
    private List<ChannelData> channels;
    private int displayMode;
    private int tileTotalCount;
    private int tileLoadedCount;
    private int planeSize;
    private UnitsLength refUnit;
    private UnitsLength scaleBarUnit;
    private long selectedRndDefID;

    private int getDefaultResolutionLevel() {
        String zoomLevel = (String)ImViewerAgent.getRegistry().lookup("omero.client.viewer.initial_zoom_level");
        if (this.isBigImage() && CommonsLangUtils.isNotBlank(zoomLevel)) {
            return Integer.parseInt(zoomLevel);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 9 * (screenSize.width / 10);
        int h = 8 * (screenSize.height / 10);
        for (int i = this.resolutions.size() - 1; i >= 0; --i) {
            ResolutionLevel level = this.resolutions.get(i);
            Dimension d = level.getImageSize();
            if (d.width >= w && d.height >= h) continue;
            return level.getLevel();
        }
        return 0;
    }

    private PlaneDef createPlaneDef() {
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        return pDef;
    }

    private void initializeTiles() {
        ResolutionLevel level = this.getResolutionDescription();
        Dimension d = level.getTileSize();
        int w = d.width;
        int h = d.height;
        int edgeWidth = w;
        int edgeHeight = h;
        int size = level.getImageSize().width;
        edgeWidth = w;
        int n = size / w;
        this.tiledImageSizeX = n * w;
        if (n * w < size) {
            edgeWidth = size - n * w;
            this.tiledImageSizeX += edgeWidth;
            ++n;
        }
        this.numberOfColumns = n;
        size = level.getImageSize().height;
        edgeHeight = h;
        n = size / h;
        this.tiledImageSizeY = n * h;
        if (n * h < size) {
            edgeHeight = size - n * h;
            this.tiledImageSizeY += edgeHeight;
            ++n;
        }
        this.numberOfRows = n;
        int index = 0;
        int x = 0;
        int y = 0;
        if (this.numberOfColumns <= 0) {
            this.numberOfColumns = 1;
        }
        if (this.numberOfColumns <= 0) {
            this.numberOfColumns = 1;
        }
        for (int i = 0; i < this.numberOfRows; ++i) {
            int hh = i == this.numberOfRows - 1 ? edgeHeight : h;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int ww = j == this.numberOfColumns - 1 ? edgeWidth : w;
                index = i * this.numberOfColumns + j;
                Tile tile = new Tile(index, i, j);
                Region region = new Region(x, y, ww, hh);
                tile.setRegion(region);
                x += d.width;
                this.tiles.put(index, tile);
            }
            y += d.height;
            x = 0;
        }
    }

    private void sortTilesByIndex(List<Tile> tiles) {
        if (tiles == null || tiles.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                int n1 = ((Tile)o1).getIndex();
                int n2 = ((Tile)o2).getIndex();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(tiles, c);
    }

    private Integer linearize(int z, int c, int t) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1;
        }
        int sizeZ = rnd.getPixelsDimensionsZ();
        int sizeC = rnd.getPixelsDimensionsC();
        int sizeT = rnd.getPixelsDimensionsT();
        if (z < 0 || sizeZ <= z) {
            return -1;
        }
        if (c < 0 || sizeC <= c) {
            return -1;
        }
        if (t < 0 || sizeT <= t) {
            return -1;
        }
        return sizeZ * sizeC * t + sizeZ * c + z;
    }

    private void computeSizes() {
        if (this.sizeX == -1 && this.sizeY == -1) {
            double y;
            this.sizeX = 24;
            this.sizeY = 24;
            double x = (double)this.sizeX / (double)this.getMaxX();
            this.factor = x > (y = (double)this.sizeY / (double)this.getMaxY()) ? x : y;
            double ratio = (double)this.getMaxX() / (double)this.getMaxY();
            if (ratio < 1.0) {
                this.sizeX = (int)((double)this.sizeX * ratio);
            } else if (ratio > 1.0 && ratio != 0.0) {
                this.sizeY = (int)((double)this.sizeY * (1.0 / ratio));
            }
        }
    }

    private double initZoomFactor() {
        return -1.0;
    }

    private void initialize(Rectangle bounds, boolean separateWindow) {
        this.firstTime = true;
        this.separateWindow = separateWindow;
        this.tiles = new HashMap<Integer, Tile>();
        this.originalRatio = 1.0;
        this.overlayTableID = -1L;
        this.requesterBounds = bounds;
        this.state = 1;
        this.initMagnificationFactor = false;
        this.sizeY = -1;
        this.sizeX = -1;
        this.tabbedIndex = 0;
        this.textVisible = true;
        this.movieIndex = -1;
        this.loaders = new HashMap<Integer, DataLoader>();
        this.metadataViewer = null;
        this.metadataLoaded = false;
        this.currentPixelsID = -1L;
        this.selectedUserID = -1L;
        this.lastProjTime = -1;
        this.lastProjRef = null;
        this.planeSize = (Integer)ImViewerAgent.getRegistry().lookup("/services/RE/planeSize");
        this.checkDefaultDisplayMode();
    }

    private void checkDefaultDisplayMode() {
        Integer value = (Integer)ImViewerAgent.getRegistry().lookup("DataDisplay");
        if (value == null) {
            this.setDisplayMode(1);
        } else {
            this.setDisplayMode(value);
        }
    }

    private void initializeMetadataViewer() {
        Renderer otherRenderer;
        this.metadataViewer = MetadataViewerFactory.getViewer("", 1, this.alternativeSettings, this.selectedRndDefID);
        this.metadataViewer.setRootObject(this.image, this.metadataViewer.getUserID(), this.getSecurityContext());
        MetadataViewer otherViewer = MetadataViewerFactory.getViewerFromId(ImageData.class.getName(), this.image.getId());
        if (otherViewer != null && (otherRenderer = otherViewer.getRenderer()) != null) {
            this.originalDef = otherRenderer.getInitialRndSettings();
        }
    }

    void reloadRenderingThumbs() {
        this.metadataViewer.loadViewedBy();
    }

    ImViewerModel(SecurityContext ctx, long imageID, Rectangle bounds, boolean separateWindow) {
        this.ctx = ctx;
        this.imageID = imageID;
        this.initialize(bounds, separateWindow);
    }

    ImageData getImage() {
        if (this.image instanceof WellSampleData) {
            return ((WellSampleData)this.image).getImage();
        }
        return (ImageData)this.image;
    }

    ImViewerModel(SecurityContext ctx, DataObject image, Rectangle bounds, boolean separateWindow) {
        this.image = image;
        this.ctx = ctx;
        this.initialize(bounds, separateWindow);
        this.numberOfRows = 1;
        this.numberOfColumns = 1;
        if (this.getImage().getDefaultPixels() != null) {
            this.currentPixelsID = this.getImage().getDefaultPixels().getId();
        }
    }

    void initialize(ImViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, ImViewerFactory.getPreferences());
        this.selectedRndDefID = -1L;
    }

    boolean isRendererLoaded() {
        return this.metadataViewer.getRenderer() != null;
    }

    public UnitsLength getScaleBarUnit() {
        if (this.scaleBarUnit == null) {
            if (this.getPixelsSizeX() == null) {
                return UnitsLength.MICROMETER;
            }
            LengthI tmp = new LengthI(this.getPixelsSizeX().getValue() * 100.0, this.getPixelsSizeX().getUnit());
            tmp = UIUtilities.transformSize((Length)tmp);
            this.scaleBarUnit = tmp.getUnit();
        }
        return this.scaleBarUnit;
    }

    public void setScaleBarUnit(UnitsLength unit) {
        this.scaleBarUnit = unit;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)ImViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setAlternativeSettings(RndProxyDef alternativeSettings, long userID) {
        this.alternativeSettings = alternativeSettings;
        this.selectedUserID = userID;
    }

    long getAlternativeSettingsOwnerId() {
        return this.selectedUserID;
    }

    boolean isSameDisplay(ImViewerModel other) {
        return other != null;
    }

    boolean isSameParent(DataObject data) {
        if (data != null && this.parent != null) {
            if (this.parent instanceof WellData) {
                if (this.grandParent != null && data.getClass().getName().equals(this.grandParent.getClass().getName())) {
                    return data.getId() == this.grandParent.getId();
                }
            } else if (data.getClass().getName().equals(this.parent.getClass().getName())) {
                return data.getId() == this.parent.getId();
            }
        }
        return false;
    }

    String getImageName() {
        if (this.image == null) {
            return "";
        }
        return this.getImage().getName();
    }

    String getImageTitle() {
        GroupData group = this.getSelectedGroup();
        StringBuffer buffer = new StringBuffer();
        if (group != null) {
            buffer.append("Group: ");
            buffer.append(group.getName());
        }
        buffer.append(" [ID: " + this.getImageID() + "] ");
        buffer.append(EditorUtil.getPartialName(this.getImageName()));
        return buffer.toString();
    }

    int getState() {
        return this.state;
    }

    void cancelBirdEyeView() {
        this.state = 19;
        DataLoader loader = this.loaders.get(2);
        if (loader != null) {
            loader.cancel();
            this.loaders.remove(2);
        }
        this.discard();
    }

    void discard() {
        this.state = 7;
        this.imageIcon = null;
        this.browser.discard();
        if (this.image == null) {
            return;
        }
        this.resetTiles();
        Iterator<Integer> i = this.loaders.keySet().iterator();
        while (i.hasNext()) {
            this.loaders.get(i.next()).cancel();
        }
        this.browser.discard();
        if (this.metadataViewer != null && this.metadataViewer.getRenderer() != null) {
            this.metadataViewer.getRenderer().discard();
        }
        if (this.player == null) {
            return;
        }
        this.player.setPlayerState(1);
        this.player = null;
    }

    int getMaxX() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsX();
    }

    int getMaxY() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsY();
    }

    int getMaxZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsZ() - 1;
    }

    int getMaxT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsT();
    }

    int getDefaultZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getDefaultZ();
    }

    int getDefaultT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getDefaultT();
    }

    int getRealSelectedT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getRealSelectedT();
    }

    int getRealT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getRealT();
    }

    String getColorModel() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return "greyscale";
        }
        return rnd.getColorModel();
    }

    List<ChannelData> getChannelData() {
        if (this.channels != null) {
            return this.channels;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new ArrayList<ChannelData>();
        }
        this.channels = rnd.getChannelData();
        return this.channels;
    }

    void setChannels(List<ChannelData> channels) {
        this.channels = channels;
        if (this.metadataViewer != null) {
            this.metadataViewer.onUpdatedChannels(channels);
        }
    }

    ChannelData getChannelData(int index) {
        List<ChannelData> list = this.getChannelData();
        for (ChannelData channel : list) {
            if (channel.getIndex() != index) continue;
            return channel;
        }
        return null;
    }

    Color getChannelColor(int w) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getChannelColor(w);
    }

    String getLookupTable(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getLookupTable(index);
    }

    boolean getReverseIntensity(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.getReverseIntensity(index);
    }

    boolean isChannelActive(int w) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isChannelActive(w);
    }

    void firePlaneInfoRetrieval() {
        if (this.planeInfos != null && this.planeInfos.size() > 0) {
            return;
        }
        int size = this.getMaxT() * this.getMaxC() * this.getMaxZ();
        if (size > 6000) {
            return;
        }
        PlaneInfoLoader loader = new PlaneInfoLoader(this.component, this.ctx, this.getPixelsID());
        loader.load();
    }

    void fireImageRetrieval(int compression) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        PlaneDef pDef = this.createPlaneDef();
        this.state = 3;
        if (this.firstTime) {
            this.browser.setUnitBar(true);
            long pixelsID = this.getImage().getDefaultPixels().getId();
            ImageLoader loader = new ImageLoader(this.component, this.ctx, pixelsID, pDef, false, compression);
            loader.load();
            this.loaders.put(1, loader);
        } else {
            this.component.setImage(rnd.renderPlane(pDef, compression));
        }
    }

    boolean isFirstTime() {
        return this.firstTime;
    }

    BufferedImage getSplitComponentImage() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        return rnd.renderPlane(pDef);
    }

    void onRndLoaded() {
        double f;
        this.state = 6;
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null && this.isBigImage()) {
            this.resolutions = rnd.getResolutionDescriptions();
            this.setSelectedResolutionLevel(this.getDefaultResolutionLevel());
        }
        if ((f = this.initZoomFactor()) > 0.0) {
            this.browser.initializeMagnificationFactor(f);
        }
        try {
            if (this.alternativeSettings != null && rnd != null) {
                rnd.resetSettings(this.alternativeSettings, false);
            }
            this.alternativeSettings = null;
            if (rnd != null && this.originalDef == null) {
                this.originalDef = rnd.getRndSettingsCopy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Browser getBrowser() {
        return this.browser;
    }

    MetadataViewer getMetadataViewer() {
        return this.metadataViewer;
    }

    void setZoomFactor(double factor, boolean reset) {
        this.browser.setZoomFactor(factor, reset);
    }

    double getZoomFactor() {
        return this.browser.getZoomFactor();
    }

    boolean isZoomFitToWindow() {
        return this.getZoomFactor() == -1.0;
    }

    double setImage(BufferedImage image) {
        this.state = 6;
        if (image != null) {
            this.browser.setRenderedImage(image);
        }
        this.loaders.remove(1);
        this.firstTime = false;
        if (image == null) {
            return 1.0;
        }
        return this.initZoomFactor();
    }

    void createImageIcon() {
        BufferedImage img = this.browser.getRenderedImage();
        if (img != null) {
            this.computeSizes();
            this.imageIcon = Factory.magnifyImage(this.factor, img);
        }
    }

    boolean isInitMagnificationFactor() {
        return this.initMagnificationFactor;
    }

    void setColorModel(String colorModel, boolean update) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        if ("greyscale".equals(colorModel)) {
            rnd.setOverlays(this.overlayTableID, null);
            rnd.setColorModel(colorModel, update);
        } else if ("rgb".equals(colorModel)) {
            rnd.setColorModel("rgb", update);
        }
    }

    void setSelectedXYPlane(int z, int t, int bin) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setSelectedXYPlane(z, t, bin);
    }

    void setChannelColor(int index, Color c) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setChannelColor(index, c, false);
    }

    void setLookupTable(int index, String lut) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setLookupTable(index, lut, false);
    }

    void setReverseIntensity(int index, boolean revInt) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setReverseIntensity(index, revInt, false);
    }

    void setChannelActive(int index, boolean active) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setActive(index, active);
    }

    int getMaxLifetimeBin() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getMaxLifetimeBin();
    }

    boolean isLifetimeImage() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isLifetimeImage();
    }

    boolean allowSplitView() {
        if (this.isBigImage()) {
            return false;
        }
        if (this.getMaxC() <= 1) {
            return false;
        }
        if (this.getModuloT() != null) {
            return true;
        }
        return !this.isLifetimeImage();
    }

    boolean isBigImage() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isBigImage();
    }

    public boolean isExportable() {
        if (this.getPixelsData() == null) {
            return false;
        }
        long imgSize = (long)((double)this.getPixelsData().getSizeX() * this.getZoomFactor()) * (long)((double)this.getPixelsData().getSizeY() * this.getZoomFactor());
        long maxSize = DEFAULT_MAX_EXPORT_SIZE;
        String tmp = (String)ImViewerAgent.getRegistry().lookup("omero.client.download_as.max_size");
        if (tmp != null) {
            try {
                maxSize = Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                ImViewerAgent.getRegistry().getLogger().warn((Object)this, "Non integer value provided for omero.client.download_as.max_size");
            }
        }
        return imgSize <= maxSize;
    }

    boolean isLargePlane() {
        return this.getMaxX() * this.getMaxY() > this.planeSize;
    }

    int getMaxC() {
        return this.getImage().getDefaultPixels().getSizeC();
    }

    int getActiveChannelsCount() {
        return this.getActiveChannels().size();
    }

    List<Integer> getActiveChannels() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new ArrayList<Integer>();
        }
        return rnd.getActiveChannels();
    }

    void playMovie(boolean play) {
        if (this.player != null && !play) {
            this.player.setPlayerState(1);
            List l = this.player.getChannels();
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    this.setChannelActive((Integer)i.next(), true);
                }
            }
            this.player = null;
            if (this.state != 3) {
                this.state = 6;
            }
            this.playingChannelMovie = false;
            return;
        }
        this.playingChannelMovie = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImViewerModel.this.player = new ChannelPlayer(ImViewerModel.this.component);
                ImViewerModel.this.player.setPlayerState(0);
            }
        });
        this.state = 8;
    }

    boolean isPlayingChannelMovie() {
        return this.playingChannelMovie;
    }

    void setState(int state) {
        this.state = state;
    }

    BufferedImage getDisplayedImage() {
        return this.browser.getDisplayedImage();
    }

    BufferedImage getOriginalImage() {
        return this.browser.getRenderedImage();
    }

    BufferedImage getProjectedImage() {
        return this.browser.getProjectedImage();
    }

    BufferedImage getGridImage() {
        return this.browser.getGridImage();
    }

    Length getPixelsSizeX() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return rnd.getPixelsSizeX();
    }

    Length getPixelsSizeY() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return rnd.getPixelsSizeY();
    }

    Length getPixelsSizeZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return rnd.getPixelsSizeZ();
    }

    boolean isUnitBar() {
        return this.browser.isUnitBar();
    }

    BufferedImage getImageIcon() {
        return this.imageIcon;
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    long getPixelsID() {
        return this.currentPixelsID;
    }

    int getTabbedIndex() {
        return this.tabbedIndex;
    }

    void setTabbedIndex(int index) {
        this.tabbedIndex = index;
    }

    boolean[] hasRGB() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.hasRGB();
    }

    boolean isTextVisible() {
        return this.textVisible;
    }

    void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    boolean isImageLoaded() {
        return this.image != null;
    }

    long getImageID() {
        if (this.image == null) {
            return this.imageID;
        }
        return this.getImage().getId();
    }

    void saveRndSettings(boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef def = rnd.saveCurrentSettings();
        if (reset) {
            this.originalDef = def;
            if (def != null && this.renderingSettings != null) {
                this.renderingSettings.put(ImViewerAgent.getUserDetails(), def);
            }
        }
    }

    void setPlayingMovie(boolean play, int index) {
        this.playingMovie = play;
        this.movieIndex = index;
    }

    boolean isPlayingMovie() {
        return this.playingMovie;
    }

    boolean isColorComponent(int band, int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isColorComponent(band, index);
    }

    Map<Integer, Color> getActiveChannelsColorMap() {
        List<Integer> l = this.getActiveChannels();
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(l.size());
        for (Integer index : l) {
            m.put(index, this.getChannelColor(index));
        }
        return m;
    }

    Map<Integer, Color> getChannelsColorMap() {
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(this.getMaxC());
        for (int i = 0; i < this.getMaxC(); ++i) {
            m.put(i, this.getChannelColor(i));
        }
        return m;
    }

    void setLastSettingsRef(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        switch (index) {
            case 1: 
            case 2: {
                this.lastMainDef = rnd.getRndSettingsCopy();
                break;
            }
        }
    }

    HistoryItem createHistoryItem() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        String title = null;
        BufferedImage img = null;
        Color c = null;
        RndProxyDef def = rnd.getRndSettingsCopy();
        switch (this.getTabbedIndex()) {
            case 2: {
                title = "Projection";
                img = this.browser.getProjectedImage();
                this.lastProjDef = def;
                c = Color.GREEN.brighter();
                break;
            }
            case 0: {
                title = "Image";
                img = this.browser.getRenderedImage();
                this.lastMainDef = def;
            }
        }
        if (img == null) {
            return null;
        }
        double ratio = 1.0;
        int w = img.getWidth();
        int h = img.getHeight();
        ratio = w < 96 || h < 96 ? 1.0 : (w >= h ? 96.0 / (double)w : 96.0 / (double)h);
        BufferedImage thumb = Factory.magnifyImage(ratio, img);
        HistoryItem i = new HistoryItem(def, thumb, title);
        i.setHighlight(c);
        i.allowClose(false);
        i.setIndex(this.getTabbedIndex());
        if (this.historyItems == null) {
            this.historyItems = new ArrayList<HistoryItem>();
        }
        if (this.historyItems.size() == 10) {
            this.historyItems.remove(1);
        }
        this.historyItems.add(i);
        return i;
    }

    RndProxyDef getOriginalDef() {
        return this.originalDef;
    }

    RndProxyDef getLastMainDef() {
        return this.lastMainDef;
    }

    RndProxyDef getLastProjDef() {
        return this.lastProjDef;
    }

    void removeHistoryItem(HistoryItem node) {
        if (this.historyItems != null) {
            this.historyItems.remove(node);
        }
    }

    void clearHistory() {
        if (this.historyItems == null || this.historyItems.size() == 0) {
            return;
        }
        HistoryItem node = this.historyItems.get(0);
        this.historyItems.clear();
        this.historyItems.add(node);
        this.lastMainDef = node.getRndSettings();
        this.lastProjDef = null;
        this.lastProjTime = -1;
    }

    List<HistoryItem> getHistory() {
        return this.historyItems;
    }

    void resetMappingSettings(RndProxyDef settings) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.resetSettings(settings, true);
    }

    void setLastRndDef(RndProxyDef settings) {
        switch (this.getTabbedIndex()) {
            case 2: {
                break;
            }
            case 0: {
                this.lastMainDef = settings;
            }
        }
    }

    void resetOriginalSettings(RndProxyDef settings) {
        this.originalDef = settings;
        if (settings != null && this.renderingSettings != null) {
            this.renderingSettings.put(ImViewerAgent.getUserDetails(), settings);
        }
    }

    void fireLoadRndSettingsToPaste() {
        this.state = 14;
        if (ImViewerFactory.getRefSettings() == null) {
            RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.ctx, ImViewerFactory.getRefImage().getDefaultPixels().getId(), true);
            loader.load();
        } else {
            this.component.setSettingsToPaste(ImViewerFactory.getRefSettings());
        }
    }

    void resetDefaultRndSettings() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.resetSettings();
    }

    void setOriginalRndSettings() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setOriginalRndSettings();
    }

    boolean hasRndToPaste() {
        if (this.metadataViewer == null) {
            return false;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        ImageData image = ImViewerFactory.getRefImage();
        if (image == null) {
            return false;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return false;
        }
        return rnd.validatePixels(pixels);
    }

    void copyRenderingSettings() {
        RndProxyDef rndDef = null;
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null && rnd.isModified()) {
            rndDef = rnd.getRndSettingsCopy();
        }
        CopyRndSettings evt = new CopyRndSettings(this.getImage(), rndDef);
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    int getMovieIndex() {
        return this.movieIndex;
    }

    boolean isImageCompressed() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isCompressed();
    }

    void setCompressionLevel(int compressionLevel) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setCompression(compressionLevel);
    }

    int getCompressionLevel() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getCompressionLevel();
    }

    public Collection<String> getAvailableLookupTables() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getRenderingControls().get(0).getAvailableLookupTables();
    }

    void fireRenderingSettingsRetrieval() {
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.ctx, this.getImage().getDefaultPixels().getId());
        ((DataLoader)loader).load();
        if (this.loaders.get(0) != null) {
            this.loaders.get(0).cancel();
        }
        this.loaders.put(0, loader);
    }

    void fireOwnerSettingsRetrieval() {
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.ctx, this.getImage().getDefaultPixels().getId());
        loader.setOwner(this.getOwnerID());
        loader.load();
        if (this.loaders.get(0) != null) {
            this.loaders.get(0).cancel();
        }
        this.loaders.put(0, loader);
    }

    Map getRenderingSettings() {
        return this.renderingSettings;
    }

    void setRenderingSettings(Map map) {
        this.renderingSettings = map;
        this.loaders.remove(0);
    }

    void setUserSettings(ExperimenterData exp) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef rndDef = (RndProxyDef)this.renderingSettings.get(exp);
        rnd.resetSettings(rndDef, false);
    }

    long getOwnerID() {
        return this.image.getOwner().getId();
    }

    boolean hasMetadataToSave() {
        if (this.metadataViewer == null) {
            return false;
        }
        return this.metadataViewer.hasDataToSave();
    }

    void saveMetadata() {
        if (this.metadataViewer != null) {
            this.metadataViewer.saveData();
        }
    }

    void loadMetadata() {
        if (!this.metadataLoaded) {
            this.metadataLoaded = true;
            LinkedHashMap<ChannelData, Object> m = new LinkedHashMap<ChannelData, Object>();
            List<ChannelData> sorted = this.getChannelData();
            for (ChannelData channel : sorted) {
                if (CommonsLangUtils.isNotEmpty(this.getLookupTable(channel.getIndex()))) {
                    m.put(channel, this.getLookupTable(channel.getIndex()));
                    continue;
                }
                m.put(channel, this.getChannelColor(channel.getIndex()));
            }
            this.metadataViewer.activate(m);
        }
    }

    void resetHistory() {
        this.historyItems = null;
    }

    void fireRenderProjected(int startZ, int endZ, int stepping, int type) {
        this.state = 12;
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type);
        param.setChannels(this.getActiveChannels());
        this.lastProjRef = param;
        this.lastProjDef = this.metadataViewer.getRenderer().getRndSettingsCopy();
        ProjectionSaver loader = new ProjectionSaver(this.component, this.ctx, param, 0);
        loader.load();
    }

    void fireImageProjection(int startZ, int endZ, int stepping, int type, String typeName, ProjectionRef ref) {
        if (startZ < 0) {
            startZ = ref.getStartZ();
        }
        if (endZ < startZ) {
            endZ = ref.getEndZ();
        }
        this.state = 13;
        StringBuffer buf = new StringBuffer();
        buf.append("Original Image: " + this.getImageName());
        buf.append("\n");
        buf.append("Original Image ID: " + this.getImageID());
        buf.append("\n");
        buf.append("Projection type: " + typeName);
        buf.append("\n");
        buf.append("z-sections: " + (startZ + 1) + "-" + (endZ + 1));
        buf.append("\n");
        String imageNameWithRange = this.combineFilenameWith(ref.getImageName(), this.getImageName());
        int startT = ref.getStartT();
        int endT = ref.getEndT();
        if (startT == endT) {
            buf.append("timepoint: " + (startT + 1));
        } else {
            buf.append("timepoints: " + (startT + 1) + "-" + (endT + 1));
        }
        List<Integer> channels = ref.getChannels();
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type, startT, endT, channels, imageNameWithRange);
        param.setDescription(buf.toString());
        param.setDatasets(ref.getDatasets());
        param.setDatasetParent((DataObject)ref.getProject());
        param.setChannels(this.getActiveChannels());
        ProjectionSaver loader = new ProjectionSaver(this.component, this.ctx, param, 1, ref.isApplySettings());
        loader.load();
    }

    private String combineFilenameWith(String projectName, String imageName) {
        String extension = FilenameUtils.getExtension((String)imageName);
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(projectName);
        nameBuilder.append(".");
        nameBuilder.append(extension);
        return nameBuilder.toString();
    }

    void fireContainersLoading() {
        this.state = 11;
        ContainerLoader loader = new ContainerLoader(this.component, this.ctx, this.getImageID());
        loader.load();
    }

    String getPixelsType() {
        return this.getImage().getDefaultPixels().getPixelType();
    }

    void fireProjectedRndSettingsCreation(List<Integer> indexes, ImageData image) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef def = rnd.getRndSettingsCopy();
        RenderingSettingsCreator l = new RenderingSettingsCreator(this.component, this.ctx, image, def, indexes);
        l.load();
    }

    void setContext(DataObject parent, DataObject grandParent) {
        this.parent = parent;
        this.grandParent = grandParent;
        if (this.metadataViewer != null) {
            this.metadataViewer.setParentRootObject(parent, grandParent);
        }
        if (this.isHCSImage()) {
            this.fireMeasurementsLoading();
        }
    }

    DataObject getParent() {
        return this.parent;
    }

    DataObject getGrandParent() {
        return this.grandParent;
    }

    void setPlaneInfo(Collection objects) {
        if (this.planeInfos == null) {
            this.planeInfos = new HashMap<Integer, PlaneInfo>();
        } else {
            this.planeInfos.clear();
        }
        for (PlaneInfo object : objects) {
            Integer index;
            if (object == null || (index = this.linearize(object.getTheZ().getValue(), object.getTheC().getValue(), object.getTheT().getValue())) < 0) continue;
            this.planeInfos.put(index, object);
        }
    }

    PlaneInfo getPlane(int z, int c, int t) {
        Integer index = null;
        try {
            index = this.linearize(z, c, t);
            if (index < 0) {
                return null;
            }
            return this.planeInfos.get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    void fireImageLoading() {
        this.state = 10;
        ImageDataLoader loader = new ImageDataLoader(this.component, this.ctx, this.getImageID());
        loader.load();
    }

    void setImageData(ImageData image) {
        this.state = 17;
        this.image = image;
        this.initializeMetadataViewer();
        this.currentPixelsID = image.getDefaultPixels().getId();
        if (this.metadataViewer != null) {
            this.metadataViewer.setParentRootObject(this.parent, this.grandParent);
        }
    }

    boolean isOriginalSettings(boolean checkPlane) {
        if (this.originalDef == null) {
            return true;
        }
        if (this.metadataViewer == null) {
            return true;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return true;
        }
        return this.isSameSettings(this.originalDef, checkPlane);
    }

    boolean isOriginalPlane() {
        if (this.originalDef != null) {
            if (this.originalDef.getDefaultZ() != this.getDefaultZ()) {
                return false;
            }
            if (this.originalDef.getDefaultT() != this.getDefaultT()) {
                return false;
            }
        }
        return true;
    }

    boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        if (this.metadataViewer == null) {
            return false;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isSameSettings(def, checkPlane);
    }

    void setRenderProjected(Object image) {
        this.state = 6;
        this.browser.setRenderProjected(image);
    }

    void setContainers(Collection containers) {
        this.containers = containers;
        this.state = 6;
    }

    Collection getContainers() {
        return this.containers;
    }

    PixelsData getPixelsData() {
        if (this.image == null) {
            return null;
        }
        return this.getImage().getDefaultPixels();
    }

    ProjectionParam getLastProjRef() {
        return this.lastProjRef;
    }

    void setLastProjectionRef(ProjectionParam ref) {
        this.lastProjRef = ref;
    }

    int getLastProjectionTime() {
        return this.lastProjTime;
    }

    void setLastProjectionTime(int time) {
        this.lastProjTime = time;
    }

    double getUnitInRefUnits() {
        return this.browser.getUnitInRefUnits();
    }

    void loadAllContainers() {
        ContainerLoader loader = new ContainerLoader(this.component, this.ctx);
        loader.load();
    }

    void makeMovie() {
        if (this.metadataViewer == null) {
            return;
        }
        this.metadataViewer.makeMovie((int)this.getUnitInRefUnits(), this.getBrowser().getUnitBarColor());
    }

    int getSelectedBin() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1;
        }
        return rnd.getSelectedBin();
    }

    void setSelectedChannel(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setSelectedChannel(index);
    }

    boolean isSeparateWindow() {
        return this.separateWindow;
    }

    void setSeparateWindow(boolean separateWindow) {
        this.separateWindow = separateWindow;
    }

    void fireMeasurementsLoading() {
        if (this.parent instanceof WellData) {
            ImageData p = this.getImage();
            MeasurementsLoader loader = new MeasurementsLoader(this.component, this.ctx, (DataObject)p);
            loader.load();
        }
    }

    void setMeasurements(Collection result) {
        this.measurements = result;
    }

    Collection getMeasurements() {
        return this.measurements;
    }

    void activityOptions(Component source, Point location) {
        if (this.metadataViewer == null) {
            return;
        }
        this.metadataViewer.activityOptions(source, location, 100);
    }

    boolean isMappedImageRGB(List channels) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isMappedImageRGB(channels);
    }

    Map<Integer, Integer> getOverLays() {
        Iterator i = this.measurements.iterator();
        TableResult table = null;
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof TableResult)) continue;
            table = (TableResult)object;
            this.overlayTableID = table.getTableID();
            break;
        }
        if (table == null) {
            return null;
        }
        Object[][] data = table.getData();
        LinkedHashMap<Integer, Integer> overlays = new LinkedHashMap<Integer, Integer>();
        int index = 0;
        Color c = null;
        Long value = -1L;
        for (int j = 0; j < data.length; ++j) {
            value = (Long)data[j][2];
            if (value != null) {
                overlays.put((Integer)data[j][0], value.intValue());
            } else {
                if (index == 0) {
                    c = Color.red;
                } else if (index == 1) {
                    c = Color.green;
                } else if (index == 2) {
                    c = Color.blue;
                }
                overlays.put((Integer)data[j][0], UIUtilities.convertColor(c));
            }
            if (++index % 3 != 0) continue;
            index = 0;
        }
        return overlays;
    }

    void renderOverlays(Map<Long, Integer> overlays) {
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        this.state = 3;
        OverlaysRenderer loader = new OverlaysRenderer(this.component, this.ctx, this.getPixelsID(), pDef, this.overlayTableID, overlays);
        loader.load();
    }

    double getOriginalRatio() {
        return this.originalRatio;
    }

    void refresh() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null) {
            rnd.refresh();
        }
    }

    boolean isWritable() {
        boolean b = this.isUserOwner();
        if (b) {
            return b;
        }
        GroupData g = ImViewerAgent.getUserDetails().getDefaultGroup();
        switch (g.getPermissions().getPermissionsLevel()) {
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    boolean isUserOwner() {
        long userID = ImViewerAgent.getUserDetails().getId();
        return EditorUtil.isUserOwner(this.getImage(), userID);
    }

    void setRangeAllChannels(boolean absolute) {
        this.metadataViewer.getRenderer().setRangeAllChannels(absolute);
    }

    boolean isHCSImage() {
        return this.image instanceof WellSampleData;
    }

    void fireBirdEyeViewRetrieval(boolean scale) {
        BirdEyeLoader loader;
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        if (!ImViewerAgent.canCreate() && this.state == 18) {
            return;
        }
        int w = this.tiledImageSizeX;
        int h = this.tiledImageSizeY;
        if (scale) {
            double ratio = 1.0;
            int ref = 128;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (screen.height > 1200 && screen.height <= 1600) {
                ref = 196;
            } else if (screen.height > 1600) {
                ref = 256;
            }
            ratio = w < ref || h < ref ? 1.0 : (w >= h ? (double)ref / (double)w : (double)ref / (double)h);
            ratio = (double)ref / 96.0;
            this.state = 18;
            loader = new BirdEyeLoader(this.component, this.ctx, this.getImage(), ratio);
        } else {
            int imgSize = 128;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (screen.height > 1200 && screen.height <= 1600) {
                imgSize = 196;
            } else if (screen.height > 1600) {
                imgSize = 256;
            }
            loader = new BirdEyeLoader(this.component, this.ctx, this.getImage(), imgSize);
        }
        loader.load();
        this.loaders.put(2, loader);
    }

    Dimension getTileSize() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        ResolutionLevel r = this.getResolutionDescription();
        if (r == null) {
            return rnd.getTileSize();
        }
        return r.getTileSize();
    }

    ResolutionLevel getResolutionDescription() {
        return this.getResolutionDescription(this.getSelectedResolutionLevel());
    }

    double getNominalMagnification() {
        if (this.component.getImageAcquisitionData() != null) {
            ObjectiveData objective = this.component.getImageAcquisitionData().getObjective();
            return objective != null ? objective.getNominalMagnification() : -1.0;
        }
        this.fireImagAcquisitionDataLoading();
        return -1.0;
    }

    void fireImagAcquisitionDataLoading() {
        if (this.component.getImageAcquisitionData() == null) {
            AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, this.ctx, this.image);
            loader.load();
        }
    }

    ResolutionLevel getResolutionDescription(int index) {
        if (this.resolutions == null) {
            return null;
        }
        for (ResolutionLevel level : this.resolutions) {
            if (index != level.getLevel()) continue;
            return level;
        }
        return null;
    }

    int getRows() {
        return this.numberOfRows;
    }

    int getColumns() {
        return this.numberOfColumns;
    }

    Map<Integer, Tile> getTiles() {
        return this.tiles;
    }

    void fireTileLoading(List<Tile> selection) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null || selection == null) {
            return;
        }
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        List<Tile> list = selection;
        this.sortTilesByIndex(list);
        this.state = 15;
        List<RenderingControl> proxies = rnd.getRenderingControls();
        int m = proxies.size();
        int n = selection.size();
        int diff = n / m;
        int step = 0;
        if (n < m) {
            diff = 1;
        }
        this.tileTotalCount = n;
        this.tileLoadedCount = 0;
        for (int i = 0; i < m; ++i) {
            List<Object> l = new ArrayList();
            int j = step + diff;
            if (i == m - 1) {
                j += n - j;
            }
            if (j <= n) {
                l = list.subList(step, j);
                step += l.size();
            }
            if (l.size() <= 0) continue;
            RenderingControl proxy = proxies.get(i);
            TileLoader loader = new TileLoader(this.component, this.ctx, this.currentPixelsID, pDef, proxy, l);
            loader.load();
        }
    }

    void resetTiles() {
        if (this.tiles == null) {
            return;
        }
        Iterator<Tile> i = this.tiles.values().iterator();
        while (i.hasNext()) {
            i.next().setImage(null);
        }
    }

    int getResolutionLevels() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 1;
        }
        return rnd.getResolutionLevels();
    }

    int getSelectedResolutionLevel() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getSelectedResolutionLevel();
    }

    void setSelectedResolutionLevel(int level) {
        Renderer rnd;
        if (level < 0) {
            level = 0;
        }
        if (level >= this.getResolutionLevels()) {
            level = this.getResolutionLevels() - 1;
        }
        if ((rnd = this.metadataViewer.getRenderer()) == null) {
            return;
        }
        this.clearTileImages(this.tiles.values());
        this.tiles.clear();
        rnd.setSelectedResolutionLevel(level);
        this.initializeTiles();
        this.browser.setSelectedResolutionLevelZoomFactor(this.getResolutionDescription().getRatio());
    }

    int getTiledImageSizeX() {
        if (!this.isBigImage()) {
            return this.getMaxX();
        }
        return this.tiledImageSizeX;
    }

    int getTiledImageSizeY() {
        if (!this.isBigImage()) {
            return this.getMaxY();
        }
        return this.tiledImageSizeY;
    }

    void clearTileImages(Collection<Tile> toClear) {
        if (toClear == null || toClear.size() == 0) {
            return;
        }
        for (Tile tile : toClear) {
            Object image = tile.getImage();
            if (image == null || !(image instanceof BufferedImage)) continue;
            BufferedImage bi = (BufferedImage)image;
            bi.getGraphics().dispose();
            bi.flush();
            tile.setImage(null);
        }
    }

    void cancelRendering() {
        if (this.metadataViewer == null) {
            return;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null) {
            rnd.discard();
        }
        this.state = 19;
    }

    void setBirdEyeView(BufferedImage image, boolean scaled) {
        this.loaders.remove(2);
        this.getBrowser().setBirdEyeView(image);
    }

    boolean isSame(long pixelsID, SecurityContext ctx) {
        return this.getPixelsID() == pixelsID;
    }

    boolean isSameImage(long imageID, SecurityContext ctx) {
        return this.getImageID() == imageID;
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    GroupData getSelectedGroup() {
        Collection set = (Collection)ImViewerAgent.getRegistry().lookup("/userGroup/details");
        if (set == null || set.size() <= 1) {
            return null;
        }
        for (GroupData g : set) {
            if (g.getId() != this.ctx.getGroupID()) continue;
            return g;
        }
        return null;
    }

    UnitsLength getRefUnit() {
        if (this.refUnit != null) {
            return this.refUnit;
        }
        Length tmp = UIUtilities.transformSize(this.getPixelsSizeX());
        this.refUnit = tmp.getUnit();
        return this.refUnit;
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    void setDisplayMode(int value) {
        if (value < 0) {
            this.checkDefaultDisplayMode();
            return;
        }
        switch (value) {
            case 0: 
            case 1: {
                this.displayMode = value;
                break;
            }
            default: {
                this.displayMode = 1;
            }
        }
        if (this.containers != null) {
            this.containers.clear();
            this.containers = null;
        }
    }

    boolean isTileLoaded(int count) {
        this.tileLoadedCount += count;
        return this.tileLoadedCount == this.tileTotalCount;
    }

    ModuloInfo getModuloT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getModuloT();
    }

    boolean isInterpolation() {
        return this.browser.isInterpolation();
    }

    void setInterpolation(boolean interpolation) {
        this.browser.setInterpolation(interpolation);
    }

    void setSelectedRndDef(long defID) {
        this.selectedRndDefID = defID;
    }

    public void reloadROICount() {
        this.metadataViewer.reloadROICount();
    }
}

