/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.proj;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ProjectData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.util.ComboBoxToolTipRenderer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.DataNode;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.CreateFolderDialog;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;

public class ProjSavingDialog
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String PROJECTION_PROPERTY = "projection";
    public static final String LOAD_ALL_PROPERTY = "loadAll";
    private static final String PROJECT_TXT = "Project";
    private static final String DATASET_TXT = "Dataset";
    private static final String TITLE = "Projection";
    private static final String DEFAULT_EXTENSION = "_proj";
    private static final int CLOSE = 0;
    private static final int PROJECT = 1;
    private static final int NEWFOLDER = 2;
    private static final int OTHER = 3;
    private JTextField nameField;
    private JButton closeButton;
    private JButton projectButton;
    private JButton newFolderButton;
    private JPanel selectionPane;
    private TextualTwoKnobsSlider timeSelection;
    private TextualTwoKnobsSlider zrangeSelection;
    private JComboBox pixelsType;
    private JCheckBox rndSettingsBox;
    private int maxT;
    private int algorithm;
    private ViewerSorter sorter;
    private JComboBox datasetsBox;
    private JComboBox parentsBox;
    private ItemListener parentsBoxListener;
    private ItemListener datasetsBoxListener;
    private DataObject selectedContainer;
    private DataObject selectedGrandParentContainer;
    private DatasetData selectedDataset;

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void populateDatasetsBox(DataNode newDataset) {
        DataNode n = (DataNode)this.parentsBox.getSelectedItem();
        List<DataNode> list = n.getUIDatasetNodes();
        ArrayList<DataNode> l = new ArrayList<DataNode>();
        if (newDataset != null) {
            l.add(newDataset);
        }
        l.addAll(this.sorter.sort(list));
        this.datasetsBox.setVisible(l.size() > 0);
        this.datasetsBox.removeItemListener(this.datasetsBoxListener);
        this.datasetsBox.removeAllItems();
        this.populateAndAddTooltipsToComboBox(l, this.datasetsBox);
        if (this.selectedContainer != null && this.selectedContainer instanceof DatasetData) {
            DatasetData d = (DatasetData)this.selectedContainer;
            Iterator i = l.iterator();
            boolean set = false;
            while (i.hasNext()) {
                n = (DataNode)i.next();
                if (n.getDataObject().getId() == d.getId() && n.getDataObject().canLink()) {
                    this.datasetsBox.setSelectedItem(n);
                    this.selectedDataset = (DatasetData)n.getDataObject();
                    set = true;
                    break;
                }
                if (set) continue;
                this.datasetsBox.setSelectedItem(0);
                n = (DataNode)this.datasetsBox.getSelectedItem();
                this.selectedDataset = (DatasetData)n.getDataObject();
            }
        } else {
            this.datasetsBox.setSelectedItem(0);
        }
        this.datasetsBox.addItemListener(this.datasetsBoxListener);
    }

    private void initComponents(String imageName, String type, int maxZ, int startZ, int endZ) {
        this.parentsBox = new JComboBox();
        this.parentsBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DataNode node = (DataNode)ProjSavingDialog.this.parentsBox.getSelectedItem();
                    if (!node.isDefaultNode() && !node.getDataObject().canLink()) {
                        ProjSavingDialog.this.selectedContainer = null;
                        ProjSavingDialog.this.parentsBox.setSelectedIndex(0);
                    }
                    ProjSavingDialog.this.populateDatasetsBox(null);
                }
            }
        };
        this.parentsBox.removeItemListener(this.parentsBoxListener);
        this.datasetsBox = new JComboBox();
        this.datasetsBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataNode node;
                if (e.getStateChange() == 1 && (node = (DataNode)ProjSavingDialog.this.datasetsBox.getSelectedItem()) != null) {
                    if (!node.isDefaultNode() && !node.getDataObject().canLink()) {
                        ProjSavingDialog.this.datasetsBox.setSelectedIndex(0);
                        node = (DataNode)ProjSavingDialog.this.datasetsBox.getSelectedItem();
                        ProjSavingDialog.this.selectedDataset = (DatasetData)node.getDataObject();
                    } else {
                        ProjSavingDialog.this.selectedDataset = (DatasetData)node.getDataObject();
                    }
                }
            }
        };
        this.datasetsBox.removeItemListener(this.datasetsBoxListener);
        this.rndSettingsBox = new JCheckBox("Apply same rendering settings");
        this.rndSettingsBox.setToolTipText(UIUtilities.formatToolTipText("Apply the rendering settings to the projected image."));
        this.rndSettingsBox.setSelected(true);
        this.zrangeSelection = new TextualTwoKnobsSlider(1, maxZ, startZ, endZ);
        this.zrangeSelection.layoutComponents(1);
        this.timeSelection = new TextualTwoKnobsSlider(1, this.maxT, 1, this.maxT);
        this.timeSelection.layoutComponents(1);
        this.timeSelection.setEnabled(this.maxT > 1);
        Map<String, String> map = EditorUtil.PIXELS_TYPE_DESCRIPTION;
        String[] data = new String[map.size()];
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> i = set.iterator();
        int index = 0;
        int selectedIndex = 0;
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            String key = entry.getKey();
            data[index] = entry.getValue();
            if (key.equals(type)) {
                selectedIndex = index;
            }
            ++index;
        }
        this.pixelsType = new JComboBox<String>(data);
        this.pixelsType.setSelectedIndex(selectedIndex);
        this.pixelsType.setEnabled(this.algorithm == ProjectionParam.SUM_INTENSITY);
        this.selectionPane = new JPanel();
        this.selectionPane.setLayout(new BoxLayout(this.selectionPane, 1));
        this.closeButton = new JButton("Cancel");
        this.closeButton.setToolTipText(UIUtilities.formatToolTipText("Close the window."));
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
        this.projectButton = new JButton("Save");
        this.projectButton.setToolTipText(UIUtilities.formatToolTipText("Project the image."));
        this.projectButton.setActionCommand("1");
        this.projectButton.addActionListener(this);
        this.newFolderButton = new JButton("New Dataset...");
        this.newFolderButton.setToolTipText(UIUtilities.formatToolTipText("Create a new Dataset."));
        this.newFolderButton.setActionCommand("2");
        this.newFolderButton.addActionListener(this);
        this.nameField = new JTextField();
        StringBuffer buffer = new StringBuffer();
        buffer.append(UIUtilities.removeFileExtension(imageName));
        buffer.append(DEFAULT_EXTENSION);
        this.nameField.setText(buffer.toString());
        this.nameField.getDocument().addDocumentListener(this);
        this.getRootPane().setDefaultButton(this.projectButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjSavingDialog.this.close();
            }
        });
    }

    private JPanel buildParametersPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildRangePanel(this.zrangeSelection, "Z Range: "));
        p.add(this.buildRangePanel(this.timeSelection, "Timepoint: "));
        if (this.pixelsType != null) {
            p.add(new JSeparator());
            p.add(this.buildPixelsTypePanel());
        }
        JPanel r = UIUtilities.buildComponentPanel(p);
        r.setBorder(new TitledBorder(""));
        return r;
    }

    private JPanel buildRangePanel(JComponent comp, String text) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(text));
        p.add(UIUtilities.buildComponentPanel(comp));
        return p;
    }

    private JPanel buildPixelsTypePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Data Type: "));
        p.add(UIUtilities.buildComponentPanel(this.pixelsType));
        return p;
    }

    private JPanel buildControls() {
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder(""));
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.selectionPane);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.newFolderButton);
        return p;
    }

    private JPanel createRow() {
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0, 5, 0));
        row.setBorder(null);
        return row;
    }

    private void buildLocationPane() {
        this.selectionPane.removeAll();
        JPanel row = this.createRow();
        this.selectionPane.add(row);
        this.selectionPane.add(Box.createVerticalStrut(2));
        row = this.createRow();
        row.add(UIUtilities.setTextFont(PROJECT_TXT));
        row.add(this.parentsBox);
        this.selectionPane.add(row);
        this.selectionPane.add(Box.createVerticalStrut(8));
        row = this.createRow();
        row.add(UIUtilities.setTextFont(DATASET_TXT));
        row.add(this.datasetsBox);
        this.selectionPane.add(row);
    }

    private JPanel buildBody() {
        JPanel content = new JPanel();
        int height = 80;
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, -2.0, 5.0, -2.0, height, 5.0, -2.0, -1.0}};
        content.setLayout(new TableLayout(tl));
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.add((Component)UIUtilities.setTextFont("Name "), "0, 1, LEFT, CENTER");
        content.add((Component)this.nameField, "1, 1, FULL, CENTER");
        content.add((Component)new JLabel(), "0, 2, 1, 2");
        content.add((Component)UIUtilities.setTextFont("Save in "), "0, 3, LEFT, CENTER");
        content.add((Component)this.buildControls(), "1, 3, 1, 4");
        content.add((Component)new JLabel(), "0, 5, 1, 5");
        content.add((Component)UIUtilities.setTextFont("Parameters "), "0, 6, LEFT, CENTER");
        content.add((Component)this.buildParametersPanel(), "1, 6, 1, 7");
        return content;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.closeButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.projectButton);
        bar.add(Box.createHorizontalStrut(20));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, "Set the projection's parameters.", icons.getIcon(59));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(5, 5));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void createDataset(String name) {
        DatasetData d = new DatasetData();
        d.setName(name);
        this.selectedDataset = d;
        this.populateDatasetsBox(new DataNode((DataObject)d));
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void enableSave() {
        this.projectButton.setEnabled(CommonsLangUtils.isNotBlank(this.nameField.getText()));
    }

    private void project() {
        int startT = 0;
        int endT = 0;
        if (this.maxT > 0) {
            startT = (int)this.timeSelection.getStartValue() - 1;
            endT = (int)this.timeSelection.getEndValue() - 1;
        }
        ProjectionRef ref = new ProjectionRef();
        if (this.selectedDataset != null) {
            DataNode node;
            ref.setDatasets(Arrays.asList(this.selectedDataset));
            if (this.selectedDataset.getId() <= 0L && (node = (DataNode)this.parentsBox.getSelectedItem()) != null && !node.isDefaultNode()) {
                ref.setProject((ProjectData)node.getDataObject());
            }
        }
        ref.setImageName(this.nameField.getText());
        ref.setTInterval(startT, endT);
        double s = this.zrangeSelection.getStartValue();
        double e = this.zrangeSelection.getEndValue();
        ref.setZInterval((int)s - 1, (int)e - 1);
        ref.setApplySettings(this.rndSettingsBox.isSelected());
        this.firePropertyChange(PROJECTION_PROPERTY, null, ref);
        this.close();
    }

    public ProjSavingDialog(JFrame owner, DataObject selectedContainer, DataObject selectedGrandParentContainer) {
        super(owner);
        this.selectedContainer = selectedContainer;
        this.selectedGrandParentContainer = selectedGrandParentContainer;
        this.setProperties();
        this.sorter = new ViewerSorter();
    }

    public void initialize(int algorithm, int maxT, String pixelsType, String imageName, Collection containers, int maxZ, int startZ, int endZ) {
        this.maxT = maxT;
        this.algorithm = algorithm;
        this.initComponents(imageName, pixelsType, maxZ, startZ, endZ);
        this.buildGUI();
        this.setContainers(containers);
    }

    public void setProjectionInterval(int startZ, int endZ) {
        this.zrangeSelection.setInterval(startZ, endZ);
    }

    private void populateAndAddTooltipsToComboBox(List<DataNode> dataNodes, JComboBox comboBox) {
        ExperimenterData exp;
        ArrayList<String> tooltips = new ArrayList<String>(dataNodes.size());
        for (DataNode n : dataNodes) {
            exp = this.getExperimenter(n.getOwner());
            comboBox.addItem(n);
            ArrayList<String> lines = new ArrayList<String>();
            if (exp != null) {
                lines.add("<b>Owner: </b>" + EditorUtil.formatExperimenter(exp));
            }
            lines.addAll(UIUtilities.wrapStyleWord(n.getFullName()));
            tooltips.add(UIUtilities.formatToolTipText(lines));
        }
        exp = ImViewerAgent.getUserDetails();
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer(exp.getId());
        comboBox.setRenderer(renderer);
        renderer.setTooltips(tooltips);
    }

    private ExperimenterData getExperimenter(ExperimenterData owner) {
        if (owner == null) {
            return null;
        }
        if (owner.isLoaded()) {
            return owner;
        }
        List l = (List)ImViewerAgent.getRegistry().lookup("/users/details");
        if (l == null) {
            return null;
        }
        Iterator i = l.iterator();
        long id = owner.getId();
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            if (exp.getId() != id) continue;
            return exp;
        }
        return null;
    }

    public void setContainers(Collection containers) {
        DataNode n;
        if (CollectionUtils.isEmpty((Collection)containers)) {
            return;
        }
        this.parentsBox.removeItemListener(this.parentsBoxListener);
        this.parentsBox.removeAllItems();
        this.datasetsBox.removeAllItems();
        ArrayList<DataNode> topList = new ArrayList<DataNode>();
        ArrayList<DataNode> datasetsList = new ArrayList<DataNode>();
        if (CollectionUtils.isNotEmpty((Collection)containers)) {
            for (DataObject ho : containers) {
                if (ho instanceof ProjectData) {
                    n = new DataNode(ho);
                    topList.add(n);
                    continue;
                }
                if (!(ho instanceof DatasetData)) continue;
                n = new DataNode(ho);
                datasetsList.add(n);
            }
        }
        List sortedList = new ArrayList();
        if (topList.size() > 0) {
            sortedList = this.sorter.sort(topList);
        }
        ArrayList<DataNode> finalList = new ArrayList<DataNode>();
        if (datasetsList.size() > 0) {
            finalList.add(new DataNode(datasetsList));
        }
        finalList.addAll(sortedList);
        this.populateAndAddTooltipsToComboBox(finalList, this.parentsBox);
        if (this.selectedGrandParentContainer != null && this.selectedGrandParentContainer instanceof ProjectData) {
            for (int i = 0; i < this.parentsBox.getItemCount(); ++i) {
                n = (DataNode)this.parentsBox.getItemAt(i);
                if (n.getDataObject().getId() != this.selectedGrandParentContainer.getId() || !n.getDataObject().canLink()) continue;
                this.parentsBox.setSelectedIndex(i);
                break;
            }
        }
        this.parentsBox.addItemListener(this.parentsBoxListener);
        this.populateDatasetsBox(null);
        this.buildLocationPane();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.project();
                break;
            }
            case 0: {
                this.close();
                break;
            }
            case 3: {
                this.firePropertyChange(LOAD_ALL_PROPERTY, (Object)false, (Object)true);
                break;
            }
            case 2: {
                CreateFolderDialog d = new CreateFolderDialog(this, "New Dataset");
                d.pack();
                d.setDefaultName("untitled dataset");
                d.addPropertyChangeListener("createFolder", this);
                UIUtilities.centerAndShow(this, d);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String folderName;
        String name = evt.getPropertyName();
        if ("createFolder".equals(name) && (folderName = (String)evt.getNewValue()) != null && folderName.trim().length() > 0) {
            this.createDataset(folderName);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableSave();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableSave();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

