/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ImporterAction;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class GroupSelectionAction
extends ImporterAction {
    private GroupData group;

    private void setPermissions() {
        IconManager im = IconManager.getInstance();
        Icon icon = im.getIcon(21);
        String desc = "";
        switch (this.group.getPermissions().getPermissionsLevel()) {
            case 0: {
                desc = "Private Group";
                icon = im.getIcon(22);
                break;
            }
            case 1: {
                desc = "Collaborators can only read your data.";
                icon = im.getIcon(23);
                break;
            }
            case 2: {
                desc = "Collaborators can read and annotate your data.";
                icon = im.getIcon(24);
                break;
            }
            case 3: {
                desc = "Collaborators can read, annotate, delete, etc., your data.";
                icon = im.getIcon(34);
                break;
            }
            case 4: {
                desc = "Public";
                icon = im.getIcon(25);
                break;
            }
            case 5: {
                desc = "Public";
                icon = im.getIcon(25);
            }
        }
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    public GroupSelectionAction(Importer model, GroupData group) {
        super(model);
        if (group == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        this.group = group;
        this.putValue("Name", group.getName());
        this.setPermissions();
    }

    public boolean isSameGroup(long groupID) {
        return this.group.getId() == groupID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.setUserGroup(this.group);
    }
}

