/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.FontMetrics;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultTable;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;

public class SearchResultTableModel
extends DefaultTableModel {
    public static final String[] COLUMN_NAMES = new String[]{"Type", "Name", "Acquired", "Imported", "Group", " "};
    public static final int VIEWBUTTON_COLUMN_INDEX = COLUMN_NAMES.length - 1;
    private static final double THUMB_ZOOM_FACTOR = 0.3;
    private List<DataObject> data = new ArrayList<DataObject>();
    private AdvancedResultSearchModel model;
    private Collection<GroupData> groups = TreeViewerAgent.getAvailableUserGroups();
    private SearchResultTable parent;

    public SearchResultTableModel(SearchResultTable parent, List<DataObject> data, AdvancedResultSearchModel model) {
        super(COLUMN_NAMES, data.size());
        this.parent = parent;
        this.data = data;
        this.model = model;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.data.size()) {
            throw new ArrayIndexOutOfBoundsException(row + " is not within the valid range of rows [0," + (this.data.size() - 1) + "]");
        }
        DataObject obj = this.data.get(row);
        Object result = null;
        switch (column) {
            case 0: {
                result = this.getIcon(obj);
                break;
            }
            case 1: {
                result = this.getObjectName(obj);
                break;
            }
            case 2: {
                result = this.getADate(obj);
                break;
            }
            case 3: {
                result = this.getIDate(obj);
                break;
            }
            case 4: {
                result = this.getGroup(obj);
                break;
            }
            case 5: {
                result = obj;
            }
        }
        return result != null ? result : "--";
    }

    private Date getADate(DataObject obj) {
        if (obj instanceof ImageData) {
            Timestamp time = EditorUtil.getAcquisitionTime((ImageData)obj);
            if (time == null) {
                return null;
            }
            return new Date(time.getTime());
        }
        return null;
    }

    private Object getIDate(DataObject obj) {
        Timestamp time = obj.getCreated();
        if (time == null) {
            return null;
        }
        return new Date(time.getTime());
    }

    private String getGroup(DataObject obj) {
        for (GroupData g : this.groups) {
            if (g.getId() != obj.getGroupId()) continue;
            return g.getName();
        }
        return "[ID: " + obj.getGroupId() + "]";
    }

    private Icon getIcon(DataObject obj) {
        if (obj instanceof ImageData) {
            Thumbnail thumb = this.model.getThumbnail(obj);
            return thumb == null ? IconManager.getInstance().getIcon(6) : thumb.getIcon(0.3);
        }
        if (obj instanceof ProjectData) {
            return IconManager.getInstance().getIcon(4);
        }
        if (obj instanceof DatasetData) {
            return IconManager.getInstance().getIcon(5);
        }
        if (obj instanceof ScreenData) {
            return IconManager.getInstance().getIcon(75);
        }
        if (obj instanceof PlateData) {
            return IconManager.getInstance().getIcon(77);
        }
        if (obj instanceof PlateAcquisitionData) {
            return IconManager.getInstance().getIcon(114);
        }
        return IconManager.getInstance().getIcon(32);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return DataObject.class;
            }
        }
        return String.class;
    }

    private String getObjectName(DataObject obj) {
        String name = "";
        if (obj instanceof ImageData) {
            name = ((ImageData)obj).getName();
        } else if (obj instanceof DatasetData) {
            name = ((DatasetData)obj).getName();
        } else if (obj instanceof ProjectData) {
            name = ((ProjectData)obj).getName();
        } else if (obj instanceof ScreenData) {
            name = ((ScreenData)obj).getName();
        } else if (obj instanceof PlateData) {
            name = ((PlateData)obj).getName();
        } else if (obj instanceof PlateAcquisitionData) {
            name = ((PlateAcquisitionData)obj).getLabel();
        }
        FontMetrics fm = this.parent.getGraphics().getFontMetrics();
        int colWidth = this.parent.getColumn(1).getWidth();
        int textWidth = fm.stringWidth(name);
        if (textWidth > (colWidth -= 20)) {
            int dotsWidth = fm.stringWidth("...");
            while (true) {
                if ((textWidth = dotsWidth + fm.stringWidth(name)) <= colWidth) {
                    name = "..." + name;
                    break;
                }
                if (name.isEmpty()) {
                    name = "";
                    break;
                }
                name = name.substring(1);
            }
        }
        String idPrefix = null;
        if (this.model.isIdMatch(obj.getClass(), obj.getId())) {
            idPrefix = "<font color=\"#ff0000\"><b>[ID: " + obj.getId() + "]</b></font> ";
        }
        return idPrefix != null ? idPrefix + "" + name : name;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == VIEWBUTTON_COLUMN_INDEX;
    }
}

