/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class SEQReader
extends BaseTiffReader {
    private static final int IMAGE_PRO_TAG_1 = 50288;
    private static final int IMAGE_PRO_TAG_2 = 40105;
    private static final int IMAGE_PRO_TAG_3 = 40100;

    public SEQReader() {
        super("Image-Pro Sequence", "seq");
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        parser.fillInIFD(ifd);
        Object tag1 = ifd.get((Object)50288);
        Object tag3 = ifd.get((Object)40100);
        return tag1 != null && tag1 instanceof short[] || tag3 != null && tag3 instanceof int[];
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeZ = 0;
        m.sizeT = 0;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        for (IFD ifd : this.ifds) {
            int tag2;
            short[] tag1;
            if (level != MetadataLevel.MINIMUM && (tag1 = (short[])ifd.getIFDValue(50288)) != null) {
                StringBuilder seqId = new StringBuilder();
                for (int i = 0; i < tag1.length; ++i) {
                    seqId.append(tag1[i]);
                }
                this.addGlobalMeta("Image-Pro SEQ ID", seqId.toString());
            }
            if ((tag2 = ((IFD)this.ifds.get(0)).getIFDIntValue(40105)) != -1) {
                ++m.sizeZ;
                this.addGlobalMeta("Frame Rate", tag2);
            }
            this.addGlobalMeta("Number of images", this.getSizeZ());
        }
        if (this.getSizeZ() == 0) {
            m.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m.sizeT = 1;
        }
        if (this.getSizeZ() == 1 && this.getSizeT() == 1) {
            m.sizeZ = this.ifds.size();
        }
        this.addGlobalMeta("frames", this.getSizeZ());
        this.addGlobalMeta("channels", super.getSizeC());
        this.addGlobalMeta("slices", this.getSizeT());
        String descr = ((IFD)this.ifds.get(0)).getComment();
        this.metadata.remove("Comment");
        if (descr != null) {
            String[] lines;
            for (String token : lines = descr.split("\n")) {
                int eq = (token = token.trim()).indexOf(61);
                if (eq == -1) {
                    eq = token.indexOf(58);
                }
                if (eq == -1) continue;
                String label = token.substring(0, eq);
                String data = token.substring(eq + 1);
                this.addGlobalMeta(label, data);
                if (label.equals("channels")) {
                    m.sizeC = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("frames")) {
                    m.sizeT = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("slices")) continue;
                m.sizeZ = Integer.parseInt(data);
            }
        }
        if (this.isRGB() && this.getSizeC() != 3) {
            m.sizeC *= 3;
        }
        m.dimensionOrder = "XY";
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.getSizeZ(), this.getSizeC(), this.getSizeT()};
        String[] axes = new String[]{"Z", "C", "T"};
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] <= max) continue;
            max = dims[i];
            maxNdx = i;
        }
        m.dimensionOrder = m.dimensionOrder + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.getSizeC() > 1) {
                m.dimensionOrder = m.dimensionOrder + 'C';
                m.dimensionOrder = m.dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                m.dimensionOrder = m.dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            m.dimensionOrder = this.getSizeZ() > this.getSizeT() ? m.dimensionOrder + "ZT" : m.dimensionOrder + "TZ";
        }
    }
}

