/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OperettaReader
extends FormatReader {
    private static final String XML_FILE = "Index.idx.xml";
    private static final int XML_TAG = 65500;
    private Plane[][] planes;
    private MinimalTiffReader reader;

    public OperettaReader() {
        super("PerkinElmer Operetta", new String[]{"tif", "tiff", "xml"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
        this.datasetDescription = "Directory with XML file and one .tif/.tiff file per plane";
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals(XML_FILE)) {
            return true;
        }
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        Location xml = new Location(parent, XML_FILE);
        if (!xml.exists()) {
            return false;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(65500);
        if (s == null) {
            return false;
        }
        String xml = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return xml.indexOf("Operetta") < 1024;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        for (Plane p : this.planes[this.getSeries()]) {
            if (p == null || p.filename == null || !new Location(p.filename).exists()) continue;
            files.add(p.filename);
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.planes = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        Plane p;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Arrays.fill(buf, (byte)0);
        if (this.getSeries() < this.planes.length && no < this.planes[this.getSeries()].length && (p = this.planes[this.getSeries()][no]) != null && p.filename != null && new Location(p.filename).exists()) {
            if (this.reader == null) {
                this.reader = new MinimalTiffReader();
            }
            this.reader.setId(p.filename);
            this.reader.openBytes(0, buf, x, y, w, h);
            this.reader.close();
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!OperettaReader.checkSuffix((String)id, (String)"xml")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            Location xml = new Location(parent, XML_FILE);
            if (!xml.exists()) {
                throw new FormatException("Could not find XML file " + xml.getAbsolutePath());
            }
            this.initFile(xml.getAbsolutePath());
            return;
        }
        super.initFile(id);
        String xmlData = DataTools.readFile((String)id);
        OperettaHandler handler = new OperettaHandler();
        XMLTools.parseXML((String)xmlData, (DefaultHandler)((Object)handler));
        ArrayList<Plane> planeList = handler.getPlanes();
        ArrayList<Integer> uniqueRows = new ArrayList<Integer>();
        ArrayList<Integer> uniqueCols = new ArrayList<Integer>();
        ArrayList<Integer> uniqueFields = new ArrayList<Integer>();
        ArrayList<Integer> uniqueZs = new ArrayList<Integer>();
        ArrayList<Integer> uniqueTs = new ArrayList<Integer>();
        ArrayList<Integer> uniqueCs = new ArrayList<Integer>();
        for (Plane p : planeList) {
            if (!uniqueRows.contains(p.row)) {
                uniqueRows.add(p.row);
            }
            if (!uniqueCols.contains(p.col)) {
                uniqueCols.add(p.col);
            }
            if (!uniqueFields.contains(p.field)) {
                uniqueFields.add(p.field);
            }
            if (!uniqueZs.contains(p.z)) {
                uniqueZs.add(p.z);
            }
            if (!uniqueCs.contains(p.c)) {
                uniqueCs.add(p.c);
            }
            if (uniqueTs.contains(p.t)) continue;
            uniqueTs.add(p.t);
        }
        Object[] rows = uniqueRows.toArray(new Integer[uniqueRows.size()]);
        Object[] cols = uniqueCols.toArray(new Integer[uniqueCols.size()]);
        Object[] fields = uniqueFields.toArray(new Integer[uniqueFields.size()]);
        Object[] zs = uniqueZs.toArray(new Integer[uniqueZs.size()]);
        Object[] cs = uniqueCs.toArray(new Integer[uniqueCs.size()]);
        Object[] ts = uniqueTs.toArray(new Integer[uniqueTs.size()]);
        Arrays.sort(rows);
        Arrays.sort(cols);
        Arrays.sort(fields);
        Arrays.sort(zs);
        Arrays.sort(ts);
        Arrays.sort(cs);
        int seriesCount = rows.length * cols.length * fields.length;
        this.core.clear();
        this.planes = new Plane[seriesCount][zs.length * cs.length * ts.length];
        int nextSeries = 0;
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < cols.length; ++col) {
                for (int field = 0; field < fields.length; ++field) {
                    int nextPlane = 0;
                    for (int t = 0; t < ts.length; ++t) {
                        for (int z = 0; z < zs.length; ++z) {
                            for (int c = 0; c < cs.length; ++c) {
                                for (Plane p : planeList) {
                                    if (p.row != (Integer)rows[row] || p.col != (Integer)cols[col] || p.field != (Integer)fields[field] || p.t != (Integer)ts[t] || p.z != (Integer)zs[z] || p.c != (Integer)cs[c]) continue;
                                    this.planes[nextSeries][nextPlane] = p;
                                    break;
                                }
                                ++nextPlane;
                            }
                        }
                    }
                    ++nextSeries;
                }
            }
        }
        this.reader = new MinimalTiffReader();
        for (int i = 0; i < seriesCount; ++i) {
            int planeIndex;
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            ms.sizeZ = uniqueZs.size();
            ms.sizeC = uniqueCs.size();
            ms.sizeT = uniqueTs.size();
            ms.dimensionOrder = "XYCZT";
            ms.rgb = false;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            for (planeIndex = 0; planeIndex < this.planes[i].length && this.planes[i][planeIndex] == null; ++planeIndex) {
                LOGGER.debug("skipping null plane series = {}, plane = {}", (Object)i, (Object)planeIndex);
            }
            if (planeIndex >= this.planes[i].length) {
                if (i > 0) {
                    ms.sizeX = ((CoreMetadata)this.core.get((int)(i - 1))).sizeX;
                    ms.sizeY = ((CoreMetadata)this.core.get((int)(i - 1))).sizeY;
                    ms.pixelType = ((CoreMetadata)this.core.get((int)(i - 1))).pixelType;
                    ms.littleEndian = ((CoreMetadata)this.core.get((int)(i - 1))).littleEndian;
                    continue;
                }
                LOGGER.warn("Could not find valid plane for series 0");
                continue;
            }
            ms.sizeX = this.planes[i][planeIndex].x;
            ms.sizeY = this.planes[i][planeIndex].y;
            String filename = this.planes[i][planeIndex].filename;
            while (!(filename != null && new Location(filename).exists() || planeIndex >= this.planes[i].length - 1)) {
                LOGGER.debug("Missing TIFF file: {}", (Object)filename);
                filename = this.planes[i][++planeIndex].filename;
            }
            if (filename != null && new Location(filename).exists()) {
                RandomAccessInputStream s = new RandomAccessInputStream(filename, 16);
                TiffParser parser = new TiffParser(s);
                parser.setDoCaching(false);
                IFD firstIFD = parser.getFirstIFD();
                ms.littleEndian = firstIFD.isLittleEndian();
                ms.pixelType = firstIFD.getPixelType();
                s.close();
                continue;
            }
            if (i > 0) {
                LOGGER.warn("Could not find valid TIFF file for series {}", (Object)i);
                ms.littleEndian = ((CoreMetadata)this.core.get((int)0)).littleEndian;
                ms.pixelType = ((CoreMetadata)this.core.get((int)0)).pixelType;
                continue;
            }
            LOGGER.warn("Could not find valid TIFF file for series 0; pixel type may be wrong");
        }
        this.addGlobalMeta("Plate name", handler.getPlateName());
        this.addGlobalMeta("Plate description", handler.getPlateDescription());
        this.addGlobalMeta("Plate ID", handler.getPlateIdentifier());
        this.addGlobalMeta("Measurement ID", handler.getMeasurementID());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrument, 0);
        String objective = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
        store.setObjectiveID(objective, 0, 0);
        if (this.planes[0][0] != null) {
            store.setObjectiveNominalMagnification(Double.valueOf(this.planes[0][0].magnification), 0, 0);
            store.setObjectiveLensNA(Double.valueOf(this.planes[0][0].lensNA), 0, 0);
        }
        store.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
        store.setPlateRows(new PositiveInteger(Integer.valueOf(handler.getPlateRows())), 0);
        store.setPlateColumns(new PositiveInteger(Integer.valueOf(handler.getPlateColumns())), 0);
        String plateAcqID = MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0});
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount((Integer)fields.length);
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < cols.length; ++col) {
                int well = row * cols.length + col;
                store.setWellID(MetadataTools.createLSID((String)"Well", (int[])new int[]{0, well}), 0, well);
                store.setWellRow(new NonNegativeInteger((Integer)rows[row]), 0, well);
                store.setWellColumn(new NonNegativeInteger((Integer)cols[col]), 0, well);
                for (int field = 0; field < fields.length; ++field) {
                    int imageIndex = well * fields.length + field;
                    String wellSampleID = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{0, well, field});
                    store.setWellSampleID(wellSampleID, 0, well, field);
                    store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(imageIndex)), 0, well, field);
                    String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{imageIndex});
                    store.setImageID(imageID, imageIndex);
                    store.setWellSampleImageRef(imageID, 0, well, field);
                    store.setImageInstrumentRef(instrument, imageIndex);
                    store.setObjectiveSettingsID(objective, imageIndex);
                    String name = "Well " + (well + 1) + ", Field " + (field + 1);
                    store.setImageName(name, imageIndex);
                    store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, imageIndex);
                    if (this.planes[imageIndex][0] == null || this.planes[imageIndex][0].absoluteTime == null) continue;
                    store.setImageAcquisitionDate(this.planes[imageIndex][0].absoluteTime, imageIndex);
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPlateName(handler.getPlateName(), 0);
            store.setPlateDescription(handler.getPlateDescription(), 0);
            store.setPlateExternalIdentifier(handler.getPlateIdentifier(), 0);
            String experimenterID = MetadataTools.createLSID((String)"Experimenter", (int[])new int[]{0});
            store.setExperimenterID(experimenterID, 0);
            store.setExperimenterLastName(handler.getExperimenterName(), 0);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                store.setImageExperimenterRef(experimenterID, i);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (this.planes[i][c] != null && this.planes[i][c].channelName != null) {
                        store.setChannelName(this.planes[i][c].channelName, i, c);
                    }
                    if (this.planes[i][c] == null) continue;
                    store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength((Double)this.planes[i][c].emWavelength), i, c);
                    store.setChannelExcitationWavelength(FormatTools.getExcitationWavelength((Double)this.planes[i][c].exWavelength), i, c);
                }
                if (this.planes[i][0] != null) {
                    store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)this.planes[i][0].resolutionX), i);
                    store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)this.planes[i][0].resolutionY), i);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    if (this.planes[i][p] == null) continue;
                    store.setPlanePositionX(this.planes[i][p].positionX, i, p);
                    store.setPlanePositionY(this.planes[i][p].positionY, i, p);
                    store.setPlanePositionZ(this.planes[i][p].positionZ, i, p);
                    store.setPlaneExposureTime(this.planes[i][p].exposureTime, i, p);
                    store.setPlaneDeltaT(this.planes[i][p].deltaT, i, p);
                }
            }
        }
    }

    class Plane {
        public String filename;
        public int row;
        public int col;
        public int field;
        public int x;
        public int y;
        public int z;
        public int t;
        public int c;
        public String channelName;
        public double resolutionX;
        public double resolutionY;
        public Length positionX;
        public Length positionY;
        public Length positionZ;
        public double emWavelength;
        public double exWavelength;
        public double magnification;
        public double lensNA;
        public Time exposureTime;
        public Time deltaT;
        public Timestamp absoluteTime;

        Plane() {
        }
    }

    class OperettaHandler
    extends BaseHandler {
        private String currentName;
        private Plane activePlane;
        private String displayName;
        private String plateID;
        private String measurementID;
        private String measurementTime;
        private String plateName;
        private String plateDescription;
        private int plateRows;
        private int plateCols;
        private ArrayList<Plane> planes = new ArrayList();
        private final StringBuilder currentValue = new StringBuilder();

        OperettaHandler() {
        }

        public ArrayList<Plane> getPlanes() {
            return this.planes;
        }

        public String getExperimenterName() {
            return this.displayName;
        }

        public String getPlateIdentifier() {
            return this.plateID;
        }

        public String getMeasurementID() {
            return this.measurementID;
        }

        public String getMeasurementTime() {
            return this.measurementTime;
        }

        public String getPlateName() {
            return this.plateName;
        }

        public String getPlateDescription() {
            return this.plateDescription;
        }

        public int getPlateRows() {
            return this.plateRows;
        }

        public int getPlateColumns() {
            return this.plateCols;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            this.currentValue.append(value);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentValue.setLength(0);
            this.currentName = qName;
            if (qName.equals("Image") && attributes.getValue("id") == null) {
                this.activePlane = new Plane();
            }
        }

        public void endElement(String uri, String localName, String qName) {
            String value = this.currentValue.toString();
            if ("User".equals(this.currentName)) {
                this.displayName = value;
            } else if ("PlateID".equals(this.currentName)) {
                this.plateID = value;
            } else if ("MeasurementID".equals(this.currentName)) {
                this.measurementID = value;
            } else if ("MeasurementStartTime".equals(this.currentName)) {
                this.measurementTime = value;
            } else if ("Name".equals(this.currentName)) {
                this.plateName = value;
            } else if ("PlateTypeName".equals(this.currentName)) {
                this.plateDescription = value;
            } else if ("PlateRows".equals(this.currentName)) {
                this.plateRows = Integer.parseInt(value);
            } else if ("PlateColumns".equals(this.currentName)) {
                this.plateCols = Integer.parseInt(value);
            } else if (this.activePlane != null) {
                if ("URL".equals(this.currentName)) {
                    if (value.length() > 0) {
                        Location parent = new Location(OperettaReader.this.currentId).getAbsoluteFile().getParentFile();
                        this.activePlane.filename = new Location(parent, value).getAbsolutePath();
                    }
                } else if ("Row".equals(this.currentName)) {
                    this.activePlane.row = Integer.parseInt(value) - 1;
                } else if ("Col".equals(this.currentName)) {
                    this.activePlane.col = Integer.parseInt(value) - 1;
                } else if ("FieldID".equals(this.currentName)) {
                    this.activePlane.field = Integer.parseInt(value);
                } else if ("PlaneID".equals(this.currentName)) {
                    this.activePlane.z = Integer.parseInt(value);
                } else if ("ImageSizeX".equals(this.currentName)) {
                    this.activePlane.x = Integer.parseInt(value);
                } else if ("ImageSizeY".equals(this.currentName)) {
                    this.activePlane.y = Integer.parseInt(value);
                } else if ("TimepointID".equals(this.currentName)) {
                    this.activePlane.t = Integer.parseInt(value);
                } else if ("ChannelID".equals(this.currentName)) {
                    this.activePlane.c = Integer.parseInt(value);
                } else if ("ChannelName".equals(this.currentName)) {
                    this.activePlane.channelName = value;
                } else if ("ImageResolutionX".equals(this.currentName)) {
                    this.activePlane.resolutionX = Double.parseDouble(value) * 1000000.0;
                } else if ("ImageResolutionY".equals(this.currentName)) {
                    this.activePlane.resolutionY = Double.parseDouble(value) * 1000000.0;
                } else if ("PositionX".equals(this.currentName)) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionX = new Length((Number)meters, UNITS.METRE);
                } else if ("PositionY".equals(this.currentName)) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionY = new Length((Number)meters, UNITS.METRE);
                } else if ("AbsPositionZ".equals(this.currentName)) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionZ = new Length((Number)meters, UNITS.METRE);
                } else if ("ObjectiveMagnification".equals(this.currentName)) {
                    this.activePlane.magnification = Double.parseDouble(value);
                } else if ("ObjectiveNA".equals(this.currentName)) {
                    this.activePlane.lensNA = Double.parseDouble(value);
                } else if ("MainEmissionWavelength".equals(this.currentName)) {
                    this.activePlane.emWavelength = Double.parseDouble(value);
                } else if ("MainExcitationWavelength".equals(this.currentName)) {
                    this.activePlane.exWavelength = Double.parseDouble(value);
                } else if ("ExposureTime".equals(this.currentName)) {
                    this.activePlane.exposureTime = new Time((Number)Double.parseDouble(value), UNITS.S);
                } else if ("MeasurementTimeOffset".equals(this.currentName)) {
                    this.activePlane.deltaT = new Time((Number)Double.parseDouble(value), UNITS.S);
                } else if ("AbsTime".equals(this.currentName)) {
                    this.activePlane.absoluteTime = new Timestamp(value);
                }
            }
            this.currentName = null;
            if (qName.equals("Image") && this.activePlane != null) {
                this.planes.add(this.activePlane);
            }
        }
    }
}

