/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import omero.RBool;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RList;
import omero.RLong;
import omero.RMap;
import omero.RString;
import omero.RType;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.AnnotationAnnotationLinkI;
import omero.model.BooleanAnnotation;
import omero.model.BooleanAnnotationI;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkI;
import omero.model.DatasetI;
import omero.model.DatasetImageLink;
import omero.model.DatasetImageLinkI;
import omero.model.DoubleAnnotation;
import omero.model.DoubleAnnotationI;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.ExperimenterI;
import omero.model.GroupExperimenterMapI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImageAnnotationLinkI;
import omero.model.ImageI;
import omero.model.LongAnnotation;
import omero.model.LongAnnotationI;
import omero.model.MapAnnotation;
import omero.model.MapAnnotationI;
import omero.model.OriginalFile;
import omero.model.OriginalFileAnnotationLinkI;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionAnnotationLink;
import omero.model.PlateAcquisitionAnnotationLinkI;
import omero.model.PlateAnnotationLink;
import omero.model.PlateAnnotationLinkI;
import omero.model.PlateI;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectAnnotationLinkI;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.model.ProjectI;
import omero.model.Screen;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenAnnotationLinkI;
import omero.model.ScreenI;
import omero.model.ScreenPlateLinkI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.TermAnnotation;
import omero.model.TermAnnotationI;
import omero.model.Well;
import omero.model.WellAnnotationLink;
import omero.model.WellAnnotationLinkI;
import omero.model.XmlAnnotation;
import omero.model.XmlAnnotationI;
import omero.rtypes;
import org.apache.commons.lang.StringUtils;

public class ModelMapper {
    public static void unloadCollections(IObject object) {
        if (object == null) {
            return;
        }
        if (object.isLoaded()) {
            object.unloadCollections();
        }
    }

    public static IObject getChildFromLink(IObject link) {
        if (link == null) {
            return null;
        }
        if (link instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)link).getChild();
        }
        if (link instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)link).getChild();
        }
        if (link instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)link).getChild();
        }
        if (link instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)link).getChild();
        }
        if (link instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)link).getChild();
        }
        if (link instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)link).getChild();
        }
        if (link instanceof PlateAcquisitionAnnotationLink) {
            return ((PlateAcquisitionAnnotationLink)link).getChild();
        }
        if (link instanceof AnnotationAnnotationLink) {
            return ((AnnotationAnnotationLink)link).getChild();
        }
        return null;
    }

    public static IObject getParentFromLink(IObject link) {
        if (link == null) {
            return null;
        }
        if (link instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)link).getParent();
        }
        if (link instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)link).getParent();
        }
        if (link instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)link).getParent();
        }
        if (link instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)link).getParent();
        }
        if (link instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)link).getParent();
        }
        if (link instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)link).getParent();
        }
        if (link instanceof PlateAcquisitionAnnotationLink) {
            return ((PlateAcquisitionAnnotationLink)link).getParent();
        }
        if (link instanceof AnnotationAnnotationLink) {
            return ((AnnotationAnnotationLink)link).getParent();
        }
        return null;
    }

    public static IObject linkParentToChild(IObject child, IObject parent) {
        if (parent == null) {
            return null;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Project unloadedProject = parent.getId() == null ? (Project)parent : new ProjectI(parent.getId().getValue(), false);
            Dataset unloadedDataset = child.getId() == null ? (Dataset)child : new DatasetI(child.getId().getValue(), false);
            ProjectDatasetLinkI l = new ProjectDatasetLinkI();
            l.link(unloadedProject, unloadedDataset);
            return l;
        }
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset unloadedDataset = parent.getId() == null ? (Dataset)parent : new DatasetI(parent.getId().getValue(), false);
            ImageI unloadedImage = new ImageI(child.getId().getValue(), false);
            DatasetImageLinkI l = new DatasetImageLinkI();
            l.link(unloadedDataset, unloadedImage);
            return l;
        }
        if (parent instanceof Screen) {
            if (!(child instanceof Plate)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Screen unloadedScreen = parent.getId() == null ? (Screen)parent : new ScreenI(parent.getId().getValue(), false);
            Plate unloadedPlate = child.getId() == null ? (Plate)child : new PlateI(child.getId().getValue(), false);
            ScreenPlateLinkI l = new ScreenPlateLinkI();
            l.link(unloadedScreen, unloadedPlate);
            return l;
        }
        if (parent instanceof TagAnnotation) {
            if (!(child instanceof TagAnnotation)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            RString ns = ((TagAnnotation)parent).getNs();
            if (ns == null || !ns.getValue().equals("openmicroscopy.org/omero/insight/tagset")) {
                return null;
            }
            return ModelMapper.linkAnnotation(parent, (TagAnnotation)child);
        }
        if (parent instanceof ExperimenterGroup) {
            if (!(child instanceof Experimenter)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            ExperimenterGroupI unloadedGroup = new ExperimenterGroupI(parent.getId().getValue(), false);
            ExperimenterI unloadedExp = new ExperimenterI(child.getId().getValue(), false);
            GroupExperimenterMapI l = new GroupExperimenterMapI();
            l.link(unloadedGroup, unloadedExp);
            return l;
        }
        return null;
    }

    public static void linkParentToNewChild(IObject child, IObject parent) {
        if (parent == null) {
            return;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Project p = (Project)parent;
            Dataset d = (Dataset)child;
            List<ProjectDatasetLink> l = d.copyProjectLinks();
            if (l == null) {
                return;
            }
            Iterator<ProjectDatasetLink> it = l.iterator();
            long id = p.getId().getValue();
            while (it.hasNext()) {
                ProjectDatasetLink link = it.next();
                if (id != link.getParent().getId().getValue()) continue;
                p.addProjectDatasetLink(new ProjectDatasetLinkI(link.getId(), false));
            }
        } else if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset p = (Dataset)parent;
            Image d = (Image)child;
            List<DatasetImageLink> l = d.copyDatasetLinks();
            if (l == null) {
                return;
            }
            Iterator<DatasetImageLink> it = l.iterator();
            long id = p.getId().getValue();
            while (it.hasNext()) {
                DatasetImageLink link = it.next();
                if (id != link.getParent().getId().getValue()) continue;
                p.addDatasetImageLink(new DatasetImageLinkI(link.getId(), false));
            }
        } else {
            throw new IllegalArgumentException("DataObject not supported.");
        }
    }

    public static IObject createIObject(DataObject child) {
        return ModelMapper.createIObject(child, null);
    }

    public static IObject createIObject(DataObject child, DataObject parent) {
        if (child instanceof ProjectData) {
            ProjectData data = (ProjectData)child;
            ProjectI model = new ProjectI();
            model.setName(rtypes.rstring(data.getName()));
            model.setDescription(rtypes.rstring(data.getDescription()));
            return model;
        }
        if (child instanceof DatasetData) {
            DatasetData data = (DatasetData)child;
            DatasetI model = new DatasetI();
            model.setName(rtypes.rstring(data.getName()));
            model.setDescription(rtypes.rstring(data.getDescription()));
            if (parent != null) {
                model.linkProject(new ProjectI(parent.getId(), false));
            }
            return model;
        }
        if (child instanceof ImageData) {
            if (!(parent instanceof DatasetData)) {
                throw new IllegalArgumentException("Parent not valid.");
            }
            ImageData data = (ImageData)child;
            ImageI model = new ImageI();
            model.setName(rtypes.rstring(data.getName()));
            model.setDescription(rtypes.rstring(data.getDescription()));
            model.linkDataset(new DatasetI(parent.getId(), false));
            return model;
        }
        if (child instanceof ScreenData) {
            ScreenData data = (ScreenData)child;
            ScreenI model = new ScreenI();
            model.setName(rtypes.rstring(data.getName()));
            model.setDescription(rtypes.rstring(data.getDescription()));
            return model;
        }
        if (child instanceof TagAnnotationData) {
            return ModelMapper.createAnnotation((TagAnnotationData)child);
        }
        if (child instanceof ExperimenterData) {
            ExperimenterData data = (ExperimenterData)child;
            ExperimenterI exp = new ExperimenterI();
            exp.setFirstName(rtypes.rstring(data.getFirstName()));
            exp.setLastName(rtypes.rstring(data.getLastName()));
            exp.setMiddleName(rtypes.rstring(data.getMiddleName()));
            exp.setEmail(rtypes.rstring(data.getEmail()));
            exp.setInstitution(rtypes.rstring(data.getInstitution()));
            return exp;
        }
        if (child instanceof GroupData) {
            GroupData data = (GroupData)child;
            ExperimenterGroupI g = new ExperimenterGroupI();
            g.setName(rtypes.rstring(data.getName()));
            return g;
        }
        throw new IllegalArgumentException("Child and parent are not compatible.");
    }

    public static IObject removeIObject(IObject child, IObject parent) {
        if (child instanceof Dataset && parent instanceof Project) {
            Project mParent = (Project)parent;
            List<ProjectDatasetLink> s = mParent.copyDatasetLinks();
            Iterator<ProjectDatasetLink> i = s.iterator();
            while (i.hasNext()) {
                mParent.removeProjectDatasetLink(new ProjectDatasetLinkI(i.next().getId(), false));
            }
            return mParent;
        }
        throw new IllegalArgumentException("DataObject not supported.");
    }

    public static IObject createAnnotationAndLink(IObject annotatedObject, AnnotationData data) {
        Annotation annotation = ModelMapper.createAnnotation(data);
        if (annotation == null) {
            return null;
        }
        return ModelMapper.linkAnnotation(annotatedObject, annotation);
    }

    public static Annotation createAnnotation(AnnotationData data) {
        Annotation annotation = null;
        if (data instanceof TextualAnnotationData) {
            annotation = new CommentAnnotationI();
            ((CommentAnnotation)annotation).setTextValue(rtypes.rstring(data.getContentAsString()));
        } else if (data instanceof RatingAnnotationData) {
            int rate = ((RatingAnnotationData)data).getRating();
            if (rate == 0) {
                return null;
            }
            annotation = new LongAnnotationI();
            annotation.setNs(rtypes.rstring("openmicroscopy.org/omero/insight/rating"));
            ((LongAnnotation)annotation).setLongValue(rtypes.rlong((Long)data.getContent()));
        } else if (data instanceof TermAnnotationData) {
            annotation = new TermAnnotationI();
            ((TermAnnotation)annotation).setTermValue(rtypes.rstring(data.getContentAsString()));
        } else if (data instanceof TagAnnotationData) {
            annotation = new TagAnnotationI();
            ((TagAnnotation)annotation).setTextValue(rtypes.rstring(data.getContentAsString()));
            annotation.setDescription(rtypes.rstring(((TagAnnotationData)data).getTagDescription()));
            String ns = data.getNameSpace();
            if (StringUtils.isNotEmpty((String)ns)) {
                annotation.setNs(rtypes.rstring(ns));
            }
        } else if (data instanceof BooleanAnnotationData) {
            annotation = new BooleanAnnotationI();
            annotation.setNs(rtypes.rstring("openmicroscopy.org/omero/insight/published"));
            ((BooleanAnnotation)annotation).setBoolValue(rtypes.rbool(((BooleanAnnotationData)data).getValue()));
        } else if (data instanceof XMLAnnotationData) {
            annotation = new XmlAnnotationI();
            ((XmlAnnotation)annotation).setTextValue(rtypes.rstring(data.getContentAsString()));
            annotation.setDescription(rtypes.rstring(((XMLAnnotationData)data).getDescription()));
            String ns = data.getNameSpace();
            if (ns != null && ns.length() > 0) {
                annotation.setNs(rtypes.rstring(ns));
            }
        } else if (data instanceof LongAnnotationData) {
            annotation = new LongAnnotationI();
            ((LongAnnotation)annotation).setLongValue(rtypes.rlong((Long)data.getContent()));
        } else if (data instanceof DoubleAnnotationData) {
            annotation = new DoubleAnnotationI();
            ((DoubleAnnotation)annotation).setDoubleValue(rtypes.rdouble((Double)data.getContent()));
        } else if (data instanceof MapAnnotationData) {
            annotation = new MapAnnotationI();
            String ns = data.getNameSpace();
            if (StringUtils.isNotEmpty((String)ns)) {
                annotation.setNs(rtypes.rstring(ns));
            }
            ((MapAnnotation)annotation).setMapValue((List)data.getContent());
        }
        return annotation;
    }

    public static IObject linkAnnotation(IObject annotatedObject, Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        if (annotatedObject instanceof Dataset) {
            DatasetAnnotationLinkI l = new DatasetAnnotationLinkI();
            l.setParent((Dataset)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Image) {
            ImageAnnotationLinkI l = new ImageAnnotationLinkI();
            l.setParent((Image)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Project) {
            ProjectAnnotationLinkI l = new ProjectAnnotationLinkI();
            l.setParent((Project)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Annotation) {
            AnnotationAnnotationLinkI l = new AnnotationAnnotationLinkI();
            l.setParent((Annotation)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Screen) {
            ScreenAnnotationLinkI l = new ScreenAnnotationLinkI();
            l.setParent((Screen)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Plate) {
            PlateAnnotationLinkI l = new PlateAnnotationLinkI();
            l.setParent((Plate)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof PlateAcquisition) {
            PlateAcquisitionAnnotationLinkI l = new PlateAcquisitionAnnotationLinkI();
            l.setParent((PlateAcquisition)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Well) {
            WellAnnotationLinkI l = new WellAnnotationLinkI();
            l.setParent((Well)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof OriginalFile) {
            OriginalFileAnnotationLinkI l = new OriginalFileAnnotationLinkI();
            l.setParent((OriginalFile)annotatedObject.proxy());
            l.setChild(annotation);
            return l;
        }
        return null;
    }

    public static IObject getAnnotatedObject(IObject annotation) {
        if (annotation instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof AnnotationAnnotationLink) {
            return ((AnnotationAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof PlateAcquisitionAnnotationLink) {
            return ((PlateAcquisitionAnnotationLink)annotation).getParent();
        }
        return null;
    }

    public static IObject getAnnotationObject(IObject link) {
        if (link instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)link).getChild();
        }
        if (link instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)link).getChild();
        }
        if (link instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)link).getChild();
        }
        if (link instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)link).getChild();
        }
        if (link instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)link).getChild();
        }
        if (link instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)link).getChild();
        }
        return null;
    }

    public static void fillIObject(IObject oldObject, IObject newObject) {
        if (oldObject == null || newObject == null) {
            throw new IllegalArgumentException("Object cannot be NULL.");
        }
        if (oldObject.getClass() != newObject.getClass()) {
            throw new IllegalArgumentException("Objects should be of the same type.");
        }
        if (oldObject instanceof Project) {
            Project n = (Project)newObject;
            Project o = (Project)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Dataset) {
            Dataset n = (Dataset)newObject;
            Dataset o = (Dataset)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Image) {
            Image n = (Image)newObject;
            Image o = (Image)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Experimenter) {
            Experimenter n = (Experimenter)newObject;
            Experimenter o = (Experimenter)oldObject;
            n.setEmail(o.getEmail());
            n.setFirstName(o.getFirstName());
            n.setLastName(o.getLastName());
            n.setMiddleName(o.getMiddleName());
            n.setInstitution(o.getInstitution());
        } else if (oldObject instanceof Screen) {
            Screen n = (Screen)newObject;
            Screen o = (Screen)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Plate) {
            Plate n = (Plate)newObject;
            Plate o = (Plate)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
            n.setDefaultSample(o.getDefaultSample());
        } else if (oldObject instanceof Well) {
            Well n = (Well)newObject;
            Well o = (Well)oldObject;
            n.setType(o.getType());
            n.setExternalDescription(o.getExternalDescription());
            n.setRed(o.getRed());
            n.setGreen(o.getGreen());
            n.setBlue(o.getBlue());
            n.setAlpha(o.getAlpha());
        } else if (oldObject instanceof PlateAcquisition) {
            PlateAcquisition n = (PlateAcquisition)newObject;
            PlateAcquisition o = (PlateAcquisition)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
            n.setEndTime(o.getEndTime());
            n.setStartTime(o.getStartTime());
            n.setMaximumFieldCount(o.getMaximumFieldCount());
        }
    }

    public static Object convertRTypeToJava(RType type) {
        if (type instanceof RString) {
            return ((RString)type).getValue();
        }
        if (type instanceof RLong) {
            return ((RLong)type).getValue();
        }
        if (type instanceof RBool) {
            return ((RBool)type).getValue();
        }
        if (type instanceof RDouble) {
            return ((RDouble)type).getValue();
        }
        if (type instanceof RFloat) {
            return Float.valueOf(((RFloat)type).getValue());
        }
        if (type instanceof RInt) {
            return ((RInt)type).getValue();
        }
        if (type instanceof RList) {
            List<RType> types = ((RList)type).getValue();
            ArrayList<Object> l = new ArrayList<Object>(types.size());
            Iterator<RType> i = types.iterator();
            while (i.hasNext()) {
                l.add(ModelMapper.convertRTypeToJava(i.next()));
            }
            return l;
        }
        if (type instanceof RMap) {
            Map<String, RType> types = ((RMap)type).getValue();
            LinkedHashMap<String, Object> l = new LinkedHashMap<String, Object>(types.size());
            for (Map.Entry<String, RType> e : types.entrySet()) {
                l.put(e.getKey(), ModelMapper.convertRTypeToJava(e.getValue()));
            }
            return l;
        }
        return "";
    }
}

