/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import omero.metadatastore.IObjectContainer;
import omero.model.Plate;
import omero.model.Well;
import omero.rtypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WellProcessor
implements ModelProcessor {
    private Logger log = LoggerFactory.getLogger(WellProcessor.class);
    private IObjectContainerStore store;

    @Override
    public void process(IObjectContainerStore store) throws ModelException {
        this.store = store;
        List<IObjectContainer> containers = store.getIObjectContainers(Well.class);
        for (IObjectContainer container : containers) {
            Integer plateIndex = container.indexes.get(Index.PLATE_INDEX.getValue());
            Plate plate = this.validatePlate(plateIndex);
            Well well = (Well)container.sourceObject;
            if (well.getColumn() != null && well.getColumn().getValue() >= plate.getColumns().getValue()) {
                plate.setColumns(rtypes.rint(well.getColumn().getValue() + 1));
            }
            if (well.getRow() == null || well.getRow().getValue() < plate.getRows().getValue()) continue;
            plate.setRows(rtypes.rint(well.getRow().getValue() + 1));
        }
    }

    private Plate validatePlate(int plateIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        IObjectContainer container = this.store.getIObjectContainer(Plate.class, indexes);
        Plate plate = (Plate)container.sourceObject;
        String userSpecifiedPlateName = this.store.getUserSpecifiedName();
        String userSpecifiedPlateDescription = this.store.getUserSpecifiedDescription();
        if (userSpecifiedPlateName != null) {
            plate.setName(rtypes.rstring(userSpecifiedPlateName));
        }
        if (plate.getName() == null || plate.getName().getValue() == null || plate.getName().getValue().isEmpty()) {
            this.log.warn("Missing plate name for: " + container.LSID);
            String filename = this.store.getReader().getCurrentFile();
            filename = new File(filename).getName();
            plate.setName(rtypes.rstring(filename));
        }
        if (userSpecifiedPlateDescription != null) {
            plate.setDescription(rtypes.rstring(userSpecifiedPlateDescription));
        }
        if (plate.getRows() == null) {
            plate.setRows(rtypes.rint(1));
        }
        if (plate.getColumns() == null) {
            plate.setColumns(rtypes.rint(1));
        }
        return plate;
    }
}

