(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     93230,       2684]
NotebookOptionsPosition[     90352,       2605]
NotebookOutlinePosition[     90881,       2626]
CellTagsIndexPosition[     90838,       2623]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherPairState", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"state", ",", "2"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"state", "-", "1"}], ",", 
     RowBox[{"state", "+", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant2", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"state", " ", "-", " ", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"state", "+", "1"}], ",", " ", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant4", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"state", " ", "\[GreaterEqual]", " ", "5"}], ",", " ", "5", ",", 
     " ", "1"}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"allPermutations", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutations"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Four", "-", 
    RowBox[{"way", " ", "states"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"permutations", " ", "=", " ", 
     RowBox[{"GroupElements", "[", 
      RowBox[{"PermutationGroup", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", " ", "4"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{"(*", "Symmetries", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"standardiseUsingPermutation", "[", 
     RowBox[{"{", 
      RowBox[{"unique_", ",", " ", "standardised_", ",", " ", "remaining_"}], 
      "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"current", ",", "positions", ",", "permutationsOfCurrent"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"current", " ", "=", " ", 
        RowBox[{"First", "[", "remaining", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permutationsOfCurrent", " ", "=", " ", 
        RowBox[{"allPermutations", "[", "current", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"positions", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"unique", ",", "#1"}], "]"}], "&"}], "/@", 
         "permutationsOfCurrent"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Plus", "@@", 
           RowBox[{"(", 
            RowBox[{"Flatten", "[", "positions", "]"}], ")"}]}], " ", 
          "\[Equal]", " ", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Append", "[", 
            RowBox[{"unique", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"unique", ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", 
             RowBox[{"unique", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Flatten", "[", "positions", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
           " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{
      RowBox[{"Nest", "[", 
       RowBox[{"standardiseUsingPermutation", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", " ", 
          RowBox[{"{", "}"}], ",", " ", "states"}], "}"}], ",", 
        RowBox[{"Length", "[", "states", "]"}]}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"statesWithCounts", "=", 
    RowBox[{"Tally", "[", "states", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "statesWithCounts", "]"}], "\[IndentingNewLine]", 
   RowBox[{"states", " ", "=", " ", 
    RowBox[{"First", " ", "/@", "statesWithCounts"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilMatrixFunction", "[", 
   RowBox[{"from_", ",", " ", "to_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "twoRecomb", ",", " ", "twoNonRecomb", ",", " ", "oneEach", ",", " ", 
      "twoRecombMatches", ",", " ", "twoNonRecombMatches", ",", " ", 
      "oneEachMatches", ",", " ", "permutationsOfTo"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOfTo", " ", "=", " ", 
      RowBox[{"allPermutations", "[", "to", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoNonRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"oneEach", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"twoNonRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoNonRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@",
          "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"oneEachMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"oneEach", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"twoRecombMatches", " ", 
       FractionBox[
        SuperscriptBox["r", "2"], "4"]}], " ", "+", " ", 
      RowBox[{"twoNonRecombMatches", " ", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "2"], "4"]}], " ", "+", " ", 
      RowBox[{"oneEachMatches", " ", "r", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "4"]}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rilMatrix", " ", "=", " ", 
   RowBox[{
    RowBox[{"Outer", "[", 
     RowBox[{
     "rilMatrixFunction", ",", " ", "states", ",", " ", "states", ",", "1"}], 
     "]"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"rilMatrix", ",", " ", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"states", ",", " ", "states"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "These", " ", "should", " ", "all", " ", "sum", " ", "to", " ", "1"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", "rilMatrix"}], " ", "//",
   "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "eigen", " ", "decomposition", " ", "works"}], 
   ",", " ", 
   RowBox[{
   "difference", " ", "should", " ", "be", " ", "a", " ", "zero", " ", 
    "matrix"}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"decomposed", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"decomposed", " ", "-", " ", "rilMatrix"}], "//", 
  "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Use", " ", "eigen", " ", "decomposition", " ", "to", " ", "take", " ", 
   "power"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"power", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ",", "d"}], 
     "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Check", " ", "that", " ", "the", " ", "limit", " ", "looks", " ", 
   "right"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilLimit", " ", "=", " ", 
   RowBox[{"Limit", "[", 
    RowBox[{"power", ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
       RowBox[{"r", " ", "<", " ", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"haplotypeProbability", "[", 
   RowBox[{"state1_", ",", "state2_"}], "]"}], " ", ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"state1", " ", "\[Equal]", " ", "state2"}], ",", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}], "2"], ",", 
    FractionBox["r", "2"]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"state", ",", " ", "count"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"state", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"count", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Can", "'"}], "t", " ", "inherit", " ", "the", " ", "same", 
          " ", "alleles", " ", "from", " ", "both", " ", "sides"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"state", "[", 
             RowBox[{"[", "1", "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"state", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"state", "[", 
             RowBox[{"[", "3", "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"state", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"state", "[", 
             RowBox[{"[", "1", "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"state", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"state", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"state", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          "0", ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "How", " ", "many", " ", "funnels", " ", "will", " ", "allow", " ",
             "this", " ", 
            RowBox[{"possibility", "?"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", 
               RowBox[{"DeleteDuplicates", "[", "state", "]"}], "]"}], " ", 
              "\[Equal]", " ", "2"}], ",", " ", "2", ",", " ", "1"}], "]"}], 
           "\[IndentingNewLine]", 
           FractionBox["count", "6"], " ", 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}], 
     "&"}], "/@", "statesWithCounts"}]}], ";"}]}], "Input"],

Cell[BoxData["initialProbabilities"], "Input"],

Cell[BoxData[{
 RowBox[{"infiniteSelfing", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"initialProbabilities", " ", ".", " ", "rilLimit"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
       "statesWithCounts"}], ")"}]}], " ", "//", "FullSimplify"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"Pick", "[", 
  RowBox[{"states", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", " ", "=!=", " ", "0"}], ")"}], "&"}], "/@", 
    "infiniteSelfing"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Probabilities", " ", "for", " ", "a", " ", "finite", " ", "number", " ", 
    "of", " ", "generations", " ", "of", " ", "selfing"}], ",", " ", 
   RowBox[{
    RowBox[{"no", " ", 
     RowBox[{"intercossing", ".", " ", "This"}], " ", "can", " ", "be", " ", 
     "worked", " ", "out", " ", "for", " ", "the", " ", "8"}], "-", 
    RowBox[{
    "way", " ", "design", " ", "just", " ", "based", " ", "on", " ", "the", 
     " ", "2"}], "-", 
    RowBox[{"way", " ", "design"}]}], ",", " ", 
   RowBox[{
   "and", " ", "it", " ", "should", " ", "match", " ", "the", " ", 
    "eigenvalue", " ", "calculation", " ", "above"}]}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fromPaper2way", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}], ")"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "+", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      FractionBox["r", 
       RowBox[{"1", "+", 
        RowBox[{"2", "r"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "-", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox["r", "2"]}]}], ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "+", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"fromPaper2way", "*", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "4", ",", "1", ",", "1"}], "}"}]}], ")"}]}],
   " ", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"permutationsF2", " ", "=", " ", 
   RowBox[{"GroupElements", "[", 
    RowBox[{"PermutationGroup", "[", 
     RowBox[{"{", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"allPermutationsF2", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutationsF2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected4wayFiniteSelfingMatrixFunction", " ", "=", " ", 
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "toStates", ",", " ", "permutationsToStates", ",", " ", "result", ",",
          " ", "positions", ",", " ", "indices", ",", " ", "f2Permutations"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", " ", "=", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"0", ",", " ", 
           RowBox[{"Length", "[", "states", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "B", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "B", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "5", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "//", "FullSimplify"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected4wayFiniteSelfingMatrix", " ", "=", 
   RowBox[{"expected4wayFiniteSelfingMatrixFunction", "/@", "states"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", 
   "expected4wayFiniteSelfingMatrix"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected4wayFiniteSelfing", "=", 
   RowBox[{"initialProbabilities", ".", "expected4wayFiniteSelfingMatrix"}]}],
   ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "expected4wayFiniteSelfing"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Check", " ", "that", " ", "asymptotically", " ", "we", " ", "have", " ", 
   "the", " ", "right", " ", "values"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"expected4wayFiniteSelfing", ",", " ", 
    RowBox[{"d", "\[Rule]", "\[Infinity]"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", " ", 
     RowBox[{
      RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
      RowBox[{"r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
    "statesWithCounts"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Ok", ",", " ", 
   RowBox[{
   "so", " ", "we", " ", "correctly", " ", "recreated", " ", "the", " ", 
    "results", " ", "from", " ", "the", " ", 
    RowBox[{"paper", ".", " ", "But"}], " ", "now", " ", "what", " ", "about",
     " ", "the", " ", "case", " ", "where", " ", "there", " ", "is", " ", 
    RowBox[{"intercrossing", "?"}]}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diseq", " ", "=", " ", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], "2"], "4"], " ", "-", " ", 
    FractionBox["1", "16"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"specificNonRecombProb", " ", "=", " ", 
   RowBox[{
    RowBox[{"diseq", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], 
      RowBox[{"nIntercrossing", "-", "1"}]]}], " ", "+", " ", 
    FractionBox["1", "16"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"specificRecombProb", " ", "=", " ", 
   FractionBox[
    RowBox[{"(", 
     RowBox[{"1", " ", "-", 
      RowBox[{"4", " ", "specificNonRecombProb"}]}], ")"}], "12"]}], 
  ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"initialProbabilitiesAIC", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", "\[Equal]", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
         "specificNonRecombProb", ",", "specificRecombProb"}], "]"}], "&"}], "/@",
       "states"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", " ", 
         "specificNonRecombProb", ",", "specificRecombProb"}], "]"}], "&"}], "/@",
       "states"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"#1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
      "statesWithCounts"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", "initialProbabilitiesAIC"}], "//", 
  "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"combinedProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"initialProbabilitiesAIC", ".", "power"}], ")"}], "//", 
    "FullSimplify"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"selfingLimit", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Limit", "[", 
     RowBox[{"combinedProbabilities", ",", " ", 
      RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
        RowBox[{"1", "/", "2"}]}]}]}], "]"}], "/", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"#1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
      "statesWithCounts"}], ")"}]}], "//", "FullSimplify", " "}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Has", " ", "the", " ", "correct", " ", "limit", " ", "with", " ", 
   "infinite", " ", "generations", " ", "of", " ", "selfing"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"selfingLimit", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "-", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{"2", "r"}]}]], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"2", " ", "+", " ", "nIntercrossing", "-", "1"}]], "4"], " ", 
      "+", " ", 
      FractionBox[
       RowBox[{
        RowBox[{"2", "r"}], " ", "+", " ", "1", " ", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], 
         RowBox[{"nIntercrossing", "-", "1"}]]}], "16"]}], ")"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"selfingLimit", "[", 
    RowBox[{"[", "4", "]"}], "]"}], " ", "-", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"4", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}]], 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], 
            RowBox[{"2", " ", "+", " ", "nIntercrossing", "-", "1"}]], "4"], 
          " ", "+", " ", 
          FractionBox[
           RowBox[{
            RowBox[{"2", "r"}], " ", "+", " ", "1", " ", "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], 
             RowBox[{"nIntercrossing", "-", "1"}]]}], "16"]}], ")"}]}]}], 
      ")"}], "/", "12"}], ")"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"selfingLimit", "[", 
    RowBox[{"[", "6", "]"}], "]"}], " ", "-", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"4", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}]], 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], 
            RowBox[{"2", " ", "+", " ", "nIntercrossing", "-", "1"}]], "4"], 
          " ", "+", " ", 
          FractionBox[
           RowBox[{
            RowBox[{"2", "r"}], " ", "+", " ", "1", " ", "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], 
             RowBox[{"nIntercrossing", "-", "1"}]]}], "16"]}], ")"}]}]}], 
      ")"}], "/", "12"}], ")"}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Rewrite", " ", "the", " ", "formula", " ", "into", " ", "something", " ", 
   "computable", " ", "more", " ", "efficiently"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rewritten", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"combinedProbabilities", "//", "Simplify"}], ")"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], 
              RowBox[{"1", "+", "nIntercrossing"}]], "\[Rule]", " ", 
             "powOneMinusR1"}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], 
              RowBox[{"nIntercrossing", "-", "1"}]], "\[Rule]", " ", 
             "powOneMinusR2"}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], 
              RowBox[{"2", " ", "nIntercrossing"}]], "\[Rule]", " ", 
             "powOneMinusR3"}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], "nIntercrossing"], " ", 
             "\[Rule]", " ", 
             RowBox[{"powOneMinusR2", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}]}]}], ",", " ", 
            RowBox[{
             SuperscriptBox["2", 
              RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
             RowBox[{"2", "*", "pow2"}]}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}],
               "d"], "\[Rule]", "quadraticPower"}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
             "powOneMinus2R"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "3"}], "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"2", " ", "r"}]}], ")"}]}], "\[Rule]", " ", 
             "quadratic2"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
             "\[Rule]", " ", "quadratic1"}], ",", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "-", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
             "\[Rule]", " ", 
             RowBox[{"(", 
              RowBox[{"-", "quadratic1"}], ")"}]}], ",", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], "2"], " ", "\[Rule]", 
             " ", "oneMinusRSquared"}]}], "}"}]}], ")"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], 
            RowBox[{"1", "+", "nIntercrossing"}]], "\[Rule]", " ", 
           "powOneMinusR1"}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}], 
            RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "r"}]}], ")"}], "*", "powOneMinus2R"}]}]}], 
         "}"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "r"}]}], ")"}], "\[Rule]", "oneMinus2R"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], "\[Rule]", " ", "onePlus2R"}], 
        ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "\[Rule]", " ", "oneMinusR"}], ",", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], " ", "+", " ", "r"}], ")"}], " ", "\[Rule]", 
         " ", 
         RowBox[{"-", "oneMinusR"}]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "6"}], "-", "d"}]], " ", "\[Rule]", " ", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"-", "6"}]], "pow2"]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "-", "d"}]], " ", "\[Rule]", " ", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"-", "4"}]], "pow2"]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"-", "5"}]], "pow2"]}], ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"-", "7"}]], "pow2"]}], ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"-", "3"}]], "pow2"]}], ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
         RowBox[{"2", "*", "pow2"}]}]}], "}"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["quadratic1", "2"], "\[Rule]", " ", 
       "quadratic1Squared"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "oneMinusR"}], "+", 
          RowBox[{"oneMinusR", " ", "powOneMinusR2", " ", "quadratic1"}]}], 
         ")"}], "2"], "\[Rule]", " ", "cubicPower"}], ",", " ", 
      RowBox[{
       SuperscriptBox["oneMinusR", 
        RowBox[{"-", "2"}]], " ", "\[Rule]", " ", 
       RowBox[{"1", "/", "oneMinusRSquared"}]}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"powOneMinusR2", " ", "quadratic1"}]}], ")"}], "2"], 
       "\[Rule]", " ", "squaredFactor1"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"powOneMinusR2", " ", "quadratic1"}]}], ")"}], "2"], 
       "\[Rule]", " ", 
       RowBox[{"cubicPower", "/", "oneMinusRSquared"}]}]}], "}"}]}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"InputForm", "[", "rewritten", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"rewritten", "[", 
  RowBox[{"[", "6", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Now", " ", "the", " ", "case", " ", "with", " ", "no", " ", 
   RowBox[{"intercrossing", "."}]}], " ", "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"rewritten", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"expected4wayFiniteSelfing", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "statesWithCounts"}], 
      ")"}]}], ")"}], "//", "FullSimplify"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rewritten", " ", "=", " ", 
   RowBox[{
    RowBox[{"rewritten", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}]], "\[Rule]", " ", "onePlus2RInverse"}], ",", 
       " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "6"}], "-", "d"}]], " ", "\[Rule]", " ", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"-", "6"}]], "pow2"]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "4"}], "-", "d"}]], " ", "\[Rule]", " ", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"-", "4"}]], "pow2"]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"-", "5"}]], "pow2"]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"-", "7"}]], "pow2"]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"-", "3"}]], "pow2"]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
        RowBox[{"2", "*", "pow2"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
        "powOneMinus2R"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "\[Rule]", " ", "oneMinusR"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "\[Rule]", " ", 
        RowBox[{"-", "oneMinusR"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", "*", "oneMinusR", "*", "r"}]}], ")"}], "^", "d"}], 
       "\[Rule]", " ", "complex1"}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "complex1"}], "+", "powOneMinus2R"}], ")"}], "\[Rule]", 
       " ", "complex2"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "2"}], "-", 
          RowBox[{"oneMinusR", "*", "r"}]}], ")"}], "^", "d"}], "\[Rule]", 
       " ", "complex3"}], ",", " ", 
      RowBox[{
       RowBox[{"oneMinusR", "^", "2"}], " ", "\[Rule]", " ", 
       "oneMinusRSquared"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "+", "powOneMinus2R", "-", 
        RowBox[{"6", "*", "r"}], "+", 
        RowBox[{"6", "*", "pow2", "*", "r"}], "-", 
        RowBox[{"3", "*", "powOneMinus2R", "*", "r"}], "-", 
        RowBox[{"4", "*", 
         RowBox[{"r", "^", "2"}]}], "+", 
        RowBox[{"2", "*", "powOneMinus2R", "*", 
         RowBox[{"r", "^", "2"}]}], "+", 
        RowBox[{"complex1", "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", "r"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "*", "r"}]}], ")"}]}]}], "\[Rule]", " ", "complex4"}],
       ",", " ", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "r"}]}], "\[Rule]", " ", "onePlus2R"}]}], "}"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"InputForm", "[", "rewritten", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "We", " ", "need", " ", "to", " ", "divide", " ", "by", " ", "the", " ", 
   "counts", " ", "in", " ", "the", " ", "implementation"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "-", "1"}], ",", " ", 
      RowBox[{
       RowBox[{"statesWithCounts", "[", 
        RowBox[{"[", "#1", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ")"}], "&"}], "/@", " ", 
  RowBox[{"Range", "[", 
   RowBox[{"1", ",", " ", 
    RowBox[{"Length", "[", "states", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"contributionsToMarkerValue", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"combinedProbabilities", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "4"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expected4wayFiniteSelfing", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "4"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", " ", 
    "uninformative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "0"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", 
    " ", "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "1"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData["statesWithCounts"], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Single", " ", "locus", " ", "homozygote", " ", "probability"}], 
   ",", " ", 
   RowBox[{"if", " ", 
    RowBox[{"there", "'"}], "s", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "5", "]"}], "]"}], "*", 
    RowBox[{"4", "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "6", "]"}], "]"}], "*", 
    RowBox[{"2", "/", "8"}]}], "+", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "7", "]"}], "]"}], "*", 
    RowBox[{"2", "/", "16"}]}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Single", " ", "locus", " ", "hetrozygote", " ", "probability", " ", "if", 
    " ", 
    RowBox[{"there", "'"}], "s", " ", "intercrossing"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", " ", 
      RowBox[{"4", "*", "%"}]}], ")"}], "/", "12"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Single", " ", "locus", " ", "homozygote", " ", "probability"}], 
   ",", " ", 
   RowBox[{"without", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"expected4wayFiniteSelfing", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"expected4wayFiniteSelfing", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "5", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "/", "8"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "7", "]"}], "]"}], "/", "16"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], " ", "or", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "without", 
   " ", "intercrossing"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "8", "]"}], "]"}], "/", "4"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "7", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"8", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "9", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "10", "]"}], "]"}], "/", "4"}]}], " ", "+", " ", 
   RowBox[{"8", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "11", "]"}], "]"}], "/", "32"}]}], " ", "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "12", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "3"}], "}"}], " ", "or", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "has", 
     " ", "non"}], "-", 
    RowBox[{"zero", " ", "probability"}]}], ",", " ", 
   RowBox[{"without", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "5", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "9", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "11", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "13", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "14", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "15", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "16", "]"}], "]"}], "/", "8"}]}], " ", "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "17", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "18", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"simplifiedTable", " ", "=", 
   RowBox[{
    RowBox[{"FullSimplify", "[", "power", "]"}], " ", "//", "MatrixForm"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"simplifiedTable2", " ", "=", " ", 
   RowBox[{"simplifiedTable", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["2", 
           RowBox[{"-", "d"}]]}], ")"}]}], "\[Rule]", " ", 
       SubscriptBox["p", "1"]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["2", 
          RowBox[{"-", "d"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "r"}]}]], "-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "-", "r"}], ")"}], 
          RowBox[{"1", "+", "d"}]], 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "r"}]}]], "+", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "d"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
          "d"]}]}], " ", "\[Rule]", " ", 
       SubscriptBox["p", "2"]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["2", 
          RowBox[{"-", "d"}]]}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "-", "r"}], ")"}], 
          RowBox[{"1", "+", "d"}]], 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "r"}]}]], "+", 
        FractionBox[
         RowBox[{"2", " ", "r"}], 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "r"}]}]], "+", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "d"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
          "d"]}]}], "\[Rule]", " ", 
       SubscriptBox["p", "3"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"simplifiedTable2", " ", "=", " ", 
   RowBox[{"simplifiedTable2", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "d"}]], 
        RowBox[{"Plus", "[", "c_", "]"}]}], "\[RuleDelayed]", " ", 
       RowBox[{
        RowBox[{"Plus", "[", "c", "]"}], " ", 
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"HoldForm", "[", 
         SuperscriptBox["2", 
          RowBox[{"-", "2"}]], "]"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "d"}]], 
        RowBox[{"Plus", "[", "c_", "]"}]}], "\[RuleDelayed]", " ", 
       RowBox[{
        RowBox[{"Plus", "[", "c", "]"}], " ", 
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"HoldForm", "[", 
         SuperscriptBox["2", 
          RowBox[{"-", "1"}]], "]"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "-", "d"}]], 
        RowBox[{"Plus", "[", "c_", "]"}]}], "\[RuleDelayed]", " ", 
       RowBox[{
        RowBox[{"Plus", "[", "c", "]"}], " ", 
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"HoldForm", "[", 
         SuperscriptBox["2", "1"], "]"}]}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"simplifiedTable2", " ", "=", " ", 
   RowBox[{"simplifiedTable2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SuperscriptBox["2", 
            RowBox[{"1", "+", "d"}]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}], "d"], "-", 
           RowBox[{"4", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "r"}]}], ")"}], "d"], " ", "r"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
             "d"]}]}], ")"}], " ", 
         SuperscriptBox["2", 
          RowBox[{"-", "d"}]]}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "r"}]}]], "\[Rule]", " ", 
       SubscriptBox["p", "4"]}], ",", " ", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"-", "d"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}], "d"], "-", 
           RowBox[{"4", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["2", 
             RowBox[{"2", "+", "d"}]], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "r"}]}], ")"}], "d"], " ", "r"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
             "d"]}]}], ")"}]}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "r"}]}]], "\[Rule]", " ", 
       SubscriptBox["p", "5"]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
           "d"]}], ")"}]}], "\[Rule]", " ", 
       SubscriptBox["p", "6"]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["2", 
          RowBox[{"-", "d"}]]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
           "d"]}], ")"}]}], "\[Rule]", " ", 
       SubscriptBox["p", "6"]}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["2", 
            RowBox[{"-", "d"}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}], 
            RowBox[{"1", "+", "d"}]]}], 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "r"}]}]], "+", 
         FractionBox[
          RowBox[{"4", " ", "r"}], 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "r"}]}]], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
          "d"], "-", 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"-", "d"}]], " ", 
          TagBox[
           SuperscriptBox["2", "1"],
           HoldForm]}]}], ")"}], "\[Rule]", " ", 
       SubscriptBox["p", "7"]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["2", "d"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
           "d"]}], ")"}]}], " ", "\[Rule]", " ", 
       SubscriptBox["p", "8"]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}], "d"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
           "d"]}], ")"}]}], "\[Rule]", " ", 
       SubscriptBox["p", "9"]}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "r"}]}], ")"}], "d"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
           "d"]}], ")"}]}], "\[Rule]", " ", 
       SubscriptBox["p", "10"]}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], "d"],
        "\[Rule]", " ", 
       SubscriptBox["p", "11"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"simplifiedTable2", "=", " ", 
   RowBox[{"simplifiedTable2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"HoldForm", "[", "c_", "]"}], " ", "\[RuleDelayed]", " ", "c"}],
      "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TeXForm", "[", "simplifiedTable2", " ", "]"}]}], "Input"]
},
WindowSize->{1680, 995},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.8}},
TrackCellChangeTimes->False,
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 883, 25, 77, "Input"],
Cell[1444, 47, 2294, 61, 165, "Input"],
Cell[3741, 110, 4200, 108, 363, "Input"],
Cell[7944, 220, 8776, 228, 367, "Input"],
Cell[16723, 450, 458, 12, 55, "Input"],
Cell[17184, 464, 134, 4, 32, "Input"],
Cell[17321, 470, 172, 6, 32, "Input"],
Cell[17496, 478, 264, 8, 32, "Input"],
Cell[17763, 488, 561, 15, 77, "Input"],
Cell[18327, 505, 147, 4, 32, "Input"],
Cell[18477, 511, 512, 14, 55, "Input"],
Cell[18992, 527, 142, 4, 32, "Input"],
Cell[19137, 533, 398, 10, 32, "Input"],
Cell[19538, 545, 3338, 82, 353, "Input"],
Cell[22879, 629, 46, 0, 32, "Input"],
Cell[22928, 631, 647, 20, 55, "Input"],
Cell[23578, 653, 704, 16, 77, "Input"],
Cell[24285, 671, 3684, 113, 201, "Input"],
Cell[27972, 786, 2613, 71, 187, "Input"],
Cell[30588, 859, 12917, 325, 1132, "Input"],
Cell[43508, 1186, 173, 4, 32, "Input"],
Cell[43684, 1192, 194, 6, 32, "Input"],
Cell[43881, 1200, 167, 4, 32, "Input"],
Cell[44051, 1206, 115, 3, 32, "Input"],
Cell[44169, 1211, 176, 4, 32, "Input"],
Cell[44348, 1217, 545, 16, 55, "Input"],
Cell[44896, 1235, 400, 8, 55, "Input"],
Cell[45299, 1245, 772, 24, 160, "Input"],
Cell[46074, 1271, 1240, 37, 121, "Input"],
Cell[47317, 1310, 215, 6, 32, "Input"],
Cell[47535, 1318, 606, 16, 77, "Input"],
Cell[48144, 1336, 195, 5, 32, "Input"],
Cell[48342, 1343, 732, 24, 63, "Input"],
Cell[49077, 1369, 920, 28, 88, "Input"],
Cell[50000, 1399, 920, 28, 88, "Input"],
Cell[50923, 1429, 188, 4, 32, "Input"],
Cell[51114, 1435, 7155, 204, 401, "Input"],
Cell[58272, 1641, 70, 1, 32, "Input"],
Cell[58345, 1644, 85, 2, 32, "Input"],
Cell[58433, 1648, 161, 3, 32, "Input"],
Cell[58597, 1653, 339, 10, 32, "Input"],
Cell[58939, 1665, 3689, 110, 288, "Input"],
Cell[62631, 1777, 195, 4, 32, "Input"],
Cell[62829, 1783, 420, 13, 32, "Input"],
Cell[63252, 1798, 5579, 140, 407, "Input"],
Cell[68834, 1940, 1118, 32, 55, "Input"],
Cell[69955, 1974, 1041, 30, 55, "Input"],
Cell[70999, 2006, 1039, 30, 55, "Input"],
Cell[72041, 2038, 1114, 32, 55, "Input"],
Cell[73158, 2072, 42, 0, 32, "Input"],
Cell[73203, 2074, 231, 6, 32, "Input"],
Cell[73437, 2082, 1017, 28, 55, "Input"],
Cell[74457, 2112, 376, 12, 55, "Input"],
Cell[74836, 2126, 197, 5, 32, "Input"],
Cell[75036, 2133, 1054, 29, 55, "Input"],
Cell[76093, 2164, 250, 7, 32, "Input"],
Cell[76346, 2173, 1096, 31, 55, "Input"],
Cell[77445, 2206, 385, 11, 32, "Input"],
Cell[77833, 2219, 1535, 43, 77, "Input"],
Cell[79371, 2264, 173, 5, 32, "Input"],
Cell[79547, 2271, 10801, 332, 339, "Input"]
}
]
*)

(* End of internal cache information *)
