/*
===========================================================
search_api.js (version 2.1)
-----------------------------------------------------------
JavaScript API for creating a location search widget in a web page.
The primary data source is a dedicated database and data service created for this api.
The ESRI Online Geocoding Service ( http://geocode.arcgis.com/arcgis/ ) is used as a secondary data source when no api service results found.
-----------------------------------------------------------
This API requires jQuery ( https://jquery.com/ ) to be loaded.
-----------------------------------------------------------
U.S. Geological Survey, Texas Water Science Center, Austin
https://txpub.usgs.gov/DSS/search_api/
===========================================================
*/
void 0===window.search_api&&(window.search_api={}),search_api.verbose=!1,search_api.version="2.1",void 0===window.console&&(window.console={log:function(){},warn:function(){},error:function(){},clear:function(){}}),search_api._isLoadedJq=void 0!==window.jQuery?!0:!1,search_api._isLoadedJq||console.error("The search_api requires jQuery. The search_api will not function properly."),search_api._caller="jsapi_2.1",search_api._apiServiceUrl="https://txpub.usgs.gov/DSS/search_api/2.1/services/services.ashx/search",search_api._2ndServiceUrl="https://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer/findAddressCandidates",search_api._2ndOkTypes=["STATE OR PROVINCE","COUNTY","CITY","OTHER POPULATED PLACE","STATE CAPITAL","NATIONAL CAPITAL","STREAM","CANAL","CHANNEL","LAKE","RESERVOIR","CAPE","BAY","BASIN","DAM","WATERFALL","MARINA","OTHER WATER FEATURE","SPRING","PARK","MUSEUM","HOSPITAL","SCHOOL","HISTORICAL MONUMENT","RUIN","AIRPORT","SPORTS CENTER","TOURIST ATTRACTION","AMUSEMENT PARK","MILITARY BASE","POLICE STATION",""],search_api._statesLong2short={ALASKA:"AK",HAWAII:"HI","PUERTO RICO":"PR",ALABAMA:"AL",ARKANSAS:"AR",ARIZONA:"AZ",CALIFORNIA:"CA",COLORADO:"CO",CONNECTICUT:"CT","WASHINGTON, D.C.":"DC","DISTRICT OF COLUMBIA":"DC",DELAWARE:"DE",FLORIDA:"FL",GEORGIA:"GA",IOWA:"IA",IDAHO:"ID",ILLINOIS:"IL",INDIANA:"IN",KANSAS:"KS",KENTUCKY:"KY",LOUISIANA:"LA",MASSACHUSETTS:"MA",MARYLAND:"MD",MAINE:"ME",MICHIGAN:"MI",MINNESOTA:"MN",MISSOURI:"MO",MISSISSIPPI:"MS",MONTANA:"MT","NORTH CAROLINA":"NC","NORTH DAKOTA":"ND",NEBRASKA:"NE","NEW HAMPSHIRE":"NH","NEW JERSEY":"NJ","NEW MEXICO":"NM",NEVADA:"NV","NEW YORK":"NY",OHIO:"OH",OKLAHOMA:"OK",OREGON:"OR",PENNSYLVANIA:"PA","RHODE ISLAND":"RI","SOUTH CAROLINA":"SC","SOUTH DAKOTA":"SD",TENNESSEE:"TN",TEXAS:"TX",UTAH:"UT",VIRGINIA:"VA","VIRGIN ISLANDS":"VI",VERMONT:"VT",WASHINGTON:"WA",WISCONSIN:"WI","WEST VIRGINIA":"WV",WYOMING:"WY","":"N/A"},search_api._stateAbbrevs=[],search_api._isLoadedJq&&$.each(search_api._statesLong2short,function(e,t){search_api._stateAbbrevs.push(t)}),search_api._opt_default={size:"md",width:0,placeholder:"Search for a place",tooltip:"",lat_min:-90,lat_max:90,lon_min:-180,lon_max:180,search_states:"all",menu_min_char:2,menu_max_entries:50,menu_height:0,include_gnis_major:!0,include_gnis_minor:!1,include_state:!0,include_zip_code:!0,include_area_code:!1,include_usgs_sw:!1,include_usgs_gw:!1,include_usgs_sp:!1,include_usgs_at:!1,include_usgs_ot:!1,include_huc2:!1,include_huc4:!1,include_huc6:!1,include_huc8:!1,include_huc10:!1,include_huc12:!1,on_search:function(){},on_update:function(){},on_result:function(){},on_failure:function(){},verbose:!1},search_api.create=function(e,t){var a="[create]: ";if(!search_api._isLoadedJq)return void search_api._console(a+"The search_api requires jQuery - widget not created","warn");if(void 0===e)return void search_api._console(a+"id of element to create widget in must be input - widget not created","warn");if("string"!=typeof e)return void search_api._console(a+"input id must be a string - widget not created","warn");if(1!==$("#"+e).length)return void search_api._console(a+"unique element with id '"+e+"' does not exist - widget not created","warn");void 0===t&&(t={});var s={id:"#"+e};return $(s.id).empty().html('<div class="search-api-container"><span class="search-api-icon"><svg focusable="false" xmlns="http://www.w3.org/2000/svg"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path></svg></span><span><input type="text" value=""/></span><span class="search-api-spinner search-api-spinner-hidden"></span></div>'),s._menu={container:$('<div class="search-api-menu" data-id="'+s.id+'"></div>').appendTo("body")},s._getContainer=function(){return $(this.id).find(".search-api-container")},s._getIcon=function(){return $(this.id).find(".search-api-icon")},s._getTextbox=function(){return $(this.id).find("input")},s._getSpinner=function(){return $(this.id).find(".search-api-spinner")},s._getMenu=function(){return s._menu.container},s._getSearchTermStates=function(){var e=$.trim(s._getTextbox().val()).toUpperCase().replace(/[^\000-\177]/g,"").replace(/[\000-\037]/g,"").replace(/[\/\\^$+?()|[\]{}%]/g,"").replace(/,+/g," ").replace(/\s+/g," ").replace(/^ST /,"SAINT "),t="",a=e.split(" ");return a.length>=2&&$.inArray(a[a.length-1],search_api._stateAbbrevs)>=0&&(t=a.pop(),e=a.join(" ")),""!==t&&"ALL"===s.opts.search_states||(""!==t&&"ALL"!==s.opts.search_states?$.inArray(t,s.opts.search_states.split(","))<=-1&&(e=e+" "+t,t=s.opts.search_states):t=s.opts.search_states),{term:e,states:t}},s.setOpts=function(e,t){var a="[setOpts "+this.id+"]: ",i=e;if(2===arguments.length&&"string"==typeof arguments[0]&&(i={},i[arguments[0]]=arguments[1]),"object"!=typeof i)return search_api._console(a+"input options must be a object of option values - options not updated","warn"),this;$.each(i,function(e,t){delete i[e],i[e.toLowerCase()]=t});var n=0,o=this;return void 0===o.opts&&(o.opts={}),$.each(search_api._opt_default,function(e,t){void 0===o.opts[e]&&(o.opts[e]=t),void 0!==i[e]&&("number"!=typeof t||isNaN(parseFloat(i[e]))||(i[e]=parseFloat(i[e])),"boolean"!=typeof t||1!==i[e]&&!/^\s*T/i.test(i[e]+"")||(i[e]=!0),"boolean"!=typeof t||0!==i[e]&&!/^\s*F/i.test(i[e]+"")||(i[e]=!1),typeof i[e]==typeof t?o.opts[e]=i[e]:(search_api._console(a+"'"+e+"' option value must be a "+typeof t+" - option ignored","warn"),n++))}),$.each(i,function(e){void 0===search_api._opt_default[e]&&(search_api._console(a+"unrecognized option ignored: "+e,"warn"),n++)}),(s.opts.lat_min<-90||s.opts.lat_min>90)&&(search_api._console(a+"invalid 'lat_min' option ("+s.opts.lat_min+"): value must be between -90 and 90 degrees, inclusive - default used","warn"),n++,s.opts.lat_min=search_api._opt_default.lat_min),(s.opts.lat_max<-90||s.opts.lat_max>90)&&(search_api._console(a+"invalid 'lat_max' option ("+s.opts.lat_max+"): value must be between -90 and 90 degrees, inclusive - default used","warn"),n++,s.opts.lat_max=search_api._opt_default.lat_max),(s.opts.lon_min<-180||s.opts.lon_min>180)&&(search_api._console(a+"invalid 'lon_min' option ("+s.opts.lon_min+"): value must be between -180 and 180 degrees, inclusive - default used","warn"),n++,s.opts.lon_min=search_api._opt_default.lon_min),(s.opts.lon_max<-180||s.opts.lon_max>180)&&(search_api._console(a+"invalid 'lon_max' option ("+s.opts.lon_max+"): value must be between -180 and 180 degrees, inclusive - default used","warn"),n++,s.opts.lon_max=search_api._opt_default.lon_max),s.opts.lat_min>s.opts.lat_max&&(search_api._console(a+"'lat_min' option must be less than 'lat_max' - defaults for both used","warn"),n++,s.opts.lat_min=search_api._opt_default.lat_min,s.opts.lat_max=search_api._opt_default.lat_max),s.opts.lon_min>s.opts.lon_max&&(search_api._console(a+"'lon_min' option must be less than 'lon_max' - defaults for both used","warn"),n++,s.opts.lon_min=search_api._opt_default.lon_min,s.opts.lon_max=search_api._opt_default.lon_max),s.opts.menu_min_char<1&&(search_api._console(a+"invalid 'menu_min_char' option ("+s.opts.menu_min_char+"): value must be at least 1 - default used","warn"),n++,s.opts.menu_min_char=search_api._opt_default.menu_min_char),s.opts.menu_max_entries<1&&(search_api._console(a+"invalid 'menu_max_entries' option ("+s.opts.menu_max_entries+"): value must be at least 1 - default used","warn"),n++,s.opts.menu_max_entries=search_api._opt_default.menu_max_entries),s.opts.menu_height<0&&(search_api._console(a+"invalid 'menu_height' option ("+s.opts.menu_height+"): value must be greater or equal to 0 - default used","warn"),n++,s.opts.menu_height=search_api._opt_default.menu_height),$.inArray(s.opts.size,["lg","md","sm","xs"])<=-1&&(search_api._console(a+"invalid 'size' option ('"+s.opts.size+"'): string must be one of 'lg','md','sm', or 'xs' - default used","warn"),n++,s.opts.size=search_api._opt_default.size),s.opts.width<0&&(search_api._console(a+"invalid 'width' option ("+s.opts.width+"): value must be greater or equal to 0 - default used","warn"),n++,s.opts.width=search_api._opt_default.width),s.opts.search_states=s.opts.search_states.replace(/\s+/g,"").toUpperCase(),$.each(s.opts.search_states.split(","),function(e,t){return $.inArray(t,search_api._stateAbbrevs.concat("ALL"))<=-1?(s.opts.search_states=search_api._opt_default.search_states.toUpperCase(),search_api._console(a+"1 or more 'search_states' is not a valid 2-character State or Territory abbreviation - default used","warn"),n++,!1):void 0}),void 0!==i.verbose&&(search_api.verbose=i.verbose),delete s.opts.verbose,search_api._console(a+"options set "+(n>0?"with "+n+" warnings":"ok")),search_api._setup(this)},s.on=function(e,t,a){if(e=e.toLowerCase(),/^on_/.test(e)||(e="on_"+e),void 0===a&&(a=!1),null===t)t=function(){};else if(a){var i=this.opts[e],n=t;t=function(){i(s),n(s)}}var o={};return o[e]=t,this.setOpts(o)},s.trigger=function(e){var t="[trigger "+this.id+"]: ";return $.each(e.replace(/,+/g," ").replace(/\s+/g," ").toLowerCase().split(" "),function(e,a){a=a.replace(/^on_/,""),$.inArray(a,["search","update","result","failure"])>=0?(s.opts["on_"+a](s),search_api._console(t+a+" event triggered")):search_api._console(t+"invalid event '"+a+"'","warn")}),this},s.visible=function(e){var t="[visible "+this.id+"]: ";switch(e){case!0:this._getContainer().add(this._getMenu()).removeClass("search-api-hidden");break;case!1:this._getContainer().add(this._getMenu()).addClass("search-api-hidden");break;case void 0:this._getContainer().add(this._getMenu()).toggleClass("search-api-hidden");break;default:return search_api._console(t+"invalid input","warn"),this}return search_api._console(t+this.isVisible()),this},s.isVisible=function(){return!this._getContainer().is(".search-api-hidden")},s.enable=function(e){var t="[enable "+this.id+"]: ";switch(e){case!0:this._getContainer().add(this._getMenu()).removeClass("search-api-disabled");break;case!1:this._getContainer().add(this._getMenu()).addClass("search-api-disabled");break;case void 0:this._getContainer().add(this._getMenu()).toggleClass("search-api-disabled");break;default:return search_api._console(t+"invalid input","warn"),this}return this._getTextbox().prop("disabled",!this.isEnabled()),search_api._console(t+this.isEnabled()),this},s.isEnabled=function(){return!this._getContainer().is(".search-api-disabled")},s.val=function(e){var t="[val "+this.id+"]: ";switch(typeof e){case"string":return this._getTextbox().val(e),this;case"undefined":return e=this._getTextbox().val();default:return search_api._console(t+"invalid input","warn"),this}},s.getSuggestions=function(){var e={type:"FeatureCollection",features:[]};return $.each(s._getMenu().find(".search-api-menu-item"),function(t,a){e.features.push({type:"Feature",geometry:{type:"Point",coordinates:[$(a).data("properties").Lon,$(a).data("properties").Lat]},properties:$(a).data("properties")})}),e},s.destroy=function(){var e="[destroy "+this.id+"]: ";$(window).off("resize.search_api_"+this.id),this._getTextbox().add(this._getIcon()).add(this._getMenu()).off(".search_api"),this._getMenu().remove(),$(this.id).empty(),delete search_api._widgets[this.id];var t=this;return $.each(t,function(e,a){delete t[e]}),search_api._console(e+"widget destroyed and no longer usable"),this},s.result=void 0,search_api._console("[create #"+e+"]: widget created"),s.setOpts(t)},search_api._setup=function(e){return e._getTextbox().attr("placeholder",e.opts.placeholder).prop("title",e.opts.tooltip),e._getContainer().removeClass("search-api-lg search-api-md search-api-sm search-api-xs").addClass("search-api-"+e.opts.size).css({width:e.opts.width>0?e.opts.width+"px":""}),e._menu.cache={},e._getMenu().removeClass("search-api-lg search-api-md search-api-sm search-api-xs").addClass("search-api-"+e.opts.size),e._menu.position=function(){var t=$(window).height(),a=e._getTextbox().offset().top-$(document).scrollTop(),s=t-a,i="initial",n="initial",o="initial",r="";s>a?(i=e._getTextbox().offset().top+e._getTextbox().outerHeight(),o=.9*s,r="search-api-menu-down"):(n=t-e._getTextbox().offset().top,o=.9*a,r="search-api-menu-up"),e._getMenu().css({left:e._getTextbox().offset().left-e._getIcon().outerWidth(),width:e._getIcon().outerWidth()+e._getTextbox().outerWidth()+e._getSpinner().outerWidth(),top:i,bottom:n}).removeClass("search-api-menu-down search-api-menu-up").addClass(r).find(".search-api-menu-content").css({"max-height":e.opts.menu_height>0?Math.min(e.opts.menu_height,o):o})},$(window).off("resize.search_api_"+e.id).on("resize.search_api_"+e.id,e._menu.position),e._closeMenu=function(){return e._getMenu().stop().fadeOut(200,function(){e._getMenu().empty(),e.trigger("update")}),this},e._menu.update=function(t,a){if(a.length<=0)return e._getTextbox().addClass("search-api-no-suggestions"),void e._closeMenu();e._getTextbox().addClass("search-api-have-suggestions"),e._getMenu().html('<div class="search-api-menu-title">'+(a.length>=e.opts.menu_max_entries?"Top ":"")+a.length+' Results<div class="search-api-menu-close" onclick="search_api._widgets[ $(this).closest(\'.search-api-menu\').data(\'id\') ]._closeMenu();">&#10006;</div></div><div class="search-api-menu-content"></div>');var s;try{s=new RegExp("("+t.replace(/\*/g,"").split(" ").join("|")+")","gi")}catch(i){s=new RegExp("()")}var n="X";$.each(a,function(t,a){a.Category!==n&&($('<div class="search-api-menu-separator">'+a.Category+(100!==a.PercentMatch?" (Closest Matches)":"")+"</div>").appendTo(e._getMenu().find(".search-api-menu-content")),n=a.Category),$('<div class="search-api-menu-item">'+a.Name.replace(s,'<span class="search-api-menu-item-highlight">$1</span>')+("N/A"!==a.County&&"N/A"!==a.State?' <br/><span class="search-api-menu-item-info">'+a.County+", "+a.State+"</span>":"")+(100!==a.PercentMatch?' <br/><span class="search-api-menu-item-info">'+a.PercentMatch+"% match":"")+"</div>").data("properties",a).appendTo(e._getMenu().find(".search-api-menu-content"))}),1==a.length&&e._getMenu().find(".search-api-menu-item").addClass("search-api-menu-item-selected"),e._menu.position(),e._getMenu().stop().fadeIn(200),e._menu.position(),e.trigger("update")},e._getTextbox().off("blur.search_api").on("blur.search_api",function(){e._closeMenu()}).off("keyup.search_api  input.search_api  propertychange.search_api  paste.search_api").on("keyup.search_api  input.search_api  propertychange.search_api  paste.search_api",function(t){$.inArray(t.which,[13,27,33,34,35,36,37,38,39,40])>-1||search_api._search(e)}).off("keydown.search_api").on("keydown.search_api",function(t){switch(t.which){case 38:case 40:if(""===e._getMenu().html())return;var a,s=$(".search-api-menu-item-selected",e._getMenu()).eq(0);if(a=s.length<=0?40===t.which?$(".search-api-menu-item",e._getMenu()).first():$(".search-api-menu-item",e._getMenu()).last():40===t.which?s.nextAll(".search-api-menu-item").first():s.prevAll(".search-api-menu-item").first(),$(".search-api-menu-item-selected",e._getMenu()).removeClass("search-api-menu-item-selected"),a.addClass("search-api-menu-item-selected"),a.length>0){var i=parseInt(e._getMenu().find(".search-api-menu-content").css("max-height")),n=a.outerHeight(),o=e._getMenu().find(".search-api-menu-content").scrollTop(),r=a.offset().top-e._getMenu().find(".search-api-menu-content").offset().top;r+n-i>0?e._getMenu().find(".search-api-menu-content").scrollTop(r+n+o-i):0>r&&e._getMenu().find(".search-api-menu-content").scrollTop(r+o)}else e._getMenu().find(".search-api-menu-content").scrollTop(0);break;case 27:e._closeMenu();break;case 13:var s=$(".search-api-menu-item-selected",e._getMenu()).eq(0);s.length>0&&s.click()}}),e._getMenu().off("mouseenter.search_api").on("mouseenter.search_api",".search-api-menu-item",function(){$(".search-api-menu-item-selected").removeClass("search-api-menu-item-selected"),$(this).addClass("search-api-menu-item-selected")}).off("mouseleave.search_api").on("mouseleave.search_api",".search-api-menu-item",function(){$(".search-api-menu-item-selected").removeClass("search-api-menu-item-selected")}).off("click.search_api").on("click.search_api",".search-api-menu-item",function(t){e.result={type:"Feature",geometry:{type:"Point",coordinates:[$(this).data("properties").Lon,$(this).data("properties").Lat]},properties:$(this).data("properties")},e._closeMenu(),e._getTextbox().val(""),e.trigger("result")}),void 0===search_api._widgets&&(search_api._widgets={}),search_api._widgets[e.id]=e,e},search_api._search=function(e){var t="[_search "+e.id+"]: ";if(e._getTextbox().val()!==e._menu.currentSearchVal){e._menu.currentSearchVal=e._getTextbox().val(),clearTimeout(e._menu.timer);try{e._menu.xhr1.abort()}catch(a){}try{e._menu.xhr2.abort()}catch(a){}if(e._getTextbox().removeClass("search-api-have-suggestions search-api-no-suggestions"),$.trim(e._getTextbox().val()).length<e.opts.menu_min_char)return search_api._console(t+"not enough characters entered to search (at least "+e.opts.menu_min_char+" needed)"),void e._closeMenu();e.trigger("search");var s=e._getSearchTermStates(),i=s.term,n=s.states,o=i.split(/\s/);o.length<2&&o.push("X");var r=!0,c=parseFloat(o[0]);(isNaN(c)||c<e.opts.lat_min||c>e.opts.lat_max)&&(r=!1);var p=-Math.abs(parseFloat(o[1]));if((isNaN(p)||p<e.opts.lon_min||p>e.opts.lon_max)&&(r=!1),r)return search_api._console(t+"parsed as lat-lon"),void e._menu.update(i,[{Id:null,Category:"Latitude-Longitude Coordinate",Label:"Coordinate "+c+", "+p,Name:"Coordinate "+c+", "+p,County:"N/A",State:"N/A",ElevFt:"N/A",GnisId:"N/A",Lat:c,Lon:p,LatMin:c-1e-6,LatMax:c+1e-6,LonMin:p-1e-6,LonMax:p+1e-6,PercentMatch:100,Source:"LAT_LON"}]);var u=i+"|"+n;return u in e._menu.cache?(search_api._console(t+"cached value used"),void e._menu.update(i,e._menu.cache[u])):void(e._menu.timer=setTimeout(function(){e._getSpinner().removeClass("search-api-spinner-hidden"),search_api._console(t+"calling api data service: '"+i+"'");var a=[];$.support&&($.support.cors=!0),e._menu.xhr1=$.ajax({url:search_api._apiServiceUrl,data:{term:i,search_states:n,lat_min:e.opts.lat_min,lat_max:e.opts.lat_max,lon_min:e.opts.lon_min,lon_max:e.opts.lon_max,include_gnis_major:e.opts.include_gnis_major,include_gnis_minor:e.opts.include_gnis_minor,include_state:e.opts.include_state,include_zip_code:e.opts.include_zip_code,include_area_code:e.opts.include_area_code,include_usgs_sw:e.opts.include_usgs_sw,include_usgs_gw:e.opts.include_usgs_gw,include_usgs_sp:e.opts.include_usgs_sp,include_usgs_at:e.opts.include_usgs_at,include_usgs_ot:e.opts.include_usgs_ot,include_huc2:e.opts.include_huc2,include_huc4:e.opts.include_huc4,include_huc6:e.opts.include_huc6,include_huc8:e.opts.include_huc8,include_huc10:e.opts.include_huc10,include_huc12:e.opts.include_huc12,top_n:e.opts.menu_max_entries,caller:search_api._caller},type:"GET",dataType:"json",async:!0,cache:!0,timeout:3e3,success:function(e){return void 0!==e.error?void search_api._console(t+"api service error: "+e.error,"warn"):e.constructor!==Array?void search_api._console(t+"invalid api service response: not array","warn"):void(a=e)},error:function(e,a,s){"abort"!==e.statusText.toLowerCase()&&search_api._console(t+"api service error: "+e.statusText,"warn")},complete:function(){return a.length>0?(search_api._console(t+"api service returned "+a.length+" results"),e._getSpinner().addClass("search-api-spinner-hidden"),e._menu.update(i,a),void(e._menu.cache[u]=a)):(search_api._console(t+"api service returned no results - calling secondary service"),void(e._menu.xhr2=$.ajax({url:search_api._2ndServiceUrl,data:{f:"json",singleLine:i,CountryCode:"USA",searchExtent:[e.opts.lon_min,e.opts.lat_min,e.opts.lon_max,e.opts.lat_max].join(","),maxLocations:e.opts.menu_max_entries,outFields:["Type","Region","Subregion","X","Y","Loc_name"].join(",")},type:"GET",dataType:"json",async:!0,cache:!0,timeout:5e3,success:function(s){if(void 0===s.candidates)return void search_api._console(t+"invalid secondary service response: no candidate field","warn");if(search_api._console(t+"secondary service returned "+s.candidates.length+" total results"),!(s.candidates.length<=0)){var i=n.split(",");"ALL"===i[0]&&(i=search_api._stateAbbrevs);var o={},r=[];$.each(s.candidates,function(t,a){if(void 0===a.address||void 0===a.score||isNaN(parseFloat(a.score))||a.score<95||void 0===a.attributes||void 0===a.attributes.Type||$.inArray(a.attributes.Type.toUpperCase(),search_api._2ndOkTypes)<0||void 0===a.attributes.X||a.attributes.X<e.opts.lon_min||a.attributes.X>e.opts.lon_max||void 0===a.attributes.Y||a.attributes.Y<e.opts.lat_min||a.attributes.Y>e.opts.lat_max)return!0;$.each(a.attributes,function(e,t){t=$.trim(t),a.attributes[e]=""!==t?t:"N/A"});var s=search_api._statesLong2short[a.attributes.Region.toUpperCase()];if(void 0===s||$.inArray(s,i)<0)return!0;var n=a.attributes.Subregion;if("N/A"===n)return!0;if(/ County/i.test(n)||(n+=" County"),"N/A"!==a.attributes.Type)var c=a.attributes.Type,p=$.trim(a.address.split(",")[0]);else var c="Addresses and Other Suggestions",p=$.trim(a.address);void 0===o[c]&&(o[c]={}),void 0===o[c][s]&&(o[c][s]={}),void 0===o[c][s][n]&&(o[c][s][n]=[]);var u=[c,s,n,p].join("|");$.inArray(u,r)<0&&(r.push(u),o[c][s][n].push({Id:null,Category:c,Label:p+" ("+n+", "+s+")",Name:p,County:n,State:s,ElevFt:"N/A",GnisId:"N/A",Lat:parseFloat(a.attributes.Y),Lon:parseFloat(a.attributes.X),LatMin:a.extent.ymin,LatMax:a.extent.ymax,LonMin:a.extent.xmin,LonMax:a.extent.xmax,PercentMatch:a.score,Source:"ESRI:"+a.attributes.Loc_name}))});var c=[];$.each(o,function(e){c.push(e)}),$.each(c.sort(),function(e,t){var s=[];$.each(o[t],function(e){s.push(e)}),$.each(s.sort(),function(e,s){var i=[];$.each(o[t][s],function(e){i.push(e)}),$.each(i.sort(),function(e,i){a=a.concat(o[t][s][i])})})})}},error:function(e){"abort"!==e.statusText.toLowerCase()&&search_api._console(t+"secondary service error: "+e.statusText,"warn")},complete:function(s){search_api._console(t+"secondary service returned "+a.length+" results after filtering"),e._getSpinner().addClass("search-api-spinner-hidden"),e._menu.update(i,a),"abort"!==s.statusText.toLowerCase()&&(e._menu.cache[u]=a),a.length<=0&&e.trigger("failure")}})))}})},50))}},search_api._console=function(e,t){if(window.console){if(void 0===e&&(e=""),void 0===t&&(t="D"),t=t.substring(0,1).toUpperCase(),"D"===t&&!search_api.verbose)return 0;switch(t){case"W":console.warn((new Date).toLocaleTimeString()+" search_api "+search_api.version+" WARNING "+e);break;case"E":console.error((new Date).toLocaleTimeString()+" search_api "+search_api.version+" ERROR "+e);break;case"D":console.log((new Date).toLocaleTimeString()+" search_api "+search_api.version+" "+e);break;default:console.log((new Date).toLocaleTimeString()+" search_api "+search_api.version+" "+e)}}},search_api._isLoadedJq&&console.log((new Date).toLocaleTimeString()+" search_api "+search_api.version+" [load]: api loaded and available"),void 0!==window.L&&void 0!==L.Control&&void 0!==L.Control.extend&&void 0!==L.control&&void 0!==L.Map&&void 0!==L.Map.mergeOptions&&void 0!==L.Map.addInitHook&&(L.Control.Search=L.Control.extend({options:{position:"topright",autoResult:!0},getWidget:function(){return this._widget},onAdd:function(e){for(var t=L.DomUtil.create("div","",e.getContainer()),a=1;null!==L.DomUtil.get("search_api_"+a);)a++;t.id="search_api_"+a,L.DomEvent.disableClickPropagation(t);var s=L.Util.extend({},this.options);return s.autoResult===!0&&"function"!=typeof s.on_result&&(s.on_result=function(t){e.fitBounds([[t.result.properties.LatMin,t.result.properties.LonMin],[t.result.properties.LatMax,t.result.properties.LonMax]]).openPopup('<div style="text-align:center;"><b>'+t.result.properties.Label+"</b><br/>"+t.result.properties.Category+"</div>",[t.result.properties.Lat,t.result.properties.Lon])}),delete s.position,delete s.autoResult,this._widget=search_api.create(t.id,s),t},onRemove:function(e){this._widget.destroy()}}),L.control.search=function(e){return new L.Control.Search(e)},L.Map.mergeOptions({searchControl:!1}),L.Map.addInitHook(function(){"object"==typeof this.options.searchControl&&(this.searchControl=new L.Control.Search(this.options.searchControl).addTo(this))}),console.log((new Date).toLocaleTimeString()+" search_api "+search_api.version+" [load]: Leaflet plugin loaded and available"));
