/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.test;

import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.test.Test;
import java.util.ArrayList;

public class MesgIndexTest
implements Test,
MesgListener {
    private String szError = "";
    private ArrayList<MesgIndexList> MesgIndexLists = new ArrayList();

    @Override
    public void onMesg(Mesg mesg) {
        Object[] objectArray = this.MesgIndexLists.toArray();
        if (this.szError != "") {
            return;
        }
        Field field = mesg.getField("message_index");
        if (field == null) {
            return;
        }
        if (this.containsMesg(mesg.getName())) {
            int n = this.getIndex(mesg.getName());
            if (((MesgIndexList)objectArray[n]).contains(Integer.parseInt(field.getValue().toString()))) {
                this.szError = "Mesg " + mesg.getName() + " already contains index " + field.getValue();
            }
            ((MesgIndexList)objectArray[n]).add(Integer.parseInt(field.getValue().toString()));
        } else {
            MesgIndexList mesgIndexList = new MesgIndexList(mesg.getName());
            mesgIndexList.add(Integer.parseInt(field.getValue().toString()));
            this.MesgIndexLists.add(mesgIndexList);
        }
    }

    private boolean containsMesg(String string) {
        if (this.MesgIndexLists.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.MesgIndexLists.size(); ++i) {
            if (this.MesgIndexLists.get(i).getName() != string) continue;
            return true;
        }
        return false;
    }

    private int getIndex(String string) {
        if (this.MesgIndexLists.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.MesgIndexLists.size(); ++i) {
            if (this.MesgIndexLists.get(i).getName() != string) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getError() {
        if (this.szError != "") {
            return this.szError;
        }
        for (int i = 0; i < this.MesgIndexLists.size(); ++i) {
            String string = this.MesgIndexLists.get(i).verify();
            if (string == "") continue;
            return string;
        }
        return null;
    }

    private class MesgIndexList {
        private String szName;
        private ArrayList<Integer> MesgIndexes = new ArrayList();

        MesgIndexList(String string) {
            this.szName = string;
        }

        public void add(int n) {
            this.MesgIndexes.add(n);
        }

        public boolean contains(int n) {
            return this.MesgIndexes.contains(n);
        }

        public String getName() {
            return this.szName;
        }

        public String verify() {
            if (this.MesgIndexes.isEmpty()) {
                return "Message contains no indexes";
            }
            int n = this.MesgIndexes.get(0);
            for (int i = 0; i < this.MesgIndexes.size(); ++i) {
                if (this.MesgIndexes.get(i) <= n) continue;
                n = this.MesgIndexes.get(i);
            }
            if (n == 0) {
                return null;
            }
            do {
                if (this.MesgIndexes.contains(--n)) continue;
                return "Message index " + n + " missing from " + this.szName + " messages.";
            } while (n > 0);
            return null;
        }
    }
}

