/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.tokenizers.Tokenizer;

public abstract class CharacterDelimitedTokenizer
extends Tokenizer {
    private static final long serialVersionUID = -3091468793633408477L;
    protected String m_Delimiters = " \r\n\t.,;:'\"()?!";

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe delimiters to use\n\t(default ' \\r\\n\\t.,;:'\"()?!').", "delimiters", 1, "-delimiters <value>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-delimiters");
        result.add(this.getDelimiters());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("delimiters", options);
        if (tmpStr.length() != 0) {
            this.setDelimiters(tmpStr);
        } else {
            this.setDelimiters(" \r\n\t.,;:'\"()?!");
        }
    }

    public String getDelimiters() {
        return this.m_Delimiters;
    }

    public void setDelimiters(String value) {
        this.m_Delimiters = Utils.unbackQuoteChars(value);
    }

    public String delimitersTipText() {
        return "Set of delimiter characters to use in tokenizing (\\r, \\n and \\t can be used for carriage-return, line-feed and tab)";
    }
}

