/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.structural;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponseDecomposer;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.structural.Component;
import ec.tstoolkit.structural.ComponentUse;
import ec.tstoolkit.structural.ModelSpecification;
import ec.tstoolkit.structural.SeasonalModel;
import ec.tstoolkit.ucarima.UcarimaModel;

public class BasicStructuralModel
implements ISsf,
Cloneable {
    public final int freq;
    private int[] m_cmps;
    private Matrix m_tsvar;
    double lVar;
    double sVar;
    double seasVar;
    double cVar;
    double nVar;
    double cDump;
    double cPeriod;
    private double ccos;
    private double csin;
    SeasonalModel seasModel;
    private static Matrix g_VTS2;
    private static Matrix g_VTS3;
    private static Matrix g_VTS4;
    private static Matrix g_VTS6;
    private static Matrix g_VTS12;

    private static Matrix _tsvar(int freq) {
        int n = freq - 1;
        Matrix M = new Matrix(n, freq);
        M.diagonal().set(1.0);
        M.column(n).set(-1.0);
        Matrix O = SymmetricMatrix.XXt(M);
        Householder qr = new Householder(false);
        qr.decompose(O);
        Matrix Q = qr.solve(M);
        Matrix H = new Matrix(freq, n);
        for (int i = 0; i < freq; ++i) {
            double z = Math.PI * 2 * (double)(i + 1) / (double)freq;
            for (int j = 0; j < n / 2; ++j) {
                H.set(i, 2 * j, Math.cos((double)(j + 1) * z));
                H.set(i, 2 * j + 1, Math.sin((double)(j + 1) * z));
            }
            if (n % 2 != 1) continue;
            H.set(i, n - 1, Math.cos((double)(freq / 2) * z));
        }
        return SymmetricMatrix.XXt(Q.times(H));
    }

    private static ComponentUse getUse(double var) {
        if (var < 0.0) {
            return ComponentUse.Unused;
        }
        if (var == 0.0) {
            return ComponentUse.Fixed;
        }
        return ComponentUse.Free;
    }

    private static double getVar(ComponentUse use) {
        if (use == ComponentUse.Unused) {
            return -1.0;
        }
        if (use == ComponentUse.Fixed) {
            return 0.0;
        }
        return 1.0;
    }

    private static double getVar(SeasonalModel use) {
        if (use == SeasonalModel.Unused) {
            return -1.0;
        }
        if (use == SeasonalModel.Fixed) {
            return 0.0;
        }
        return 1.0;
    }

    public static void initQSeas(int freq, SeasonalModel sm, SubMatrix Q) {
        if (sm == SeasonalModel.Dummy) {
            Q.set(0.0);
            Q.set(freq - 2, freq - 2, 1.0);
        } else if (sm == SeasonalModel.Crude) {
            Q.set(1.0);
        } else if (sm == SeasonalModel.HarrisonStevens) {
            double v = 1.0 / (double)freq;
            Q.set(-v);
            Q.diagonal().add(1.0);
        } else {
            Q.copy(BasicStructuralModel.tsVar(freq).subMatrix());
        }
    }

    private static void svar(int freq, SubMatrix O) {
        int n = freq - 1;
        Matrix H = new Matrix(freq, n);
        for (int i = 0; i < freq; ++i) {
            double z = Math.PI * 2 * (double)(i + 1) / (double)freq;
            for (int j = 0; j < n / 2; ++j) {
                H.set(i, 2 * j, Math.cos((double)(j + 1) * z));
                H.set(i, 2 * j + 1, Math.sin((double)(j + 1) * z));
            }
            if (n % 2 != 1) continue;
            H.set(i, n - 1, Math.cos((double)(freq / 2) * z));
        }
        SymmetricMatrix.XXt(H.subMatrix(), O);
    }

    public static Matrix tsVar(int freq) {
        if (freq == 12) {
            if (g_VTS12 == null) {
                g_VTS12 = BasicStructuralModel._tsvar(12);
            }
            return g_VTS12;
        }
        if (freq == 4) {
            if (g_VTS4 == null) {
                g_VTS4 = BasicStructuralModel._tsvar(4);
            }
            return g_VTS4;
        }
        if (freq == 2) {
            if (g_VTS2 == null) {
                g_VTS2 = BasicStructuralModel._tsvar(2);
            }
            return g_VTS2;
        }
        if (freq == 3) {
            if (g_VTS3 == null) {
                g_VTS3 = BasicStructuralModel._tsvar(3);
            }
            return g_VTS3;
        }
        if (freq == 6) {
            if (g_VTS6 == null) {
                g_VTS6 = BasicStructuralModel._tsvar(6);
            }
            return g_VTS6;
        }
        return BasicStructuralModel._tsvar(freq);
    }

    public BasicStructuralModel(ModelSpecification spec, int freq) {
        this.freq = freq;
        this.seasModel = spec.getSeasonalModel();
        this.seasVar = BasicStructuralModel.getVar(this.seasModel);
        this.lVar = BasicStructuralModel.getVar(spec.lUse);
        this.sVar = BasicStructuralModel.getVar(spec.sUse);
        this.cVar = BasicStructuralModel.getVar(spec.cUse);
        this.nVar = BasicStructuralModel.getVar(spec.nUse);
        if (spec.cUse != ComponentUse.Unused) {
            this.cycle(0.5, freq * 2);
        }
    }

    public UcarimaModel computeReducedModel(boolean normalized) {
        UcarimaModel ucm = new UcarimaModel();
        BackFilter D = BackFilter.D1;
        ArimaModel cycle = null;
        ArimaModel trend = null;
        if (this.cVar >= 0.0) {
            double[] ar = new double[]{1.0, -2.0 * this.ccos, this.cDump * this.cDump};
            double t = 1.0 + this.cDump * this.cDump;
            double[] ma = new double[]{t, -this.ccos};
            SymmetricFrequencyResponseDecomposer decomposer = new SymmetricFrequencyResponseDecomposer();
            decomposer.decompose(SymmetricFilter.of(ma));
            cycle = new ArimaModel(BackFilter.of(ar), null, decomposer.getBFilter(), this.cVar * decomposer.getFactor());
        }
        if (this.lVar >= 0.0 && this.sVar >= 0.0) {
            if (this.lVar == 0.0 && this.sVar == 0.0) {
                trend = new ArimaModel(null, D.times(D), null, 0.0);
            } else if (this.lVar == 0.0) {
                trend = new ArimaModel(null, D.times(D), null, this.sVar);
            } else if (this.sVar == 0.0) {
                trend = new ArimaModel(null, D.times(D), D, this.lVar);
            } else {
                ArimaModel ml = new ArimaModel(null, null, D, this.lVar);
                ml = ml.plus(this.sVar);
                trend = new ArimaModel(null, D.times(D), ml.sma());
            }
        } else if (this.lVar >= 0.0) {
            trend = new ArimaModel(null, D, null, this.lVar);
        }
        if (trend != null) {
            if (cycle != null) {
                ucm.addComponent(trend.plus(cycle, false));
            } else {
                ucm.addComponent(trend);
            }
        } else if (cycle != null) {
            ucm.addComponent(cycle);
        } else {
            ucm.addComponent(new ArimaModel(null, null, null, 0.0));
        }
        if (this.seasVar >= 0.0) {
            BackFilter S = new BackFilter(UnitRoots.S(this.freq, 1));
            if (this.seasVar > 0.0) {
                SymmetricFilter sma;
                if (this.seasModel != SeasonalModel.Dummy) {
                    Matrix O = new Matrix(this.freq, this.freq);
                    switch (this.seasModel) {
                        case Crude: {
                            int f = this.freq - 1;
                            O.set(1.0);
                            O.row(0).mul(-f);
                            O.column(0).mul(-f);
                            break;
                        }
                        case HarrisonStevens: {
                            O.set(-1.0 / (double)this.freq);
                            O.diagonal().add(1.0);
                            break;
                        }
                        case Trigonometric: {
                            BasicStructuralModel.svar(this.freq, O.subMatrix());
                            break;
                        }
                    }
                    double[] w = new double[this.freq - 1];
                    for (int i = 0; i < this.freq - 1; ++i) {
                        for (int j = i; j < this.freq - 1; ++j) {
                            SubMatrix s = O.subMatrix(0, 1 + j - i, 0, 1 + j);
                            int n = i;
                            w[n] = w[n] + s.sum();
                        }
                    }
                    sma = SymmetricFilter.of(w);
                    sma = sma.times(this.seasVar);
                } else {
                    sma = SymmetricFilter.of(new double[]{this.seasVar});
                }
                ucm.addComponent(new ArimaModel(null, S, sma));
            } else {
                ucm.addComponent(new ArimaModel(null, S, null, 0.0));
            }
        } else {
            ucm.addComponent(new ArimaModel(null, null, null, 0.0));
        }
        if (this.nVar > 0.0) {
            ucm.addComponent(new ArimaModel(null, null, null, this.nVar));
        } else {
            ucm.addComponent(new ArimaModel(null, null, null, 0.0));
        }
        if (normalized) {
            ucm.normalize();
        }
        return ucm;
    }

    protected final void calcCmpsIndexes() {
        int n = 0;
        if (this.nVar > 0.0) {
            ++n;
        }
        if (this.cVar >= 0.0) {
            ++n;
        }
        if (this.lVar >= 0.0) {
            ++n;
        }
        if (this.seasVar >= 0.0) {
            ++n;
        }
        this.m_cmps = new int[n];
        int i = 0;
        int j = 0;
        if (this.nVar > 0.0) {
            this.m_cmps[i++] = j++;
        }
        if (this.cVar >= 0.0) {
            this.m_cmps[i++] = j;
            j += 2;
        }
        if (this.lVar >= 0.0) {
            this.m_cmps[i++] = j++;
        }
        if (this.sVar >= 0.0) {
            ++j;
        }
        if (this.seasVar >= 0.0) {
            this.m_cmps[i] = j;
        }
    }

    public BasicStructuralModel clone() {
        try {
            BasicStructuralModel bsm = (BasicStructuralModel)super.clone();
            return bsm;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public void diffuseConstraints(SubMatrix p) {
        int sdim = this.getStateDim();
        int istart = this.nVar > 0.0 ? 1 : 0;
        int iend = sdim;
        int i = istart;
        int j = 0;
        while (i < iend) {
            p.set(i, j, 1.0);
            ++i;
            ++j;
        }
    }

    public Component fixMaxVariance(double val) {
        double vmax;
        Component max = this.getMaxVariance();
        if (max != Component.Undefined && (vmax = this.getVariance(max)) != val) {
            this.scaleVariances(val / vmax);
        }
        return max;
    }

    public boolean fixSmallVariance(double eps) {
        Component min = this.getMinVariance();
        if (min != Component.Undefined && this.getVariance(min) < eps) {
            this.setVariance(min, 0.0);
            return true;
        }
        return false;
    }

    @Override
    public void fullQ(int pos, SubMatrix q) {
        int i = 0;
        if (this.nVar > 0.0) {
            q.set(i, i, this.nVar);
            ++i;
        }
        if (this.cVar >= 0.0) {
            q.set(i, i, this.cVar);
            q.set(++i, i, this.cVar);
            ++i;
        }
        if (this.lVar >= 0.0) {
            if (this.lVar != 0.0) {
                q.set(i, i, this.lVar);
            }
            ++i;
        }
        if (this.sVar >= 0.0) {
            if (this.sVar != 0.0) {
                q.set(i, i, this.sVar);
            }
            ++i;
        }
        if (this.seasVar > 0.0) {
            this.initQSeas(q.extract(i, i + this.freq - 1, i, i + this.freq - 1), this.seasVar);
        }
    }

    public int[] getCmpPositions() {
        int[] cmp = new int[this.getCmpsCount()];
        int idx = 0;
        int i = 0;
        if (this.nVar > 0.0) {
            cmp[idx++] = i++;
        }
        if (this.cVar >= 0.0) {
            cmp[idx++] = i;
            i += 2;
        }
        if (this.lVar >= 0.0) {
            cmp[idx++] = i++;
            if (this.sVar >= 0.0) {
                cmp[idx++] = i++;
            }
        }
        if (this.seasVar >= 0.0) {
            cmp[idx] = i;
        }
        return cmp;
    }

    public int getCmpsCount() {
        int n = 0;
        if (this.nVar > 0.0) {
            ++n;
        }
        if (this.cVar >= 0.0) {
            ++n;
        }
        if (this.lVar >= 0.0) {
            ++n;
            if (this.sVar >= 0.0) {
                ++n;
            }
        }
        if (this.seasVar >= 0.0) {
            ++n;
        }
        return n;
    }

    public Component[] getComponents() {
        Component[] cmp = new Component[this.getCmpsCount()];
        int idx = 0;
        if (this.nVar > 0.0) {
            cmp[idx++] = Component.Noise;
        }
        if (this.cVar >= 0.0) {
            cmp[idx++] = Component.Cycle;
        }
        if (this.lVar >= 0.0) {
            cmp[idx++] = Component.Level;
            if (this.sVar >= 0.0) {
                cmp[idx++] = Component.Slope;
            }
        }
        if (this.seasVar >= 0.0) {
            cmp[idx] = Component.Seasonal;
        }
        return cmp;
    }

    public Component getMaxVariance() {
        Component cmp = Component.Undefined;
        double vmax = 0.0;
        if (this.lVar > vmax) {
            vmax = this.lVar;
            cmp = Component.Level;
        }
        if (this.sVar > vmax) {
            vmax = this.sVar;
            cmp = Component.Slope;
        }
        if (this.seasVar > vmax) {
            vmax = this.seasVar;
            cmp = Component.Seasonal;
        }
        if (this.cVar > vmax) {
            vmax = this.cVar;
            cmp = Component.Cycle;
        }
        if (this.nVar > vmax) {
            cmp = Component.Noise;
        }
        return cmp;
    }

    public Component getMinVariance() {
        Component cmp = Component.Undefined;
        double vmin = Double.MAX_VALUE;
        if (this.lVar > 0.0 && this.lVar < vmin) {
            vmin = this.lVar;
            cmp = Component.Level;
        }
        if (this.sVar > 0.0 && this.sVar < vmin) {
            vmin = this.sVar;
            cmp = Component.Slope;
        }
        if (this.seasVar > 0.0 && this.seasVar < vmin) {
            vmin = this.seasVar;
            cmp = Component.Seasonal;
        }
        if (this.cVar > 0.0 && this.cVar < vmin) {
            vmin = this.cVar;
            cmp = Component.Cycle;
        }
        if (this.nVar > 0.0 && this.nVar < vmin) {
            cmp = Component.Noise;
        }
        return cmp;
    }

    @Override
    public int getNonStationaryDim() {
        int r = 0;
        if (this.lVar >= 0.0) {
            ++r;
        }
        if (this.sVar >= 0.0) {
            ++r;
        }
        if (this.seasVar >= 0.0) {
            r += this.freq - 1;
        }
        return r;
    }

    private SeasonalModel getSeas() {
        if (this.seasVar < 0.0) {
            return SeasonalModel.Unused;
        }
        if (this.seasVar == 0.0) {
            return SeasonalModel.Fixed;
        }
        return this.seasModel;
    }

    public ModelSpecification getSpecification() {
        ModelSpecification spec = new ModelSpecification();
        spec.setSeasonalModel(this.getSeas());
        spec.useLevel(BasicStructuralModel.getUse(this.lVar));
        spec.useSlope(BasicStructuralModel.getUse(this.sVar));
        spec.useCycle(BasicStructuralModel.getUse(this.cVar));
        spec.useNoise(this.nVar <= 0.0 ? ComponentUse.Unused : ComponentUse.Free);
        return spec;
    }

    @Override
    public int getStateDim() {
        int r = 0;
        if (this.nVar > 0.0) {
            ++r;
        }
        if (this.cVar >= 0.0) {
            r += 2;
        }
        if (this.lVar >= 0.0) {
            ++r;
        }
        if (this.sVar >= 0.0) {
            ++r;
        }
        if (this.seasVar >= 0.0) {
            r += this.freq - 1;
        }
        return r;
    }

    @Override
    public int getTransitionResCount() {
        int nr = 0;
        if (this.seasVar > 0.0) {
            nr = this.seasModel == SeasonalModel.Dummy ? ++nr : (nr += this.freq - 1);
        }
        if (this.nVar > 0.0) {
            ++nr;
        }
        if (this.cVar > 0.0) {
            nr += 2;
        }
        if (this.lVar > 0.0) {
            ++nr;
        }
        if (this.sVar > 0.0) {
            ++nr;
        }
        return nr;
    }

    @Override
    public int getTransitionResDim() {
        int nr = 0;
        if (this.seasVar > 0.0) {
            nr = this.seasModel == SeasonalModel.Dummy ? ++nr : (nr += this.freq - 1);
        }
        if (this.nVar > 0.0) {
            ++nr;
        }
        if (this.cVar > 0.0) {
            nr += 2;
        }
        if (this.lVar > 0.0) {
            ++nr;
        }
        if (this.sVar > 0.0) {
            ++nr;
        }
        return nr;
    }

    public double getVariance(Component cmp) {
        switch (cmp) {
            case Noise: {
                return this.nVar;
            }
            case Cycle: {
                return this.cVar;
            }
            case Level: {
                return this.lVar;
            }
            case Slope: {
                return this.sVar;
            }
            case Seasonal: {
                return this.seasVar;
            }
        }
        return 0.0;
    }

    @Override
    public boolean hasR() {
        if (this.lVar == 0.0) {
            return true;
        }
        if (this.sVar == 0.0) {
            return true;
        }
        if (this.cVar >= 0.0) {
            return true;
        }
        return this.seasVar == 0.0 || this.seasModel == SeasonalModel.Dummy;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    protected void initQSeas(SubMatrix Q, double var) {
        if (this.seasModel == SeasonalModel.Dummy) {
            Q.set(Q.getRowsCount() - 1, Q.getColumnsCount() - 1, var);
        } else if (this.seasModel == SeasonalModel.Crude) {
            Q.set(var);
        } else if (this.seasModel == SeasonalModel.HarrisonStevens) {
            double v = var / (double)this.freq;
            Q.set(-v);
            Q.diagonal().add(var);
        } else {
            this.initTSVar();
            Q.copy(this.m_tsvar.subMatrix());
            Q.mul(var);
        }
        SymmetricMatrix.fromLower(Q);
    }

    protected void initTSVar() {
        if (this.m_tsvar != null && this.m_tsvar.getRowsCount() == this.freq - 1) {
            return;
        }
        this.m_tsvar = BasicStructuralModel.tsVar(this.freq);
    }

    @Override
    public boolean isDiffuse() {
        return this.isValid();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.freq == 1 && this.seasVar >= 0.0) {
            return false;
        }
        return this.lVar >= 0.0 || this.sVar >= 0.0 || this.cVar >= 0.0 || this.nVar >= 0.0;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix l) {
        this.T(pos, l);
        if (this.m_cmps == null) {
            this.calcCmpsIndexes();
        }
        int n = this.m_cmps.length;
        for (int j = 0; j < n; ++j) {
            l.column(this.m_cmps[j]).sub(k);
        }
    }

    @Override
    public void Pf0(SubMatrix p) {
        int i = 0;
        if (this.nVar > 0.0) {
            p.set(0, 0, this.nVar);
            ++i;
        }
        if (this.cVar > 0.0) {
            double q = this.cVar / (1.0 - this.cDump * this.cDump);
            p.set(i, i, q);
            p.set(++i, i, q);
        }
    }

    @Override
    public void Pi0(SubMatrix p) {
        int istart;
        int sdim = this.getStateDim();
        int n = istart = this.nVar > 0.0 ? 1 : 0;
        if (this.cVar >= 0.0) {
            istart += 2;
        }
        int iend = sdim;
        for (int i = istart; i < iend; ++i) {
            p.set(i, i, 1.0);
        }
    }

    @Override
    public void Q(int pos, SubMatrix q) {
        int i = 0;
        if (this.nVar > 0.0) {
            q.set(i, i, this.nVar);
            ++i;
        }
        if (this.cVar > 0.0) {
            q.set(i, i, this.cVar);
            q.set(++i, i, this.cVar);
            ++i;
        }
        if (this.lVar > 0.0) {
            q.set(i, i, this.lVar);
            ++i;
        }
        if (this.sVar > 0.0) {
            q.set(i, i, this.sVar);
            ++i;
        }
        if (this.seasVar > 0.0) {
            if (this.seasModel == SeasonalModel.Dummy) {
                q.set(i, i, this.seasVar);
            } else {
                this.initQSeas(q.extract(i, i + this.freq - 1, i, i + this.freq - 1), this.seasVar);
            }
        }
    }

    @Override
    public void R(int pos, SubArrayOfInt r) {
        int i = 0;
        int j = 0;
        if (this.nVar > 0.0) {
            r.set(i++, j);
            ++j;
        }
        if (this.cVar >= 0.0) {
            if (this.cVar != 0.0) {
                r.set(i++, j);
                r.set(i++, j + 1);
            }
            j += 2;
        }
        if (this.lVar >= 0.0) {
            if (this.lVar != 0.0) {
                r.set(i++, j);
            }
            ++j;
            if (this.sVar >= 0.0) {
                if (this.sVar != 0.0) {
                    r.set(i++, j);
                }
                ++j;
            }
        }
        if (this.seasVar > 0.0) {
            if (this.seasModel == SeasonalModel.Dummy) {
                r.set(i, j + this.freq - 2);
            } else {
                for (int k = 1; k < this.freq; ++k) {
                    r.set(i++, j++);
                }
            }
        }
    }

    public void scaleVariances(double factor) {
        if (this.lVar > 0.0) {
            this.lVar *= factor;
        }
        if (this.cVar > 0.0) {
            this.cVar *= factor;
        }
        if (this.sVar > 0.0) {
            this.sVar *= factor;
        }
        if (this.seasVar > 0.0) {
            this.seasVar *= factor;
        }
        if (this.nVar > 0.0) {
            this.nVar *= factor;
        }
        if (factor == 0.0) {
            this.m_cmps = null;
        }
    }

    public void setVariance(Component cmp, double var) {
        if (var == 0.0) {
            this.m_cmps = null;
        }
        switch (cmp) {
            case Noise: {
                if (this.nVar > 0.0) {
                    this.nVar = var;
                }
                return;
            }
            case Cycle: {
                if (this.cVar >= 0.0) {
                    this.cVar = var;
                }
                return;
            }
            case Level: {
                if (this.lVar >= 0.0) {
                    this.lVar = var;
                }
                return;
            }
            case Slope: {
                if (this.sVar >= 0.0) {
                    this.sVar = var;
                }
                return;
            }
            case Seasonal: {
                if (!(this.seasVar >= 0.0)) break;
                this.seasVar = var;
                if (var != 0.0) break;
                this.seasModel = SeasonalModel.Fixed;
            }
        }
    }

    public void setCycle(double cro, double cperiod) {
        this.cycle(cro, cperiod);
    }

    private void cycle(double cro, double cperiod) {
        this.cDump = cro;
        this.cPeriod = cperiod;
        double q = Math.PI * 2 / cperiod;
        this.ccos = this.cDump * Math.cos(q);
        this.csin = this.cDump * Math.sin(q);
    }

    public double getCyclicalDumpingFactor() {
        return this.cDump;
    }

    public double getCyclicalPeriod() {
        return this.cPeriod;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        int i = 0;
        if (this.nVar > 0.0) {
            ++i;
        }
        if (this.cVar >= 0.0) {
            tr.set(i, i, this.ccos);
            tr.set(i + 1, i + 1, this.ccos);
            tr.set(i, i + 1, this.csin);
            tr.set(i + 1, i, -this.csin);
            i += 2;
        }
        if (this.lVar >= 0.0) {
            tr.set(i, i, 1.0);
            if (this.sVar >= 0.0) {
                tr.set(i, i + 1, 1.0);
                tr.set(++i, i, 1.0);
            }
            ++i;
        }
        if (this.seasVar >= 0.0) {
            SubMatrix seas = tr.extract(i, i + this.freq - 1, i, i + this.freq - 1);
            seas.row(this.freq - 2).set(-1.0);
            seas.subDiagonal(1).set(1.0);
        }
    }

    @Override
    public void TVT(int pos, SubMatrix V) {
        DataBlockIterator cols = V.columns();
        DataBlock col = cols.getData();
        do {
            this.TX(pos, col);
        } while (cols.next());
        DataBlockIterator rows = V.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int i0 = 0;
        if (this.nVar > 0.0) {
            x.set(0, 0.0);
            ++i0;
        }
        if (this.cVar >= 0.0) {
            double a = x.get(i0);
            double b = x.get(i0 + 1);
            x.set(i0, a * this.ccos + b * this.csin);
            x.set(i0 + 1, -a * this.csin + b * this.ccos);
            i0 += 2;
        }
        if (this.lVar >= 0.0) {
            if (this.sVar >= 0.0) {
                x.add(i0, x.get(i0 + 1));
                i0 += 2;
            } else {
                ++i0;
            }
        }
        if (this.seasVar >= 0.0) {
            DataBlock ex = x.extract(i0, this.freq - 1, 1);
            ex.bshift(DataBlock.ShiftOption.NegSum);
        }
    }

    protected void updateStructure() {
        this.calcCmpsIndexes();
    }

    @Override
    public void VpZdZ(int pos, SubMatrix V, double d) {
        if (this.m_cmps == null) {
            this.calcCmpsIndexes();
        }
        int n = this.m_cmps.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V.add(this.m_cmps[i], this.m_cmps[j], d);
            }
        }
    }

    @Override
    public void W(int pos, SubMatrix w) {
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        if (this.m_cmps == null) {
            this.calcCmpsIndexes();
        }
        int n = this.m_cmps.length;
        for (int i = 0; i < n; ++i) {
            x.add(this.m_cmps[i], d);
        }
    }

    @Override
    public void XT(int pos, DataBlock xin) {
        int i0 = 0;
        if (this.nVar > 0.0) {
            xin.set(0, 0.0);
            ++i0;
        }
        if (this.cVar >= 0.0) {
            double a = xin.get(i0);
            double b = xin.get(i0 + 1);
            xin.set(i0, a * this.ccos - b * this.csin);
            xin.set(i0 + 1, a * this.csin + b * this.ccos);
            i0 += 2;
        }
        if (this.lVar >= 0.0) {
            if (this.sVar >= 0.0) {
                xin.add(i0 + 1, xin.get(i0));
                i0 += 2;
            } else {
                ++i0;
            }
        }
        if (this.seasVar >= 0.0) {
            int imax = i0 + this.freq - 2;
            double xs = xin.get(imax);
            for (int i = imax; i > i0; --i) {
                xin.set(i, xin.get(i - 1) - xs);
            }
            xin.set(i0, -xs);
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        int i = 0;
        if (this.nVar > 0.0) {
            z.set(i++, 1.0);
        }
        if (this.cVar > 0.0) {
            z.set(i, 1.0);
            i += 2;
        }
        if (this.lVar >= 0.0) {
            z.set(i++, 1.0);
            if (this.sVar >= 0.0) {
                ++i;
            }
        }
        if (this.seasVar >= 0.0) {
            z.set(i, 1.0);
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        DataBlockIterator cols = m.columns();
        DataBlock col = cols.getData();
        int i = 0;
        do {
            x.set(i++, this.ZX(pos, col));
        } while (cols.next());
    }

    @Override
    public double ZVZ(int pos, SubMatrix V) {
        double d = 0.0;
        if (this.m_cmps == null) {
            this.calcCmpsIndexes();
        }
        int n = this.m_cmps.length;
        for (int i = 0; i < n; ++i) {
            d += V.get(this.m_cmps[i], this.m_cmps[i]);
            for (int j = 0; j < i; ++j) {
                d += 2.0 * V.get(this.m_cmps[i], this.m_cmps[j]);
            }
        }
        return d;
    }

    @Override
    public double ZX(int pos, DataBlock xin) {
        if (this.m_cmps == null) {
            this.calcCmpsIndexes();
        }
        int n = this.m_cmps.length;
        double d = xin.get(this.m_cmps[0]);
        for (int i = 1; i < n; ++i) {
            d += xin.get(this.m_cmps[i]);
        }
        return d;
    }
}

