/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotFleetTagSpecification;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotFleetRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.getSpotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {
            SdkInternalList spotFleetRequestConfigDataLaunchSpecificationsList;
            if (spotFleetRequestConfig.getAllocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringUtils.fromString((String)spotFleetRequestConfig.getAllocationStrategy()));
            }
            if (spotFleetRequestConfig.getClientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString((String)spotFleetRequestConfig.getClientToken()));
            }
            if (spotFleetRequestConfig.getExcessCapacityTerminationPolicy() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringUtils.fromString((String)spotFleetRequestConfig.getExcessCapacityTerminationPolicy()));
            }
            if (spotFleetRequestConfig.getFulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfig.getFulfilledCapacity()));
            }
            if (spotFleetRequestConfig.getIamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString((String)spotFleetRequestConfig.getIamFleetRole()));
            }
            if (!(spotFleetRequestConfigDataLaunchSpecificationsList = (SdkInternalList)spotFleetRequestConfig.getLaunchSpecifications()).isEmpty() || !spotFleetRequestConfigDataLaunchSpecificationsList.isAutoConstruct()) {
                int launchSpecificationsListIndex = 1;
                for (SpotFleetLaunchSpecification spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {
                    SdkInternalList spotFleetLaunchSpecificationTagSpecificationsList;
                    SpotPlacement placement;
                    SdkInternalList spotFleetLaunchSpecificationNetworkInterfacesList;
                    SpotFleetMonitoring monitoring;
                    IamInstanceProfileSpecification iamInstanceProfile;
                    SdkInternalList spotFleetLaunchSpecificationBlockDeviceMappingsList;
                    SdkInternalList spotFleetLaunchSpecificationSecurityGroupsList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.getSecurityGroups();
                    if (!spotFleetLaunchSpecificationSecurityGroupsList.isEmpty() || !spotFleetLaunchSpecificationSecurityGroupsList.isAutoConstruct()) {
                        int securityGroupsListIndex = 1;
                        for (Object spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName()));
                            }
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId()));
                            }
                            ++securityGroupsListIndex;
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getAddressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getAddressingType()));
                    }
                    if (!(spotFleetLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.getBlockDeviceMappings()).isEmpty() || !spotFleetLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                        Object spotFleetLaunchSpecificationSecurityGroupsListValue;
                        int blockDeviceMappingsListIndex = 1;
                        spotFleetLaunchSpecificationSecurityGroupsListValue = spotFleetLaunchSpecificationBlockDeviceMappingsList.iterator();
                        while (spotFleetLaunchSpecificationSecurityGroupsListValue.hasNext()) {
                            EbsBlockDevice ebs;
                            BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue = (BlockDeviceMapping)spotFleetLaunchSpecificationSecurityGroupsListValue.next();
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                            }
                            if ((ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                                if (ebs.getEncrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                                }
                                if (ebs.getDeleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                                }
                                if (ebs.getIops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                                }
                                if (ebs.getSnapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                                }
                                if (ebs.getVolumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                                }
                                if (ebs.getVolumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                                }
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                            }
                            ++blockDeviceMappingsListIndex;
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getEbsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean((Boolean)spotFleetRequestConfigDataLaunchSpecificationsListValue.getEbsOptimized()));
                    }
                    if ((iamInstanceProfile = spotFleetRequestConfigDataLaunchSpecificationsListValue.getIamInstanceProfile()) != null) {
                        if (iamInstanceProfile.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                        }
                        if (iamInstanceProfile.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getImageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getImageId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getInstanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getInstanceType()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getKernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getKernelId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getKeyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getKeyName()));
                    }
                    if ((monitoring = spotFleetRequestConfigDataLaunchSpecificationsListValue.getMonitoring()) != null && monitoring.getEnabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.getEnabled()));
                    }
                    if (!(spotFleetLaunchSpecificationNetworkInterfacesList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.getNetworkInterfaces()).isEmpty() || !spotFleetLaunchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                        int networkInterfacesListIndex = 1;
                        for (InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue : spotFleetLaunchSpecificationNetworkInterfacesList) {
                            SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                                int groupsListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    ++groupsListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                                Object instanceNetworkInterfaceSpecificationGroupsListValue;
                                int ipv6AddressesListIndex = 1;
                                instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                                while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                                    InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                                    if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address()));
                                    }
                                    ++ipv6AddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                                int privateIpAddressesListIndex = 1;
                                for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                                    }
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                                    }
                                    ++privateIpAddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId()));
                            }
                            ++networkInterfacesListIndex;
                        }
                    }
                    if ((placement = spotFleetRequestConfigDataLaunchSpecificationsListValue.getPlacement()) != null) {
                        if (placement.getAvailabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                        }
                        if (placement.getGroupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                        }
                        if (placement.getTenancy() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getRamdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getRamdiskId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getSpotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getSpotPrice()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getSubnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getSubnetId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getUserData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.getUserData()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.getWeightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfigDataLaunchSpecificationsListValue.getWeightedCapacity()));
                    }
                    if (!(spotFleetLaunchSpecificationTagSpecificationsList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.getTagSpecifications()).isEmpty() || !spotFleetLaunchSpecificationTagSpecificationsList.isAutoConstruct()) {
                        int tagSpecificationsListIndex = 1;
                        for (SpotFleetTagSpecification spotFleetLaunchSpecificationTagSpecificationsListValue : spotFleetLaunchSpecificationTagSpecificationsList) {
                            SdkInternalList spotFleetTagSpecificationTagsList;
                            if (spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType()));
                            }
                            if (!(spotFleetTagSpecificationTagsList = (SdkInternalList)spotFleetLaunchSpecificationTagSpecificationsListValue.getTags()).isEmpty() || !spotFleetTagSpecificationTagsList.isAutoConstruct()) {
                                int tagsListIndex = 1;
                                for (Tag spotFleetTagSpecificationTagsListValue : spotFleetTagSpecificationTagsList) {
                                    if (spotFleetTagSpecificationTagsListValue.getKey() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)spotFleetTagSpecificationTagsListValue.getKey()));
                                    }
                                    if (spotFleetTagSpecificationTagsListValue.getValue() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)spotFleetTagSpecificationTagsListValue.getValue()));
                                    }
                                    ++tagsListIndex;
                                }
                            }
                            ++tagSpecificationsListIndex;
                        }
                    }
                    ++launchSpecificationsListIndex;
                }
            }
            if (spotFleetRequestConfig.getSpotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString((String)spotFleetRequestConfig.getSpotPrice()));
            }
            if (spotFleetRequestConfig.getTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger((Integer)spotFleetRequestConfig.getTargetCapacity()));
            }
            if (spotFleetRequestConfig.getTerminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.getTerminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfig.getType() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringUtils.fromString((String)spotFleetRequestConfig.getType()));
            }
            if (spotFleetRequestConfig.getValidFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate((Date)spotFleetRequestConfig.getValidFrom()));
            }
            if (spotFleetRequestConfig.getValidUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate((Date)spotFleetRequestConfig.getValidUntil()));
            }
            if (spotFleetRequestConfig.getReplaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.getReplaceUnhealthyInstances()));
            }
        }
        return request;
    }
}

