/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVolumesModificationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVolumesModificationsRequestMarshaller
implements Marshaller<Request<DescribeVolumesModificationsRequest>, DescribeVolumesModificationsRequest> {
    public Request<DescribeVolumesModificationsRequest> marshall(DescribeVolumesModificationsRequest describeVolumesModificationsRequest) {
        SdkInternalList describeVolumesModificationsRequestFiltersList;
        if (describeVolumesModificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumesModificationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVolumesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVolumesModificationsRequestVolumeIdsList = (SdkInternalList)describeVolumesModificationsRequest.getVolumeIds();
        if (!describeVolumesModificationsRequestVolumeIdsList.isEmpty() || !describeVolumesModificationsRequestVolumeIdsList.isAutoConstruct()) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesModificationsRequestVolumeIdsListValue : describeVolumesModificationsRequestVolumeIdsList) {
                if (describeVolumesModificationsRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumesModificationsRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (!(describeVolumesModificationsRequestFiltersList = (SdkInternalList)describeVolumesModificationsRequest.getFilters()).isEmpty() || !describeVolumesModificationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVolumesModificationsRequestFiltersListValue : describeVolumesModificationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVolumesModificationsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumesModificationsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVolumesModificationsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumesModificationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumesModificationsRequest.getNextToken()));
        }
        if (describeVolumesModificationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumesModificationsRequest.getMaxResults()));
        }
        return request;
    }
}

