/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstancesHealthRequestMarshaller
implements Marshaller<Request<DescribeInstancesHealthRequest>, DescribeInstancesHealthRequest> {
    public Request<DescribeInstancesHealthRequest> marshall(DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        SdkInternalList attributeNamesList;
        if (describeInstancesHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstancesHealthRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeInstancesHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstancesHealthRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeInstancesHealthRequest.getEnvironmentName()));
        }
        if (describeInstancesHealthRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeInstancesHealthRequest.getEnvironmentId()));
        }
        if (!(attributeNamesList = (SdkInternalList)describeInstancesHealthRequest.getAttributeNames()).isEmpty() || !attributeNamesList.isAutoConstruct()) {
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (describeInstancesHealthRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstancesHealthRequest.getNextToken()));
        }
        return request;
    }
}

