/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.image;

import com.levigo.jbig2.image.Filter;
import com.levigo.jbig2.util.Utils;

class ParameterizedFilter {
    final Filter filter;
    final double scale;
    final double support;
    final int width;

    public ParameterizedFilter(Filter filter, double d) {
        this.filter = filter;
        this.scale = filter.blur * Math.max(1.0, 1.0 / d);
        this.support = Math.max(0.5, this.scale * filter.support);
        this.width = (int)Math.ceil(2.0 * this.support);
    }

    public ParameterizedFilter(Filter filter, double d, double d2, int n) {
        this.filter = filter;
        this.scale = d;
        this.support = d2;
        this.width = n;
    }

    public double eval(double d, int n) {
        return this.filter.fWindowed(((double)n + 0.5 - d) / this.scale);
    }

    public int minIndex(double d) {
        return Utils.floor(d - this.support);
    }

    public int maxIndex(double d) {
        return Utils.ceil(d + this.support);
    }
}

