# samc 1.1.0

- Added support for the use vectors of time steps in most short-term metrics. It is more computationally efficient and ergonomic to do this rather than calculating short-term metrics for each individual time step. Some key points:
  - When vector inputs are used for time steps, the result is contained in a list
  - The names of the entries in the list are character versions of the corresponding time step values
  - Time step vectors must consist of ordered positive integers with no duplicate values
  - Time step vector inputs have not been added for short-term metrics that return dense matrices
- Updated the map() function to support list inputs generated by the short-term metrics. The result is a list of RasterLayers
- Updated the *Temporal Analysis* and *Animations* vignettes to incorporate time step vectors
- Created a [Gitter community](https://gitter.im/samc-package/community) for package support. Gitter badges on the README and home pages can be used to access it.
- Updated the package citation info to refer to Marx et al. (2020, DOI: [10.1111/ecog.04891](https://doi.org/10.1111/ecog.04891))


# samc 1.0.4

- Add conditional usage of suggested packages in vignettes
- Minor updates for package info


# samc 1.0.3

- First CRAN submission


# samc 1.0.0

- Complete package rewrite (code dependent on v0.1.0 will not work)
- samc-class for managing SAMC data
- Utility functions for creating samc-class objects, checking inputs, and mapping data
- Heavily optimized analytical functions for all metrics described in Fletcher et al. (2019, DOI: [10.1111/ele.13333](https://doi.org/10.1111/ele.13333))
  - Utilizing sparse matrices
  - Eigen C++ implementation via Rcpp and RcppEigen
- Updated example data
- Extensive documentation
- Several tutorials


# samc 0.1.0

- Created crude functions for calculating metrics in Fletcher et al. (2019, DOI: [10.1111/ele.13333](https://doi.org/10.1111/ele.13333))
- Included example data
