/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class SignOp
extends AbstractBinIntSConstraint {
    protected boolean same;

    public SignOp(IntDomainVar x0, IntDomainVar x1, boolean same) {
        super(x0, x1);
        this.same = same;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void filterSame(IntDomainVar x1, IntDomainVar x2) throws ContradictionException {
        if (x1.getSup() < 0) {
            x2.updateSup(0, this, false);
            this.setEntailed();
        } else if (x1.getInf() > 0) {
            x2.updateInf(0, this, false);
            this.setEntailed();
        }
    }

    public void filterNotSame(IntDomainVar x1, IntDomainVar x2) throws ContradictionException {
        if (x1.getInf() == 0) {
            x1.updateInf(1, this, false);
        }
        if (x1.getSup() == 0) {
            x1.updateSup(-1, this, false);
        }
        if (x1.getSup() < 0) {
            x2.updateInf(1, this, false);
            this.setEntailed();
        } else if (x1.getInf() > 0) {
            x2.updateSup(-1, this, false);
            this.setEntailed();
        }
    }

    public void filter() throws ContradictionException {
        if (this.same) {
            this.filterSame(this.v0, this.v1);
            this.filterSame(this.v1, this.v0);
        } else {
            this.filterNotSame(this.v0, this.v1);
            this.filterNotSame(this.v1, this.v0);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (!this.same) {
            this.v0.removeVal(0, this, false);
            this.v1.removeVal(0, this, false);
        }
        this.filter();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0)) {
            return this.same ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.v0.getInf() >= 0 && this.v1.getInf() >= 0 || this.v0.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.same ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.v0.getInf() > 0 && this.v1.getSup() < 0 || this.v1.getInf() > 0 && this.v0.getSup() < 0) {
            return this.same ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (!this.same) {
            return tuple[0] != 0 && tuple[1] != 0 && (tuple[0] > 0 && tuple[1] < 0 || tuple[0] < 0 && tuple[1] > 0);
        }
        return tuple[0] == 0 || tuple[1] == 0 || tuple[0] >= 0 && tuple[1] >= 0 || tuple[0] <= 0 && tuple[1] <= 0;
    }

    @Override
    public boolean isConsistent() {
        throw new UnsupportedOperationException("is consistent not implemented on SignOp");
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new SignOp(this.v0, this.v1, !this.same);
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        if (this.same) {
            sb.append(" of same sign than ");
        } else {
            sb.append(" of different sign than ");
        }
        sb.append(this.v1.toString());
        return sb.toString();
    }
}

