/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.PrecsGraphView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateBitSet;
import java.util.BitSet;
import java.util.logging.Logger;

public class Dominators {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected int nbVertices;
    protected VarGraphView graph;
    protected PrecsGraphView precs;
    protected int[] color;
    protected int[] postOrder;
    protected int[] revPostOrder;
    protected BitSet visited;
    protected int time;
    protected BitSet tmp;
    boolean affiche = false;

    public Dominators(VarGraphView graph, PrecsGraphView precs) {
        this.graph = graph;
        this.precs = precs;
        this.nbVertices = graph.getNbNodes();
        this.tmp = new BitSet(this.nbVertices);
    }

    public BitSet[][] computeDominators() {
        int j;
        int i;
        BitSet[][] currentDoms = new BitSet[this.nbVertices][this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            for (j = 0; j < this.nbVertices; ++j) {
                currentDoms[i][j] = new BitSet(this.nbVertices);
                for (int k = 0; k < this.nbVertices; ++k) {
                    currentDoms[i][j].set(k, true);
                }
            }
        }
        for (i = 0; i < this.nbVertices; ++i) {
            currentDoms = this.computeDominatorTree(i, currentDoms);
        }
        for (i = 0; i < this.nbVertices; ++i) {
            for (j = 0; j < this.nbVertices; ++j) {
                currentDoms[i][j].set(i, false);
                currentDoms[i][j].set(j, false);
            }
        }
        return currentDoms;
    }

    private void init(int source) {
        int i;
        this.color = new int[this.nbVertices];
        this.postOrder = new int[this.nbVertices];
        this.revPostOrder = new int[this.nbVertices];
        this.time = -1;
        this.visited = new BitSet(this.nbVertices);
        for (i = 0; i < this.nbVertices; ++i) {
            this.color[i] = 0;
            this.postOrder[i] = -1;
            this.revPostOrder[i] = -1;
        }
        if (this.affiche) {
            LOGGER.info("source = " + source);
        }
        this.computePostOrder(source);
        if (this.affiche) {
            LOGGER.info("-----------------------------");
            for (i = 0; i < this.revPostOrder.length; ++i) {
                LOGGER.info("revPostOrder[" + i + "] = " + this.revPostOrder[i]);
            }
            LOGGER.info("-----------------------------");
        }
    }

    private BitSet[][] computeDominatorTree(int source, BitSet[][] currentDoms) {
        this.init(source);
        for (int i = 0; i < this.nbVertices; ++i) {
            if (this.postOrder[i] != -1) continue;
            BitSet unreachable = currentDoms[source][i];
            int j = unreachable.nextSetBit(0);
            while (j >= 0) {
                unreachable.set(j, false);
                j = unreachable.nextSetBit(j + 1);
            }
        }
        boolean changed = true;
        BitSet computed = new BitSet(this.nbVertices);
        while (changed) {
            changed = false;
            if (this.affiche) {
                LOGGER.info("une boucle: ");
            }
            for (int i = this.nbVertices - 1; i > -1; --i) {
                int node = this.revPostOrder[i];
                if (this.affiche) {
                    LOGGER.info("au temps " + i + " on a visite " + node);
                }
                if (node <= -1) continue;
                if (this.affiche) {
                    LOGGER.info("\t On cherche les dominants de " + node + " par rapport \u00ef\u00bf\u00bd " + source + ": ");
                }
                computed.set(node, true);
                BitSet newSet = new BitSet(this.nbVertices);
                newSet.set(node, true);
                BitSet previous = (BitSet)currentDoms[source][node].clone();
                BitSet intersect = (BitSet)currentDoms[source][node].clone();
                this.tmp = this.precs.getAncestors(node);
                this.tmp.and(this.precs.getDescendants(source));
                intersect.or(this.tmp);
                IStateBitSet preds = this.graph.getGlobal().getPredecessors(node);
                boolean atLeastOne = false;
                boolean atLeastOneComp = false;
                if (this.affiche) {
                    LOGGER.info("\t\t au moins un pred pour " + node + "? ");
                }
                int j = preds.nextSetBit(0);
                while (j >= 0) {
                    if (j != node) {
                        if (this.affiche) {
                            LOGGER.info("oui");
                        }
                        atLeastOne = true;
                        if (computed.get(j)) {
                            if (this.affiche) {
                                LOGGER.info("[update with dom[" + j + "]=" + currentDoms[source][j] + "] ");
                            }
                            intersect.and(currentDoms[source][j]);
                            atLeastOneComp = true;
                        }
                    }
                    j = preds.nextSetBit(j + 1);
                }
                if (!atLeastOne) {
                    if (this.affiche) {
                        LOGGER.info("non");
                    }
                    j = previous.nextSetBit(0);
                    while (j >= 0) {
                        if (j != node) {
                            newSet.set(j, false);
                        }
                        j = previous.nextSetBit(j + 1);
                    }
                } else if (atLeastOneComp) {
                    newSet.or(intersect);
                }
                if (this.affiche) {
                    LOGGER.info("");
                }
                if (this.affiche) {
                    LOGGER.info("\t\t candidats = " + newSet.toString());
                }
                j = previous.nextSetBit(0);
                while (j >= 0) {
                    if (!newSet.get(j)) {
                        changed = true;
                    }
                    j = previous.nextSetBit(j + 1);
                }
                j = newSet.nextSetBit(0);
                while (j >= 0) {
                    if (!previous.get(j)) {
                        changed = true;
                    }
                    j = newSet.nextSetBit(j + 1);
                }
                if (!changed) continue;
                if (this.affiche) {
                    LOGGER.info("\t\t dominants de " + node + " par rapport \u00ef\u00bf\u00bd " + source + " = " + newSet.toString());
                }
                currentDoms[source][node] = newSet;
                if (!this.affiche) continue;
                LOGGER.info("");
            }
            if (!this.affiche) continue;
            LOGGER.info("------------------------------------------------------------");
        }
        return currentDoms;
    }

    public void computePostOrder(int u) {
        BitSet src = new BitSet(this.nbVertices);
        src.set(u, true);
        int i = src.nextSetBit(0);
        while (i >= 0) {
            if (this.color[i] == 0) {
                this.getPostOrder(i);
            }
            i = src.nextSetBit(i + 1);
        }
    }

    public void getPostOrder(int u) {
        this.color[u] = 1;
        this.visited.set(u, true);
        IStateBitSet succ = this.graph.getGlobal().getSuccessors(u);
        int k = succ.nextSetBit(0);
        while (k >= 0) {
            if (this.color[k] == 0) {
                this.getPostOrder(k);
            }
            k = succ.nextSetBit(k + 1);
        }
        this.color[u] = 2;
        this.postOrder[u] = ++this.time;
        this.revPostOrder[this.time] = u;
    }
}

