/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.xml;

import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.TreeMap;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderAdapter;
import salvo.jesus.graph.DirectedAcyclicGraph;
import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.DirectedEdgeImpl;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.WeightedEdgeImpl;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.xml.GraphToXMLEventGenerator;
import salvo.jesus.graph.xml.GraphToXMLHandler;
import salvo.jesus.graph.xml.VertexComparator;

public class GraphToXGMMLSAXHandler
implements GraphToXMLHandler {
    private GraphToXMLEventGenerator eventGenerator;
    protected XMLSerializer serializer;
    private GraphToXGMMLSAXHandler delegate;

    public GraphToXGMMLSAXHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer) {
        this.eventGenerator = eventGenerator;
        this.serializer = serializer;
    }

    public void startSerialize(Graph graph) throws Exception {
        this.delegate = new GraphHandler(this.eventGenerator, this.serializer, new CommonHandler(this.eventGenerator, this.serializer));
        this.delegate.startSerialize(graph);
    }

    public void startSerialize(VisualGraph vGraph) throws Exception {
        this.delegate = new VisualGraphHandler(this.eventGenerator, this.serializer, new CommonHandler(this.eventGenerator, this.serializer));
        this.delegate.startSerialize(vGraph);
    }

    public void serializeEdge(Edge edge) throws Exception {
        this.delegate.serializeEdge(edge);
    }

    public void endSerializeEdge(Edge edge) throws Exception {
        this.delegate.endSerializeEdge(edge);
    }

    public void serializeVertex(Vertex vertex) throws Exception {
        this.delegate.serializeVertex(vertex);
    }

    public void endSerializeVertex(Vertex vertex) throws Exception {
        this.delegate.endSerializeVertex(vertex);
    }

    public void endSerialize() throws Exception {
        this.delegate.endSerialize();
    }

    public GraphToXMLEventGenerator getEventGenerator() {
        return this.eventGenerator;
    }

    class VisualGraphHandler
    extends GraphToXGMMLSAXHandler {
        private VisualGraph vGraph;
        private CommonHandler commonHandler;
        private GraphHandler graphHandler;

        public VisualGraphHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer, CommonHandler commonHandler) {
            super(eventGenerator, serializer);
            this.commonHandler = commonHandler;
            this.graphHandler = new GraphHandler(eventGenerator, serializer, this.commonHandler);
        }

        public void startSerialize(Graph graph) throws Exception {
        }

        public void startSerialize(VisualGraph vGraph) throws Exception {
            this.vGraph = vGraph;
            this.commonHandler.startSerialize(vGraph.getGraph());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "Graphic", "Graphic", this.commonHandler.sPool.toString(this.commonHandler.BOOLEAN_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.ONE_LITERAL_STRINGPOOL_INDEX));
            attrs.addAttribute("", "Vendor", "Vendor", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.OPENJGRAPH_LITERAL_STRINGPOOL_INDEX));
            attrs.addAttribute("", "directed", "directed", this.commonHandler.sPool.toString(this.commonHandler.BOOLEAN_TYPE_STRINGPOOL_INDEX), vGraph.getGraph() instanceof DirectedGraph ? this.commonHandler.sPool.toString(this.commonHandler.ONE_LITERAL_STRINGPOOL_INDEX) : this.commonHandler.sPool.toString(this.commonHandler.ZERO_LITERAL_STRINGPOOL_INDEX));
            this.commonHandler.getReaderAdapter().startElement("", "graph", "graph", attrs);
            this.commonHandler.serializeOtherGraphMetaInformation();
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "layoutManager");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "string");
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.vGraph.getGraphLayoutManager().getClass().getName());
            this.commonHandler.getReaderAdapter().startElement("", "att", "att", attrs);
            this.commonHandler.getReaderAdapter().endElement("", "att", "att");
        }

        public void serializeVertex(Vertex vertex) throws Exception {
            XMLReaderAdapter readerAdapter = this.commonHandler.getReaderAdapter();
            AttributesImpl attrs = new AttributesImpl();
            this.graphHandler.serializeVertex(vertex);
            VisualVertex vVertex = this.vGraph.getVisualVertex(vertex);
            Rectangle2D bounds = vVertex.getBounds2D();
            attrs.addAttribute("", "w", "w", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Double.toString(bounds.getWidth()));
            attrs.addAttribute("", "h", "h", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Double.toString(bounds.getHeight()));
            attrs.addAttribute("", "font", "font", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vVertex.getFont().getName());
            attrs.addAttribute("", "visible", "visible", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "true");
            attrs.addAttribute("", "fill", "fill", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Integer.toHexString(vVertex.getFillcolor().getRGB()));
            attrs.addAttribute("", "outline", "outline", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Integer.toHexString(vVertex.getOutlinecolor().getRGB()));
            readerAdapter.startElement("", "graphics", "graphics", attrs);
            attrs.clear();
            attrs.addAttribute("", "x", "x", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Double.toString(bounds.getCenterX()));
            attrs.addAttribute("", "y", "y", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Double.toString(bounds.getCenterY()));
            readerAdapter.startElement("", "center", "center", attrs);
            readerAdapter.endElement("", "center", "center");
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "className");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX));
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vVertex.getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "painter");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX));
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vVertex.getPainter().getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
            readerAdapter.endElement("", "Graphic", "Graphic");
        }

        public void endSerializeVertex(Vertex vertex) throws Exception {
            this.commonHandler.endSerializeVertex(vertex);
        }

        public void serializeEdge(Edge edge) throws Exception {
            XMLReaderAdapter readerAdapter = this.commonHandler.getReaderAdapter();
            AttributesImpl attrs = new AttributesImpl();
            this.graphHandler.serializeEdge(edge);
            VisualEdge vEdge = this.vGraph.getVisualEdge(edge);
            attrs.addAttribute("", "font", "font", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vEdge.getFont().getName());
            attrs.addAttribute("", "visible", "visible", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "true");
            attrs.addAttribute("", "fill", "fill", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Integer.toHexString(vEdge.getFillcolor().getRGB()));
            attrs.addAttribute("", "outline", "outline", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Integer.toHexString(vEdge.getOutlinecolor().getRGB()));
            readerAdapter.startElement("", "graphics", "graphics", attrs);
            readerAdapter.startElement("", "Line", "Line", new AttributesImpl());
            double[] edgeSegment = new double[6];
            PathIterator pathIterator = vEdge.getGeneralPath().getPathIterator(null);
            while (!pathIterator.isDone()) {
                int segmentType = pathIterator.currentSegment(edgeSegment);
                if (segmentType != 4) {
                    attrs.clear();
                    attrs.addAttribute("", "x", "x", this.commonHandler.sPool.toString(this.commonHandler.DOUBLE_TYPE_STRINGPOOL_INDEX), Double.toString(edgeSegment[0]));
                    attrs.addAttribute("", "y", "y", this.commonHandler.sPool.toString(this.commonHandler.DOUBLE_TYPE_STRINGPOOL_INDEX), Double.toString(edgeSegment[1]));
                    readerAdapter.startElement("", "point", "point", attrs);
                    readerAdapter.endElement("", "point", "point");
                }
                pathIterator.next();
            }
            readerAdapter.endElement("", "Line", "Line");
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "className");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX));
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vEdge.getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "painter");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX));
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vEdge.getPainter().getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
            readerAdapter.endElement("", "Graphic", "Graphic");
        }

        public void endSerializeEdge(Edge edge) throws Exception {
            this.commonHandler.endSerializeEdge(edge);
        }

        public void endSerialize() throws Exception {
            this.commonHandler.endSerialize();
        }
    }

    class GraphHandler
    extends GraphToXGMMLSAXHandler {
        private CommonHandler commonHandler;

        public GraphHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer, CommonHandler commonHandler) {
            super(eventGenerator, serializer);
            this.commonHandler = commonHandler;
        }

        public void startSerialize(Graph graph) throws Exception {
            this.commonHandler.startSerialize(graph);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "Graphic", "Graphic", this.commonHandler.sPool.toString(this.commonHandler.BOOLEAN_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.ZERO_LITERAL_STRINGPOOL_INDEX));
            attrs.addAttribute("", "Vendor", "Vendor", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), this.commonHandler.sPool.toString(this.commonHandler.OPENJGRAPH_LITERAL_STRINGPOOL_INDEX));
            attrs.addAttribute("", "directed", "directed", this.commonHandler.sPool.toString(this.commonHandler.BOOLEAN_TYPE_STRINGPOOL_INDEX), graph instanceof DirectedGraph ? this.commonHandler.sPool.toString(this.commonHandler.ONE_LITERAL_STRINGPOOL_INDEX) : this.commonHandler.sPool.toString(this.commonHandler.ZERO_LITERAL_STRINGPOOL_INDEX));
            this.commonHandler.getReaderAdapter().startElement("", "graph", "graph", attrs);
            this.commonHandler.serializeOtherGraphMetaInformation();
        }

        public void startSerialize(VisualGraph vGraph) throws Exception {
        }

        public void serializeVertex(Vertex vertex) throws Exception {
            XMLReaderAdapter readerAdapter = this.commonHandler.getReaderAdapter();
            TreeMap vertexIDMap = this.commonHandler.getVertexIDMap();
            long idAttribute = this.commonHandler.getCurrentIDAttribute();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), Long.toString(idAttribute));
            attrs.addAttribute("", "label", "label", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vertex.toString());
            readerAdapter.startElement("", "node", "node", attrs);
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "className");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "string");
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), vertex.getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
        }

        public void endSerializeVertex(Vertex vertex) throws Exception {
            this.commonHandler.endSerializeVertex(vertex);
        }

        public void serializeEdge(Edge edge) throws Exception {
            XMLReaderAdapter readerAdapter = this.commonHandler.getReaderAdapter();
            TreeMap vertexIDMap = this.commonHandler.getVertexIDMap();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "label", "label", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), edge.toString());
            if (edge instanceof DirectedEdgeImpl) {
                DirectedEdge dEdge = (DirectedEdge)edge;
                attrs.addAttribute("", "source", "source", this.commonHandler.sPool.toString(this.commonHandler.INTEGER_TYPE_STRINGPOOL_INDEX), ((Long)vertexIDMap.get(dEdge.getSource())).toString());
                attrs.addAttribute("", "target", "target", this.commonHandler.sPool.toString(this.commonHandler.INTEGER_TYPE_STRINGPOOL_INDEX), ((Long)vertexIDMap.get(dEdge.getSink())).toString());
            } else {
                attrs.addAttribute("", "source", "source", this.commonHandler.sPool.toString(this.commonHandler.INTEGER_TYPE_STRINGPOOL_INDEX), ((Long)vertexIDMap.get(edge.getVertexA())).toString());
                attrs.addAttribute("", "target", "target", this.commonHandler.sPool.toString(this.commonHandler.INTEGER_TYPE_STRINGPOOL_INDEX), ((Long)vertexIDMap.get(edge.getVertexB())).toString());
            }
            if (edge instanceof WeightedEdgeImpl) {
                attrs.addAttribute("", "weight", "weight", this.commonHandler.sPool.toString(this.commonHandler.DOUBLE_TYPE_STRINGPOOL_INDEX), Double.toString(((WeightedEdge)edge).getWeight()));
            }
            readerAdapter.startElement("", "edge", "edge", attrs);
            attrs.clear();
            attrs.addAttribute("", "name", "name", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "className");
            attrs.addAttribute("", "type", "type", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), "string");
            attrs.addAttribute("", "value", "value", this.commonHandler.sPool.toString(this.commonHandler.STRING_TYPE_STRINGPOOL_INDEX), edge.getClass().getName());
            readerAdapter.startElement("", "att", "att", attrs);
            readerAdapter.endElement("", "att", "att");
        }

        public void endSerializeEdge(Edge edge) throws Exception {
            this.commonHandler.endSerializeEdge(edge);
        }

        public void endSerialize() throws Exception {
            this.commonHandler.endSerialize();
        }
    }

    class CommonHandler
    extends GraphToXGMMLSAXHandler {
        protected int DOCTYPE_NAME_STRINGPOOL_INDEX;
        protected int PUBLIC_ID_STRINGPOOL_INDEX;
        protected int SYSTEM_ID_STRINGPOOL_INDEX;
        protected int OPENJGRAPH_LITERAL_STRINGPOOL_INDEX;
        protected int GRAPH_ELEMENT_LITERAL_STRINGPOOL_INDEX;
        protected int VENDOR_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int DIRECTED_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int GRAPHIC_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int ATT_ELEMENT_LITERAL_STRINGPOOL_INDEX;
        protected int ATT_ELEMENT_NAME_ATTRIBUTE_VALUE_WEIGHTED_STRINGPOOL_INDEX;
        protected int ATT_ELEMENT_NAME_ATTRIBUTE_VALUE_DAG_STRINGPOOL_INDEX;
        protected int TYPE_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int NAME_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int VALUE_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int NODE_ELEMENT_LITERAL_STRINGPOOL_INDEX;
        protected int EDGE_ELEMENT_LITERAL_STRINGPOOL_INDEX;
        protected int SOURCE_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int TARGET_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int WEIGHT_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int ID_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int LABEL_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX;
        protected int STRING_TYPE_STRINGPOOL_INDEX;
        protected int INTEGER_TYPE_STRINGPOOL_INDEX;
        protected int DOUBLE_TYPE_STRINGPOOL_INDEX;
        protected int BOOLEAN_TYPE_STRINGPOOL_INDEX;
        protected int ZERO_LITERAL_STRINGPOOL_INDEX;
        protected int ONE_LITERAL_STRINGPOOL_INDEX;
        private XMLReaderAdapter readerAdapter;
        private Graph graph;
        private SAXParser parser;
        private OutputFormat format;
        private TreeMap vertexIDMap;
        private long idAttribute;
        private StringPool sPool = this.initStringPool();

        public CommonHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer) {
            super(eventGenerator, serializer);
        }

        public void startSerialize(Graph graph) throws Exception {
            this.graph = graph;
            this.parser = new SAXParser();
            this.readerAdapter = new XMLReaderAdapter((XMLReader)this.parser);
            this.format = new OutputFormat();
            this.vertexIDMap = new TreeMap(new VertexComparator());
            this.idAttribute = 1L;
            this.format.setOmitXMLDeclaration(false);
            this.format.setEncoding("UTF-8");
            this.format.setIndenting(true);
            this.format.setDoctype("-//John Punin//DTD graph description//EN", "http://www.cs.rpi.edu/~puninj/XGMML/xgmml.dtd");
            this.serializer.setOutputFormat(this.format);
            this.parser.setContentHandler((ContentHandler)this.serializer);
            this.parser.startDocument();
            this.parser.startDTD(new QName(-1, this.DOCTYPE_NAME_STRINGPOOL_INDEX, this.DOCTYPE_NAME_STRINGPOOL_INDEX), this.PUBLIC_ID_STRINGPOOL_INDEX, this.SYSTEM_ID_STRINGPOOL_INDEX);
            this.parser.endDTD();
            this.readerAdapter.setDocumentHandler((DocumentHandler)this.serializer);
        }

        public void startSerialize(VisualGraph vGraph) throws Exception {
        }

        public void serializeVertex(Vertex vertex) throws Exception {
        }

        public void endSerializeVertex(Vertex vertex) throws Exception {
            this.readerAdapter.endElement("", "node", "node");
            this.vertexIDMap.put(vertex, new Long(this.idAttribute));
            this.incremenetIDAttribute();
        }

        public void serializeEdge(Edge edge) throws Exception {
        }

        public void endSerializeEdge(Edge edge) throws Exception {
            this.readerAdapter.endElement("", "edge", "edge");
        }

        public void endSerialize() throws Exception {
            this.readerAdapter.endElement("", "graph", "graph");
            this.parser.endDocument();
        }

        protected XMLReaderAdapter getReaderAdapter() {
            return this.readerAdapter;
        }

        protected TreeMap getVertexIDMap() {
            return this.vertexIDMap;
        }

        protected long getCurrentIDAttribute() {
            return this.idAttribute;
        }

        protected void incremenetIDAttribute() {
            ++this.idAttribute;
        }

        private StringPool initStringPool() {
            StringPool sPool = new StringPool();
            this.DOCTYPE_NAME_STRINGPOOL_INDEX = sPool.addString("graph");
            this.PUBLIC_ID_STRINGPOOL_INDEX = sPool.addString("-//John Punin//DTD graph description//EN");
            this.SYSTEM_ID_STRINGPOOL_INDEX = sPool.addString("http://www.cs.rpi.edu/~puninj/XGMML/xgmml.dtd");
            this.GRAPH_ELEMENT_LITERAL_STRINGPOOL_INDEX = sPool.addString("graph");
            this.VENDOR_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX = sPool.addString("Vendor");
            this.OPENJGRAPH_LITERAL_STRINGPOOL_INDEX = sPool.addString("OpenJGraph");
            this.GRAPHIC_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX = sPool.addString("Graphic");
            this.DIRECTED_ATTRIBUTE_LITERAL_STRINGPOOL_INDEX = sPool.addString("directed");
            this.STRING_TYPE_STRINGPOOL_INDEX = sPool.addString("string");
            this.INTEGER_TYPE_STRINGPOOL_INDEX = sPool.addString("integer");
            this.DOUBLE_TYPE_STRINGPOOL_INDEX = sPool.addString("double");
            this.BOOLEAN_TYPE_STRINGPOOL_INDEX = sPool.addString("boolean");
            this.ZERO_LITERAL_STRINGPOOL_INDEX = sPool.addString("0");
            this.ONE_LITERAL_STRINGPOOL_INDEX = sPool.addString("1");
            return sPool;
        }

        protected void serializeOtherGraphMetaInformation() throws Exception {
            AttributesImpl attrs = new AttributesImpl();
            if (this.graph instanceof DirectedAcyclicGraph) {
                attrs.addAttribute("", "name", "name", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "dag");
                attrs.addAttribute("", "type", "type", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "integer");
                attrs.addAttribute("", "value", "value", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), this.sPool.toString(this.ONE_LITERAL_STRINGPOOL_INDEX));
                this.readerAdapter.startElement("", "att", "att", attrs);
                this.readerAdapter.endElement("", "att", "att");
            } else if (this.graph instanceof WeightedGraph) {
                attrs.addAttribute("", "name", "name", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "weighted");
                attrs.addAttribute("", "type", "type", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "integer");
                attrs.addAttribute("", "value", "value", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), this.sPool.toString(this.ONE_LITERAL_STRINGPOOL_INDEX));
                this.readerAdapter.startElement("", "att", "att", attrs);
                this.readerAdapter.endElement("", "att", "att");
            }
            attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "graphFactory");
            attrs.addAttribute("", "type", "type", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "string");
            attrs.addAttribute("", "value", "value", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), this.graph.getGraphFactory().getClass().getName());
            this.readerAdapter.startElement("", "att", "att", attrs);
            this.readerAdapter.endElement("", "att", "att");
            attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "traversal");
            attrs.addAttribute("", "type", "type", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), "string");
            attrs.addAttribute("", "value", "value", this.sPool.toString(this.STRING_TYPE_STRINGPOOL_INDEX), this.graph.getTraversal().getClass().getName());
            this.readerAdapter.startElement("", "att", "att", attrs);
            this.readerAdapter.endElement("", "att", "att");
        }
    }
}

