/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.SingleOutlierDetector;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.Comparator;
import java.util.ArrayList;
import java.util.List;

public class OutliersDetector
implements IOutliersDetectionModule {
    private static final double EPS = 1.0E-5;
    private static final int MAXROUND = 50;
    private static final int MAXOUTLIERS = 24;
    private RegArimaModel<SarimaModel> regarima_;
    private final ArrayList<IOutlierVariable> outliers_ = new ArrayList();
    private final SingleOutlierDetector sod_ = new SingleOutlierDetector();
    private double[] coeff_;
    private double[] tstats_;
    private int nhp_;
    private int round_;
    private boolean rflag_;
    private boolean backw_;
    private boolean exit_;
    private boolean festim_;
    private IOutlierVariable lastremoved_;
    private DataBlock res_;
    private TsPeriodSelector span_;
    private boolean mvx_;
    private boolean cmvx_;
    private int selectivity_;
    private double cv_;
    private double curcv_;
    private double pc_ = 0.12;
    public static final double MINCV = 2.0;
    private static final String OUTLIERS = "Outliers detection";
    private static final String OUT_ADD = "Outlier added";
    private static final String OUT_REMOVE = "Outlier removed";
    private static final String VA = "Critical value";

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.clear();
        List<OutlierDefinition> initial = OutlierDefinition.of(context.description.getOutliers());
        if (this.curcv_ == 0.0) {
            this.curcv_ = this.calcCv(context);
        }
        this.addVaInfo(context, this.curcv_);
        int test = this.comatip(context.description);
        if (test < 0) {
            return ProcessingResult.Unprocessed;
        }
        this.cmvx_ = test > 0;
        TsDomain edomain = context.description.getEstimationDomain();
        this.sod_.prepare(edomain, this.span_ == null ? null : edomain.select(this.span_));
        this.sod_.exclude(context.description.getMissingValues());
        this.sod_.exclude(context.description.getOutliersPosition(true));
        this.sod_.exclude(context.description.getOutliersPosition(false));
        this.sod_.exclude(context.description.getFixedOutliersPosition());
        this.outliers_.addAll(context.description.getOutliers());
        this.regarima_ = context.description.buildRegArima();
        this.nhp_ = this.regarima_.getArima().getParametersCount();
        double max = 0.0;
        try {
            do {
                if (!this.estimateModel()) {
                    return ProcessingResult.Failed;
                }
                boolean search = true;
                if (this.backw_) {
                    search = this.verifyModel(context);
                    if (this.exit_) break;
                }
                if (!search) continue;
                if (!this.sod_.process(this.regarima_.getArima(), this.res_)) break;
                ++this.round_;
                max = this.sod_.getMaxTStat();
                if (Math.abs(max) < this.curcv_) break;
                IOutlierVariable o = this.sod_.getMaxOutlier();
                boolean bok = true;
                for (int i = 0; i < this.outliers_.size(); ++i) {
                    if (!o.getPosition().equals((Object)this.outliers_.get(i).getPosition())) continue;
                    bok = false;
                    break;
                }
                if (!bok) break;
                this.addOutlier(o, this.sod_.getMaxCoefficient());
                this.addOutlierInfo(context, o, max);
                if (this.outliers_.size() == 24) break;
            } while (this.round_ < 50);
            if (this.exit_ || this.round_ == 50 || this.outliers_.size() == 24) {
                this.updateLikelihood(this.regarima_.computeLikelihood());
            }
            this.festim_ = false;
            while (!this.verifyModel(context)) {
                this.updateLikelihood(this.regarima_.computeLikelihood());
            }
            if (!Comparator.equals(initial, OutlierDefinition.of(this.outliers_))) {
                context.description.setOutliers(this.outliers_);
                this.addInfo(context.description, context.information);
                context.estimation = null;
                return ProcessingResult.Changed;
            }
            return ProcessingResult.Unchanged;
        }
        catch (RuntimeException err) {
            return ProcessingResult.Failed;
        }
    }

    private GlsSarimaMonitor makeMonitor() {
        ProxyMinimizer minimizer = new ProxyMinimizer(new LevenbergMarquardtMethod());
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(minimizer);
        monitor.setPrecision(1.0E-5);
        return monitor;
    }

    private boolean estimateModel() {
        SarimaModel sarima = this.regarima_.getArima().clone();
        SarimaSpecification spec = sarima.getSpecification();
        if (this.rflag_) {
            if (this.regarima_.getDModel().getVarsCount() > 0) {
                Ols ols = new Ols();
                if (!ols.process(this.regarima_.getDModel())) {
                    return false;
                }
                this.res_ = ols.getResiduals();
            } else {
                this.res_ = this.regarima_.getDModel().getY().deepClone();
            }
        } else {
            this.res_ = this.coeff_ != null ? this.regarima_.getDModel().calcRes(new DataBlock(this.coeff_)) : this.regarima_.getDModel().getY();
        }
        boolean stable = true;
        this.rflag_ = false;
        if (this.festim_) {
            HannanRissanen hr;
            SarmaSpecification dspec = spec.doStationary();
            if (spec.getParametersCount() != 0 && (hr = new HannanRissanen()).process(this.res_, dspec)) {
                SarimaModel stmodel = hr.getModel();
                boolean bl = stable = !SarimaMapping.stabilize(stmodel);
                if (stable || this.cmvx_ || this.round_ == 0) {
                    sarima.setParameters(stmodel.getParameters());
                    this.regarima_.setArima(sarima);
                } else {
                    this.rflag_ = true;
                    stable = true;
                }
            }
            if ((this.cmvx_ || !stable) && this.festim_) {
                return this.optimizeModel();
            }
        }
        if (this.regarima_.getVarsCount() > 0) {
            this.updateLikelihood(this.regarima_.computeLikelihood());
        }
        return true;
    }

    private boolean optimizeModel() {
        GlsSarimaMonitor monitor = this.makeMonitor();
        RegArimaEstimation<SarimaModel> estimation = monitor.optimize(this.regarima_);
        if (!monitor.hasConverged()) {
            int iter = 0;
            monitor.useMaximumLikelihood(false);
            double tol = 1.0E-5;
            do {
                monitor.setPrecision(tol *= 10.0);
                estimation = monitor.optimize(this.regarima_);
            } while (!monitor.hasConverged() && iter++ < 3);
            if (iter == 3) {
                return false;
            }
        }
        this.regarima_ = estimation.model;
        this.updateLikelihood(estimation.likelihood);
        return true;
    }

    private void updateLikelihood(ConcentratedLikelihood likelihood) {
        this.coeff_ = likelihood.getB();
        this.tstats_ = likelihood.getTStats(true, this.nhp_);
        this.res_ = this.regarima_.getDModel().calcRes(new DataBlock(this.coeff_));
    }

    private void clear() {
        this.rflag_ = true;
        this.nhp_ = 0;
        this.outliers_.clear();
        this.festim_ = true;
        this.backw_ = false;
        this.exit_ = false;
        this.round_ = 0;
        this.lastremoved_ = null;
        this.res_ = null;
        this.coeff_ = null;
        this.tstats_ = null;
        this.curcv_ = 0.0;
    }

    private boolean verifyModel(ModellingContext context) {
        this.festim_ = true;
        if (this.outliers_.isEmpty()) {
            return true;
        }
        int nx0 = this.regarima_.getVarsCount() - this.outliers_.size();
        int imin = 0;
        for (int i = 1; i < this.outliers_.size(); ++i) {
            if (!(Math.abs(this.tstats_[i + nx0]) < Math.abs(this.tstats_[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(this.tstats_[nx0 + imin]) >= this.curcv_) {
            return true;
        }
        this.backw_ = false;
        this.festim_ = false;
        IOutlierVariable toremove = this.outliers_.get(imin);
        this.sod_.allow(toremove);
        this.removeOutlier(imin);
        this.removeOutlierInfo(context, toremove);
        if (this.lastremoved_ != null && toremove.getPosition().equals((Object)this.lastremoved_.getPosition()) && toremove.getOutlierType() == this.lastremoved_.getOutlierType()) {
            this.exit_ = true;
        }
        this.lastremoved_ = toremove;
        return false;
    }

    private void addOutlier(IOutlierVariable o) {
        this.outliers_.add(o);
        double[] xo = new double[this.regarima_.getObsCount()];
        DataBlock XO = new DataBlock(xo);
        o.data(this.sod_.getDomain().getStart(), XO);
        this.regarima_.addX(XO);
        this.sod_.exclude(o);
    }

    private void addOutlier(IOutlierVariable o, double c) {
        this.addOutlier(o);
        if (this.coeff_ == null) {
            this.coeff_ = new double[]{c};
        } else {
            double[] tmp = new double[this.coeff_.length + 1];
            for (int i = 0; i < this.coeff_.length; ++i) {
                tmp[i] = this.coeff_[i];
            }
            tmp[this.coeff_.length] = c;
            this.coeff_ = tmp;
        }
        this.backw_ = true;
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima_.getXCount() - this.outliers_.size() + idx;
        this.regarima_.removeX(opos);
        this.outliers_.remove(idx);
        if (this.coeff_.length == 1) {
            this.coeff_ = null;
        } else {
            int i;
            if (this.regarima_.isMeanCorrection()) {
                ++opos;
            }
            double[] tmp = new double[this.coeff_.length - 1];
            for (i = 0; i < opos; ++i) {
                tmp[i] = this.coeff_[i];
            }
            for (i = opos + 1; i < this.coeff_.length; ++i) {
                tmp[i - 1] = this.coeff_[i];
            }
            this.coeff_ = tmp;
        }
    }

    public void addOutlierFactory(IOutlierFactory o) {
        this.sod_.addOutlierFactory(o);
    }

    public void clearOutlierFactories() {
        this.sod_.clearOutlierFactories();
    }

    public void setAll() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        LevelShiftFactory lfac = new LevelShiftFactory();
        lfac.setZeroEnded(true);
        this.addOutlierFactory(lfac);
        this.addOutlierFactory(new TransitoryChangeFactory());
        SeasonalOutlierFactory sfac = new SeasonalOutlierFactory();
        sfac.setZeroEnded(true);
        this.addOutlierFactory(sfac);
    }

    public int getOutlierFactoriesCount() {
        return this.sod_.getOutlierFactoriesCount();
    }

    public void setDefault() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        this.addOutlierFactory(new LevelShiftFactory());
        this.addOutlierFactory(new TransitoryChangeFactory());
        this.curcv_ = 0.0;
    }

    public boolean isEML() {
        return this.mvx_;
    }

    public boolean hasUsedEML() {
        return this.cmvx_;
    }

    public void useEML(boolean value) {
        this.mvx_ = value;
    }

    public void setCriticalValue(double value) {
        this.cv_ = value;
    }

    public double getCritivalValue() {
        return this.cv_;
    }

    public double getPc() {
        return this.pc_;
    }

    public void setPc(double pc) {
        this.pc_ = pc;
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
        InformationSet subset = information.subSet("outliers");
        subset.set("count", Integer.valueOf(desc.getOutliers().size()));
    }

    private int comatip(ModelDescription desc) {
        SarimaSpecification spec;
        int nparm;
        int n = desc.getY().length;
        if (desc.getMissingValues() != null) {
            n -= desc.getMissingValues().length;
        }
        if (n - (nparm = Math.max((spec = desc.getSpecification().clone()).getD() + spec.getP() + spec.getFrequency() * (spec.getBD() + spec.getBP()), spec.getQ() + spec.getFrequency() * spec.getBQ()) + (desc.isEstimatedMean() ? 1 : 0) + 15 * n / 100 + spec.getFrequency()) <= 0) {
            return -1;
        }
        if (this.mvx_) {
            return 1;
        }
        int ndf1 = TramoProcessor.autlar(n, spec);
        int ndf2 = 0;
        if (spec.getP() + spec.getBP() > 0 && spec.getQ() + spec.getBQ() > 0) {
            spec.setP(0);
            spec.setBP(0);
            ndf2 = TramoProcessor.autlar(n -= spec.getP() + spec.getFrequency() * spec.getBP(), spec);
        }
        if (ndf1 < 0 || ndf2 < 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean reduceSelectivity() {
        if (this.curcv_ == 0.0) {
            return false;
        }
        --this.selectivity_;
        if (this.curcv_ == 2.0) {
            return false;
        }
        this.curcv_ = Math.max(2.0, this.curcv_ * (1.0 - this.pc_));
        return true;
    }

    @Override
    public void setSelectivity(int level) {
        if (this.selectivity_ != level) {
            this.selectivity_ = level;
            this.curcv_ = 0.0;
        }
    }

    @Override
    public int getSelectivity() {
        return this.selectivity_;
    }

    @Deprecated
    public static double calcDefaultCriticalValue(int n) {
        double cv = 0.0;
        cv = n <= 50 ? 3.3 : (n < 450 ? 3.3 + 0.0025 * (double)(n - 50) : 4.3);
        return cv;
    }

    private double calcCv(ModellingContext context) {
        double cv = this.cv_;
        if (cv == 0.0) {
            cv = IOutliersDetectionModule.ICriticalValueComputer.defaultComputer().compute(context.description.getY().length);
        }
        for (int i = 0; i < -this.selectivity_; ++i) {
            cv *= 1.0 - this.pc_;
        }
        return Math.max(cv, 2.0);
    }

    public void setSpan(TsPeriodSelector span) {
        this.span_ = span;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    private void addOutlierInfo(ModellingContext context, IOutlierVariable var, double t) {
    }

    private void removeOutlierInfo(ModellingContext context, IOutlierVariable var) {
    }

    private void addVaInfo(ModellingContext context, double va) {
    }
}

