/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.ihm.controle;

import java.awt.Color;
import javalain.algorithmegenetique.ihm.ControleAlgoG;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import util.GuiUtils;

public final class TexteNbMeilleur
extends JTextField
implements CaretListener {
    private ControleAlgoG ctrlAG;
    private boolean erreur;
    private int valeur;

    public TexteNbMeilleur(ControleAlgoG c) {
        super(3);
        this.addCaretListener(this);
        this.ctrlAG = c;
        this.erreur = false;
        this.valeur = Integer.MAX_VALUE;
    }

    public void setValeur(int i) {
        if (this.valeur != i) {
            this.valeur = i;
            this.setText(Integer.toString(i));
        }
    }

    @Override
    public void caretUpdate(CaretEvent ce) {
        this.invokeLater();
    }

    private void invokeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        int i = Integer.parseInt(TexteNbMeilleur.this.getText());
                        if (i <= 0) {
                            throw new NumberFormatException();
                        }
                        TexteNbMeilleur.this.valeur = i;
                        TexteNbMeilleur.this.ctrlAG.getEvolution().getPopulation().getParametreAG().setNbMeilleurs(i);
                        TexteNbMeilleur.this.setBackground(Color.white);
                        TexteNbMeilleur.this.erreur = false;
                    }
                    catch (NumberFormatException nfe) {
                        if (TexteNbMeilleur.this.erreur) break block3;
                        JOptionPane.showMessageDialog(TexteNbMeilleur.this.ctrlAG, "<html>Elitisme<br/>-----<br/>Vous devez entrer un nombre entier positif non nul</html>", "Message", 2);
                        TexteNbMeilleur.this.setBackground(GuiUtils.BLEU_ERREUR);
                        TexteNbMeilleur.this.erreur = true;
                    }
                }
            }
        });
    }
}

