/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.svd.AbstractFactorizer;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.als.AlternatingLeastSquaresSolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALSWRFactorizer
extends AbstractFactorizer {
    private final DataModel dataModel;
    private final int numFeatures;
    private final double lambda;
    private final int numIterations;
    private static final Logger log = LoggerFactory.getLogger(ALSWRFactorizer.class);

    public ALSWRFactorizer(DataModel dataModel, int numFeatures, double lambda, int numIterations) throws TasteException {
        super(dataModel);
        this.dataModel = dataModel;
        this.numFeatures = numFeatures;
        this.lambda = lambda;
        this.numIterations = numIterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Factorization factorize() throws TasteException {
        log.info("starting to compute the factorization...");
        final AlternatingLeastSquaresSolver solver = new AlternatingLeastSquaresSolver();
        final Features features = new Features(this);
        for (int iteration = 0; iteration < this.numIterations; ++iteration) {
            log.info("iteration {}", (Object)iteration);
            ExecutorService queue = this.createQueue();
            LongPrimitiveIterator userIDsIterator = this.dataModel.getUserIDs();
            try {
                while (userIDsIterator.hasNext()) {
                    final long userID = userIDsIterator.nextLong();
                    final LongPrimitiveIterator itemIDsFromUser = this.dataModel.getItemIDsFromUser(userID).iterator();
                    final PreferenceArray userPrefs = this.dataModel.getPreferencesFromUser(userID);
                    queue.execute(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<Vector> featureVectors = Lists.newArrayList();
                            while (itemIDsFromUser.hasNext()) {
                                long itemID = itemIDsFromUser.nextLong();
                                featureVectors.add(features.getItemFeatureColumn(ALSWRFactorizer.this.itemIndex(itemID)));
                            }
                            Vector userFeatures = solver.solve(featureVectors, ALSWRFactorizer.this.ratingVector(userPrefs), ALSWRFactorizer.this.lambda, ALSWRFactorizer.this.numFeatures);
                            features.setFeatureColumnInU(ALSWRFactorizer.this.userIndex(userID), userFeatures);
                        }
                    });
                }
            }
            finally {
                queue.shutdown();
                try {
                    queue.awaitTermination(this.dataModel.getNumUsers(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.warn("Error when computing user features", e);
                }
            }
            queue = this.createQueue();
            LongPrimitiveIterator itemIDsIterator = this.dataModel.getItemIDs();
            try {
                while (itemIDsIterator.hasNext()) {
                    final long itemID = itemIDsIterator.nextLong();
                    final PreferenceArray itemPrefs = this.dataModel.getPreferencesForItem(itemID);
                    queue.execute(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<Vector> featureVectors = Lists.newArrayList();
                            for (Preference pref : itemPrefs) {
                                long userID = pref.getUserID();
                                featureVectors.add(features.getUserFeatureColumn(ALSWRFactorizer.this.userIndex(userID)));
                            }
                            Vector itemFeatures = solver.solve(featureVectors, ALSWRFactorizer.this.ratingVector(itemPrefs), ALSWRFactorizer.this.lambda, ALSWRFactorizer.this.numFeatures);
                            features.setFeatureColumnInM(ALSWRFactorizer.this.itemIndex(itemID), itemFeatures);
                        }
                    });
                }
                continue;
            }
            finally {
                queue.shutdown();
                try {
                    queue.awaitTermination(this.dataModel.getNumItems(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.warn("Error when computing item features", e);
                }
            }
        }
        log.info("finished computation of the factorization...");
        return this.createFactorization(features.getU(), features.getM());
    }

    protected ExecutorService createQueue() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    protected Vector ratingVector(PreferenceArray prefs) {
        double[] ratings = new double[prefs.length()];
        for (int n = 0; n < prefs.length(); ++n) {
            ratings[n] = prefs.get(n).getValue();
        }
        return new DenseVector(ratings);
    }

    static class Features {
        private final DataModel dataModel;
        private final int numFeatures;
        private final double[][] M;
        private final double[][] U;

        Features(ALSWRFactorizer factorizer) throws TasteException {
            this.dataModel = factorizer.dataModel;
            this.numFeatures = factorizer.numFeatures;
            Random random = RandomUtils.getRandom();
            this.M = new double[this.dataModel.getNumItems()][this.numFeatures];
            LongPrimitiveIterator itemIDsIterator = this.dataModel.getItemIDs();
            while (itemIDsIterator.hasNext()) {
                long itemID = itemIDsIterator.nextLong();
                int itemIDIndex = factorizer.itemIndex(itemID);
                this.M[itemIDIndex][0] = this.averateRating(itemID);
                for (int feature = 1; feature < this.numFeatures; ++feature) {
                    this.M[itemIDIndex][feature] = random.nextDouble() * 0.1;
                }
            }
            this.U = new double[this.dataModel.getNumUsers()][this.numFeatures];
        }

        double[][] getM() {
            return this.M;
        }

        double[][] getU() {
            return this.U;
        }

        Vector getUserFeatureColumn(int index) {
            return new DenseVector(this.U[index]);
        }

        Vector getItemFeatureColumn(int index) {
            return new DenseVector(this.M[index]);
        }

        void setFeatureColumnInU(int idIndex, Vector vector) {
            this.setFeatureColumn(this.U, idIndex, vector);
        }

        void setFeatureColumnInM(int idIndex, Vector vector) {
            this.setFeatureColumn(this.M, idIndex, vector);
        }

        protected void setFeatureColumn(double[][] matrix, int idIndex, Vector vector) {
            for (int feature = 0; feature < this.numFeatures; ++feature) {
                matrix[idIndex][feature] = vector.get(feature);
            }
        }

        protected double averateRating(long itemID) throws TasteException {
            PreferenceArray prefs = this.dataModel.getPreferencesForItem(itemID);
            FullRunningAverage avg = new FullRunningAverage();
            for (Preference pref : prefs) {
                avg.addDatum(pref.getValue());
            }
            return avg.getAverage();
        }
    }
}

