/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.DataRetrievalRule;

@SdkInternalApi
public class DataRetrievalRuleMarshaller {
    private static final MarshallingInfo<String> STRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Strategy").build();
    private static final MarshallingInfo<Long> BYTESPERHOUR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesPerHour").build();
    private static final DataRetrievalRuleMarshaller instance = new DataRetrievalRuleMarshaller();

    public static DataRetrievalRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataRetrievalRule dataRetrievalRule, ProtocolMarshaller protocolMarshaller) {
        if (dataRetrievalRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataRetrievalRule.getStrategy(), STRATEGY_BINDING);
            protocolMarshaller.marshall((Object)dataRetrievalRule.getBytesPerHour(), BYTESPERHOUR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

