/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.BatchWriteOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchWriteRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private List<BatchWriteOperation> operations;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public BatchWriteRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public List<BatchWriteOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(Collection<BatchWriteOperation> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new ArrayList<BatchWriteOperation>(operations);
    }

    public BatchWriteRequest withOperations(BatchWriteOperation ... operations) {
        if (this.operations == null) {
            this.setOperations(new ArrayList<BatchWriteOperation>(operations.length));
        }
        for (BatchWriteOperation ele : operations) {
            this.operations.add(ele);
        }
        return this;
    }

    public BatchWriteRequest withOperations(Collection<BatchWriteOperation> operations) {
        this.setOperations(operations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getOperations() != null) {
            sb.append("Operations: ").append(this.getOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteRequest)) {
            return false;
        }
        BatchWriteRequest other = (BatchWriteRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        return other.getOperations() == null || other.getOperations().equals(this.getOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        return hashCode;
    }

    public BatchWriteRequest clone() {
        return (BatchWriteRequest)super.clone();
    }
}

