/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class TautomerizationMechanism
implements IReactionMechanism {
    @Override
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 1) {
            throw new CDKException("TautomerizationMechanism only expects one IAtomContainer");
        }
        if (atomList.size() != 4) {
            throw new CDKException("TautomerizationMechanism expects four atoms in the ArrayList");
        }
        if (bondList.size() != 3) {
            throw new CDKException("TautomerizationMechanism expects three bonds in the ArrayList");
        }
        IAtomContainer molecule = atomContainerSet.getAtomContainer(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IAtomContainer!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.indexOf(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule.indexOf(atom2));
        IAtom atom3 = atomList.get(2);
        IAtom atom3C = reactantCloned.getAtom(molecule.indexOf(atom3));
        IAtom atom4 = atomList.get(3);
        IAtom atom4C = reactantCloned.getAtom(molecule.indexOf(atom4));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.indexOf(bond1);
        IBond bond2 = bondList.get(1);
        int posBond2 = molecule.indexOf(bond2);
        IBond bond3 = bondList.get(2);
        int posBond3 = molecule.indexOf(bond3);
        BondManipulator.decreaseBondOrder(reactantCloned.getBond(posBond1));
        BondManipulator.increaseBondOrder(reactantCloned.getBond(posBond2));
        reactantCloned.removeBond(reactantCloned.getBond(posBond3));
        IBond newBond = molecule.getBuilder().newInstance(IBond.class, new Object[]{atom1C, atom4C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        atom3C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom3C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        IReaction reaction = atom2C.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = atom2C.getBuilder().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.indexOf(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

