/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;

public class FieldUtil {
    private FieldUtil() {
    }

    public static <F extends Field<?>> Map<FieldName, F> nameMap(Collection<? extends F> fields) {
        LinkedHashMap<FieldName, Field> fieldMap = new LinkedHashMap<FieldName, Field>(2 * fields.size());
        for (Field field : fields) {
            FieldName name = field.getName();
            Field previousField = fieldMap.put(name, field);
            if (previousField == null) continue;
            throw new IllegalArgumentException("Fields " + FieldUtil.format(field) + " and " + FieldUtil.format(previousField) + " have the same name " + name);
        }
        return fieldMap;
    }

    public static <F extends Field<?>> Set<FieldName> nameSet(Collection<? extends F> fields) {
        Map<FieldName, F> fieldMap = FieldUtil.nameMap(fields);
        return fieldMap.keySet();
    }

    public static <F extends Field<?>> Collection<F> selectAll(Collection<? extends F> fields, Set<FieldName> names) {
        return FieldUtil.selectAll(fields, names, false);
    }

    public static <F extends Field<?>> Collection<F> selectAll(Collection<? extends F> fields, Set<FieldName> names, boolean allowPartialSelection) {
        LinkedHashMap<FieldName, Field> fieldMap = new LinkedHashMap<FieldName, Field>(2 * names.size());
        for (Field field : fields) {
            Field previousField;
            FieldName name = field.getName();
            if (!names.contains(name) || (previousField = fieldMap.put(name, field)) == null) continue;
            throw new IllegalArgumentException("Fields " + FieldUtil.format(field) + " and " + FieldUtil.format(previousField) + " have the same name " + name);
        }
        if (!allowPartialSelection && fieldMap.size() < names.size()) {
            LinkedHashSet<FieldName> unmatchedNames = new LinkedHashSet<FieldName>(names);
            unmatchedNames.removeAll(fieldMap.keySet());
            throw new IllegalArgumentException("Name(s) " + unmatchedNames + " do not match any fields");
        }
        return fieldMap.values();
    }

    private static String format(Field<?> field) {
        return String.valueOf(field);
    }
}

