/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.output.DietOutput;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.stage.DietOutputStage;
import fr.ird.osmose.stage.IStage;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PredatorPressureOutput
extends SimulationLinker
implements IOutput {
    private FileOutputStream fos;
    private PrintWriter prw;
    private int recordFrequency;
    private double[][][][] predatorPressure;
    private IStage dietOutputStage;
    private final String separator = this.getConfiguration().getOutputSeparator();

    public PredatorPressureOutput(int rank) {
        super(rank);
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        int nSpec = this.getNSpecies();
        int nPrey = nSpec + this.getConfiguration().getNPlankton();
        this.predatorPressure = new double[nSpec][][][];
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            int nStage = this.dietOutputStage.getNStage(iSpec);
            this.predatorPressure[iSpec] = new double[nStage][][];
            for (int s = 0; s < nStage; ++s) {
                this.predatorPressure[iSpec][s] = new double[nPrey][];
                for (int iPrey = 0; iPrey < nPrey; ++iPrey) {
                    this.predatorPressure[iSpec][s][iPrey] = iPrey < nSpec ? new double[this.dietOutputStage.getNStage(iPrey)] : new double[1];
                }
            }
        }
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int iSpec = school.getSpeciesIndex();
            int stage = this.dietOutputStage.getStage(school);
            for (Prey prey : school.getPreys()) {
                double[] dArray = this.predatorPressure[iSpec][stage][prey.getSpeciesIndex()];
                int n = this.dietOutputStage.getStage(prey);
                dArray[n] = dArray[n] + prey.getBiomass();
            }
        }
    }

    @Override
    public void write(float time) {
        int nSpec = this.getNSpecies();
        int dtRecord = this.getConfiguration().getInt("output.recordfrequency.ndt");
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            String name = this.getSimulation().getSpecies(iSpec).getName();
            float[] threshold = this.dietOutputStage.getThresholds(iSpec);
            int nStagePred = this.dietOutputStage.getNStage(iSpec);
            for (int iStage = 0; iStage < nStagePred; ++iStage) {
                this.prw.print(time);
                this.prw.print(this.separator);
                if (nStagePred == 1) {
                    this.prw.print(name);
                } else if (iStage == 0) {
                    this.prw.print(this.quote(name + " < " + threshold[iStage]));
                } else {
                    this.prw.print(this.quote(name + " >=" + threshold[iStage - 1]));
                }
                this.prw.print(this.separator);
                for (int i = 0; i < nSpec; ++i) {
                    int nStage = this.dietOutputStage.getNStage(i);
                    for (int s = 0; s < nStage; ++s) {
                        float val = (float)(this.predatorPressure[i][s][iSpec][iStage] / (double)dtRecord);
                        String sval = Float.isInfinite(val) ? "Inf" : Float.toString(val);
                        this.prw.print(sval);
                        if (i >= nSpec - 1 && s >= nStage - 1) continue;
                        this.prw.print(this.separator);
                    }
                }
                this.prw.println();
            }
        }
        for (int j = nSpec; j < nSpec + this.getConfiguration().getNPlankton(); ++j) {
            this.prw.print(time);
            this.prw.print(this.separator);
            this.prw.print(this.getSimulation().getPlankton(j - nSpec));
            this.prw.print(this.separator);
            for (int i = 0; i < nSpec; ++i) {
                int nStage = this.dietOutputStage.getNStage(i);
                for (int s = 0; s < nStage; ++s) {
                    this.prw.print((float)(this.predatorPressure[i][s][j][0] / (double)dtRecord));
                    if (i >= nSpec - 1 && s >= nStage - 1) continue;
                    this.prw.print(this.separator);
                }
            }
            this.prw.println();
        }
    }

    @Override
    public void init() {
        this.recordFrequency = this.getConfiguration().getInt("output.recordfrequency.ndt");
        this.dietOutputStage = new DietOutputStage();
        this.dietOutputStage.init();
        File path = new File(this.getConfiguration().getOutputPathname());
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_predatorPressure_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        File file = new File(path, filename.toString());
        boolean fileExists = file.exists();
        file.getParentFile().mkdirs();
        try {
            this.fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DietOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.prw = new PrintWriter(this.fos, true);
        if (!fileExists) {
            this.prw.println(this.quote("Biomass of prey species (in tons per time step of saving, in rows) eaten by a predator species (in col). The last column reports the biomass of prey at the beginning of the time step (before all sources of mortality - fishing, predation, starvation, others)"));
            this.prw.print(this.quote("Time"));
            this.prw.print(this.separator);
            this.prw.print(this.quote("Prey"));
            for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                String name = this.getSimulation().getSpecies(iSpec).getName();
                float[] threshold = this.dietOutputStage.getThresholds(iSpec);
                int nStage = this.dietOutputStage.getNStage(iSpec);
                for (int iStage = 0; iStage < nStage; ++iStage) {
                    this.prw.print(this.separator);
                    if (nStage == 1) {
                        this.prw.print(this.quote(name));
                        continue;
                    }
                    if (iStage == 0) {
                        this.prw.print(this.quote(name + " < " + threshold[iStage]));
                        continue;
                    }
                    this.prw.print(this.quote(name + " >=" + threshold[iStage - 1]));
                }
            }
            this.prw.println();
        }
    }

    @Override
    public void close() {
        if (null != this.prw) {
            this.prw.close();
        }
        if (null != this.fos) {
            try {
                this.fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return (iStepSimu + 1) % this.recordFrequency == 0;
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }
}

