/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import mrmc.core.DBRecord;
import mrmc.core.MRMC;
import mrmc.gui.GUInterface;

public class ManualCard {
    private GUInterface gui;
    private MRMC lst;
    private JTextField manualInReader;
    private JTextField manualInNormal;
    private JTextField manualInDisease;
    private JTextField AUCText1;
    private JTextField AUCText2;
    private DBRecord record;
    private double[] auc = new double[2];
    private JRadioButton com1Button;
    private JRadioButton SingleMod;
    private int Reader;
    private int Normal;
    private int Disease;
    private int selectedManualComp = 0;
    private String BDGlabel = "M1, M2, M3, M4, M5, M6, M7, M8";
    private String DBMlabel = "R, C, RC, TR, TC, TRC";
    private String BCKlabel = "N, D, ND, R, NR, DR, RND";
    private String ORlabel = "R, TR, COV1, COV2, COV3, ERROR";
    private JLabel compLabel;
    private JTextField compText;
    private int[] numberOfComps = new int[]{8, 7, 6, 6};
    private String[] com = new String[]{"BDG", "BCK", "DBM", "OR"};
    private String[] mod = new String[]{"Single Modality", "Difference"};
    private int SingleOrDiff = 0;

    public int getSelectedManualComp() {
        return this.selectedManualComp;
    }

    public int getSingleOrDiff() {
        return this.SingleOrDiff;
    }

    public void reset() {
        this.com1Button.setSelected(true);
        this.gui.StatPanel1.enableTabs();
        this.SingleMod.setSelected(true);
        this.AUCText2.setEnabled(false);
        this.manualInReader.setText("22");
        this.manualInNormal.setText("22");
        this.manualInDisease.setText("22");
        this.AUCText1.setText("0.8");
        this.AUCText2.setText("0.85");
        this.compText.setText(" 0.116943691, 0.071012127, 0.046916759, 0.022056021, 0.051145786, 0.044660693, 0.027096782, 0.022590056");
    }

    public DBRecord getManualRecord() {
        return this.record;
    }

    public int getReader() {
        return this.Reader;
    }

    public int getNormal() {
        return this.Normal;
    }

    public int getDisease() {
        return this.Disease;
    }

    public ManualCard(JPanel manualCard, GUInterface guitemp, MRMC lsttemp) {
        this.lst = lsttemp;
        this.gui = guitemp;
        GroupLayout layout = new GroupLayout(manualCard);
        manualCard.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel studyInfoLabel = new JLabel("Information of the study\t");
        JLabel readerLabel = new JLabel("# Readers");
        this.manualInReader = new JTextField(5);
        JLabel normalLabel = new JLabel("# Normal");
        this.manualInNormal = new JTextField(5);
        JLabel diseaseLabel = new JLabel("# Disease");
        this.manualInDisease = new JTextField(5);
        JLabel componentsLabel = new JLabel("Which components are you using?");
        this.com1Button = new JRadioButton(this.com[0]);
        this.com1Button.setActionCommand(this.com[0]);
        this.com1Button.setSelected(true);
        JRadioButton com2Button = new JRadioButton(this.com[1]);
        com2Button.setActionCommand(this.com[1]);
        JRadioButton com3Button = new JRadioButton(this.com[2]);
        com3Button.setActionCommand(this.com[2]);
        JRadioButton com4Button = new JRadioButton(this.com[3]);
        com4Button.setActionCommand(this.com[3]);
        ButtonGroup groupcom = new ButtonGroup();
        groupcom.add(this.com1Button);
        groupcom.add(com2Button);
        groupcom.add(com3Button);
        groupcom.add(com4Button);
        comSelListener comListener = new comSelListener();
        this.com1Button.addActionListener(comListener);
        com2Button.addActionListener(comListener);
        com3Button.addActionListener(comListener);
        com4Button.addActionListener(comListener);
        JLabel space = new JLabel("       The components are for");
        this.SingleMod = new JRadioButton(this.mod[0]);
        this.SingleMod.setActionCommand(this.mod[0]);
        this.SingleMod.setSelected(true);
        JRadioButton DiffMod = new JRadioButton(this.mod[1]);
        DiffMod.setActionCommand(this.mod[1]);
        ButtonGroup groupmod = new ButtonGroup();
        groupmod.add(this.SingleMod);
        groupmod.add(DiffMod);
        modSelListener modListener = new modSelListener();
        this.SingleMod.addActionListener(modListener);
        DiffMod.addActionListener(modListener);
        JButton varAnalysisButton = new JButton("MRMC Variance Analysis");
        varAnalysisButton.addActionListener(new VarAnalysisBtnListener());
        JLabel aucLabel1 = new JLabel("AUC1 ");
        this.AUCText1 = new JTextField(10);
        JLabel aucLabel2 = new JLabel("AUC2 ");
        this.AUCText2 = new JTextField(10);
        this.AUCText2.setEnabled(false);
        String tempspace = "                                                             ";
        tempspace = String.valueOf(tempspace) + tempspace + tempspace;
        JLabel space2 = new JLabel(tempspace);
        this.compLabel = new JLabel(this.BDGlabel);
        this.compText = new JTextField(50);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(studyInfoLabel).addComponent(readerLabel).addComponent(this.manualInReader).addComponent(normalLabel).addComponent(this.manualInNormal).addComponent(diseaseLabel).addComponent(this.manualInDisease)).addGroup(layout.createSequentialGroup().addComponent(aucLabel1).addComponent(this.AUCText1).addComponent(aucLabel2).addComponent(this.AUCText2).addComponent(space2)).addGroup(layout.createSequentialGroup().addComponent(componentsLabel).addComponent(this.com1Button).addComponent(com2Button).addComponent(com3Button).addComponent(com4Button).addComponent(space).addComponent(this.SingleMod).addComponent(DiffMod).addComponent(varAnalysisButton)).addGroup(layout.createSequentialGroup().addComponent(this.compLabel).addComponent(this.compText))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(studyInfoLabel).addComponent(readerLabel).addComponent(this.manualInReader).addComponent(normalLabel).addComponent(this.manualInNormal).addComponent(diseaseLabel).addComponent(this.manualInDisease)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(aucLabel1).addComponent(this.AUCText1).addComponent(aucLabel2).addComponent(this.AUCText2).addComponent(space2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(componentsLabel).addComponent(this.com1Button).addComponent(com2Button).addComponent(com3Button).addComponent(com4Button).addComponent(space).addComponent(this.SingleMod).addComponent(DiffMod).addComponent(varAnalysisButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compLabel).addComponent(this.compText)));
    }

    class VarAnalysisBtnListener
    implements ActionListener {
        VarAnalysisBtnListener() {
        }

        public boolean checkinput() {
            String readerInput = ManualCard.this.manualInReader.getText();
            String normalInput = ManualCard.this.manualInNormal.getText();
            String diseaseInput = ManualCard.this.manualInDisease.getText();
            String componentsInput = ManualCard.this.compText.getText();
            String auc1Input = ManualCard.this.AUCText1.getText();
            String auc2Input = ManualCard.this.AUCText2.getText();
            if (readerInput.equals("") || normalInput.equals("") || diseaseInput.equals("") || componentsInput.equals("") || auc1Input.equals("") || auc2Input.equals("") && ManualCard.this.SingleOrDiff == 1) {
                JFrame frame = ManualCard.this.lst.getFrame();
                JOptionPane.showMessageDialog(frame, "The input is not complete", "Error", 0);
                return false;
            }
            String[] tempComp = componentsInput.split(",");
            if (tempComp.length != ManualCard.this.numberOfComps[ManualCard.this.selectedManualComp]) {
                JFrame frame = ManualCard.this.lst.getFrame();
                String strtemp = "The " + ManualCard.this.com[ManualCard.this.selectedManualComp] + " components has " + Integer.toString(ManualCard.this.numberOfComps[ManualCard.this.selectedManualComp]) + " elements!\n";
                JOptionPane.showMessageDialog(frame, strtemp, "Error", 0);
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.checkinput()) {
                return;
            }
            ManualCard.this.Reader = Integer.parseInt(ManualCard.this.manualInReader.getText());
            ManualCard.this.Normal = Integer.parseInt(ManualCard.this.manualInNormal.getText());
            ManualCard.this.Disease = Integer.parseInt(ManualCard.this.manualInDisease.getText());
            String[] temp = ManualCard.this.compText.getText().split(",");
            double[] data = new double[temp.length];
            int i = 0;
            while (i < ManualCard.this.numberOfComps[ManualCard.this.selectedManualComp]) {
                data[i] = Double.valueOf(temp[i]);
                ++i;
            }
            ((ManualCard)ManualCard.this).auc[0] = Double.valueOf(ManualCard.this.AUCText1.getText());
            ((ManualCard)ManualCard.this).auc[1] = ManualCard.this.auc[0];
            if (ManualCard.this.SingleOrDiff == 1) {
                ((ManualCard)ManualCard.this).auc[1] = Double.valueOf(ManualCard.this.AUCText2.getText());
            }
            double[][] tempData = new double[][]{data, data, data, data};
            ManualCard.this.record = new DBRecord(tempData, ManualCard.this.selectedManualComp, ManualCard.this.Reader, ManualCard.this.Normal, ManualCard.this.Disease, ManualCard.this.auc);
            ((ManualCard)ManualCard.this).gui.StatPanel1.setStatPanel();
            ((ManualCard)ManualCard.this).gui.StatPanel1.setTable1();
            ((ManualCard)ManualCard.this).gui.SizePanel1.setSizePanel();
        }
    }

    class comSelListener
    implements ActionListener {
        comSelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ManualCard)ManualCard.this).gui.StatPanel1.disableTabs();
            String str = e.getActionCommand();
            if (str.equals("BDG")) {
                ManualCard.this.selectedManualComp = 0;
                ManualCard.this.compLabel.setText(ManualCard.this.BDGlabel);
                ((ManualCard)ManualCard.this).gui.StatPanel1.enableTabs();
            } else if (str.equals("BCK")) {
                ManualCard.this.selectedManualComp = 1;
                ManualCard.this.compLabel.setText(ManualCard.this.BCKlabel);
                ((ManualCard)ManualCard.this).gui.StatPanel1.enableBCKTab();
            } else if (str.equals("DBM")) {
                ManualCard.this.selectedManualComp = 2;
                ManualCard.this.compLabel.setText(ManualCard.this.DBMlabel);
                ((ManualCard)ManualCard.this).gui.StatPanel1.enableDBMORTabs();
            } else if (str.equals("OR")) {
                ManualCard.this.selectedManualComp = 3;
                ManualCard.this.compLabel.setText(ManualCard.this.ORlabel);
                ((ManualCard)ManualCard.this).gui.StatPanel1.enableDBMORTabs();
            }
            ManualCard.this.compText.setText("");
        }
    }

    class modSelListener
    implements ActionListener {
        modSelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

