/*
 * Decompiled with CFR 0.152.
 */
package org.act.testdef;

import java.util.ArrayList;
import java.util.List;

public class Item {
    private String id;
    private int rowIndex;
    private List<String> numericAttrsNames = new ArrayList<String>();
    private List<String> categAttrsNames = new ArrayList<String>();
    private List<Double> numericAttrs = new ArrayList<Double>();
    private List<String> categAttrs = new ArrayList<String>();

    public Item(String id, List<String> rowData, List<String> columnNames, boolean[] itemNumericColumns, int rowIndex) {
        int count = 0;
        this.id = id;
        this.rowIndex = rowIndex;
        for (boolean mark : itemNumericColumns) {
            if (mark) {
                this.numericAttrsNames.add(columnNames.get(count));
                this.numericAttrs.add(Double.parseDouble(rowData.get(count)));
            } else {
                this.categAttrsNames.add(columnNames.get(count));
                this.categAttrs.add(rowData.get(count));
            }
            ++count;
        }
    }

    public String getId() {
        return this.id;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public List<String> getNumericAttrsNames() {
        return this.numericAttrsNames;
    }

    public List<String> getCategAttrsNames() {
        return this.categAttrsNames;
    }

    public List<Double> getNumericAttrs() {
        return this.numericAttrs;
    }

    public List<String> getCategAttrs() {
        return this.categAttrs;
    }

    public static enum ColumnName {
        ITEM_ID("Item ID"),
        ITEM_PASSAGE_ID("Passage ID"),
        A_PARAM("A-Param"),
        B_PARAM("B-Param"),
        C_PARAM("C-Param"),
        A_PARAM_SE("A-Param-SE"),
        B_PARAM_SE("B-Param-SE"),
        C_PARAM_SE("C-Param-SE"),
        D_CONSTANT("D-Constant");

        private String colName;

        private ColumnName(String colName) {
            this.colName = colName;
        }

        public String getColName() {
            return this.colName;
        }
    }
}

