/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.DefaultSarimaMapping;

public class SarimaMapping2
implements IParametricMapping<SarimaModel> {
    static final double REPS = 0.01;
    static final double MAX = 0.99999;
    public static final double ARMAX = 0.96;
    public static final double MAMAX = 0.99;
    static final double STEP = 1.0E-6;
    private double armax_ = 1.0;
    private double mamax_ = 1.0;
    private boolean all_;
    private final SarimaSpecification spec;

    public static boolean stabilize(SarimaModel model, double armax, double mamax) {
        SarimaMapping2 mapping = new SarimaMapping2(model.getSpecification(), true);
        mapping.setArMax(armax);
        mapping.setMaMax(mamax);
        DataBlock p = new DataBlock(model.getParameters());
        if (mapping.stabilize(p)) {
            model.setParameters(p);
            return true;
        }
        return false;
    }

    public boolean stabilize(IDataBlock p) {
        boolean rslt = false;
        if (this.spec.getP() > 0 && this.stabilize(p, 0, this.spec.getP(), this.armax_)) {
            rslt = true;
        }
        if (this.spec.getBP() > 0 && this.stabilize(p, this.spec.getP(), this.spec.getBP(), this.armax_)) {
            rslt = true;
        }
        if (this.all_ && this.spec.getQ() > 0 && this.stabilize(p, this.spec.getP() + this.spec.getBP(), this.spec.getQ(), this.mamax_)) {
            rslt = true;
        }
        if (this.all_ && this.spec.getBQ() > 0 && this.stabilize(p, this.spec.getP() + this.spec.getBP() + this.spec.getQ(), this.spec.getBQ(), this.mamax_)) {
            rslt = true;
        }
        return rslt;
    }

    private boolean stabilize(IDataBlock c, int start, int nc, double rmax) {
        Polynomial sp;
        if (nc == 0) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(start);
            double cabs = Math.abs(c0);
            if (cabs <= rmax) {
                return false;
            }
            if (rmax < 1.0) {
                c.set(start, c0 > 0.0 ? rmax : -rmax);
            } else {
                c.set(start, 1.0 / c0);
            }
            return true;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(start + i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = SarimaMapping2.stabilize(p, rmax))) {
            for (int i = 0; i < nc; ++i) {
                c.set(start + i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    private static Polynomial stabilize(Polynomial p, double rmax) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (!(n > rmax)) continue;
            if (rmax < 1.0) {
                roots[i] = root.times(n / rmax);
            } else if (n > 1.0) {
                roots[i] = root.inv();
            }
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    public double getArMax() {
        return this.armax_;
    }

    public void setArMax(double value) {
        this.armax_ = value;
    }

    public double getMaMax() {
        return this.mamax_;
    }

    public void setMaMax(double value) {
        this.mamax_ = value;
    }

    public SarimaMapping2(SarimaSpecification spec, boolean all) {
        this.spec = spec;
        this.all_ = all;
    }

    public void checkAll(boolean value) {
        this.all_ = value;
    }

    private boolean check(IReadDataBlock p, int start, int length, double rmax) {
        IReadDataBlock ex = p.rextract(start, length);
        if (rmax == 1.0) {
            return Utilities.checkStability(ex);
        }
        return Utilities.checkRoots(ex, 1.0 / rmax);
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock p) {
        if (this.spec.getP() > 0 && !this.check(p, 0, this.spec.getP(), this.armax_)) {
            return false;
        }
        if (this.spec.getBP() > 0 && !this.check(p, this.spec.getP(), this.spec.getBP(), this.armax_)) {
            return false;
        }
        if (this.all_ && this.spec.getQ() > 0 && !this.check(p, this.spec.getP() + this.spec.getBP(), this.spec.getQ(), this.mamax_)) {
            return false;
        }
        return !this.all_ || this.spec.getBQ() <= 0 || this.check(p, this.spec.getP() + this.spec.getBP() + this.spec.getQ(), this.spec.getBQ(), this.mamax_);
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        double p = inparams.get(idx);
        if (p < 0.0) {
            return -1.0E-6 * Math.min(-0.1, p);
        }
        return -1.0E-6 * Math.max(0.1, p);
    }

    @Override
    public int getDim() {
        return this.spec.getParametersCount();
    }

    public boolean isCheckingAll() {
        return this.all_;
    }

    @Override
    public double lbound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return -this.armax_;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return -this.armax_;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return -this.mamax_;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return -this.mamax_;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SarimaModel map(IReadDataBlock p) {
        if (p.getLength() != this.spec.getParametersCount()) {
            return null;
        }
        SarimaModel m = new SarimaModel(this.spec);
        m.setParameters(p);
        return m;
    }

    @Override
    public IReadDataBlock map(SarimaModel t) {
        SarimaSpecification curspec = t.getSpecification();
        if (curspec.getP() != this.spec.getP() || curspec.getQ() != this.spec.getQ() || curspec.getBP() != this.spec.getBP() || curspec.getBQ() != this.spec.getBQ()) {
            return null;
        }
        return t.getParameters();
    }

    @Override
    public double ubound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return 0.99999;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock value) {
        if (value.getLength() != this.spec.getParametersCount()) {
            return ParamValidation.Invalid;
        }
        if (this.stabilize(value)) {
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    @Override
    public String getDescription(int idx) {
        return DefaultSarimaMapping.getDescription(this.spec, idx);
    }
}

